/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.field.EntProjectPublicSectorField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.selectable.EntProjectPublicSectorSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Project Public Sector
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EntProjectPublicSectorType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EntProjectPublicSector extends VdmEntity<EntProjectPublicSector>
{

    /**
     * Selector for all available fields of EntProjectPublicSector.
     *
     */
    public final static EntProjectPublicSectorSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<UUID> PROJECT_UUID =
        new EntProjectPublicSectorField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     * <p>
     * If you assign the budget to a fund, you can obtain a detailed list of origin for the amounts involved.
     * </p>
     *
     * @return Key which uniquely identifies the fund.
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<String> FUND = new EntProjectPublicSectorField<String>("Fund");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FundIsFixAssigned</b>
     * </p>
     *
     * @return Indicator for Fund with Fixed Assignment
     */
    @SerializedName( "FundIsFixAssigned" )
    @JsonProperty( "FundIsFixAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FundIsFixAssigned" )
    private Boolean fundIsFixAssigned;
    /**
     * Use with available fluent helpers to apply the <b>FundIsFixAssigned</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<Boolean> FUND_IS_FIX_ASSIGNED =
        new EntProjectPublicSectorField<Boolean>("FundIsFixAssigned");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaIsFixAssigned</b>
     * </p>
     *
     * @return Indicator for Functional Area with Fixed Assignment
     */
    @SerializedName( "FunctionalAreaIsFixAssigned" )
    @JsonProperty( "FunctionalAreaIsFixAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FunctionalAreaIsFixAssigned" )
    private Boolean functionalAreaIsFixAssigned;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalAreaIsFixAssigned</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<Boolean> FUNCTIONAL_AREA_IS_FIX_ASSIGNED =
        new EntProjectPublicSectorField<Boolean>("FunctionalAreaIsFixAssigned");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     * <p>
     * A grant may be for any purpose and cover all or only part of the costs of the project in question. You must enter
     * a grant type for each grant you create in Grants Management (GM).The grant as an object has a finite lifecycle,
     * divided into stages. Each stage is represented in the GM solution by a system status. The following are the
     * stages of a grant's lifecycle:Initial DraftThis is the first stage of a grant. It is a working copy that can be
     * modified as many times as needed.ProposalWhen the initial draft becomes a formal and complete document, it
     * becomes a proposal.ApplicationWhen a proposal is routed to the sponsor for approval, it becomes an application.
     * This application might contain changes in the budget or other adjustments.AwardIf the sponsor approves an
     * application, an award is created. This is the real operative stage of a grant. The creation and consumption of
     * the grant's budget occurs at this stage. This stage also represents the binding contract between the sponsor and
     * the grantee.ClosingWhen an award is expiring, a phase of closing is established. Only restricted operations can
     * be performed in this stage.ClosedThis stage defines an expired and closed grant. No further operations are
     * allowed except archiving.
     * </p>
     *
     * @return Legal instrument used to establish a funding relationship between a sponsor (grantor) and grantee, in
     *         order to carry out a public purpose of support or stimulation in which the sponsor does not expect to be
     *         substantially involved.
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<String> GRANT_ID =
        new EntProjectPublicSectorField<String>("GrantID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GrantIsFixAssigned</b>
     * </p>
     *
     * @return Indicator for Grant with Fixed Assignment
     */
    @SerializedName( "GrantIsFixAssigned" )
    @JsonProperty( "GrantIsFixAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GrantIsFixAssigned" )
    private Boolean grantIsFixAssigned;
    /**
     * Use with available fluent helpers to apply the <b>GrantIsFixAssigned</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<Boolean> GRANT_IS_FIX_ASSIGNED =
        new EntProjectPublicSectorField<Boolean>("GrantIsFixAssigned");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     * <p>
     * The sponsored program is used to group costs in order to satisfy the sponsor's view and reporting needs; it is
     * used in all Grants Management (GM) activities. One grant might fund several sponsored programs and one sponsored
     * program might be funded by several grants.The sponsored program provides a link between GM and Funds Management
     * (FM). In particular, it provides a link to funds centers, functional areas, and funded programs for the purpose
     * of budget transfers.The assignment tool should be used to derive the sponsored program during actual postings.
     * </p>
     *
     * @return The sponsored program is a fundamental part of the sponsor's view. It is a dimension that defines, in the
     *         sponsor's view and terms, a program to be funded. Whenever a grantee has to report back to the sponsor,
     *         the sponsored program is in fact, the program dimension that the sponsor will recognize.
     */
    @SerializedName( "SponsoredProgram" )
    @JsonProperty( "SponsoredProgram" )
    @Nullable
    @ODataField( odataName = "SponsoredProgram" )
    private String sponsoredProgram;
    /**
     * Use with available fluent helpers to apply the <b>SponsoredProgram</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<String> SPONSORED_PROGRAM =
        new EntProjectPublicSectorField<String>("SponsoredProgram");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectLastChangedDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "ProjectLastChangedDateTime" )
    @JsonProperty( "ProjectLastChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectLastChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime projectLastChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ProjectLastChangedDateTime</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<ZonedDateTime> PROJECT_LAST_CHANGED_DATE_TIME =
        new EntProjectPublicSectorField<ZonedDateTime>("ProjectLastChangedDateTime");

    @Nonnull
    @Override
    public Class<EntProjectPublicSector> getType()
    {
        return EntProjectPublicSector.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     * <p>
     * If you assign the budget to a fund, you can obtain a detailed list of origin for the amounts involved.
     * </p>
     *
     * @param fund
     *            Key which uniquely identifies the fund.
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FundIsFixAssigned</b>
     * </p>
     *
     * @param fundIsFixAssigned
     *            Indicator for Fund with Fixed Assignment
     */
    public void setFundIsFixAssigned( @Nullable final Boolean fundIsFixAssigned )
    {
        rememberChangedField("FundIsFixAssigned", this.fundIsFixAssigned);
        this.fundIsFixAssigned = fundIsFixAssigned;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaIsFixAssigned</b>
     * </p>
     *
     * @param functionalAreaIsFixAssigned
     *            Indicator for Functional Area with Fixed Assignment
     */
    public void setFunctionalAreaIsFixAssigned( @Nullable final Boolean functionalAreaIsFixAssigned )
    {
        rememberChangedField("FunctionalAreaIsFixAssigned", this.functionalAreaIsFixAssigned);
        this.functionalAreaIsFixAssigned = functionalAreaIsFixAssigned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     * <p>
     * A grant may be for any purpose and cover all or only part of the costs of the project in question. You must enter
     * a grant type for each grant you create in Grants Management (GM).The grant as an object has a finite lifecycle,
     * divided into stages. Each stage is represented in the GM solution by a system status. The following are the
     * stages of a grant's lifecycle:Initial DraftThis is the first stage of a grant. It is a working copy that can be
     * modified as many times as needed.ProposalWhen the initial draft becomes a formal and complete document, it
     * becomes a proposal.ApplicationWhen a proposal is routed to the sponsor for approval, it becomes an application.
     * This application might contain changes in the budget or other adjustments.AwardIf the sponsor approves an
     * application, an award is created. This is the real operative stage of a grant. The creation and consumption of
     * the grant's budget occurs at this stage. This stage also represents the binding contract between the sponsor and
     * the grantee.ClosingWhen an award is expiring, a phase of closing is established. Only restricted operations can
     * be performed in this stage.ClosedThis stage defines an expired and closed grant. No further operations are
     * allowed except archiving.
     * </p>
     *
     * @param grantID
     *            Legal instrument used to establish a funding relationship between a sponsor (grantor) and grantee, in
     *            order to carry out a public purpose of support or stimulation in which the sponsor does not expect to
     *            be substantially involved.
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GrantIsFixAssigned</b>
     * </p>
     *
     * @param grantIsFixAssigned
     *            Indicator for Grant with Fixed Assignment
     */
    public void setGrantIsFixAssigned( @Nullable final Boolean grantIsFixAssigned )
    {
        rememberChangedField("GrantIsFixAssigned", this.grantIsFixAssigned);
        this.grantIsFixAssigned = grantIsFixAssigned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     * <p>
     * The sponsored program is used to group costs in order to satisfy the sponsor's view and reporting needs; it is
     * used in all Grants Management (GM) activities. One grant might fund several sponsored programs and one sponsored
     * program might be funded by several grants.The sponsored program provides a link between GM and Funds Management
     * (FM). In particular, it provides a link to funds centers, functional areas, and funded programs for the purpose
     * of budget transfers.The assignment tool should be used to derive the sponsored program during actual postings.
     * </p>
     *
     * @param sponsoredProgram
     *            The sponsored program is a fundamental part of the sponsor's view. It is a dimension that defines, in
     *            the sponsor's view and terms, a program to be funded. Whenever a grantee has to report back to the
     *            sponsor, the sponsored program is in fact, the program dimension that the sponsor will recognize.
     */
    public void setSponsoredProgram( @Nullable final String sponsoredProgram )
    {
        rememberChangedField("SponsoredProgram", this.sponsoredProgram);
        this.sponsoredProgram = sponsoredProgram;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectLastChangedDateTime</b>
     * </p>
     *
     * @param projectLastChangedDateTime
     *            Timestamp of Last Object Change
     */
    public void setProjectLastChangedDateTime( @Nullable final ZonedDateTime projectLastChangedDateTime )
    {
        rememberChangedField("ProjectLastChangedDateTime", this.projectLastChangedDateTime);
        this.projectLastChangedDateTime = projectLastChangedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EntProjectPublicSector";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectUUID", getProjectUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectUUID", getProjectUUID());
        values.put("Fund", getFund());
        values.put("FundIsFixAssigned", getFundIsFixAssigned());
        values.put("FunctionalAreaIsFixAssigned", getFunctionalAreaIsFixAssigned());
        values.put("GrantID", getGrantID());
        values.put("GrantIsFixAssigned", getGrantIsFixAssigned());
        values.put("SponsoredProgram", getSponsoredProgram());
        values.put("ProjectLastChangedDateTime", getProjectLastChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("FundIsFixAssigned") ) {
                final Object value = values.remove("FundIsFixAssigned");
                if( (value == null) || (!value.equals(getFundIsFixAssigned())) ) {
                    setFundIsFixAssigned(((Boolean) value));
                }
            }
            if( values.containsKey("FunctionalAreaIsFixAssigned") ) {
                final Object value = values.remove("FunctionalAreaIsFixAssigned");
                if( (value == null) || (!value.equals(getFunctionalAreaIsFixAssigned())) ) {
                    setFunctionalAreaIsFixAssigned(((Boolean) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("GrantIsFixAssigned") ) {
                final Object value = values.remove("GrantIsFixAssigned");
                if( (value == null) || (!value.equals(getGrantIsFixAssigned())) ) {
                    setGrantIsFixAssigned(((Boolean) value));
                }
            }
            if( values.containsKey("SponsoredProgram") ) {
                final Object value = values.remove("SponsoredProgram");
                if( (value == null) || (!value.equals(getSponsoredProgram())) ) {
                    setSponsoredProgram(((String) value));
                }
            }
            if( values.containsKey("ProjectLastChangedDateTime") ) {
                final Object value = values.remove("ProjectLastChangedDateTime");
                if( (value == null) || (!value.equals(getProjectLastChangedDateTime())) ) {
                    setProjectLastChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EntProjectPublicSectorField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EntProjectPublicSectorField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EntProjectPublicSectorField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EntProjectPublicSectorField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService.DEFAULT_SERVICE_PATH);
    }

}
