/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.field.EnterpriseProjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.link.EnterpriseProjectLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.link.EnterpriseProjectOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.selectable.EnterpriseProjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EnterpriseProjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EnterpriseProject extends VdmEntity<EnterpriseProject>
{

    /**
     * Selector for all available fields of EnterpriseProject.
     *
     */
    public final static EnterpriseProjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<UUID> PROJECT_UUID = new EnterpriseProjectField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjectInternalID</b>
     * </p>
     *
     * @return Project (internal)
     */
    @SerializedName( "ProjectInternalID" )
    @JsonProperty( "ProjectInternalID" )
    @Nullable
    @ODataField( odataName = "ProjectInternalID" )
    private String projectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectInternalID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROJECT_INTERNAL_ID =
        new EnterpriseProjectField<String>("ProjectInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Identification of Entities
     */
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROJECT = new EnterpriseProjectField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDescription</b>
     * </p>
     *
     * @return User-definable text, 40 characters long.
     */
    @SerializedName( "ProjectDescription" )
    @JsonProperty( "ProjectDescription" )
    @Nullable
    @ODataField( odataName = "ProjectDescription" )
    private String projectDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDescription</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROJECT_DESCRIPTION =
        new EnterpriseProjectField<String>("ProjectDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EnterpriseProjectType</b>
     * </p>
     * <p>
     * You can define the criteria for a project type.
     * </p>
     *
     * @return Key identifying a project type.
     */
    @SerializedName( "EnterpriseProjectType" )
    @JsonProperty( "EnterpriseProjectType" )
    @Nullable
    @ODataField( odataName = "EnterpriseProjectType" )
    private String enterpriseProjectType;
    /**
     * Use with available fluent helpers to apply the <b>EnterpriseProjectType</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> ENTERPRISE_PROJECT_TYPE =
        new EnterpriseProjectField<String>("EnterpriseProjectType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     *
     * @return Priority
     */
    @SerializedName( "PriorityCode" )
    @JsonProperty( "PriorityCode" )
    @Nullable
    @ODataField( odataName = "PriorityCode" )
    private String priorityCode;
    /**
     * Use with available fluent helpers to apply the <b>PriorityCode</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PRIORITY_CODE =
        new EnterpriseProjectField<String>("PriorityCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStartDate</b>
     * </p>
     *
     * @return Latest Start
     */
    @SerializedName( "ProjectStartDate" )
    @JsonProperty( "ProjectStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projectStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjectStartDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<LocalDateTime> PROJECT_START_DATE =
        new EnterpriseProjectField<LocalDateTime>("ProjectStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectEndDate</b>
     * </p>
     *
     * @return Latest Finish
     */
    @SerializedName( "ProjectEndDate" )
    @JsonProperty( "ProjectEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projectEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjectEndDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<LocalDateTime> PROJECT_END_DATE =
        new EnterpriseProjectField<LocalDateTime>("ProjectEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     *
     * @return Object Processing Status
     */
    @SerializedName( "ProcessingStatus" )
    @JsonProperty( "ProcessingStatus" )
    @Nullable
    @ODataField( odataName = "ProcessingStatus" )
    private String processingStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProcessingStatus</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROCESSING_STATUS =
        new EnterpriseProjectField<String>("ProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @return Responsible Cost Center
     */
    @SerializedName( "ResponsibleCostCenter" )
    @JsonProperty( "ResponsibleCostCenter" )
    @Nullable
    @ODataField( odataName = "ResponsibleCostCenter" )
    private String responsibleCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>ResponsibleCostCenter</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> RESPONSIBLE_COST_CENTER =
        new EnterpriseProjectField<String>("ResponsibleCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Key which together with the controlling area uniquely identifies a profit center.
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROFIT_CENTER =
        new EnterpriseProjectField<String>("ProfitCenter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectManagerUUID</b>
     * </p>
     *
     * @return Business Partner GUID
     */
    @SerializedName( "ProjectManagerUUID" )
    @JsonProperty( "ProjectManagerUUID" )
    @Nullable
    @ODataField( odataName = "ProjectManagerUUID" )
    private UUID projectManagerUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectManagerUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<UUID> PROJECT_MANAGER_UUID =
        new EnterpriseProjectField<UUID>("ProjectManagerUUID");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
     * </p>
     *
     * @return Key identifying a project profile.
     */
    @SerializedName( "ProjectProfileCode" )
    @JsonProperty( "ProjectProfileCode" )
    @Nullable
    @ODataField( odataName = "ProjectProfileCode" )
    private String projectProfileCode;
    /**
     * Use with available fluent helpers to apply the <b>ProjectProfileCode</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROJECT_PROFILE_CODE =
        new EnterpriseProjectField<String>("ProjectProfileCode");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     * <p>
     * Use for Cost of Sales AccountingThe functional area is required to create a profit and loss statement in
     * Financial Accounting using cost of sales accounting. The following are examples of structure
     * criteria:ManufacturingAdministrationSalesResearch & DevelopmentUse for GovernmentThe functional area is needed
     * for Funds Management to meet legal requirements for reporting with functional aspects. You can use the functional
     * area to represent the global targets and goals (such as public safety or city development), in particular the
     * expenses of your organization.Use in Cost of Sales AccountingSee the documentation on Filling the Functional Area
     * Field.For more information about cost of sales accounting and functional areas, see the SAP Library under
     * Financials -> Financial Accounting -> General Ledger Accounting -> Cost of Sales AccountingUse in GovernmentFor
     * more information on functional areas, see the Implementation Guide for Funds Management Government in the section
     * Activate Account Assignment Elements.
     * </p>
     *
     * @return Structure criterion for an enterprise or government based on functional aspects.
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> FUNCTIONAL_AREA =
        new EnterpriseProjectField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return The company code is an organizational unit within financial accounting.
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> COMPANY_CODE = new EnterpriseProjectField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> CONTROLLING_AREA =
        new EnterpriseProjectField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Key uniquely identifying a plant.
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PLANT = new EnterpriseProjectField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Location</b>
     * </p>
     *
     * @return Key that identifies the location. The location is subordinate entity in a plant.
     */
    @SerializedName( "Location" )
    @JsonProperty( "Location" )
    @Nullable
    @ODataField( odataName = "Location" )
    private String location;
    /**
     * Use with available fluent helpers to apply the <b>Location</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> LOCATION = new EnterpriseProjectField<String>("Location");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return The tax jurisdiction is used for determining the tax rates in the USA. It defines to which tax
     *         authorities you must pay your taxes. It is always the city to which the goods are supplied.
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> TAX_JURISDICTION =
        new EnterpriseProjectField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCurrency</b>
     * </p>
     *
     * @return Custom Project Currency
     */
    @SerializedName( "ProjectCurrency" )
    @JsonProperty( "ProjectCurrency" )
    @Nullable
    @ODataField( odataName = "ProjectCurrency" )
    private String projectCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ProjectCurrency</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROJECT_CURRENCY =
        new EnterpriseProjectField<String>("ProjectCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlProfile</b>
     * </p>
     *
     * @return The budget availability control profile brings all parameters together, which are necessary for you to
     *         actively control your budget.
     */
    @SerializedName( "AvailabilityControlProfile" )
    @JsonProperty( "AvailabilityControlProfile" )
    @Nullable
    @ODataField( odataName = "AvailabilityControlProfile" )
    private String availabilityControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityControlProfile</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> AVAILABILITY_CONTROL_PROFILE =
        new EnterpriseProjectField<String>("AvailabilityControlProfile");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlIsActive</b>
     * </p>
     *
     * @return Availability control indicator(AVC)
     */
    @SerializedName( "AvailabilityControlIsActive" )
    @JsonProperty( "AvailabilityControlIsActive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AvailabilityControlIsActive" )
    private Boolean availabilityControlIsActive;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityControlIsActive</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> AVAILABILITY_CONTROL_IS_ACTIVE =
        new EnterpriseProjectField<Boolean>("AvailabilityControlIsActive");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     * <p>
     * If alternative labels exist for a functional location, you can define in your user profile which label should be
     * displayed in this field.
     * </p>
     *
     * @return Label that uniquely identifies a functional location.
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> FUNCTIONAL_LOCATION =
        new EnterpriseProjectField<String>("FunctionalLocation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBillingRelevant</b>
     * </p>
     * <p>
     * If you want to maintain a billing plan for a WBS element, you must set this indicator. If you have maintained a
     * billing plan for the WBS element, you cannot change this indicator.
     * </p>
     *
     * @return This indicator defines the WBS element as a billing element.
     */
    @SerializedName( "IsBillingRelevant" )
    @JsonProperty( "IsBillingRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBillingRelevant" )
    private Boolean isBillingRelevant;
    /**
     * Use with available fluent helpers to apply the <b>IsBillingRelevant</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> IS_BILLING_RELEVANT =
        new EnterpriseProjectField<Boolean>("IsBillingRelevant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjIsMultiSlsOrdItmsEnbld</b>
     * </p>
     *
     * @return Enterprise Proj. Assigned to Multiple Sales Order Items
     */
    @SerializedName( "EntProjIsMultiSlsOrdItmsEnbld" )
    @JsonProperty( "EntProjIsMultiSlsOrdItmsEnbld" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjIsMultiSlsOrdItmsEnbld" )
    private Boolean entProjIsMultiSlsOrdItmsEnbld;
    /**
     * Use with available fluent helpers to apply the <b>EntProjIsMultiSlsOrdItmsEnbld</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> ENT_PROJ_IS_MULTI_SLS_ORD_ITMS_ENBLD =
        new EnterpriseProjectField<Boolean>("EntProjIsMultiSlsOrdItmsEnbld");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new EnterpriseProjectField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile</b>
     * </p>
     * <p>
     * Important control functions of the investment profile:Automatic creation of an asset under construction when you
     * create an internal order or a work breakdown structure (WBS) elementAsset class for the creation of the asset
     * under constructionAsset class for depreciation simulation
     * </p>
     *
     * @return Investment profile
     */
    @SerializedName( "InvestmentProfile" )
    @JsonProperty( "InvestmentProfile" )
    @Nullable
    @ODataField( odataName = "InvestmentProfile" )
    private String investmentProfile;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentProfile</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> INVESTMENT_PROFILE =
        new EnterpriseProjectField<String>("InvestmentProfile");
    /**
     * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EnterpriseProject</b> to multiple
     * <b>EnterpriseProjectElement</b>.
     *
     */
    @SerializedName( "to_EnterpriseProjectElement" )
    @JsonProperty( "to_EnterpriseProjectElement" )
    @ODataField( odataName = "to_EnterpriseProjectElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EnterpriseProjectElement> toEnterpriseProjectElement;
    /**
     * Navigation property <b>to_EntProjBlkFunc</b> for <b>EnterpriseProject</b> to single <b>EnterpriseProjBlkFunc</b>.
     *
     */
    @SerializedName( "to_EntProjBlkFunc" )
    @JsonProperty( "to_EntProjBlkFunc" )
    @ODataField( odataName = "to_EntProjBlkFunc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProjBlkFunc toEntProjBlkFunc;
    /**
     * Navigation property <b>to_EntProjectPublicSector</b> for <b>EnterpriseProject</b> to single
     * <b>EntProjectPublicSector</b>.
     *
     */
    @SerializedName( "to_EntProjectPublicSector" )
    @JsonProperty( "to_EntProjectPublicSector" )
    @ODataField( odataName = "to_EntProjectPublicSector" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EntProjectPublicSector toEntProjectPublicSector;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProjectElement</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectLink<EnterpriseProjectElement> TO_ENTERPRISE_PROJECT_ELEMENT =
        new EnterpriseProjectLink<EnterpriseProjectElement>("to_EnterpriseProjectElement");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjBlkFunc</b> navigation property to query operations.
     *
     */
    public final static EnterpriseProjectOneToOneLink<EnterpriseProjBlkFunc> TO_ENT_PROJ_BLK_FUNC =
        new EnterpriseProjectOneToOneLink<EnterpriseProjBlkFunc>("to_EntProjBlkFunc");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjectPublicSector</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectOneToOneLink<EntProjectPublicSector> TO_ENT_PROJECT_PUBLIC_SECTOR =
        new EnterpriseProjectOneToOneLink<EntProjectPublicSector>("to_EntProjectPublicSector");

    @Nonnull
    @Override
    public Class<EnterpriseProject> getType()
    {
        return EnterpriseProject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjectInternalID</b>
     * </p>
     *
     * @param projectInternalID
     *            Project (internal)
     */
    public void setProjectInternalID( @Nullable final String projectInternalID )
    {
        rememberChangedField("ProjectInternalID", this.projectInternalID);
        this.projectInternalID = projectInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Identification of Entities
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDescription</b>
     * </p>
     *
     * @param projectDescription
     *            User-definable text, 40 characters long.
     */
    public void setProjectDescription( @Nullable final String projectDescription )
    {
        rememberChangedField("ProjectDescription", this.projectDescription);
        this.projectDescription = projectDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EnterpriseProjectType</b>
     * </p>
     * <p>
     * You can define the criteria for a project type.
     * </p>
     *
     * @param enterpriseProjectType
     *            Key identifying a project type.
     */
    public void setEnterpriseProjectType( @Nullable final String enterpriseProjectType )
    {
        rememberChangedField("EnterpriseProjectType", this.enterpriseProjectType);
        this.enterpriseProjectType = enterpriseProjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     *
     * @param priorityCode
     *            Priority
     */
    public void setPriorityCode( @Nullable final String priorityCode )
    {
        rememberChangedField("PriorityCode", this.priorityCode);
        this.priorityCode = priorityCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStartDate</b>
     * </p>
     *
     * @param projectStartDate
     *            Latest Start
     */
    public void setProjectStartDate( @Nullable final LocalDateTime projectStartDate )
    {
        rememberChangedField("ProjectStartDate", this.projectStartDate);
        this.projectStartDate = projectStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectEndDate</b>
     * </p>
     *
     * @param projectEndDate
     *            Latest Finish
     */
    public void setProjectEndDate( @Nullable final LocalDateTime projectEndDate )
    {
        rememberChangedField("ProjectEndDate", this.projectEndDate);
        this.projectEndDate = projectEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     *
     * @param processingStatus
     *            Object Processing Status
     */
    public void setProcessingStatus( @Nullable final String processingStatus )
    {
        rememberChangedField("ProcessingStatus", this.processingStatus);
        this.processingStatus = processingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @param responsibleCostCenter
     *            Responsible Cost Center
     */
    public void setResponsibleCostCenter( @Nullable final String responsibleCostCenter )
    {
        rememberChangedField("ResponsibleCostCenter", this.responsibleCostCenter);
        this.responsibleCostCenter = responsibleCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Key which together with the controlling area uniquely identifies a profit center.
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectManagerUUID</b>
     * </p>
     *
     * @param projectManagerUUID
     *            Business Partner GUID
     */
    public void setProjectManagerUUID( @Nullable final UUID projectManagerUUID )
    {
        rememberChangedField("ProjectManagerUUID", this.projectManagerUUID);
        this.projectManagerUUID = projectManagerUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
     * </p>
     *
     * @param projectProfileCode
     *            Key identifying a project profile.
     */
    public void setProjectProfileCode( @Nullable final String projectProfileCode )
    {
        rememberChangedField("ProjectProfileCode", this.projectProfileCode);
        this.projectProfileCode = projectProfileCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     * <p>
     * Use for Cost of Sales AccountingThe functional area is required to create a profit and loss statement in
     * Financial Accounting using cost of sales accounting. The following are examples of structure
     * criteria:ManufacturingAdministrationSalesResearch & DevelopmentUse for GovernmentThe functional area is needed
     * for Funds Management to meet legal requirements for reporting with functional aspects. You can use the functional
     * area to represent the global targets and goals (such as public safety or city development), in particular the
     * expenses of your organization.Use in Cost of Sales AccountingSee the documentation on Filling the Functional Area
     * Field.For more information about cost of sales accounting and functional areas, see the SAP Library under
     * Financials -> Financial Accounting -> General Ledger Accounting -> Cost of Sales AccountingUse in GovernmentFor
     * more information on functional areas, see the Implementation Guide for Funds Management Government in the section
     * Activate Account Assignment Elements.
     * </p>
     *
     * @param functionalArea
     *            Structure criterion for an enterprise or government based on functional aspects.
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            The company code is an organizational unit within financial accounting.
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Key uniquely identifying a plant.
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Location</b>
     * </p>
     *
     * @param location
     *            Key that identifies the location. The location is subordinate entity in a plant.
     */
    public void setLocation( @Nullable final String location )
    {
        rememberChangedField("Location", this.location);
        this.location = location;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            The tax jurisdiction is used for determining the tax rates in the USA. It defines to which tax
     *            authorities you must pay your taxes. It is always the city to which the goods are supplied.
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCurrency</b>
     * </p>
     *
     * @param projectCurrency
     *            Custom Project Currency
     */
    public void setProjectCurrency( @Nullable final String projectCurrency )
    {
        rememberChangedField("ProjectCurrency", this.projectCurrency);
        this.projectCurrency = projectCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlProfile</b>
     * </p>
     *
     * @param availabilityControlProfile
     *            The budget availability control profile brings all parameters together, which are necessary for you to
     *            actively control your budget.
     */
    public void setAvailabilityControlProfile( @Nullable final String availabilityControlProfile )
    {
        rememberChangedField("AvailabilityControlProfile", this.availabilityControlProfile);
        this.availabilityControlProfile = availabilityControlProfile;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlIsActive</b>
     * </p>
     *
     * @param availabilityControlIsActive
     *            Availability control indicator(AVC)
     */
    public void setAvailabilityControlIsActive( @Nullable final Boolean availabilityControlIsActive )
    {
        rememberChangedField("AvailabilityControlIsActive", this.availabilityControlIsActive);
        this.availabilityControlIsActive = availabilityControlIsActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     * <p>
     * If alternative labels exist for a functional location, you can define in your user profile which label should be
     * displayed in this field.
     * </p>
     *
     * @param functionalLocation
     *            Label that uniquely identifies a functional location.
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBillingRelevant</b>
     * </p>
     * <p>
     * If you want to maintain a billing plan for a WBS element, you must set this indicator. If you have maintained a
     * billing plan for the WBS element, you cannot change this indicator.
     * </p>
     *
     * @param isBillingRelevant
     *            This indicator defines the WBS element as a billing element.
     */
    public void setIsBillingRelevant( @Nullable final Boolean isBillingRelevant )
    {
        rememberChangedField("IsBillingRelevant", this.isBillingRelevant);
        this.isBillingRelevant = isBillingRelevant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjIsMultiSlsOrdItmsEnbld</b>
     * </p>
     *
     * @param entProjIsMultiSlsOrdItmsEnbld
     *            Enterprise Proj. Assigned to Multiple Sales Order Items
     */
    public void setEntProjIsMultiSlsOrdItmsEnbld( @Nullable final Boolean entProjIsMultiSlsOrdItmsEnbld )
    {
        rememberChangedField("EntProjIsMultiSlsOrdItmsEnbld", this.entProjIsMultiSlsOrdItmsEnbld);
        this.entProjIsMultiSlsOrdItmsEnbld = entProjIsMultiSlsOrdItmsEnbld;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Timestamp of Last Object Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile</b>
     * </p>
     * <p>
     * Important control functions of the investment profile:Automatic creation of an asset under construction when you
     * create an internal order or a work breakdown structure (WBS) elementAsset class for the creation of the asset
     * under constructionAsset class for depreciation simulation
     * </p>
     *
     * @param investmentProfile
     *            Investment profile
     */
    public void setInvestmentProfile( @Nullable final String investmentProfile )
    {
        rememberChangedField("InvestmentProfile", this.investmentProfile);
        this.investmentProfile = investmentProfile;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EnterpriseProject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectUUID", getProjectUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectUUID", getProjectUUID());
        values.put("ProjectInternalID", getProjectInternalID());
        values.put("Project", getProject());
        values.put("ProjectDescription", getProjectDescription());
        values.put("EnterpriseProjectType", getEnterpriseProjectType());
        values.put("PriorityCode", getPriorityCode());
        values.put("ProjectStartDate", getProjectStartDate());
        values.put("ProjectEndDate", getProjectEndDate());
        values.put("ProcessingStatus", getProcessingStatus());
        values.put("ResponsibleCostCenter", getResponsibleCostCenter());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProjectManagerUUID", getProjectManagerUUID());
        values.put("ProjectProfileCode", getProjectProfileCode());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("CompanyCode", getCompanyCode());
        values.put("ControllingArea", getControllingArea());
        values.put("Plant", getPlant());
        values.put("Location", getLocation());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("ProjectCurrency", getProjectCurrency());
        values.put("AvailabilityControlProfile", getAvailabilityControlProfile());
        values.put("AvailabilityControlIsActive", getAvailabilityControlIsActive());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("IsBillingRelevant", getIsBillingRelevant());
        values.put("EntProjIsMultiSlsOrdItmsEnbld", getEntProjIsMultiSlsOrdItmsEnbld());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("InvestmentProfile", getInvestmentProfile());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectInternalID") ) {
                final Object value = values.remove("ProjectInternalID");
                if( (value == null) || (!value.equals(getProjectInternalID())) ) {
                    setProjectInternalID(((String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("ProjectDescription") ) {
                final Object value = values.remove("ProjectDescription");
                if( (value == null) || (!value.equals(getProjectDescription())) ) {
                    setProjectDescription(((String) value));
                }
            }
            if( values.containsKey("EnterpriseProjectType") ) {
                final Object value = values.remove("EnterpriseProjectType");
                if( (value == null) || (!value.equals(getEnterpriseProjectType())) ) {
                    setEnterpriseProjectType(((String) value));
                }
            }
            if( values.containsKey("PriorityCode") ) {
                final Object value = values.remove("PriorityCode");
                if( (value == null) || (!value.equals(getPriorityCode())) ) {
                    setPriorityCode(((String) value));
                }
            }
            if( values.containsKey("ProjectStartDate") ) {
                final Object value = values.remove("ProjectStartDate");
                if( (value == null) || (!value.equals(getProjectStartDate())) ) {
                    setProjectStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjectEndDate") ) {
                final Object value = values.remove("ProjectEndDate");
                if( (value == null) || (!value.equals(getProjectEndDate())) ) {
                    setProjectEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProcessingStatus") ) {
                final Object value = values.remove("ProcessingStatus");
                if( (value == null) || (!value.equals(getProcessingStatus())) ) {
                    setProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("ResponsibleCostCenter") ) {
                final Object value = values.remove("ResponsibleCostCenter");
                if( (value == null) || (!value.equals(getResponsibleCostCenter())) ) {
                    setResponsibleCostCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProjectManagerUUID") ) {
                final Object value = values.remove("ProjectManagerUUID");
                if( (value == null) || (!value.equals(getProjectManagerUUID())) ) {
                    setProjectManagerUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectProfileCode") ) {
                final Object value = values.remove("ProjectProfileCode");
                if( (value == null) || (!value.equals(getProjectProfileCode())) ) {
                    setProjectProfileCode(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Location") ) {
                final Object value = values.remove("Location");
                if( (value == null) || (!value.equals(getLocation())) ) {
                    setLocation(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("ProjectCurrency") ) {
                final Object value = values.remove("ProjectCurrency");
                if( (value == null) || (!value.equals(getProjectCurrency())) ) {
                    setProjectCurrency(((String) value));
                }
            }
            if( values.containsKey("AvailabilityControlProfile") ) {
                final Object value = values.remove("AvailabilityControlProfile");
                if( (value == null) || (!value.equals(getAvailabilityControlProfile())) ) {
                    setAvailabilityControlProfile(((String) value));
                }
            }
            if( values.containsKey("AvailabilityControlIsActive") ) {
                final Object value = values.remove("AvailabilityControlIsActive");
                if( (value == null) || (!value.equals(getAvailabilityControlIsActive())) ) {
                    setAvailabilityControlIsActive(((Boolean) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("IsBillingRelevant") ) {
                final Object value = values.remove("IsBillingRelevant");
                if( (value == null) || (!value.equals(getIsBillingRelevant())) ) {
                    setIsBillingRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjIsMultiSlsOrdItmsEnbld") ) {
                final Object value = values.remove("EntProjIsMultiSlsOrdItmsEnbld");
                if( (value == null) || (!value.equals(getEntProjIsMultiSlsOrdItmsEnbld())) ) {
                    setEntProjIsMultiSlsOrdItmsEnbld(((Boolean) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("InvestmentProfile") ) {
                final Object value = values.remove("InvestmentProfile");
                if( (value == null) || (!value.equals(getInvestmentProfile())) ) {
                    setInvestmentProfile(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProjectElement") ) {
                final Object value = (values).remove("to_EnterpriseProjectElement");
                if( value instanceof Iterable ) {
                    if( toEnterpriseProjectElement == null ) {
                        toEnterpriseProjectElement = Lists.newArrayList();
                    } else {
                        toEnterpriseProjectElement = Lists.newArrayList(toEnterpriseProjectElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EnterpriseProjectElement entity;
                        if( toEnterpriseProjectElement.size() > i ) {
                            entity = toEnterpriseProjectElement.get(i);
                        } else {
                            entity = new EnterpriseProjectElement();
                            toEnterpriseProjectElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_EntProjBlkFunc") ) {
                final Object value = (values).remove("to_EntProjBlkFunc");
                if( value instanceof Map ) {
                    if( toEntProjBlkFunc == null ) {
                        toEntProjBlkFunc = new EnterpriseProjBlkFunc();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEntProjBlkFunc.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EntProjectPublicSector") ) {
                final Object value = (values).remove("to_EntProjectPublicSector");
                if( value instanceof Map ) {
                    if( toEntProjectPublicSector == null ) {
                        toEntProjectPublicSector = new EntProjectPublicSector();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEntProjectPublicSector.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EnterpriseProjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EnterpriseProjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EnterpriseProjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EnterpriseProjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProjectElement != null ) {
            (values).put("to_EnterpriseProjectElement", toEnterpriseProjectElement);
        }
        if( toEntProjBlkFunc != null ) {
            (values).put("to_EntProjBlkFunc", toEntProjBlkFunc);
        }
        if( toEntProjectPublicSector != null ) {
            (values).put("to_EntProjectPublicSector", toEntProjectPublicSector);
        }
        return values;
    }

    /**
     * Fetches the <b>EnterpriseProjectElement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EnterpriseProjectElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectElement> fetchEnterpriseProjectElement()
    {
        return fetchFieldAsList("to_EnterpriseProjectElement", EnterpriseProjectElement.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectElement</b> of a queried <b>EnterpriseProject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectElement> getEnterpriseProjectElementOrFetch()
    {
        if( toEnterpriseProjectElement == null ) {
            toEnterpriseProjectElement = fetchEnterpriseProjectElement();
        }
        return toEnterpriseProjectElement;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProjectElement</b> is already loaded, the
     *         result will contain the <b>EnterpriseProjectElement</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EnterpriseProjectElement>> getEnterpriseProjectElementIfPresent()
    {
        return Option.of(toEnterpriseProjectElement);
    }

    /**
     * Overwrites the list of associated <b>EnterpriseProjectElement</b> entities for the loaded navigation property
     * <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectElement</b> of a queried <b>EnterpriseProject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EnterpriseProjectElement</b> entities.
     */
    public void setEnterpriseProjectElement( @Nonnull final List<EnterpriseProjectElement> value )
    {
        if( toEnterpriseProjectElement == null ) {
            toEnterpriseProjectElement = Lists.newArrayList();
        }
        toEnterpriseProjectElement.clear();
        toEnterpriseProjectElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EnterpriseProjectElement</b> entities. This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectElement</b> of a queried <b>EnterpriseProject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EnterpriseProjectElement</b> entities.
     */
    public void addEnterpriseProjectElement( EnterpriseProjectElement... entity )
    {
        if( toEnterpriseProjectElement == null ) {
            toEnterpriseProjectElement = Lists.newArrayList();
        }
        toEnterpriseProjectElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>EnterpriseProjBlkFunc</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EntProjBlkFunc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProjBlkFunc</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjBlkFunc fetchEntProjBlkFunc()
    {
        return fetchFieldAsSingle("to_EntProjBlkFunc", EnterpriseProjBlkFunc.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjBlkFunc</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjBlkFunc</b>.
     * <p>
     * If the navigation property <b>to_EntProjBlkFunc</b> of a queried <b>EnterpriseProject</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjBlkFunc</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjBlkFunc getEntProjBlkFuncOrFetch()
    {
        if( toEntProjBlkFunc == null ) {
            toEntProjBlkFunc = fetchEntProjBlkFunc();
        }
        return toEntProjBlkFunc;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjBlkFunc</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjBlkFunc</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjBlkFunc</b> is already loaded, the result will
     *         contain the <b>EnterpriseProjBlkFunc</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProjBlkFunc> getEntProjBlkFuncIfPresent()
    {
        return Option.of(toEntProjBlkFunc);
    }

    /**
     * Overwrites the associated <b>EnterpriseProjBlkFunc</b> entity for the loaded navigation property
     * <b>to_EntProjBlkFunc</b>.
     *
     * @param value
     *            New <b>EnterpriseProjBlkFunc</b> entity.
     */
    public void setEntProjBlkFunc( final EnterpriseProjBlkFunc value )
    {
        toEntProjBlkFunc = value;
    }

    /**
     * Fetches the <b>EntProjectPublicSector</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_EntProjectPublicSector</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EntProjectPublicSector</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjectPublicSector fetchEntProjectPublicSector()
    {
        return fetchFieldAsSingle("to_EntProjectPublicSector", EntProjectPublicSector.class);
    }

    /**
     * Retrieval of associated <b>EntProjectPublicSector</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjectPublicSector</b>.
     * <p>
     * If the navigation property <b>to_EntProjectPublicSector</b> of a queried <b>EnterpriseProject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjectPublicSector</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjectPublicSector getEntProjectPublicSectorOrFetch()
    {
        if( toEntProjectPublicSector == null ) {
            toEntProjectPublicSector = fetchEntProjectPublicSector();
        }
        return toEntProjectPublicSector;
    }

    /**
     * Retrieval of associated <b>EntProjectPublicSector</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjectPublicSector</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjectPublicSector</b> is already loaded, the result
     *         will contain the <b>EntProjectPublicSector</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EntProjectPublicSector> getEntProjectPublicSectorIfPresent()
    {
        return Option.of(toEntProjectPublicSector);
    }

    /**
     * Overwrites the associated <b>EntProjectPublicSector</b> entity for the loaded navigation property
     * <b>to_EntProjectPublicSector</b>.
     *
     * @param value
     *            New <b>EntProjectPublicSector</b> entity.
     */
    public void setEntProjectPublicSector( final EntProjectPublicSector value )
    {
        toEntProjectPublicSector = value;
    }

    /**
     * Helper class to allow for fluent creation of EnterpriseProject instances.
     *
     */
    public final static class EnterpriseProjectBuilder
    {

        private List<EnterpriseProjectElement> toEnterpriseProjectElement = Lists.newArrayList();
        private EnterpriseProjBlkFunc toEntProjBlkFunc;
        private EntProjectPublicSector toEntProjectPublicSector;

        private EnterpriseProject.EnterpriseProjectBuilder toEnterpriseProjectElement(
            final List<EnterpriseProjectElement> value )
        {
            toEnterpriseProjectElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EnterpriseProject</b> to multiple
         * <b>EnterpriseProjectElement</b>.
         *
         * @param value
         *            The EnterpriseProjectElements to build this EnterpriseProject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProject.EnterpriseProjectBuilder enterpriseProjectElement( EnterpriseProjectElement... value )
        {
            return toEnterpriseProjectElement(Lists.newArrayList(value));
        }

        private EnterpriseProject.EnterpriseProjectBuilder toEntProjBlkFunc( final EnterpriseProjBlkFunc value )
        {
            toEntProjBlkFunc = value;
            return this;
        }

        /**
         * Navigation property <b>to_EntProjBlkFunc</b> for <b>EnterpriseProject</b> to single
         * <b>EnterpriseProjBlkFunc</b>.
         *
         * @param value
         *            The EnterpriseProjBlkFunc to build this EnterpriseProject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProject.EnterpriseProjectBuilder entProjBlkFunc( final EnterpriseProjBlkFunc value )
        {
            return toEntProjBlkFunc(value);
        }

        private EnterpriseProject.EnterpriseProjectBuilder toEntProjectPublicSector(
            final EntProjectPublicSector value )
        {
            toEntProjectPublicSector = value;
            return this;
        }

        /**
         * Navigation property <b>to_EntProjectPublicSector</b> for <b>EnterpriseProject</b> to single
         * <b>EntProjectPublicSector</b>.
         *
         * @param value
         *            The EntProjectPublicSector to build this EnterpriseProject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProject.EnterpriseProjectBuilder entProjectPublicSector( final EntProjectPublicSector value )
        {
            return toEntProjectPublicSector(value);
        }

    }

}
