/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.field.EnterpriseProjectElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.link.EnterpriseProjectElementLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.link.EnterpriseProjectElementOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.selectable.EnterpriseProjectElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EnterpriseProjectElementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EnterpriseProjectElement extends VdmEntity<EnterpriseProjectElement>
{

    /**
     * Selector for all available fields of EnterpriseProjectElement.
     *
     */
    public final static EnterpriseProjectElementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "ProjectElementUUID" )
    @JsonProperty( "ProjectElementUUID" )
    @Nullable
    @ODataField( odataName = "ProjectElementUUID" )
    private UUID projectElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<UUID> PROJECT_ELEMENT_UUID =
        new EnterpriseProjectElementField<UUID>("ProjectElementUUID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElement</b>
     * </p>
     *
     * @return Identification of Entities
     */
    @SerializedName( "ProjectElement" )
    @JsonProperty( "ProjectElement" )
    @Nullable
    @ODataField( odataName = "ProjectElement" )
    private String projectElement;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElement</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> PROJECT_ELEMENT =
        new EnterpriseProjectElementField<String>("ProjectElement");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return Key identifying a WBS element.
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> WBS_ELEMENT_INTERNAL_ID =
        new EnterpriseProjectElementField<String>("WBSElementInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<UUID> PROJECT_UUID =
        new EnterpriseProjectElementField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementDescription</b>
     * </p>
     *
     * @return User-definable text, 40 characters long.
     */
    @SerializedName( "ProjectElementDescription" )
    @JsonProperty( "ProjectElementDescription" )
    @Nullable
    @ODataField( odataName = "ProjectElementDescription" )
    private String projectElementDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementDescription</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> PROJECT_ELEMENT_DESCRIPTION =
        new EnterpriseProjectElementField<String>("ProjectElementDescription");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ParentObjectUUID</b>
     * </p>
     *
     * @return Projectelement Guid
     */
    @SerializedName( "ParentObjectUUID" )
    @JsonProperty( "ParentObjectUUID" )
    @Nullable
    @ODataField( odataName = "ParentObjectUUID" )
    private UUID parentObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ParentObjectUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<UUID> PARENT_OBJECT_UUID =
        new EnterpriseProjectElementField<UUID>("ParentObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     *
     * @return Object Processing Status
     */
    @SerializedName( "ProcessingStatus" )
    @JsonProperty( "ProcessingStatus" )
    @Nullable
    @ODataField( odataName = "ProcessingStatus" )
    private String processingStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProcessingStatus</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> PROCESSING_STATUS =
        new EnterpriseProjectElementField<String>("ProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SortingNumber</b>
     * </p>
     *
     * @return Sort Number
     */
    @SerializedName( "SortingNumber" )
    @JsonProperty( "SortingNumber" )
    @Nullable
    @ODataField( odataName = "SortingNumber" )
    private String sortingNumber;
    /**
     * Use with available fluent helpers to apply the <b>SortingNumber</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> SORTING_NUMBER =
        new EnterpriseProjectElementField<String>("SortingNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartDate</b>
     * </p>
     *
     * @return Latest Start
     */
    @SerializedName( "PlannedStartDate" )
    @JsonProperty( "PlannedStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plannedStartDate;
    /**
     * Use with available fluent helpers to apply the <b>PlannedStartDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<LocalDateTime> PLANNED_START_DATE =
        new EnterpriseProjectElementField<LocalDateTime>("PlannedStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedEndDate</b>
     * </p>
     *
     * @return Latest Finish
     */
    @SerializedName( "PlannedEndDate" )
    @JsonProperty( "PlannedEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plannedEndDate;
    /**
     * Use with available fluent helpers to apply the <b>PlannedEndDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<LocalDateTime> PLANNED_END_DATE =
        new EnterpriseProjectElementField<LocalDateTime>("PlannedEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @return Responsible Cost Center
     */
    @SerializedName( "ResponsibleCostCenter" )
    @JsonProperty( "ResponsibleCostCenter" )
    @Nullable
    @ODataField( odataName = "ResponsibleCostCenter" )
    private String responsibleCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>ResponsibleCostCenter</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> RESPONSIBLE_COST_CENTER =
        new EnterpriseProjectElementField<String>("ResponsibleCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return The company code is an organizational unit within financial accounting.
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> COMPANY_CODE =
        new EnterpriseProjectElementField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Key which together with the controlling area uniquely identifies a profit center.
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> PROFIT_CENTER =
        new EnterpriseProjectElementField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     * <p>
     * Use for Cost of Sales AccountingThe functional area is required to create a profit and loss statement in
     * Financial Accounting using cost of sales accounting. The following are examples of structure
     * criteria:ManufacturingAdministrationSalesResearch & DevelopmentUse for GovernmentThe functional area is needed
     * for Funds Management to meet legal requirements for reporting with functional aspects. You can use the functional
     * area to represent the global targets and goals (such as public safety or city development), in particular the
     * expenses of your organization.Use in Cost of Sales AccountingSee the documentation on Filling the Functional Area
     * Field.For more information about cost of sales accounting and functional areas, see the SAP Library under
     * Financials -> Financial Accounting -> General Ledger Accounting -> Cost of Sales AccountingUse in GovernmentFor
     * more information on functional areas, see the Implementation Guide for Funds Management Government in the section
     * Activate Account Assignment Elements.
     * </p>
     *
     * @return Structure criterion for an enterprise or government based on functional aspects.
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> FUNCTIONAL_AREA =
        new EnterpriseProjectElementField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> CONTROLLING_AREA =
        new EnterpriseProjectElementField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Key uniquely identifying a plant.
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> PLANT =
        new EnterpriseProjectElementField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Location</b>
     * </p>
     *
     * @return Key that identifies the location. The location is subordinate entity in a plant.
     */
    @SerializedName( "Location" )
    @JsonProperty( "Location" )
    @Nullable
    @ODataField( odataName = "Location" )
    private String location;
    /**
     * Use with available fluent helpers to apply the <b>Location</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> LOCATION =
        new EnterpriseProjectElementField<String>("Location");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return The tax jurisdiction is used for determining the tax rates in the USA. It defines to which tax
     *         authorities you must pay your taxes. It is always the city to which the goods are supplied.
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> TAX_JURISDICTION =
        new EnterpriseProjectElementField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     * <p>
     * If alternative labels exist for a functional location, you can define in your user profile which label should be
     * displayed in this field.
     * </p>
     *
     * @return Label that uniquely identifies a functional location.
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> FUNCTIONAL_LOCATION =
        new EnterpriseProjectElementField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Calendar
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> FACTORY_CALENDAR =
        new EnterpriseProjectElementField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     * <p>
     * You must store one costing sheet for each object for which the R/3 System is to determine overhead costs.For
     * orders, you enter the costing sheet in the order master record.For overhead cost orders the costing sheet can be
     * defaulted through a model order.For CO production orders without quantity structure the costing sheet can be
     * defaulted through a planning profile.For production orders, process orders, produc cost collectors, maintenance
     * orders, regular maintenance orders and service orders the costing sheet is defaulted through a valuation
     * variant.The valuation variant is stored in the costing variant. You can store the costing variant as default
     * value per order type and plant.For cost centers you enter the costing sheet in the master data.For buiness
     * processes you enter the costing sheet in the master data.For projects you enter the costing sheet in the project
     * profile.For materials the R/3 System selects the costing sheet through the valuation variant.For base object
     * plannings, enter the costing sheet in the master data of the costing sheet.For cost object IDs the costing sheet
     * is defaulted through the cost object profile.For cost and revenue carrying sales document items the costing sheet
     * is defaulted through the requirements class.
     * </p>
     *
     * @return Controls the calculation of overhead.
     */
    @SerializedName( "CostingSheet" )
    @JsonProperty( "CostingSheet" )
    @Nullable
    @ODataField( odataName = "CostingSheet" )
    private String costingSheet;
    /**
     * Use with available fluent helpers to apply the <b>CostingSheet</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> COSTING_SHEET =
        new EnterpriseProjectElementField<String>("CostingSheet");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile</b>
     * </p>
     * <p>
     * Important control functions of the investment profile:Automatic creation of an asset under construction when you
     * create an internal order or a work breakdown structure (WBS) elementAsset class for the creation of the asset
     * under constructionAsset class for depreciation simulation
     * </p>
     *
     * @return Investment profile
     */
    @SerializedName( "InvestmentProfile" )
    @JsonProperty( "InvestmentProfile" )
    @Nullable
    @ODataField( odataName = "InvestmentProfile" )
    private String investmentProfile;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentProfile</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> INVESTMENT_PROFILE =
        new EnterpriseProjectElementField<String>("InvestmentProfile");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsStatisticalWBSElement</b>
     * </p>
     * <p>
     * Costs and if required revenues are carried on such a WBS element for statistical purposes. This means that:For
     * business transactions that lead to actual costs/revenues another object is required to carry the actual costs.A
     * statistical WBS element cannot be settled.Additional Restriction:You cannot settle overheads on statistical WBS
     * elements.
     * </p>
     *
     * @return Use this indicator to specify whether a WBS element is only for statistical purposes or whether it may
     *         carry actual costs.
     */
    @SerializedName( "WBSIsStatisticalWBSElement" )
    @JsonProperty( "WBSIsStatisticalWBSElement" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSIsStatisticalWBSElement" )
    private Boolean wBSIsStatisticalWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSIsStatisticalWBSElement</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> WBS_IS_STATISTICAL_WBS_ELEMENT =
        new EnterpriseProjectElementField<Boolean>("WBSIsStatisticalWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     * <p>
     * This field is only used for statistical WBS elements.
     * </p>
     *
     * @return When statistical postings are made to a WBS element, actual postings are also made to the cost center you
     *         have entered.
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> COST_CENTER =
        new EnterpriseProjectElementField<String>("CostCenter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsBillingElement</b>
     * </p>
     * <p>
     * If you want to maintain a billing plan for a WBS element, you must set this indicator. If you have maintained a
     * billing plan for the WBS element, you cannot change this indicator.
     * </p>
     *
     * @return This indicator defines the WBS element as a billing element.
     */
    @SerializedName( "WBSElementIsBillingElement" )
    @JsonProperty( "WBSElementIsBillingElement" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSElementIsBillingElement" )
    private Boolean wBSElementIsBillingElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementIsBillingElement</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> WBS_ELEMENT_IS_BILLING_ELEMENT =
        new EnterpriseProjectElementField<Boolean>("WBSElementIsBillingElement");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Who Created Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> CREATED_BY_USER =
        new EnterpriseProjectElementField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Timestamp of Object Creation
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<ZonedDateTime> CREATION_DATE_TIME =
        new EnterpriseProjectElementField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new EnterpriseProjectElementField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> LAST_CHANGED_BY_USER =
        new EnterpriseProjectElementField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectLastChangedDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "ProjectLastChangedDateTime" )
    @JsonProperty( "ProjectLastChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectLastChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime projectLastChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ProjectLastChangedDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<ZonedDateTime> PROJECT_LAST_CHANGED_DATE_TIME =
        new EnterpriseProjectElementField<ZonedDateTime>("ProjectLastChangedDateTime");
    /**
     * Navigation property <b>to_EnterpriseProject</b> for <b>EnterpriseProjectElement</b> to single
     * <b>EnterpriseProject</b>.
     *
     */
    @SerializedName( "to_EnterpriseProject" )
    @JsonProperty( "to_EnterpriseProject" )
    @ODataField( odataName = "to_EnterpriseProject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProject toEnterpriseProject;
    /**
     * Navigation property <b>to_EntProjectElmntPublicSector</b> for <b>EnterpriseProjectElement</b> to single
     * <b>EntProjectElmntPublicSector</b>.
     *
     */
    @SerializedName( "to_EntProjectElmntPublicSector" )
    @JsonProperty( "to_EntProjectElmntPublicSector" )
    @ODataField( odataName = "to_EntProjectElmntPublicSector" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EntProjectElmntPublicSector toEntProjectElmntPublicSector;
    /**
     * Navigation property <b>to_EntProjElmntBlkFunc</b> for <b>EnterpriseProjectElement</b> to single
     * <b>EntProjElmntBlockFunc</b>.
     *
     */
    @SerializedName( "to_EntProjElmntBlkFunc" )
    @JsonProperty( "to_EntProjElmntBlkFunc" )
    @ODataField( odataName = "to_EntProjElmntBlkFunc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EntProjElmntBlockFunc toEntProjElmntBlkFunc;
    /**
     * Navigation property <b>to_ParentProjElement</b> for <b>EnterpriseProjectElement</b> to single
     * <b>EnterpriseProjectElement</b>.
     *
     */
    @SerializedName( "to_ParentProjElement" )
    @JsonProperty( "to_ParentProjElement" )
    @ODataField( odataName = "to_ParentProjElement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProjectElement toParentProjElement;
    /**
     * Navigation property <b>to_SubProjElement</b> for <b>EnterpriseProjectElement</b> to multiple
     * <b>EnterpriseProjectElement</b>.
     *
     */
    @SerializedName( "to_SubProjElement" )
    @JsonProperty( "to_SubProjElement" )
    @ODataField( odataName = "to_SubProjElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EnterpriseProjectElement> toSubProjElement;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProject</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementOneToOneLink<EnterpriseProject> TO_ENTERPRISE_PROJECT =
        new EnterpriseProjectElementOneToOneLink<EnterpriseProject>("to_EnterpriseProject");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjectElmntPublicSector</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementOneToOneLink<EntProjectElmntPublicSector> TO_ENT_PROJECT_ELMNT_PUBLIC_SECTOR =
        new EnterpriseProjectElementOneToOneLink<EntProjectElmntPublicSector>("to_EntProjectElmntPublicSector");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjElmntBlkFunc</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementOneToOneLink<EntProjElmntBlockFunc> TO_ENT_PROJ_ELMNT_BLK_FUNC =
        new EnterpriseProjectElementOneToOneLink<EntProjElmntBlockFunc>("to_EntProjElmntBlkFunc");
    /**
     * Use with available fluent helpers to apply the <b>to_ParentProjElement</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementOneToOneLink<EnterpriseProjectElement> TO_PARENT_PROJ_ELEMENT =
        new EnterpriseProjectElementOneToOneLink<EnterpriseProjectElement>("to_ParentProjElement");
    /**
     * Use with available fluent helpers to apply the <b>to_SubProjElement</b> navigation property to query operations.
     *
     */
    public final static EnterpriseProjectElementLink<EnterpriseProjectElement> TO_SUB_PROJ_ELEMENT =
        new EnterpriseProjectElementLink<EnterpriseProjectElement>("to_SubProjElement");

    @Nonnull
    @Override
    public Class<EnterpriseProjectElement> getType()
    {
        return EnterpriseProjectElement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @param projectElementUUID
     *            Entity Guid
     */
    public void setProjectElementUUID( @Nullable final UUID projectElementUUID )
    {
        rememberChangedField("ProjectElementUUID", this.projectElementUUID);
        this.projectElementUUID = projectElementUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElement</b>
     * </p>
     *
     * @param projectElement
     *            Identification of Entities
     */
    public void setProjectElement( @Nullable final String projectElement )
    {
        rememberChangedField("ProjectElement", this.projectElement);
        this.projectElement = projectElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            Key identifying a WBS element.
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementDescription</b>
     * </p>
     *
     * @param projectElementDescription
     *            User-definable text, 40 characters long.
     */
    public void setProjectElementDescription( @Nullable final String projectElementDescription )
    {
        rememberChangedField("ProjectElementDescription", this.projectElementDescription);
        this.projectElementDescription = projectElementDescription;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ParentObjectUUID</b>
     * </p>
     *
     * @param parentObjectUUID
     *            Projectelement Guid
     */
    public void setParentObjectUUID( @Nullable final UUID parentObjectUUID )
    {
        rememberChangedField("ParentObjectUUID", this.parentObjectUUID);
        this.parentObjectUUID = parentObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     *
     * @param processingStatus
     *            Object Processing Status
     */
    public void setProcessingStatus( @Nullable final String processingStatus )
    {
        rememberChangedField("ProcessingStatus", this.processingStatus);
        this.processingStatus = processingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SortingNumber</b>
     * </p>
     *
     * @param sortingNumber
     *            Sort Number
     */
    public void setSortingNumber( @Nullable final String sortingNumber )
    {
        rememberChangedField("SortingNumber", this.sortingNumber);
        this.sortingNumber = sortingNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartDate</b>
     * </p>
     *
     * @param plannedStartDate
     *            Latest Start
     */
    public void setPlannedStartDate( @Nullable final LocalDateTime plannedStartDate )
    {
        rememberChangedField("PlannedStartDate", this.plannedStartDate);
        this.plannedStartDate = plannedStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedEndDate</b>
     * </p>
     *
     * @param plannedEndDate
     *            Latest Finish
     */
    public void setPlannedEndDate( @Nullable final LocalDateTime plannedEndDate )
    {
        rememberChangedField("PlannedEndDate", this.plannedEndDate);
        this.plannedEndDate = plannedEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @param responsibleCostCenter
     *            Responsible Cost Center
     */
    public void setResponsibleCostCenter( @Nullable final String responsibleCostCenter )
    {
        rememberChangedField("ResponsibleCostCenter", this.responsibleCostCenter);
        this.responsibleCostCenter = responsibleCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            The company code is an organizational unit within financial accounting.
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Key which together with the controlling area uniquely identifies a profit center.
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     * <p>
     * Use for Cost of Sales AccountingThe functional area is required to create a profit and loss statement in
     * Financial Accounting using cost of sales accounting. The following are examples of structure
     * criteria:ManufacturingAdministrationSalesResearch & DevelopmentUse for GovernmentThe functional area is needed
     * for Funds Management to meet legal requirements for reporting with functional aspects. You can use the functional
     * area to represent the global targets and goals (such as public safety or city development), in particular the
     * expenses of your organization.Use in Cost of Sales AccountingSee the documentation on Filling the Functional Area
     * Field.For more information about cost of sales accounting and functional areas, see the SAP Library under
     * Financials -> Financial Accounting -> General Ledger Accounting -> Cost of Sales AccountingUse in GovernmentFor
     * more information on functional areas, see the Implementation Guide for Funds Management Government in the section
     * Activate Account Assignment Elements.
     * </p>
     *
     * @param functionalArea
     *            Structure criterion for an enterprise or government based on functional aspects.
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Key uniquely identifying a plant.
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Location</b>
     * </p>
     *
     * @param location
     *            Key that identifies the location. The location is subordinate entity in a plant.
     */
    public void setLocation( @Nullable final String location )
    {
        rememberChangedField("Location", this.location);
        this.location = location;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            The tax jurisdiction is used for determining the tax rates in the USA. It defines to which tax
     *            authorities you must pay your taxes. It is always the city to which the goods are supplied.
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     * <p>
     * If alternative labels exist for a functional location, you can define in your user profile which label should be
     * displayed in this field.
     * </p>
     *
     * @param functionalLocation
     *            Label that uniquely identifies a functional location.
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Calendar
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     * <p>
     * You must store one costing sheet for each object for which the R/3 System is to determine overhead costs.For
     * orders, you enter the costing sheet in the order master record.For overhead cost orders the costing sheet can be
     * defaulted through a model order.For CO production orders without quantity structure the costing sheet can be
     * defaulted through a planning profile.For production orders, process orders, produc cost collectors, maintenance
     * orders, regular maintenance orders and service orders the costing sheet is defaulted through a valuation
     * variant.The valuation variant is stored in the costing variant. You can store the costing variant as default
     * value per order type and plant.For cost centers you enter the costing sheet in the master data.For buiness
     * processes you enter the costing sheet in the master data.For projects you enter the costing sheet in the project
     * profile.For materials the R/3 System selects the costing sheet through the valuation variant.For base object
     * plannings, enter the costing sheet in the master data of the costing sheet.For cost object IDs the costing sheet
     * is defaulted through the cost object profile.For cost and revenue carrying sales document items the costing sheet
     * is defaulted through the requirements class.
     * </p>
     *
     * @param costingSheet
     *            Controls the calculation of overhead.
     */
    public void setCostingSheet( @Nullable final String costingSheet )
    {
        rememberChangedField("CostingSheet", this.costingSheet);
        this.costingSheet = costingSheet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile</b>
     * </p>
     * <p>
     * Important control functions of the investment profile:Automatic creation of an asset under construction when you
     * create an internal order or a work breakdown structure (WBS) elementAsset class for the creation of the asset
     * under constructionAsset class for depreciation simulation
     * </p>
     *
     * @param investmentProfile
     *            Investment profile
     */
    public void setInvestmentProfile( @Nullable final String investmentProfile )
    {
        rememberChangedField("InvestmentProfile", this.investmentProfile);
        this.investmentProfile = investmentProfile;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsStatisticalWBSElement</b>
     * </p>
     * <p>
     * Costs and if required revenues are carried on such a WBS element for statistical purposes. This means that:For
     * business transactions that lead to actual costs/revenues another object is required to carry the actual costs.A
     * statistical WBS element cannot be settled.Additional Restriction:You cannot settle overheads on statistical WBS
     * elements.
     * </p>
     *
     * @param wBSIsStatisticalWBSElement
     *            Use this indicator to specify whether a WBS element is only for statistical purposes or whether it may
     *            carry actual costs.
     */
    public void setWBSIsStatisticalWBSElement( @Nullable final Boolean wBSIsStatisticalWBSElement )
    {
        rememberChangedField("WBSIsStatisticalWBSElement", this.wBSIsStatisticalWBSElement);
        this.wBSIsStatisticalWBSElement = wBSIsStatisticalWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     * <p>
     * This field is only used for statistical WBS elements.
     * </p>
     *
     * @param costCenter
     *            When statistical postings are made to a WBS element, actual postings are also made to the cost center
     *            you have entered.
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsBillingElement</b>
     * </p>
     * <p>
     * If you want to maintain a billing plan for a WBS element, you must set this indicator. If you have maintained a
     * billing plan for the WBS element, you cannot change this indicator.
     * </p>
     *
     * @param wBSElementIsBillingElement
     *            This indicator defines the WBS element as a billing element.
     */
    public void setWBSElementIsBillingElement( @Nullable final Boolean wBSElementIsBillingElement )
    {
        rememberChangedField("WBSElementIsBillingElement", this.wBSElementIsBillingElement);
        this.wBSElementIsBillingElement = wBSElementIsBillingElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Who Created Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Timestamp of Object Creation
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Timestamp of Last Object Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectLastChangedDateTime</b>
     * </p>
     *
     * @param projectLastChangedDateTime
     *            Timestamp of Last Object Change
     */
    public void setProjectLastChangedDateTime( @Nullable final ZonedDateTime projectLastChangedDateTime )
    {
        rememberChangedField("ProjectLastChangedDateTime", this.projectLastChangedDateTime);
        this.projectLastChangedDateTime = projectLastChangedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EnterpriseProjectElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectElementUUID", getProjectElementUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectElementUUID", getProjectElementUUID());
        values.put("ProjectElement", getProjectElement());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("ProjectUUID", getProjectUUID());
        values.put("ProjectElementDescription", getProjectElementDescription());
        values.put("ParentObjectUUID", getParentObjectUUID());
        values.put("ProcessingStatus", getProcessingStatus());
        values.put("SortingNumber", getSortingNumber());
        values.put("PlannedStartDate", getPlannedStartDate());
        values.put("PlannedEndDate", getPlannedEndDate());
        values.put("ResponsibleCostCenter", getResponsibleCostCenter());
        values.put("CompanyCode", getCompanyCode());
        values.put("ProfitCenter", getProfitCenter());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("ControllingArea", getControllingArea());
        values.put("Plant", getPlant());
        values.put("Location", getLocation());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("CostingSheet", getCostingSheet());
        values.put("InvestmentProfile", getInvestmentProfile());
        values.put("WBSIsStatisticalWBSElement", getWBSIsStatisticalWBSElement());
        values.put("CostCenter", getCostCenter());
        values.put("WBSElementIsBillingElement", getWBSElementIsBillingElement());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ProjectLastChangedDateTime", getProjectLastChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectElementUUID") ) {
                final Object value = values.remove("ProjectElementUUID");
                if( (value == null) || (!value.equals(getProjectElementUUID())) ) {
                    setProjectElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectElement") ) {
                final Object value = values.remove("ProjectElement");
                if( (value == null) || (!value.equals(getProjectElement())) ) {
                    setProjectElement(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectElementDescription") ) {
                final Object value = values.remove("ProjectElementDescription");
                if( (value == null) || (!value.equals(getProjectElementDescription())) ) {
                    setProjectElementDescription(((String) value));
                }
            }
            if( values.containsKey("ParentObjectUUID") ) {
                final Object value = values.remove("ParentObjectUUID");
                if( (value == null) || (!value.equals(getParentObjectUUID())) ) {
                    setParentObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProcessingStatus") ) {
                final Object value = values.remove("ProcessingStatus");
                if( (value == null) || (!value.equals(getProcessingStatus())) ) {
                    setProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("SortingNumber") ) {
                final Object value = values.remove("SortingNumber");
                if( (value == null) || (!value.equals(getSortingNumber())) ) {
                    setSortingNumber(((String) value));
                }
            }
            if( values.containsKey("PlannedStartDate") ) {
                final Object value = values.remove("PlannedStartDate");
                if( (value == null) || (!value.equals(getPlannedStartDate())) ) {
                    setPlannedStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlannedEndDate") ) {
                final Object value = values.remove("PlannedEndDate");
                if( (value == null) || (!value.equals(getPlannedEndDate())) ) {
                    setPlannedEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ResponsibleCostCenter") ) {
                final Object value = values.remove("ResponsibleCostCenter");
                if( (value == null) || (!value.equals(getResponsibleCostCenter())) ) {
                    setResponsibleCostCenter(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Location") ) {
                final Object value = values.remove("Location");
                if( (value == null) || (!value.equals(getLocation())) ) {
                    setLocation(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("CostingSheet") ) {
                final Object value = values.remove("CostingSheet");
                if( (value == null) || (!value.equals(getCostingSheet())) ) {
                    setCostingSheet(((String) value));
                }
            }
            if( values.containsKey("InvestmentProfile") ) {
                final Object value = values.remove("InvestmentProfile");
                if( (value == null) || (!value.equals(getInvestmentProfile())) ) {
                    setInvestmentProfile(((String) value));
                }
            }
            if( values.containsKey("WBSIsStatisticalWBSElement") ) {
                final Object value = values.remove("WBSIsStatisticalWBSElement");
                if( (value == null) || (!value.equals(getWBSIsStatisticalWBSElement())) ) {
                    setWBSIsStatisticalWBSElement(((Boolean) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("WBSElementIsBillingElement") ) {
                final Object value = values.remove("WBSElementIsBillingElement");
                if( (value == null) || (!value.equals(getWBSElementIsBillingElement())) ) {
                    setWBSElementIsBillingElement(((Boolean) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ProjectLastChangedDateTime") ) {
                final Object value = values.remove("ProjectLastChangedDateTime");
                if( (value == null) || (!value.equals(getProjectLastChangedDateTime())) ) {
                    setProjectLastChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProject") ) {
                final Object value = (values).remove("to_EnterpriseProject");
                if( value instanceof Map ) {
                    if( toEnterpriseProject == null ) {
                        toEnterpriseProject = new EnterpriseProject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProject.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EntProjectElmntPublicSector") ) {
                final Object value = (values).remove("to_EntProjectElmntPublicSector");
                if( value instanceof Map ) {
                    if( toEntProjectElmntPublicSector == null ) {
                        toEntProjectElmntPublicSector = new EntProjectElmntPublicSector();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEntProjectElmntPublicSector.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EntProjElmntBlkFunc") ) {
                final Object value = (values).remove("to_EntProjElmntBlkFunc");
                if( value instanceof Map ) {
                    if( toEntProjElmntBlkFunc == null ) {
                        toEntProjElmntBlkFunc = new EntProjElmntBlockFunc();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEntProjElmntBlkFunc.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ParentProjElement") ) {
                final Object value = (values).remove("to_ParentProjElement");
                if( value instanceof Map ) {
                    if( toParentProjElement == null ) {
                        toParentProjElement = new EnterpriseProjectElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toParentProjElement.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SubProjElement") ) {
                final Object value = (values).remove("to_SubProjElement");
                if( value instanceof Iterable ) {
                    if( toSubProjElement == null ) {
                        toSubProjElement = Lists.newArrayList();
                    } else {
                        toSubProjElement = Lists.newArrayList(toSubProjElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EnterpriseProjectElement entity;
                        if( toSubProjElement.size() > i ) {
                            entity = toSubProjElement.get(i);
                        } else {
                            entity = new EnterpriseProjectElement();
                            toSubProjElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EnterpriseProjectElementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EnterpriseProjectElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EnterpriseProjectElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EnterpriseProjectElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProject != null ) {
            (values).put("to_EnterpriseProject", toEnterpriseProject);
        }
        if( toEntProjectElmntPublicSector != null ) {
            (values).put("to_EntProjectElmntPublicSector", toEntProjectElmntPublicSector);
        }
        if( toEntProjElmntBlkFunc != null ) {
            (values).put("to_EntProjElmntBlkFunc", toEntProjElmntBlkFunc);
        }
        if( toParentProjElement != null ) {
            (values).put("to_ParentProjElement", toParentProjElement);
        }
        if( toSubProjElement != null ) {
            (values).put("to_SubProjElement", toSubProjElement);
        }
        return values;
    }

    /**
     * Fetches the <b>EnterpriseProject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject fetchEnterpriseProject()
    {
        return fetchFieldAsSingle("to_EnterpriseProject", EnterpriseProject.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject getEnterpriseProjectOrFetch()
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = fetchEnterpriseProject();
        }
        return toEnterpriseProject;
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProject</b> is already loaded, the result will
     *         contain the <b>EnterpriseProject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProject> getEnterpriseProjectIfPresent()
    {
        return Option.of(toEnterpriseProject);
    }

    /**
     * Overwrites the associated <b>EnterpriseProject</b> entity for the loaded navigation property
     * <b>to_EnterpriseProject</b>.
     *
     * @param value
     *            New <b>EnterpriseProject</b> entity.
     */
    public void setEnterpriseProject( final EnterpriseProject value )
    {
        toEnterpriseProject = value;
    }

    /**
     * Fetches the <b>EntProjectElmntPublicSector</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_EntProjectElmntPublicSector</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EntProjectElmntPublicSector</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjectElmntPublicSector fetchEntProjectElmntPublicSector()
    {
        return fetchFieldAsSingle("to_EntProjectElmntPublicSector", EntProjectElmntPublicSector.class);
    }

    /**
     * Retrieval of associated <b>EntProjectElmntPublicSector</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjectElmntPublicSector</b>.
     * <p>
     * If the navigation property <b>to_EntProjectElmntPublicSector</b> of a queried <b>EnterpriseProjectElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjectElmntPublicSector</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjectElmntPublicSector getEntProjectElmntPublicSectorOrFetch()
    {
        if( toEntProjectElmntPublicSector == null ) {
            toEntProjectElmntPublicSector = fetchEntProjectElmntPublicSector();
        }
        return toEntProjectElmntPublicSector;
    }

    /**
     * Retrieval of associated <b>EntProjectElmntPublicSector</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjectElmntPublicSector</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjectElmntPublicSector</b> is already loaded, the
     *         result will contain the <b>EntProjectElmntPublicSector</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EntProjectElmntPublicSector> getEntProjectElmntPublicSectorIfPresent()
    {
        return Option.of(toEntProjectElmntPublicSector);
    }

    /**
     * Overwrites the associated <b>EntProjectElmntPublicSector</b> entity for the loaded navigation property
     * <b>to_EntProjectElmntPublicSector</b>.
     *
     * @param value
     *            New <b>EntProjectElmntPublicSector</b> entity.
     */
    public void setEntProjectElmntPublicSector( final EntProjectElmntPublicSector value )
    {
        toEntProjectElmntPublicSector = value;
    }

    /**
     * Fetches the <b>EntProjElmntBlockFunc</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EntProjElmntBlkFunc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EntProjElmntBlockFunc</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjElmntBlockFunc fetchEntProjElmntBlkFunc()
    {
        return fetchFieldAsSingle("to_EntProjElmntBlkFunc", EntProjElmntBlockFunc.class);
    }

    /**
     * Retrieval of associated <b>EntProjElmntBlockFunc</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjElmntBlkFunc</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntBlkFunc</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjElmntBlockFunc</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjElmntBlockFunc getEntProjElmntBlkFuncOrFetch()
    {
        if( toEntProjElmntBlkFunc == null ) {
            toEntProjElmntBlkFunc = fetchEntProjElmntBlkFunc();
        }
        return toEntProjElmntBlkFunc;
    }

    /**
     * Retrieval of associated <b>EntProjElmntBlockFunc</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjElmntBlkFunc</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjElmntBlkFunc</b> is already loaded, the result
     *         will contain the <b>EntProjElmntBlockFunc</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EntProjElmntBlockFunc> getEntProjElmntBlkFuncIfPresent()
    {
        return Option.of(toEntProjElmntBlkFunc);
    }

    /**
     * Overwrites the associated <b>EntProjElmntBlockFunc</b> entity for the loaded navigation property
     * <b>to_EntProjElmntBlkFunc</b>.
     *
     * @param value
     *            New <b>EntProjElmntBlockFunc</b> entity.
     */
    public void setEntProjElmntBlkFunc( final EntProjElmntBlockFunc value )
    {
        toEntProjElmntBlkFunc = value;
    }

    /**
     * Fetches the <b>EnterpriseProjectElement</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ParentProjElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProjectElement</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement fetchParentProjElement()
    {
        return fetchFieldAsSingle("to_ParentProjElement", EnterpriseProjectElement.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ParentProjElement</b>.
     * <p>
     * If the navigation property <b>to_ParentProjElement</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement getParentProjElementOrFetch()
    {
        if( toParentProjElement == null ) {
            toParentProjElement = fetchParentProjElement();
        }
        return toParentProjElement;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ParentProjElement</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ParentProjElement</b> is already loaded, the result will
     *         contain the <b>EnterpriseProjectElement</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProjectElement> getParentProjElementIfPresent()
    {
        return Option.of(toParentProjElement);
    }

    /**
     * Overwrites the associated <b>EnterpriseProjectElement</b> entity for the loaded navigation property
     * <b>to_ParentProjElement</b>.
     *
     * @param value
     *            New <b>EnterpriseProjectElement</b> entity.
     */
    public void setParentProjElement( final EnterpriseProjectElement value )
    {
        toParentProjElement = value;
    }

    /**
     * Fetches the <b>EnterpriseProjectElement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SubProjElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EnterpriseProjectElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectElement> fetchSubProjElement()
    {
        return fetchFieldAsList("to_SubProjElement", EnterpriseProjectElement.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubProjElement</b>.
     * <p>
     * If the navigation property <b>to_SubProjElement</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectElement> getSubProjElementOrFetch()
    {
        if( toSubProjElement == null ) {
            toSubProjElement = fetchSubProjElement();
        }
        return toSubProjElement;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubProjElement</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubProjElement</b> is already loaded, the result will
     *         contain the <b>EnterpriseProjectElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EnterpriseProjectElement>> getSubProjElementIfPresent()
    {
        return Option.of(toSubProjElement);
    }

    /**
     * Overwrites the list of associated <b>EnterpriseProjectElement</b> entities for the loaded navigation property
     * <b>to_SubProjElement</b>.
     * <p>
     * If the navigation property <b>to_SubProjElement</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EnterpriseProjectElement</b> entities.
     */
    public void setSubProjElement( @Nonnull final List<EnterpriseProjectElement> value )
    {
        if( toSubProjElement == null ) {
            toSubProjElement = Lists.newArrayList();
        }
        toSubProjElement.clear();
        toSubProjElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EnterpriseProjectElement</b> entities. This corresponds to the OData
     * navigation property <b>to_SubProjElement</b>.
     * <p>
     * If the navigation property <b>to_SubProjElement</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EnterpriseProjectElement</b> entities.
     */
    public void addSubProjElement( EnterpriseProjectElement... entity )
    {
        if( toSubProjElement == null ) {
            toSubProjElement = Lists.newArrayList();
        }
        toSubProjElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of EnterpriseProjectElement instances.
     *
     */
    public final static class EnterpriseProjectElementBuilder
    {

        private EnterpriseProject toEnterpriseProject;
        private EntProjectElmntPublicSector toEntProjectElmntPublicSector;
        private EntProjElmntBlockFunc toEntProjElmntBlkFunc;
        private EnterpriseProjectElement toParentProjElement;
        private List<EnterpriseProjectElement> toSubProjElement = Lists.newArrayList();

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toEnterpriseProject(
            final EnterpriseProject value )
        {
            toEnterpriseProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProject</b> for <b>EnterpriseProjectElement</b> to single
         * <b>EnterpriseProject</b>.
         *
         * @param value
         *            The EnterpriseProject to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder enterpriseProject(
            final EnterpriseProject value )
        {
            return toEnterpriseProject(value);
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toEntProjectElmntPublicSector(
            final EntProjectElmntPublicSector value )
        {
            toEntProjectElmntPublicSector = value;
            return this;
        }

        /**
         * Navigation property <b>to_EntProjectElmntPublicSector</b> for <b>EnterpriseProjectElement</b> to single
         * <b>EntProjectElmntPublicSector</b>.
         *
         * @param value
         *            The EntProjectElmntPublicSector to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder entProjectElmntPublicSector(
            final EntProjectElmntPublicSector value )
        {
            return toEntProjectElmntPublicSector(value);
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toEntProjElmntBlkFunc(
            final EntProjElmntBlockFunc value )
        {
            toEntProjElmntBlkFunc = value;
            return this;
        }

        /**
         * Navigation property <b>to_EntProjElmntBlkFunc</b> for <b>EnterpriseProjectElement</b> to single
         * <b>EntProjElmntBlockFunc</b>.
         *
         * @param value
         *            The EntProjElmntBlockFunc to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder entProjElmntBlkFunc(
            final EntProjElmntBlockFunc value )
        {
            return toEntProjElmntBlkFunc(value);
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toParentProjElement(
            final EnterpriseProjectElement value )
        {
            toParentProjElement = value;
            return this;
        }

        /**
         * Navigation property <b>to_ParentProjElement</b> for <b>EnterpriseProjectElement</b> to single
         * <b>EnterpriseProjectElement</b>.
         *
         * @param value
         *            The EnterpriseProjectElement to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder parentProjElement(
            final EnterpriseProjectElement value )
        {
            return toParentProjElement(value);
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toSubProjElement(
            final List<EnterpriseProjectElement> value )
        {
            toSubProjElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubProjElement</b> for <b>EnterpriseProjectElement</b> to multiple
         * <b>EnterpriseProjectElement</b>.
         *
         * @param value
         *            The EnterpriseProjectElements to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder subProjElement(
            EnterpriseProjectElement... value )
        {
            return toSubProjElement(Lists.newArrayList(value));
        }

    }

}
