/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link EnterpriseProjectServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService EnterpriseProjectService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultEnterpriseProjectServiceBatch
    extends
    BatchFluentHelperBasic<EnterpriseProjectServiceBatch, EnterpriseProjectServiceBatchChangeSet>
    implements
    EnterpriseProjectServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultEnterpriseProjectServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultEnterpriseProjectServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultEnterpriseProjectServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultEnterpriseProjectServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultEnterpriseProjectServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultEnterpriseProjectServiceBatchChangeSet(this, service);
    }

}
