/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement;

/**
 * Implementation of the {@link EnterpriseProjectServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService EnterpriseProjectService}.
 *
 */
public class DefaultEnterpriseProjectServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<EnterpriseProjectServiceBatch, EnterpriseProjectServiceBatchChangeSet>
    implements
    EnterpriseProjectServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService service;

    @SuppressWarnings( "deprecation" )
    DefaultEnterpriseProjectServiceBatchChangeSet(
        @Nonnull final DefaultEnterpriseProjectServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultEnterpriseProjectServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet createEnterpriseProjBlkFunc(
        @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc )
    {
        return addRequestCreate(service::createEnterpriseProjBlkFunc, enterpriseProjBlkFunc);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet updateEnterpriseProjBlkFunc(
        @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc )
    {
        return addRequestUpdate(service::updateEnterpriseProjBlkFunc, enterpriseProjBlkFunc);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet createEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return addRequestCreate(service::createEnterpriseProject, enterpriseProject);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet updateEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return addRequestUpdate(service::updateEnterpriseProject, enterpriseProject);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet deleteEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return addRequestDelete(service::deleteEnterpriseProject, enterpriseProject);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet createEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return addRequestCreate(service::createEnterpriseProjectElement, enterpriseProjectElement);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet updateEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return addRequestUpdate(service::updateEnterpriseProjectElement, enterpriseProjectElement);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet deleteEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return addRequestDelete(service::deleteEnterpriseProjectElement, enterpriseProjectElement);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet updateEntProjectElmntPublicSector(
        @Nonnull final EntProjectElmntPublicSector entProjectElmntPublicSector )
    {
        return addRequestUpdate(service::updateEntProjectElmntPublicSector, entProjectElmntPublicSector);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet updateEntProjectPublicSector(
        @Nonnull final EntProjectPublicSector entProjectPublicSector )
    {
        return addRequestUpdate(service::updateEntProjectPublicSector, entProjectPublicSector);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet createEntProjElmntBlockFunc(
        @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc )
    {
        return addRequestCreate(service::createEntProjElmntBlockFunc, entProjElmntBlockFunc);
    }

    @Nonnull
    @Override
    public EnterpriseProjectServiceBatchChangeSet updateEntProjElmntBlockFunc(
        @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc )
    {
        return addRequestUpdate(service::updateEntProjElmntBlockFunc, entProjElmntBlockFunc);
    }

}
