/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService EnterpriseProjectService}.
 *
 */
public interface EnterpriseProjectServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<EnterpriseProjectServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<EnterpriseProjectServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjBlkFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     *            EnterpriseProjBlkFunc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        createEnterpriseProjBlkFunc( @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjBlkFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
     *            EnterpriseProjBlkFunc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        updateEnterpriseProjBlkFunc( @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     * EnterpriseProject} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *            EnterpriseProject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        createEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     * EnterpriseProject} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *            EnterpriseProject} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        updateEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject EnterpriseProject}
     * entity in the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProject
     *            EnterpriseProject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        deleteEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     * EnterpriseProjectElement} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        createEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     * EnterpriseProjectElement} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        updateEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     * EnterpriseProjectElement} entity in the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        deleteEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector
     * EntProjectElmntPublicSector} entity and save it to the S/4HANA system.
     *
     * @param entProjectElmntPublicSector
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector
     *            EntProjectElmntPublicSector} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        updateEntProjectElmntPublicSector( @Nonnull final EntProjectElmntPublicSector entProjectElmntPublicSector );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector
     * EntProjectPublicSector} entity and save it to the S/4HANA system.
     *
     * @param entProjectPublicSector
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector
     *            EntProjectPublicSector} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        updateEntProjectPublicSector( @Nonnull final EntProjectPublicSector entProjectPublicSector );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntBlockFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     *            EntProjElmntBlockFunc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        createEntProjElmntBlockFunc( @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntBlockFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjElmntBlockFunc
     *            EntProjElmntBlockFunc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectServiceBatchChangeSet
        updateEntProjElmntBlockFunc( @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc );

}
