/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector
 * EntProjectElmntPublicSector}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.field.EntProjectElmntPublicSectorField
 * EntProjectElmntPublicSectorField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.link.EntProjectElmntPublicSectorLink
 * EntProjectElmntPublicSectorLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector#PROJECT_ELEMENT_UUID
 * PROJECT_ELEMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector#FUND_IS_FIX_ASSIGNED
 * FUND_IS_FIX_ASSIGNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector#FUNCTIONAL_AREA_IS_FIX_ASSIGNED
 * FUNCTIONAL_AREA_IS_FIX_ASSIGNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector#GRANT_IS_FIX_ASSIGNED
 * GRANT_IS_FIX_ASSIGNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector#SPONSORED_PROGRAM
 * SPONSORED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector#PROJECT_LAST_CHANGED_DATE_TIME
 * PROJECT_LAST_CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectElmntPublicSector#TO_ENTERPRISE_PROJECT_ELEMENT
 * TO_ENTERPRISE_PROJECT_ELEMENT}</li>
 * </ul>
 *
 */
public interface EntProjectElmntPublicSectorSelectable extends EntitySelectable<EntProjectElmntPublicSector>
{

}
