/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector
 * EntProjectPublicSector}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.field.EntProjectPublicSectorField
 * EntProjectPublicSectorField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.link.EntProjectPublicSectorLink
 * EntProjectPublicSectorLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector#FUND_IS_FIX_ASSIGNED
 * FUND_IS_FIX_ASSIGNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector#FUNCTIONAL_AREA_IS_FIX_ASSIGNED
 * FUNCTIONAL_AREA_IS_FIX_ASSIGNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector#GRANT_IS_FIX_ASSIGNED
 * GRANT_IS_FIX_ASSIGNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector#SPONSORED_PROGRAM
 * SPONSORED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EntProjectPublicSector#PROJECT_LAST_CHANGED_DATE_TIME
 * PROJECT_LAST_CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface EntProjectPublicSectorSelectable extends EntitySelectable<EntProjectPublicSector>
{

}
