/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc
 * EnterpriseProjBlkFunc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.field.EnterpriseProjBlkFuncField
 * EnterpriseProjBlkFuncField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.link.EnterpriseProjBlkFuncLink
 * EnterpriseProjBlkFuncLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc#ENT_PROJ_TIME_RECG_IS_BLKD
 * ENT_PROJ_TIME_RECG_IS_BLKD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc#ENT_PROJ_STAFF_EXPENSE_POSTG_IS_BLKD
 * ENT_PROJ_STAFF_EXPENSE_POSTG_IS_BLKD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc#ENT_PROJ_SERVICE_POSTING_IS_BLKD
 * ENT_PROJ_SERVICE_POSTING_IS_BLKD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc#ENT_PROJ_OTHER_EXPENSE_POSTG_IS_BLKD
 * ENT_PROJ_OTHER_EXPENSE_POSTG_IS_BLKD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc#ENT_PROJ_PURCHASING_IS_BLKD
 * ENT_PROJ_PURCHASING_IS_BLKD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.EnterpriseProjBlkFunc#PROJECT_LAST_CHANGED_DATE_TIME
 * PROJECT_LAST_CHANGED_DATE_TIME}</li>
 * </ul>
 *
 */
public interface EnterpriseProjBlkFuncSelectable extends EntitySelectable<EnterpriseProjBlkFunc>
{

}
