/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.net.URI;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>ChangeEntProjProcgStatus</b> OData function import.
 *
 */
public class ChangeEntProjProcgStatusFluentHelper
    extends
    SingleValuedFluentHelperFunction<ChangeEntProjProcgStatusFluentHelper, EnterpriseProject, EnterpriseProject>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>ChangeEntProjProcgStatus</b> OData function import with
     * the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param processingStatus
     *            Proc. Status
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 2
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProcessingStatus</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param projectUUID
     *            Entity GUID
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: none
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ProjectUUID</b>
     *            </p>
     */
    public ChangeEntProjProcgStatusFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final UUID projectUUID,
        @Nullable final String processingStatus )
    {
        super(servicePath);
        values.put("ProjectUUID", projectUUID);
        if( processingStatus != null ) {
            values.put("ProcessingStatus", processingStatus);
        }
    }

    @Override
    @Nonnull
    protected Class<EnterpriseProject> getEntityClass()
    {
        return EnterpriseProject.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "ChangeEntProjProcgStatus";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public EnterpriseProject executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
