/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EntProjElmntDlvbrlField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjElmntDlvbrlLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjElmntDlvbrlOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EntProjElmntDlvbrlSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Element Deliverable
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EntProjElmntDlvbrlType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EntProjElmntDlvbrl extends VdmEntity<EntProjElmntDlvbrl>
{

    /**
     * Selector for all available fields of EntProjElmntDlvbrl.
     *
     */
    public final static EntProjElmntDlvbrlSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<Boolean> UPDATE_MC = new EntProjElmntDlvbrlField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjElmntDlvDistr_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_EntProjElmntDlvDistr_oc" )
    @JsonProperty( "to_EntProjElmntDlvDistr_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_EntProjElmntDlvDistr_oc" )
    private Boolean entProjElmntDlvDistr_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjElmntDlvDistr_oc</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<Boolean> ENT_PROJ_ELMNT_DLV_DISTR_OC =
        new EntProjElmntDlvbrlField<Boolean>("to_EntProjElmntDlvDistr_oc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDeliverableUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "EntProjElmntDeliverableUUID" )
    @JsonProperty( "EntProjElmntDeliverableUUID" )
    @Nullable
    @ODataField( odataName = "EntProjElmntDeliverableUUID" )
    private UUID entProjElmntDeliverableUUID;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntDeliverableUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<UUID> ENT_PROJ_ELMNT_DELIVERABLE_UUID =
        new EntProjElmntDlvbrlField<UUID>("EntProjElmntDeliverableUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectElementUUID" )
    @JsonProperty( "ProjectElementUUID" )
    @Nullable
    @ODataField( odataName = "ProjectElementUUID" )
    private UUID projectElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<UUID> PROJECT_ELEMENT_UUID =
        new EntProjElmntDlvbrlField<UUID>("ProjectElementUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<UUID> PROJECT_UUID = new EntProjElmntDlvbrlField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDeliverableType</b>
     * </p>
     *
     * @return Type of a Project Element Deliverable
     */
    @SerializedName( "EntProjElmntDeliverableType" )
    @JsonProperty( "EntProjElmntDeliverableType" )
    @Nullable
    @ODataField( odataName = "EntProjElmntDeliverableType" )
    private String entProjElmntDeliverableType;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntDeliverableType</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<String> ENT_PROJ_ELMNT_DELIVERABLE_TYPE =
        new EntProjElmntDlvbrlField<String>("EntProjElmntDeliverableType");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlQuantity</b>
     * </p>
     *
     * @return Total Quantity of a Project Element Deliverable
     */
    @SerializedName( "EntProjElmntDlvbrlQuantity" )
    @JsonProperty( "EntProjElmntDlvbrlQuantity" )
    @Nullable
    @ODataField( odataName = "EntProjElmntDlvbrlQuantity" )
    private BigDecimal entProjElmntDlvbrlQuantity;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntDlvbrlQuantity</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<BigDecimal> ENT_PROJ_ELMNT_DLVBRL_QUANTITY =
        new EntProjElmntDlvbrlField<BigDecimal>("EntProjElmntDlvbrlQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlQuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure for the Deliverable Quantity
     */
    @SerializedName( "EntProjElmntDlvbrlQuantityUnit" )
    @JsonProperty( "EntProjElmntDlvbrlQuantityUnit" )
    @Nullable
    @ODataField( odataName = "EntProjElmntDlvbrlQuantityUnit" )
    private String entProjElmntDlvbrlQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntDlvbrlQuantityUnit</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<String> ENT_PROJ_ELMNT_DLVBRL_QUANTITY_UNIT =
        new EntProjElmntDlvbrlField<String>("EntProjElmntDlvbrlQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Who Created Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<String> CREATED_BY_USER =
        new EntProjElmntDlvbrlField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Timestamp of Object Creation
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<ZonedDateTime> CREATION_DATE_TIME =
        new EntProjElmntDlvbrlField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new EntProjElmntDlvbrlField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlField<String> LAST_CHANGED_BY_USER =
        new EntProjElmntDlvbrlField<String>("LastChangedByUser");
    /**
     * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EntProjElmntDlvbrl</b> to single
     * <b>EnterpriseProjectElement</b>.
     *
     */
    @SerializedName( "to_EnterpriseProjectElement" )
    @JsonProperty( "to_EnterpriseProjectElement" )
    @ODataField( odataName = "to_EnterpriseProjectElement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProjectElement toEnterpriseProjectElement;
    /**
     * Navigation property <b>to_EntProjElmntDlvDistr</b> for <b>EntProjElmntDlvbrl</b> to multiple
     * <b>EntProjElmntDlvbrlDistr</b>.
     *
     */
    @SerializedName( "to_EntProjElmntDlvDistr" )
    @JsonProperty( "to_EntProjElmntDlvDistr" )
    @ODataField( odataName = "to_EntProjElmntDlvDistr" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EntProjElmntDlvbrlDistr> toEntProjElmntDlvDistr;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProjectElement</b> navigation property to query
     * operations.
     *
     */
    public final static EntProjElmntDlvbrlOneToOneLink<EnterpriseProjectElement> TO_ENTERPRISE_PROJECT_ELEMENT =
        new EntProjElmntDlvbrlOneToOneLink<EnterpriseProjectElement>("to_EnterpriseProjectElement");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjElmntDlvDistr</b> navigation property to query
     * operations.
     *
     */
    public final static EntProjElmntDlvbrlLink<EntProjElmntDlvbrlDistr> TO_ENT_PROJ_ELMNT_DLV_DISTR =
        new EntProjElmntDlvbrlLink<EntProjElmntDlvbrlDistr>("to_EntProjElmntDlvDistr");

    @Nonnull
    @Override
    public Class<EntProjElmntDlvbrl> getType()
    {
        return EntProjElmntDlvbrl.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjElmntDlvDistr_oc</b>
     * </p>
     *
     * @param entProjElmntDlvDistr_oc
     *            Dynamic CbA-Control
     */
    public void setEntProjElmntDlvDistr_oc( @Nullable final Boolean entProjElmntDlvDistr_oc )
    {
        rememberChangedField("to_EntProjElmntDlvDistr_oc", this.entProjElmntDlvDistr_oc);
        this.entProjElmntDlvDistr_oc = entProjElmntDlvDistr_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDeliverableUUID</b>
     * </p>
     *
     * @param entProjElmntDeliverableUUID
     *            Entity Guid
     */
    public void setEntProjElmntDeliverableUUID( @Nullable final UUID entProjElmntDeliverableUUID )
    {
        rememberChangedField("EntProjElmntDeliverableUUID", this.entProjElmntDeliverableUUID);
        this.entProjElmntDeliverableUUID = entProjElmntDeliverableUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @param projectElementUUID
     *            Entity Guid
     */
    public void setProjectElementUUID( @Nullable final UUID projectElementUUID )
    {
        rememberChangedField("ProjectElementUUID", this.projectElementUUID);
        this.projectElementUUID = projectElementUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDeliverableType</b>
     * </p>
     *
     * @param entProjElmntDeliverableType
     *            Type of a Project Element Deliverable
     */
    public void setEntProjElmntDeliverableType( @Nullable final String entProjElmntDeliverableType )
    {
        rememberChangedField("EntProjElmntDeliverableType", this.entProjElmntDeliverableType);
        this.entProjElmntDeliverableType = entProjElmntDeliverableType;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlQuantity</b>
     * </p>
     *
     * @param entProjElmntDlvbrlQuantity
     *            Total Quantity of a Project Element Deliverable
     */
    public void setEntProjElmntDlvbrlQuantity( @Nullable final BigDecimal entProjElmntDlvbrlQuantity )
    {
        rememberChangedField("EntProjElmntDlvbrlQuantity", this.entProjElmntDlvbrlQuantity);
        this.entProjElmntDlvbrlQuantity = entProjElmntDlvbrlQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlQuantityUnit</b>
     * </p>
     *
     * @param entProjElmntDlvbrlQuantityUnit
     *            Unit of Measure for the Deliverable Quantity
     */
    public void setEntProjElmntDlvbrlQuantityUnit( @Nullable final String entProjElmntDlvbrlQuantityUnit )
    {
        rememberChangedField("EntProjElmntDlvbrlQuantityUnit", this.entProjElmntDlvbrlQuantityUnit);
        this.entProjElmntDlvbrlQuantityUnit = entProjElmntDlvbrlQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Who Created Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Timestamp of Object Creation
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Timestamp of Last Object Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EntProjElmntDlvbrl";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EntProjElmntDeliverableUUID", getEntProjElmntDeliverableUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Update_mc", getUpdate_mc());
        values.put("to_EntProjElmntDlvDistr_oc", getEntProjElmntDlvDistr_oc());
        values.put("EntProjElmntDeliverableUUID", getEntProjElmntDeliverableUUID());
        values.put("ProjectElementUUID", getProjectElementUUID());
        values.put("ProjectUUID", getProjectUUID());
        values.put("EntProjElmntDeliverableType", getEntProjElmntDeliverableType());
        values.put("EntProjElmntDlvbrlQuantity", getEntProjElmntDlvbrlQuantity());
        values.put("EntProjElmntDlvbrlQuantityUnit", getEntProjElmntDlvbrlQuantityUnit());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_EntProjElmntDlvDistr_oc") ) {
                final Object value = values.remove("to_EntProjElmntDlvDistr_oc");
                if( (value == null) || (!value.equals(getEntProjElmntDlvDistr_oc())) ) {
                    setEntProjElmntDlvDistr_oc(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjElmntDeliverableUUID") ) {
                final Object value = values.remove("EntProjElmntDeliverableUUID");
                if( (value == null) || (!value.equals(getEntProjElmntDeliverableUUID())) ) {
                    setEntProjElmntDeliverableUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectElementUUID") ) {
                final Object value = values.remove("ProjectElementUUID");
                if( (value == null) || (!value.equals(getProjectElementUUID())) ) {
                    setProjectElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("EntProjElmntDeliverableType") ) {
                final Object value = values.remove("EntProjElmntDeliverableType");
                if( (value == null) || (!value.equals(getEntProjElmntDeliverableType())) ) {
                    setEntProjElmntDeliverableType(((String) value));
                }
            }
            if( values.containsKey("EntProjElmntDlvbrlQuantity") ) {
                final Object value = values.remove("EntProjElmntDlvbrlQuantity");
                if( (value == null) || (!value.equals(getEntProjElmntDlvbrlQuantity())) ) {
                    setEntProjElmntDlvbrlQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("EntProjElmntDlvbrlQuantityUnit") ) {
                final Object value = values.remove("EntProjElmntDlvbrlQuantityUnit");
                if( (value == null) || (!value.equals(getEntProjElmntDlvbrlQuantityUnit())) ) {
                    setEntProjElmntDlvbrlQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProjectElement") ) {
                final Object value = (values).remove("to_EnterpriseProjectElement");
                if( value instanceof Map ) {
                    if( toEnterpriseProjectElement == null ) {
                        toEnterpriseProjectElement = new EnterpriseProjectElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProjectElement.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EntProjElmntDlvDistr") ) {
                final Object value = (values).remove("to_EntProjElmntDlvDistr");
                if( value instanceof Iterable ) {
                    if( toEntProjElmntDlvDistr == null ) {
                        toEntProjElmntDlvDistr = Lists.newArrayList();
                    } else {
                        toEntProjElmntDlvDistr = Lists.newArrayList(toEntProjElmntDlvDistr);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EntProjElmntDlvbrlDistr entity;
                        if( toEntProjElmntDlvDistr.size() > i ) {
                            entity = toEntProjElmntDlvDistr.get(i);
                        } else {
                            entity = new EntProjElmntDlvbrlDistr();
                            toEntProjElmntDlvDistr.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EntProjElmntDlvbrlField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EntProjElmntDlvbrlField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EntProjElmntDlvbrlField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EntProjElmntDlvbrlField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProjectElement != null ) {
            (values).put("to_EnterpriseProjectElement", toEnterpriseProjectElement);
        }
        if( toEntProjElmntDlvDistr != null ) {
            (values).put("to_EntProjElmntDlvDistr", toEntProjElmntDlvDistr);
        }
        return values;
    }

    /**
     * Fetches the <b>EnterpriseProjectElement</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProjectElement</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement fetchEnterpriseProjectElement()
    {
        return fetchFieldAsSingle("to_EnterpriseProjectElement", EnterpriseProjectElement.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectElement</b> of a queried <b>EntProjElmntDlvbrl</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement getEnterpriseProjectElementOrFetch()
    {
        if( toEnterpriseProjectElement == null ) {
            toEnterpriseProjectElement = fetchEnterpriseProjectElement();
        }
        return toEnterpriseProjectElement;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjElmntDlvbrl</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProjectElement</b> is already loaded, the
     *         result will contain the <b>EnterpriseProjectElement</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProjectElement> getEnterpriseProjectElementIfPresent()
    {
        return Option.of(toEnterpriseProjectElement);
    }

    /**
     * Overwrites the associated <b>EnterpriseProjectElement</b> entity for the loaded navigation property
     * <b>to_EnterpriseProjectElement</b>.
     *
     * @param value
     *            New <b>EnterpriseProjectElement</b> entity.
     */
    public void setEnterpriseProjectElement( final EnterpriseProjectElement value )
    {
        toEnterpriseProjectElement = value;
    }

    /**
     * Fetches the <b>EntProjElmntDlvbrlDistr</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_EntProjElmntDlvDistr</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EntProjElmntDlvbrlDistr</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EntProjElmntDlvbrlDistr> fetchEntProjElmntDlvDistr()
    {
        return fetchFieldAsList("to_EntProjElmntDlvDistr", EntProjElmntDlvbrlDistr.class);
    }

    /**
     * Retrieval of associated <b>EntProjElmntDlvbrlDistr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjElmntDlvDistr</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntDlvDistr</b> of a queried <b>EntProjElmntDlvbrl</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjElmntDlvbrlDistr</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EntProjElmntDlvbrlDistr> getEntProjElmntDlvDistrOrFetch()
    {
        if( toEntProjElmntDlvDistr == null ) {
            toEntProjElmntDlvDistr = fetchEntProjElmntDlvDistr();
        }
        return toEntProjElmntDlvDistr;
    }

    /**
     * Retrieval of associated <b>EntProjElmntDlvbrlDistr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjElmntDlvDistr</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjElmntDlvbrl</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjElmntDlvDistr</b> is already loaded, the result
     *         will contain the <b>EntProjElmntDlvbrlDistr</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EntProjElmntDlvbrlDistr>> getEntProjElmntDlvDistrIfPresent()
    {
        return Option.of(toEntProjElmntDlvDistr);
    }

    /**
     * Overwrites the list of associated <b>EntProjElmntDlvbrlDistr</b> entities for the loaded navigation property
     * <b>to_EntProjElmntDlvDistr</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntDlvDistr</b> of a queried <b>EntProjElmntDlvbrl</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EntProjElmntDlvbrlDistr</b> entities.
     */
    public void setEntProjElmntDlvDistr( @Nonnull final List<EntProjElmntDlvbrlDistr> value )
    {
        if( toEntProjElmntDlvDistr == null ) {
            toEntProjElmntDlvDistr = Lists.newArrayList();
        }
        toEntProjElmntDlvDistr.clear();
        toEntProjElmntDlvDistr.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EntProjElmntDlvbrlDistr</b> entities. This corresponds to the OData
     * navigation property <b>to_EntProjElmntDlvDistr</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntDlvDistr</b> of a queried <b>EntProjElmntDlvbrl</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EntProjElmntDlvbrlDistr</b> entities.
     */
    public void addEntProjElmntDlvDistr( EntProjElmntDlvbrlDistr... entity )
    {
        if( toEntProjElmntDlvDistr == null ) {
            toEntProjElmntDlvDistr = Lists.newArrayList();
        }
        toEntProjElmntDlvDistr.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of EntProjElmntDlvbrl instances.
     *
     */
    public final static class EntProjElmntDlvbrlBuilder
    {

        private EnterpriseProjectElement toEnterpriseProjectElement;
        private List<EntProjElmntDlvbrlDistr> toEntProjElmntDlvDistr = Lists.newArrayList();

        private EntProjElmntDlvbrl.EntProjElmntDlvbrlBuilder toEnterpriseProjectElement(
            final EnterpriseProjectElement value )
        {
            toEnterpriseProjectElement = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EntProjElmntDlvbrl</b> to single
         * <b>EnterpriseProjectElement</b>.
         *
         * @param value
         *            The EnterpriseProjectElement to build this EntProjElmntDlvbrl with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjElmntDlvbrl.EntProjElmntDlvbrlBuilder enterpriseProjectElement(
            final EnterpriseProjectElement value )
        {
            return toEnterpriseProjectElement(value);
        }

        private EntProjElmntDlvbrl.EntProjElmntDlvbrlBuilder toEntProjElmntDlvDistr(
            final List<EntProjElmntDlvbrlDistr> value )
        {
            toEntProjElmntDlvDistr.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EntProjElmntDlvDistr</b> for <b>EntProjElmntDlvbrl</b> to multiple
         * <b>EntProjElmntDlvbrlDistr</b>.
         *
         * @param value
         *            The EntProjElmntDlvbrlDistrs to build this EntProjElmntDlvbrl with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjElmntDlvbrl.EntProjElmntDlvbrlBuilder entProjElmntDlvDistr( EntProjElmntDlvbrlDistr... value )
        {
            return toEntProjElmntDlvDistr(Lists.newArrayList(value));
        }

    }

}
