/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EntProjElmntDlvbrlDistrField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjElmntDlvbrlDistrOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EntProjElmntDlvbrlDistrSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Element Deliverable Distribution
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EntProjElmntDlvbrlDistrType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EntProjElmntDlvbrlDistr extends VdmEntity<EntProjElmntDlvbrlDistr>
{

    /**
     * Selector for all available fields of EntProjElmntDlvbrlDistr.
     *
     */
    public final static EntProjElmntDlvbrlDistrSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlDistrField<Boolean> UPDATE_MC =
        new EntProjElmntDlvbrlDistrField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlDistrUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "EntProjElmntDlvbrlDistrUUID" )
    @JsonProperty( "EntProjElmntDlvbrlDistrUUID" )
    @Nullable
    @ODataField( odataName = "EntProjElmntDlvbrlDistrUUID" )
    private UUID entProjElmntDlvbrlDistrUUID;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntDlvbrlDistrUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlDistrField<UUID> ENT_PROJ_ELMNT_DLVBRL_DISTR_UUID =
        new EntProjElmntDlvbrlDistrField<UUID>("EntProjElmntDlvbrlDistrUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDeliverableUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "EntProjElmntDeliverableUUID" )
    @JsonProperty( "EntProjElmntDeliverableUUID" )
    @Nullable
    @ODataField( odataName = "EntProjElmntDeliverableUUID" )
    private UUID entProjElmntDeliverableUUID;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntDeliverableUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlDistrField<UUID> ENT_PROJ_ELMNT_DELIVERABLE_UUID =
        new EntProjElmntDlvbrlDistrField<UUID>("EntProjElmntDeliverableUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectElementUUID" )
    @JsonProperty( "ProjectElementUUID" )
    @Nullable
    @ODataField( odataName = "ProjectElementUUID" )
    private UUID projectElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlDistrField<UUID> PROJECT_ELEMENT_UUID =
        new EntProjElmntDlvbrlDistrField<UUID>("ProjectElementUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlDistrField<UUID> PROJECT_UUID =
        new EntProjElmntDlvbrlDistrField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlDistrYearVal</b>
     * </p>
     *
     * @return Year of a Distribution Period for a Deliverable
     */
    @SerializedName( "EntProjElmntDlvbrlDistrYearVal" )
    @JsonProperty( "EntProjElmntDlvbrlDistrYearVal" )
    @Nullable
    @ODataField( odataName = "EntProjElmntDlvbrlDistrYearVal" )
    private String entProjElmntDlvbrlDistrYearVal;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntDlvbrlDistrYearVal</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlDistrField<String> ENT_PROJ_ELMNT_DLVBRL_DISTR_YEAR_VAL =
        new EntProjElmntDlvbrlDistrField<String>("EntProjElmntDlvbrlDistrYearVal");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlDistrPerdVal</b>
     * </p>
     *
     * @return Period to Which a Deliverable Quantity is Distributed
     */
    @SerializedName( "EntProjElmntDlvbrlDistrPerdVal" )
    @JsonProperty( "EntProjElmntDlvbrlDistrPerdVal" )
    @Nullable
    @ODataField( odataName = "EntProjElmntDlvbrlDistrPerdVal" )
    private String entProjElmntDlvbrlDistrPerdVal;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntDlvbrlDistrPerdVal</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlDistrField<String> ENT_PROJ_ELMNT_DLVBRL_DISTR_PERD_VAL =
        new EntProjElmntDlvbrlDistrField<String>("EntProjElmntDlvbrlDistrPerdVal");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlDistrQty</b>
     * </p>
     *
     * @return Deliverable Quantity Planned for a Distribution Period
     */
    @SerializedName( "EntProjElmntDlvbrlDistrQty" )
    @JsonProperty( "EntProjElmntDlvbrlDistrQty" )
    @Nullable
    @ODataField( odataName = "EntProjElmntDlvbrlDistrQty" )
    private BigDecimal entProjElmntDlvbrlDistrQty;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntDlvbrlDistrQty</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlDistrField<BigDecimal> ENT_PROJ_ELMNT_DLVBRL_DISTR_QTY =
        new EntProjElmntDlvbrlDistrField<BigDecimal>("EntProjElmntDlvbrlDistrQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlDistrQtyUnit</b>
     * </p>
     *
     * @return Unit of Measure for the Distributed Deliverable Quantity
     */
    @SerializedName( "EntProjElmntDlvbrlDistrQtyUnit" )
    @JsonProperty( "EntProjElmntDlvbrlDistrQtyUnit" )
    @Nullable
    @ODataField( odataName = "EntProjElmntDlvbrlDistrQtyUnit" )
    private String entProjElmntDlvbrlDistrQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntDlvbrlDistrQtyUnit</b> field to query operations.
     *
     */
    public final static EntProjElmntDlvbrlDistrField<String> ENT_PROJ_ELMNT_DLVBRL_DISTR_QTY_UNIT =
        new EntProjElmntDlvbrlDistrField<String>("EntProjElmntDlvbrlDistrQtyUnit");
    /**
     * Navigation property <b>to_EntProjElmntDlvbrl</b> for <b>EntProjElmntDlvbrlDistr</b> to single
     * <b>EntProjElmntDlvbrl</b>.
     *
     */
    @SerializedName( "to_EntProjElmntDlvbrl" )
    @JsonProperty( "to_EntProjElmntDlvbrl" )
    @ODataField( odataName = "to_EntProjElmntDlvbrl" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EntProjElmntDlvbrl toEntProjElmntDlvbrl;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjElmntDlvbrl</b> navigation property to query
     * operations.
     *
     */
    public final static EntProjElmntDlvbrlDistrOneToOneLink<EntProjElmntDlvbrl> TO_ENT_PROJ_ELMNT_DLVBRL =
        new EntProjElmntDlvbrlDistrOneToOneLink<EntProjElmntDlvbrl>("to_EntProjElmntDlvbrl");

    @Nonnull
    @Override
    public Class<EntProjElmntDlvbrlDistr> getType()
    {
        return EntProjElmntDlvbrlDistr.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlDistrUUID</b>
     * </p>
     *
     * @param entProjElmntDlvbrlDistrUUID
     *            Entity Guid
     */
    public void setEntProjElmntDlvbrlDistrUUID( @Nullable final UUID entProjElmntDlvbrlDistrUUID )
    {
        rememberChangedField("EntProjElmntDlvbrlDistrUUID", this.entProjElmntDlvbrlDistrUUID);
        this.entProjElmntDlvbrlDistrUUID = entProjElmntDlvbrlDistrUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDeliverableUUID</b>
     * </p>
     *
     * @param entProjElmntDeliverableUUID
     *            Entity Guid
     */
    public void setEntProjElmntDeliverableUUID( @Nullable final UUID entProjElmntDeliverableUUID )
    {
        rememberChangedField("EntProjElmntDeliverableUUID", this.entProjElmntDeliverableUUID);
        this.entProjElmntDeliverableUUID = entProjElmntDeliverableUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @param projectElementUUID
     *            Entity Guid
     */
    public void setProjectElementUUID( @Nullable final UUID projectElementUUID )
    {
        rememberChangedField("ProjectElementUUID", this.projectElementUUID);
        this.projectElementUUID = projectElementUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlDistrYearVal</b>
     * </p>
     *
     * @param entProjElmntDlvbrlDistrYearVal
     *            Year of a Distribution Period for a Deliverable
     */
    public void setEntProjElmntDlvbrlDistrYearVal( @Nullable final String entProjElmntDlvbrlDistrYearVal )
    {
        rememberChangedField("EntProjElmntDlvbrlDistrYearVal", this.entProjElmntDlvbrlDistrYearVal);
        this.entProjElmntDlvbrlDistrYearVal = entProjElmntDlvbrlDistrYearVal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlDistrPerdVal</b>
     * </p>
     *
     * @param entProjElmntDlvbrlDistrPerdVal
     *            Period to Which a Deliverable Quantity is Distributed
     */
    public void setEntProjElmntDlvbrlDistrPerdVal( @Nullable final String entProjElmntDlvbrlDistrPerdVal )
    {
        rememberChangedField("EntProjElmntDlvbrlDistrPerdVal", this.entProjElmntDlvbrlDistrPerdVal);
        this.entProjElmntDlvbrlDistrPerdVal = entProjElmntDlvbrlDistrPerdVal;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlDistrQty</b>
     * </p>
     *
     * @param entProjElmntDlvbrlDistrQty
     *            Deliverable Quantity Planned for a Distribution Period
     */
    public void setEntProjElmntDlvbrlDistrQty( @Nullable final BigDecimal entProjElmntDlvbrlDistrQty )
    {
        rememberChangedField("EntProjElmntDlvbrlDistrQty", this.entProjElmntDlvbrlDistrQty);
        this.entProjElmntDlvbrlDistrQty = entProjElmntDlvbrlDistrQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntDlvbrlDistrQtyUnit</b>
     * </p>
     *
     * @param entProjElmntDlvbrlDistrQtyUnit
     *            Unit of Measure for the Distributed Deliverable Quantity
     */
    public void setEntProjElmntDlvbrlDistrQtyUnit( @Nullable final String entProjElmntDlvbrlDistrQtyUnit )
    {
        rememberChangedField("EntProjElmntDlvbrlDistrQtyUnit", this.entProjElmntDlvbrlDistrQtyUnit);
        this.entProjElmntDlvbrlDistrQtyUnit = entProjElmntDlvbrlDistrQtyUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EntProjElmntDlvbrlDistr";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EntProjElmntDlvbrlDistrUUID", getEntProjElmntDlvbrlDistrUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Update_mc", getUpdate_mc());
        values.put("EntProjElmntDlvbrlDistrUUID", getEntProjElmntDlvbrlDistrUUID());
        values.put("EntProjElmntDeliverableUUID", getEntProjElmntDeliverableUUID());
        values.put("ProjectElementUUID", getProjectElementUUID());
        values.put("ProjectUUID", getProjectUUID());
        values.put("EntProjElmntDlvbrlDistrYearVal", getEntProjElmntDlvbrlDistrYearVal());
        values.put("EntProjElmntDlvbrlDistrPerdVal", getEntProjElmntDlvbrlDistrPerdVal());
        values.put("EntProjElmntDlvbrlDistrQty", getEntProjElmntDlvbrlDistrQty());
        values.put("EntProjElmntDlvbrlDistrQtyUnit", getEntProjElmntDlvbrlDistrQtyUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjElmntDlvbrlDistrUUID") ) {
                final Object value = values.remove("EntProjElmntDlvbrlDistrUUID");
                if( (value == null) || (!value.equals(getEntProjElmntDlvbrlDistrUUID())) ) {
                    setEntProjElmntDlvbrlDistrUUID(((UUID) value));
                }
            }
            if( values.containsKey("EntProjElmntDeliverableUUID") ) {
                final Object value = values.remove("EntProjElmntDeliverableUUID");
                if( (value == null) || (!value.equals(getEntProjElmntDeliverableUUID())) ) {
                    setEntProjElmntDeliverableUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectElementUUID") ) {
                final Object value = values.remove("ProjectElementUUID");
                if( (value == null) || (!value.equals(getProjectElementUUID())) ) {
                    setProjectElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("EntProjElmntDlvbrlDistrYearVal") ) {
                final Object value = values.remove("EntProjElmntDlvbrlDistrYearVal");
                if( (value == null) || (!value.equals(getEntProjElmntDlvbrlDistrYearVal())) ) {
                    setEntProjElmntDlvbrlDistrYearVal(((String) value));
                }
            }
            if( values.containsKey("EntProjElmntDlvbrlDistrPerdVal") ) {
                final Object value = values.remove("EntProjElmntDlvbrlDistrPerdVal");
                if( (value == null) || (!value.equals(getEntProjElmntDlvbrlDistrPerdVal())) ) {
                    setEntProjElmntDlvbrlDistrPerdVal(((String) value));
                }
            }
            if( values.containsKey("EntProjElmntDlvbrlDistrQty") ) {
                final Object value = values.remove("EntProjElmntDlvbrlDistrQty");
                if( (value == null) || (!value.equals(getEntProjElmntDlvbrlDistrQty())) ) {
                    setEntProjElmntDlvbrlDistrQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("EntProjElmntDlvbrlDistrQtyUnit") ) {
                final Object value = values.remove("EntProjElmntDlvbrlDistrQtyUnit");
                if( (value == null) || (!value.equals(getEntProjElmntDlvbrlDistrQtyUnit())) ) {
                    setEntProjElmntDlvbrlDistrQtyUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EntProjElmntDlvbrl") ) {
                final Object value = (values).remove("to_EntProjElmntDlvbrl");
                if( value instanceof Map ) {
                    if( toEntProjElmntDlvbrl == null ) {
                        toEntProjElmntDlvbrl = new EntProjElmntDlvbrl();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEntProjElmntDlvbrl.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EntProjElmntDlvbrlDistrField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EntProjElmntDlvbrlDistrField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EntProjElmntDlvbrlDistrField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EntProjElmntDlvbrlDistrField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEntProjElmntDlvbrl != null ) {
            (values).put("to_EntProjElmntDlvbrl", toEntProjElmntDlvbrl);
        }
        return values;
    }

    /**
     * Fetches the <b>EntProjElmntDlvbrl</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EntProjElmntDlvbrl</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EntProjElmntDlvbrl</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjElmntDlvbrl fetchEntProjElmntDlvbrl()
    {
        return fetchFieldAsSingle("to_EntProjElmntDlvbrl", EntProjElmntDlvbrl.class);
    }

    /**
     * Retrieval of associated <b>EntProjElmntDlvbrl</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EntProjElmntDlvbrl</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntDlvbrl</b> of a queried <b>EntProjElmntDlvbrlDistr</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjElmntDlvbrl</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjElmntDlvbrl getEntProjElmntDlvbrlOrFetch()
    {
        if( toEntProjElmntDlvbrl == null ) {
            toEntProjElmntDlvbrl = fetchEntProjElmntDlvbrl();
        }
        return toEntProjElmntDlvbrl;
    }

    /**
     * Retrieval of associated <b>EntProjElmntDlvbrl</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EntProjElmntDlvbrl</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjElmntDlvbrlDistr</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjElmntDlvbrl</b> is already loaded, the result
     *         will contain the <b>EntProjElmntDlvbrl</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EntProjElmntDlvbrl> getEntProjElmntDlvbrlIfPresent()
    {
        return Option.of(toEntProjElmntDlvbrl);
    }

    /**
     * Overwrites the associated <b>EntProjElmntDlvbrl</b> entity for the loaded navigation property
     * <b>to_EntProjElmntDlvbrl</b>.
     *
     * @param value
     *            New <b>EntProjElmntDlvbrl</b> entity.
     */
    public void setEntProjElmntDlvbrl( final EntProjElmntDlvbrl value )
    {
        toEntProjElmntDlvbrl = value;
    }

    /**
     * Helper class to allow for fluent creation of EntProjElmntDlvbrlDistr instances.
     *
     */
    public final static class EntProjElmntDlvbrlDistrBuilder
    {

        private EntProjElmntDlvbrl toEntProjElmntDlvbrl;

        private EntProjElmntDlvbrlDistr.EntProjElmntDlvbrlDistrBuilder toEntProjElmntDlvbrl(
            final EntProjElmntDlvbrl value )
        {
            toEntProjElmntDlvbrl = value;
            return this;
        }

        /**
         * Navigation property <b>to_EntProjElmntDlvbrl</b> for <b>EntProjElmntDlvbrlDistr</b> to single
         * <b>EntProjElmntDlvbrl</b>.
         *
         * @param value
         *            The EntProjElmntDlvbrl to build this EntProjElmntDlvbrlDistr with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjElmntDlvbrlDistr.EntProjElmntDlvbrlDistrBuilder entProjElmntDlvbrl(
            final EntProjElmntDlvbrl value )
        {
            return toEntProjElmntDlvbrl(value);
        }

    }

}
