/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EntProjElmntWorkItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjElmntWorkItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EntProjElmntWorkItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Element Work Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EntProjElmntWorkItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EntProjElmntWorkItem extends VdmEntity<EntProjElmntWorkItem>
{

    /**
     * Selector for all available fields of EntProjElmntWorkItem.
     *
     */
    public final static EntProjElmntWorkItemSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<Boolean> DELETE_MC =
        new EntProjElmntWorkItemField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<Boolean> UPDATE_MC =
        new EntProjElmntWorkItemField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWorkItemUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "EntProjElmntWorkItemUUID" )
    @JsonProperty( "EntProjElmntWorkItemUUID" )
    @Nullable
    @ODataField( odataName = "EntProjElmntWorkItemUUID" )
    private UUID entProjElmntWorkItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntWorkItemUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<UUID> ENT_PROJ_ELMNT_WORK_ITEM_UUID =
        new EntProjElmntWorkItemField<UUID>("EntProjElmntWorkItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWorkItem</b>
     * </p>
     *
     * @return Enterprise Project Element Work Item
     */
    @SerializedName( "EntProjElmntWorkItem" )
    @JsonProperty( "EntProjElmntWorkItem" )
    @Nullable
    @ODataField( odataName = "EntProjElmntWorkItem" )
    private String entProjElmntWorkItem;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntWorkItem</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<String> ENT_PROJ_ELMNT_WORK_ITEM =
        new EntProjElmntWorkItemField<String>("EntProjElmntWorkItem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWorkItemName</b>
     * </p>
     *
     * @return Enterprise Project Element Work Item Name
     */
    @SerializedName( "EntProjElmntWorkItemName" )
    @JsonProperty( "EntProjElmntWorkItemName" )
    @Nullable
    @ODataField( odataName = "EntProjElmntWorkItemName" )
    private String entProjElmntWorkItemName;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntWorkItemName</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<String> ENT_PROJ_ELMNT_WORK_ITEM_NAME =
        new EntProjElmntWorkItemField<String>("EntProjElmntWorkItemName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWorkItemIsInactive</b>
     * </p>
     *
     * @return Enterprise Project Element Work Item is Inactive
     */
    @SerializedName( "EntProjElmntWorkItemIsInactive" )
    @JsonProperty( "EntProjElmntWorkItemIsInactive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjElmntWorkItemIsInactive" )
    private Boolean entProjElmntWorkItemIsInactive;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntWorkItemIsInactive</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<Boolean> ENT_PROJ_ELMNT_WORK_ITEM_IS_INACTIVE =
        new EntProjElmntWorkItemField<Boolean>("EntProjElmntWorkItemIsInactive");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWorkItemIsCnfgrd</b>
     * </p>
     *
     * @return Enterprise Project Element Work Item is Configured
     */
    @SerializedName( "EntProjElmntWorkItemIsCnfgrd" )
    @JsonProperty( "EntProjElmntWorkItemIsCnfgrd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjElmntWorkItemIsCnfgrd" )
    private Boolean entProjElmntWorkItemIsCnfgrd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntWorkItemIsCnfgrd</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<Boolean> ENT_PROJ_ELMNT_WORK_ITEM_IS_CNFGRD =
        new EntProjElmntWorkItemField<Boolean>("EntProjElmntWorkItemIsCnfgrd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<UUID> PROJECT_UUID =
        new EntProjElmntWorkItemField<UUID>("ProjectUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectElementUUID" )
    @JsonProperty( "ProjectElementUUID" )
    @Nullable
    @ODataField( odataName = "ProjectElementUUID" )
    private UUID projectElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<UUID> PROJECT_ELEMENT_UUID =
        new EntProjElmntWorkItemField<UUID>("ProjectElementUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWrkItmLastUpdtSrce</b>
     * </p>
     *
     * @return Enterprise Project Element Work Item - Source of Update
     */
    @SerializedName( "EntProjElmntWrkItmLastUpdtSrce" )
    @JsonProperty( "EntProjElmntWrkItmLastUpdtSrce" )
    @Nullable
    @ODataField( odataName = "EntProjElmntWrkItmLastUpdtSrce" )
    private String entProjElmntWrkItmLastUpdtSrce;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntWrkItmLastUpdtSrce</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<String> ENT_PROJ_ELMNT_WRK_ITM_LAST_UPDT_SRCE =
        new EntProjElmntWorkItemField<String>("EntProjElmntWrkItmLastUpdtSrce");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWrkItmCrtedByUsr</b>
     * </p>
     *
     * @return Name of Person Who Created Object
     */
    @SerializedName( "EntProjElmntWrkItmCrtedByUsr" )
    @JsonProperty( "EntProjElmntWrkItmCrtedByUsr" )
    @Nullable
    @ODataField( odataName = "EntProjElmntWrkItmCrtedByUsr" )
    private String entProjElmntWrkItmCrtedByUsr;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntWrkItmCrtedByUsr</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<String> ENT_PROJ_ELMNT_WRK_ITM_CRTED_BY_USR =
        new EntProjElmntWorkItemField<String>("EntProjElmntWrkItmCrtedByUsr");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWrkItmCrtnDteTme</b>
     * </p>
     *
     * @return Timestamp of Object Creation
     */
    @SerializedName( "EntProjElmntWrkItmCrtnDteTme" )
    @JsonProperty( "EntProjElmntWrkItmCrtnDteTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "EntProjElmntWrkItmCrtnDteTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime entProjElmntWrkItmCrtnDteTme;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntWrkItmCrtnDteTme</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<ZonedDateTime> ENT_PROJ_ELMNT_WRK_ITM_CRTN_DTE_TME =
        new EntProjElmntWorkItemField<ZonedDateTime>("EntProjElmntWrkItmCrtnDteTme");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWrkItmLstChgByUsr</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "EntProjElmntWrkItmLstChgByUsr" )
    @JsonProperty( "EntProjElmntWrkItmLstChgByUsr" )
    @Nullable
    @ODataField( odataName = "EntProjElmntWrkItmLstChgByUsr" )
    private String entProjElmntWrkItmLstChgByUsr;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntWrkItmLstChgByUsr</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<String> ENT_PROJ_ELMNT_WRK_ITM_LST_CHG_BY_USR =
        new EntProjElmntWorkItemField<String>("EntProjElmntWrkItmLstChgByUsr");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWrkItmLstChgDteTme</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "EntProjElmntWrkItmLstChgDteTme" )
    @JsonProperty( "EntProjElmntWrkItmLstChgDteTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "EntProjElmntWrkItmLstChgDteTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime entProjElmntWrkItmLstChgDteTme;
    /**
     * Use with available fluent helpers to apply the <b>EntProjElmntWrkItmLstChgDteTme</b> field to query operations.
     *
     */
    public final static EntProjElmntWorkItemField<ZonedDateTime> ENT_PROJ_ELMNT_WRK_ITM_LST_CHG_DTE_TME =
        new EntProjElmntWorkItemField<ZonedDateTime>("EntProjElmntWrkItmLstChgDteTme");
    /**
     * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EntProjElmntWorkItem</b> to single
     * <b>EnterpriseProjectElement</b>.
     *
     */
    @SerializedName( "to_EnterpriseProjectElement" )
    @JsonProperty( "to_EnterpriseProjectElement" )
    @ODataField( odataName = "to_EnterpriseProjectElement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProjectElement toEnterpriseProjectElement;
    /**
     * Navigation property <b>to_EnterpriseProject</b> for <b>EntProjElmntWorkItem</b> to single
     * <b>EnterpriseProject</b>.
     *
     */
    @SerializedName( "to_EnterpriseProject" )
    @JsonProperty( "to_EnterpriseProject" )
    @ODataField( odataName = "to_EnterpriseProject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProject toEnterpriseProject;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProjectElement</b> navigation property to query
     * operations.
     *
     */
    public final static EntProjElmntWorkItemOneToOneLink<EnterpriseProjectElement> TO_ENTERPRISE_PROJECT_ELEMENT =
        new EntProjElmntWorkItemOneToOneLink<EnterpriseProjectElement>("to_EnterpriseProjectElement");
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProject</b> navigation property to query
     * operations.
     *
     */
    public final static EntProjElmntWorkItemOneToOneLink<EnterpriseProject> TO_ENTERPRISE_PROJECT =
        new EntProjElmntWorkItemOneToOneLink<EnterpriseProject>("to_EnterpriseProject");

    @Nonnull
    @Override
    public Class<EntProjElmntWorkItem> getType()
    {
        return EntProjElmntWorkItem.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWorkItemUUID</b>
     * </p>
     *
     * @param entProjElmntWorkItemUUID
     *            Entity Guid
     */
    public void setEntProjElmntWorkItemUUID( @Nullable final UUID entProjElmntWorkItemUUID )
    {
        rememberChangedField("EntProjElmntWorkItemUUID", this.entProjElmntWorkItemUUID);
        this.entProjElmntWorkItemUUID = entProjElmntWorkItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWorkItem</b>
     * </p>
     *
     * @param entProjElmntWorkItem
     *            Enterprise Project Element Work Item
     */
    public void setEntProjElmntWorkItem( @Nullable final String entProjElmntWorkItem )
    {
        rememberChangedField("EntProjElmntWorkItem", this.entProjElmntWorkItem);
        this.entProjElmntWorkItem = entProjElmntWorkItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWorkItemName</b>
     * </p>
     *
     * @param entProjElmntWorkItemName
     *            Enterprise Project Element Work Item Name
     */
    public void setEntProjElmntWorkItemName( @Nullable final String entProjElmntWorkItemName )
    {
        rememberChangedField("EntProjElmntWorkItemName", this.entProjElmntWorkItemName);
        this.entProjElmntWorkItemName = entProjElmntWorkItemName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWorkItemIsInactive</b>
     * </p>
     *
     * @param entProjElmntWorkItemIsInactive
     *            Enterprise Project Element Work Item is Inactive
     */
    public void setEntProjElmntWorkItemIsInactive( @Nullable final Boolean entProjElmntWorkItemIsInactive )
    {
        rememberChangedField("EntProjElmntWorkItemIsInactive", this.entProjElmntWorkItemIsInactive);
        this.entProjElmntWorkItemIsInactive = entProjElmntWorkItemIsInactive;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWorkItemIsCnfgrd</b>
     * </p>
     *
     * @param entProjElmntWorkItemIsCnfgrd
     *            Enterprise Project Element Work Item is Configured
     */
    public void setEntProjElmntWorkItemIsCnfgrd( @Nullable final Boolean entProjElmntWorkItemIsCnfgrd )
    {
        rememberChangedField("EntProjElmntWorkItemIsCnfgrd", this.entProjElmntWorkItemIsCnfgrd);
        this.entProjElmntWorkItemIsCnfgrd = entProjElmntWorkItemIsCnfgrd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @param projectElementUUID
     *            Entity Guid
     */
    public void setProjectElementUUID( @Nullable final UUID projectElementUUID )
    {
        rememberChangedField("ProjectElementUUID", this.projectElementUUID);
        this.projectElementUUID = projectElementUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWrkItmLastUpdtSrce</b>
     * </p>
     *
     * @param entProjElmntWrkItmLastUpdtSrce
     *            Enterprise Project Element Work Item - Source of Update
     */
    public void setEntProjElmntWrkItmLastUpdtSrce( @Nullable final String entProjElmntWrkItmLastUpdtSrce )
    {
        rememberChangedField("EntProjElmntWrkItmLastUpdtSrce", this.entProjElmntWrkItmLastUpdtSrce);
        this.entProjElmntWrkItmLastUpdtSrce = entProjElmntWrkItmLastUpdtSrce;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWrkItmCrtedByUsr</b>
     * </p>
     *
     * @param entProjElmntWrkItmCrtedByUsr
     *            Name of Person Who Created Object
     */
    public void setEntProjElmntWrkItmCrtedByUsr( @Nullable final String entProjElmntWrkItmCrtedByUsr )
    {
        rememberChangedField("EntProjElmntWrkItmCrtedByUsr", this.entProjElmntWrkItmCrtedByUsr);
        this.entProjElmntWrkItmCrtedByUsr = entProjElmntWrkItmCrtedByUsr;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWrkItmCrtnDteTme</b>
     * </p>
     *
     * @param entProjElmntWrkItmCrtnDteTme
     *            Timestamp of Object Creation
     */
    public void setEntProjElmntWrkItmCrtnDteTme( @Nullable final ZonedDateTime entProjElmntWrkItmCrtnDteTme )
    {
        rememberChangedField("EntProjElmntWrkItmCrtnDteTme", this.entProjElmntWrkItmCrtnDteTme);
        this.entProjElmntWrkItmCrtnDteTme = entProjElmntWrkItmCrtnDteTme;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWrkItmLstChgByUsr</b>
     * </p>
     *
     * @param entProjElmntWrkItmLstChgByUsr
     *            Name of Person Who Changed Object
     */
    public void setEntProjElmntWrkItmLstChgByUsr( @Nullable final String entProjElmntWrkItmLstChgByUsr )
    {
        rememberChangedField("EntProjElmntWrkItmLstChgByUsr", this.entProjElmntWrkItmLstChgByUsr);
        this.entProjElmntWrkItmLstChgByUsr = entProjElmntWrkItmLstChgByUsr;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EntProjElmntWrkItmLstChgDteTme</b>
     * </p>
     *
     * @param entProjElmntWrkItmLstChgDteTme
     *            Timestamp of Last Object Change
     */
    public void setEntProjElmntWrkItmLstChgDteTme( @Nullable final ZonedDateTime entProjElmntWrkItmLstChgDteTme )
    {
        rememberChangedField("EntProjElmntWrkItmLstChgDteTme", this.entProjElmntWrkItmLstChgDteTme);
        this.entProjElmntWrkItmLstChgDteTme = entProjElmntWrkItmLstChgDteTme;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EntProjElmntWorkItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EntProjElmntWorkItemUUID", getEntProjElmntWorkItemUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("EntProjElmntWorkItemUUID", getEntProjElmntWorkItemUUID());
        values.put("EntProjElmntWorkItem", getEntProjElmntWorkItem());
        values.put("EntProjElmntWorkItemName", getEntProjElmntWorkItemName());
        values.put("EntProjElmntWorkItemIsInactive", getEntProjElmntWorkItemIsInactive());
        values.put("EntProjElmntWorkItemIsCnfgrd", getEntProjElmntWorkItemIsCnfgrd());
        values.put("ProjectUUID", getProjectUUID());
        values.put("ProjectElementUUID", getProjectElementUUID());
        values.put("EntProjElmntWrkItmLastUpdtSrce", getEntProjElmntWrkItmLastUpdtSrce());
        values.put("EntProjElmntWrkItmCrtedByUsr", getEntProjElmntWrkItmCrtedByUsr());
        values.put("EntProjElmntWrkItmCrtnDteTme", getEntProjElmntWrkItmCrtnDteTme());
        values.put("EntProjElmntWrkItmLstChgByUsr", getEntProjElmntWrkItmLstChgByUsr());
        values.put("EntProjElmntWrkItmLstChgDteTme", getEntProjElmntWrkItmLstChgDteTme());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjElmntWorkItemUUID") ) {
                final Object value = values.remove("EntProjElmntWorkItemUUID");
                if( (value == null) || (!value.equals(getEntProjElmntWorkItemUUID())) ) {
                    setEntProjElmntWorkItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("EntProjElmntWorkItem") ) {
                final Object value = values.remove("EntProjElmntWorkItem");
                if( (value == null) || (!value.equals(getEntProjElmntWorkItem())) ) {
                    setEntProjElmntWorkItem(((String) value));
                }
            }
            if( values.containsKey("EntProjElmntWorkItemName") ) {
                final Object value = values.remove("EntProjElmntWorkItemName");
                if( (value == null) || (!value.equals(getEntProjElmntWorkItemName())) ) {
                    setEntProjElmntWorkItemName(((String) value));
                }
            }
            if( values.containsKey("EntProjElmntWorkItemIsInactive") ) {
                final Object value = values.remove("EntProjElmntWorkItemIsInactive");
                if( (value == null) || (!value.equals(getEntProjElmntWorkItemIsInactive())) ) {
                    setEntProjElmntWorkItemIsInactive(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjElmntWorkItemIsCnfgrd") ) {
                final Object value = values.remove("EntProjElmntWorkItemIsCnfgrd");
                if( (value == null) || (!value.equals(getEntProjElmntWorkItemIsCnfgrd())) ) {
                    setEntProjElmntWorkItemIsCnfgrd(((Boolean) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectElementUUID") ) {
                final Object value = values.remove("ProjectElementUUID");
                if( (value == null) || (!value.equals(getProjectElementUUID())) ) {
                    setProjectElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("EntProjElmntWrkItmLastUpdtSrce") ) {
                final Object value = values.remove("EntProjElmntWrkItmLastUpdtSrce");
                if( (value == null) || (!value.equals(getEntProjElmntWrkItmLastUpdtSrce())) ) {
                    setEntProjElmntWrkItmLastUpdtSrce(((String) value));
                }
            }
            if( values.containsKey("EntProjElmntWrkItmCrtedByUsr") ) {
                final Object value = values.remove("EntProjElmntWrkItmCrtedByUsr");
                if( (value == null) || (!value.equals(getEntProjElmntWrkItmCrtedByUsr())) ) {
                    setEntProjElmntWrkItmCrtedByUsr(((String) value));
                }
            }
            if( values.containsKey("EntProjElmntWrkItmCrtnDteTme") ) {
                final Object value = values.remove("EntProjElmntWrkItmCrtnDteTme");
                if( (value == null) || (!value.equals(getEntProjElmntWrkItmCrtnDteTme())) ) {
                    setEntProjElmntWrkItmCrtnDteTme(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("EntProjElmntWrkItmLstChgByUsr") ) {
                final Object value = values.remove("EntProjElmntWrkItmLstChgByUsr");
                if( (value == null) || (!value.equals(getEntProjElmntWrkItmLstChgByUsr())) ) {
                    setEntProjElmntWrkItmLstChgByUsr(((String) value));
                }
            }
            if( values.containsKey("EntProjElmntWrkItmLstChgDteTme") ) {
                final Object value = values.remove("EntProjElmntWrkItmLstChgDteTme");
                if( (value == null) || (!value.equals(getEntProjElmntWrkItmLstChgDteTme())) ) {
                    setEntProjElmntWrkItmLstChgDteTme(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProjectElement") ) {
                final Object value = (values).remove("to_EnterpriseProjectElement");
                if( value instanceof Map ) {
                    if( toEnterpriseProjectElement == null ) {
                        toEnterpriseProjectElement = new EnterpriseProjectElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProjectElement.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EnterpriseProject") ) {
                final Object value = (values).remove("to_EnterpriseProject");
                if( value instanceof Map ) {
                    if( toEnterpriseProject == null ) {
                        toEnterpriseProject = new EnterpriseProject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProject.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EntProjElmntWorkItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EntProjElmntWorkItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EntProjElmntWorkItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EntProjElmntWorkItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProjectElement != null ) {
            (values).put("to_EnterpriseProjectElement", toEnterpriseProjectElement);
        }
        if( toEnterpriseProject != null ) {
            (values).put("to_EnterpriseProject", toEnterpriseProject);
        }
        return values;
    }

    /**
     * Fetches the <b>EnterpriseProjectElement</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProjectElement</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement fetchEnterpriseProjectElement()
    {
        return fetchFieldAsSingle("to_EnterpriseProjectElement", EnterpriseProjectElement.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectElement</b> of a queried <b>EntProjElmntWorkItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement getEnterpriseProjectElementOrFetch()
    {
        if( toEnterpriseProjectElement == null ) {
            toEnterpriseProjectElement = fetchEnterpriseProjectElement();
        }
        return toEnterpriseProjectElement;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjElmntWorkItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProjectElement</b> is already loaded, the
     *         result will contain the <b>EnterpriseProjectElement</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProjectElement> getEnterpriseProjectElementIfPresent()
    {
        return Option.of(toEnterpriseProjectElement);
    }

    /**
     * Overwrites the associated <b>EnterpriseProjectElement</b> entity for the loaded navigation property
     * <b>to_EnterpriseProjectElement</b>.
     *
     * @param value
     *            New <b>EnterpriseProjectElement</b> entity.
     */
    public void setEnterpriseProjectElement( final EnterpriseProjectElement value )
    {
        toEnterpriseProjectElement = value;
    }

    /**
     * Fetches the <b>EnterpriseProject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject fetchEnterpriseProject()
    {
        return fetchFieldAsSingle("to_EnterpriseProject", EnterpriseProject.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>EntProjElmntWorkItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject getEnterpriseProjectOrFetch()
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = fetchEnterpriseProject();
        }
        return toEnterpriseProject;
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjElmntWorkItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProject</b> is already loaded, the result will
     *         contain the <b>EnterpriseProject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProject> getEnterpriseProjectIfPresent()
    {
        return Option.of(toEnterpriseProject);
    }

    /**
     * Overwrites the associated <b>EnterpriseProject</b> entity for the loaded navigation property
     * <b>to_EnterpriseProject</b>.
     *
     * @param value
     *            New <b>EnterpriseProject</b> entity.
     */
    public void setEnterpriseProject( final EnterpriseProject value )
    {
        toEnterpriseProject = value;
    }

    /**
     * Helper class to allow for fluent creation of EntProjElmntWorkItem instances.
     *
     */
    public final static class EntProjElmntWorkItemBuilder
    {

        private EnterpriseProjectElement toEnterpriseProjectElement;
        private EnterpriseProject toEnterpriseProject;

        private EntProjElmntWorkItem.EntProjElmntWorkItemBuilder toEnterpriseProjectElement(
            final EnterpriseProjectElement value )
        {
            toEnterpriseProjectElement = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EntProjElmntWorkItem</b> to single
         * <b>EnterpriseProjectElement</b>.
         *
         * @param value
         *            The EnterpriseProjectElement to build this EntProjElmntWorkItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjElmntWorkItem.EntProjElmntWorkItemBuilder enterpriseProjectElement(
            final EnterpriseProjectElement value )
        {
            return toEnterpriseProjectElement(value);
        }

        private EntProjElmntWorkItem.EntProjElmntWorkItemBuilder toEnterpriseProject( final EnterpriseProject value )
        {
            toEnterpriseProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProject</b> for <b>EntProjElmntWorkItem</b> to single
         * <b>EnterpriseProject</b>.
         *
         * @param value
         *            The EnterpriseProject to build this EntProjElmntWorkItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjElmntWorkItem.EntProjElmntWorkItemBuilder enterpriseProject( final EnterpriseProject value )
        {
            return toEnterpriseProject(value);
        }

    }

}
