/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EntProjectElementJVAField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjectElementJVAOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EntProjectElementJVASelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Element JVA
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EntProjectElementJVAType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EntProjectElementJVA extends VdmEntity<EntProjectElementJVA>
{

    /**
     * Selector for all available fields of EntProjectElementJVA.
     *
     */
    public final static EntProjectElementJVASelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JntIntrstBillgClass_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "JntIntrstBillgClass_fc" )
    @JsonProperty( "JntIntrstBillgClass_fc" )
    @Nullable
    @ODataField( odataName = "JntIntrstBillgClass_fc" )
    private Short jntIntrstBillgClass_fc;
    /**
     * Use with available fluent helpers to apply the <b>JntIntrstBillgClass_fc</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<Short> JNT_INTRST_BILLG_CLASS_FC =
        new EntProjectElementJVAField<Short>("JntIntrstBillgClass_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JntIntrstBillgSubClass_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "JntIntrstBillgSubClass_fc" )
    @JsonProperty( "JntIntrstBillgSubClass_fc" )
    @Nullable
    @ODataField( odataName = "JntIntrstBillgSubClass_fc" )
    private Short jntIntrstBillgSubClass_fc;
    /**
     * Use with available fluent helpers to apply the <b>JntIntrstBillgSubClass_fc</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<Short> JNT_INTRST_BILLG_SUB_CLASS_FC =
        new EntProjectElementJVAField<Short>("JntIntrstBillgSubClass_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrProjectType_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "JntVntrProjectType_fc" )
    @JsonProperty( "JntVntrProjectType_fc" )
    @Nullable
    @ODataField( odataName = "JntVntrProjectType_fc" )
    private Short jntVntrProjectType_fc;
    /**
     * Use with available fluent helpers to apply the <b>JntVntrProjectType_fc</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<Short> JNT_VNTR_PROJECT_TYPE_FC =
        new EntProjectElementJVAField<Short>("JntVntrProjectType_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "JointVenture_fc" )
    @JsonProperty( "JointVenture_fc" )
    @Nullable
    @ODataField( odataName = "JointVenture_fc" )
    private Short jointVenture_fc;
    /**
     * Use with available fluent helpers to apply the <b>JointVenture_fc</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<Short> JOINT_VENTURE_FC =
        new EntProjectElementJVAField<Short>("JointVenture_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "JointVentureCostRecoveryCode_fc" )
    @JsonProperty( "JointVentureCostRecoveryCode_fc" )
    @Nullable
    @ODataField( odataName = "JointVentureCostRecoveryCode_fc" )
    private Short jointVentureCostRecoveryCode_fc;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureCostRecoveryCode_fc</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<Short> JOINT_VENTURE_COST_RECOVERY_CODE_FC =
        new EntProjectElementJVAField<Short>("JointVentureCostRecoveryCode_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "JointVentureEquityType_fc" )
    @JsonProperty( "JointVentureEquityType_fc" )
    @Nullable
    @ODataField( odataName = "JointVentureEquityType_fc" )
    private Short jointVentureEquityType_fc;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureEquityType_fc</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<Short> JOINT_VENTURE_EQUITY_TYPE_FC =
        new EntProjectElementJVAField<Short>("JointVentureEquityType_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<Boolean> UPDATE_MC =
        new EntProjectElementJVAField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "ProjectElementUUID" )
    @JsonProperty( "ProjectElementUUID" )
    @Nullable
    @ODataField( odataName = "ProjectElementUUID" )
    private UUID projectElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementUUID</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<UUID> PROJECT_ELEMENT_UUID =
        new EntProjectElementJVAField<UUID>("ProjectElementUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<UUID> PROJECT_UUID =
        new EntProjectElementJVAField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     *
     * @return Joint Venture
     */
    @SerializedName( "JointVenture" )
    @JsonProperty( "JointVenture" )
    @Nullable
    @ODataField( odataName = "JointVenture" )
    private String jointVenture;
    /**
     * Use with available fluent helpers to apply the <b>JointVenture</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<String> JOINT_VENTURE =
        new EntProjectElementJVAField<String>("JointVenture");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode</b>
     * </p>
     *
     * @return Recovery Indicator
     */
    @SerializedName( "JointVentureCostRecoveryCode" )
    @JsonProperty( "JointVentureCostRecoveryCode" )
    @Nullable
    @ODataField( odataName = "JointVentureCostRecoveryCode" )
    private String jointVentureCostRecoveryCode;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureCostRecoveryCode</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<String> JOINT_VENTURE_COST_RECOVERY_CODE =
        new EntProjectElementJVAField<String>("JointVentureCostRecoveryCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     *
     * @return Equity Type
     */
    @SerializedName( "JointVentureEquityType" )
    @JsonProperty( "JointVentureEquityType" )
    @Nullable
    @ODataField( odataName = "JointVentureEquityType" )
    private String jointVentureEquityType;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureEquityType</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<String> JOINT_VENTURE_EQUITY_TYPE =
        new EntProjectElementJVAField<String>("JointVentureEquityType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrProjectType</b>
     * </p>
     *
     * @return Joint Venture Object Type
     */
    @SerializedName( "JntVntrProjectType" )
    @JsonProperty( "JntVntrProjectType" )
    @Nullable
    @ODataField( odataName = "JntVntrProjectType" )
    private String jntVntrProjectType;
    /**
     * Use with available fluent helpers to apply the <b>JntVntrProjectType</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<String> JNT_VNTR_PROJECT_TYPE =
        new EntProjectElementJVAField<String>("JntVntrProjectType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntIntrstBillgClass</b>
     * </p>
     *
     * @return JIB/JIBE Class
     */
    @SerializedName( "JntIntrstBillgClass" )
    @JsonProperty( "JntIntrstBillgClass" )
    @Nullable
    @ODataField( odataName = "JntIntrstBillgClass" )
    private String jntIntrstBillgClass;
    /**
     * Use with available fluent helpers to apply the <b>JntIntrstBillgClass</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<String> JNT_INTRST_BILLG_CLASS =
        new EntProjectElementJVAField<String>("JntIntrstBillgClass");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>JntIntrstBillgSubClass</b>
     * </p>
     *
     * @return JIB/JIBE Subclass A
     */
    @SerializedName( "JntIntrstBillgSubClass" )
    @JsonProperty( "JntIntrstBillgSubClass" )
    @Nullable
    @ODataField( odataName = "JntIntrstBillgSubClass" )
    private String jntIntrstBillgSubClass;
    /**
     * Use with available fluent helpers to apply the <b>JntIntrstBillgSubClass</b> field to query operations.
     *
     */
    public final static EntProjectElementJVAField<String> JNT_INTRST_BILLG_SUB_CLASS =
        new EntProjectElementJVAField<String>("JntIntrstBillgSubClass");
    /**
     * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EntProjectElementJVA</b> to single
     * <b>EnterpriseProjectElement</b>.
     *
     */
    @SerializedName( "to_EnterpriseProjectElement" )
    @JsonProperty( "to_EnterpriseProjectElement" )
    @ODataField( odataName = "to_EnterpriseProjectElement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProjectElement toEnterpriseProjectElement;
    /**
     * Navigation property <b>to_EnterpriseProject</b> for <b>EntProjectElementJVA</b> to single
     * <b>EnterpriseProject</b>.
     *
     */
    @SerializedName( "to_EnterpriseProject" )
    @JsonProperty( "to_EnterpriseProject" )
    @ODataField( odataName = "to_EnterpriseProject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProject toEnterpriseProject;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProjectElement</b> navigation property to query
     * operations.
     *
     */
    public final static EntProjectElementJVAOneToOneLink<EnterpriseProjectElement> TO_ENTERPRISE_PROJECT_ELEMENT =
        new EntProjectElementJVAOneToOneLink<EnterpriseProjectElement>("to_EnterpriseProjectElement");
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProject</b> navigation property to query
     * operations.
     *
     */
    public final static EntProjectElementJVAOneToOneLink<EnterpriseProject> TO_ENTERPRISE_PROJECT =
        new EntProjectElementJVAOneToOneLink<EnterpriseProject>("to_EnterpriseProject");

    @Nonnull
    @Override
    public Class<EntProjectElementJVA> getType()
    {
        return EntProjectElementJVA.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JntIntrstBillgClass_fc</b>
     * </p>
     *
     * @param jntIntrstBillgClass_fc
     *            Dyn. Field Control
     */
    public void setJntIntrstBillgClass_fc( @Nullable final Short jntIntrstBillgClass_fc )
    {
        rememberChangedField("JntIntrstBillgClass_fc", this.jntIntrstBillgClass_fc);
        this.jntIntrstBillgClass_fc = jntIntrstBillgClass_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JntIntrstBillgSubClass_fc</b>
     * </p>
     *
     * @param jntIntrstBillgSubClass_fc
     *            Dyn. Field Control
     */
    public void setJntIntrstBillgSubClass_fc( @Nullable final Short jntIntrstBillgSubClass_fc )
    {
        rememberChangedField("JntIntrstBillgSubClass_fc", this.jntIntrstBillgSubClass_fc);
        this.jntIntrstBillgSubClass_fc = jntIntrstBillgSubClass_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrProjectType_fc</b>
     * </p>
     *
     * @param jntVntrProjectType_fc
     *            Dyn. Field Control
     */
    public void setJntVntrProjectType_fc( @Nullable final Short jntVntrProjectType_fc )
    {
        rememberChangedField("JntVntrProjectType_fc", this.jntVntrProjectType_fc);
        this.jntVntrProjectType_fc = jntVntrProjectType_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture_fc</b>
     * </p>
     *
     * @param jointVenture_fc
     *            Dyn. Field Control
     */
    public void setJointVenture_fc( @Nullable final Short jointVenture_fc )
    {
        rememberChangedField("JointVenture_fc", this.jointVenture_fc);
        this.jointVenture_fc = jointVenture_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode_fc</b>
     * </p>
     *
     * @param jointVentureCostRecoveryCode_fc
     *            Dyn. Field Control
     */
    public void setJointVentureCostRecoveryCode_fc( @Nullable final Short jointVentureCostRecoveryCode_fc )
    {
        rememberChangedField("JointVentureCostRecoveryCode_fc", this.jointVentureCostRecoveryCode_fc);
        this.jointVentureCostRecoveryCode_fc = jointVentureCostRecoveryCode_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType_fc</b>
     * </p>
     *
     * @param jointVentureEquityType_fc
     *            Dyn. Field Control
     */
    public void setJointVentureEquityType_fc( @Nullable final Short jointVentureEquityType_fc )
    {
        rememberChangedField("JointVentureEquityType_fc", this.jointVentureEquityType_fc);
        this.jointVentureEquityType_fc = jointVentureEquityType_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @param projectElementUUID
     *            Entity Guid
     */
    public void setProjectElementUUID( @Nullable final UUID projectElementUUID )
    {
        rememberChangedField("ProjectElementUUID", this.projectElementUUID);
        this.projectElementUUID = projectElementUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     *
     * @param jointVenture
     *            Joint Venture
     */
    public void setJointVenture( @Nullable final String jointVenture )
    {
        rememberChangedField("JointVenture", this.jointVenture);
        this.jointVenture = jointVenture;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode</b>
     * </p>
     *
     * @param jointVentureCostRecoveryCode
     *            Recovery Indicator
     */
    public void setJointVentureCostRecoveryCode( @Nullable final String jointVentureCostRecoveryCode )
    {
        rememberChangedField("JointVentureCostRecoveryCode", this.jointVentureCostRecoveryCode);
        this.jointVentureCostRecoveryCode = jointVentureCostRecoveryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     *
     * @param jointVentureEquityType
     *            Equity Type
     */
    public void setJointVentureEquityType( @Nullable final String jointVentureEquityType )
    {
        rememberChangedField("JointVentureEquityType", this.jointVentureEquityType);
        this.jointVentureEquityType = jointVentureEquityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JntVntrProjectType</b>
     * </p>
     *
     * @param jntVntrProjectType
     *            Joint Venture Object Type
     */
    public void setJntVntrProjectType( @Nullable final String jntVntrProjectType )
    {
        rememberChangedField("JntVntrProjectType", this.jntVntrProjectType);
        this.jntVntrProjectType = jntVntrProjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JntIntrstBillgClass</b>
     * </p>
     *
     * @param jntIntrstBillgClass
     *            JIB/JIBE Class
     */
    public void setJntIntrstBillgClass( @Nullable final String jntIntrstBillgClass )
    {
        rememberChangedField("JntIntrstBillgClass", this.jntIntrstBillgClass);
        this.jntIntrstBillgClass = jntIntrstBillgClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>JntIntrstBillgSubClass</b>
     * </p>
     *
     * @param jntIntrstBillgSubClass
     *            JIB/JIBE Subclass A
     */
    public void setJntIntrstBillgSubClass( @Nullable final String jntIntrstBillgSubClass )
    {
        rememberChangedField("JntIntrstBillgSubClass", this.jntIntrstBillgSubClass);
        this.jntIntrstBillgSubClass = jntIntrstBillgSubClass;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EntProjectElementJVA";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectElementUUID", getProjectElementUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("JntIntrstBillgClass_fc", getJntIntrstBillgClass_fc());
        values.put("JntIntrstBillgSubClass_fc", getJntIntrstBillgSubClass_fc());
        values.put("JntVntrProjectType_fc", getJntVntrProjectType_fc());
        values.put("JointVenture_fc", getJointVenture_fc());
        values.put("JointVentureCostRecoveryCode_fc", getJointVentureCostRecoveryCode_fc());
        values.put("JointVentureEquityType_fc", getJointVentureEquityType_fc());
        values.put("Update_mc", getUpdate_mc());
        values.put("ProjectElementUUID", getProjectElementUUID());
        values.put("ProjectUUID", getProjectUUID());
        values.put("JointVenture", getJointVenture());
        values.put("JointVentureCostRecoveryCode", getJointVentureCostRecoveryCode());
        values.put("JointVentureEquityType", getJointVentureEquityType());
        values.put("JntVntrProjectType", getJntVntrProjectType());
        values.put("JntIntrstBillgClass", getJntIntrstBillgClass());
        values.put("JntIntrstBillgSubClass", getJntIntrstBillgSubClass());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("JntIntrstBillgClass_fc") ) {
                final Object value = values.remove("JntIntrstBillgClass_fc");
                if( (value == null) || (!value.equals(getJntIntrstBillgClass_fc())) ) {
                    setJntIntrstBillgClass_fc(((Short) value));
                }
            }
            if( values.containsKey("JntIntrstBillgSubClass_fc") ) {
                final Object value = values.remove("JntIntrstBillgSubClass_fc");
                if( (value == null) || (!value.equals(getJntIntrstBillgSubClass_fc())) ) {
                    setJntIntrstBillgSubClass_fc(((Short) value));
                }
            }
            if( values.containsKey("JntVntrProjectType_fc") ) {
                final Object value = values.remove("JntVntrProjectType_fc");
                if( (value == null) || (!value.equals(getJntVntrProjectType_fc())) ) {
                    setJntVntrProjectType_fc(((Short) value));
                }
            }
            if( values.containsKey("JointVenture_fc") ) {
                final Object value = values.remove("JointVenture_fc");
                if( (value == null) || (!value.equals(getJointVenture_fc())) ) {
                    setJointVenture_fc(((Short) value));
                }
            }
            if( values.containsKey("JointVentureCostRecoveryCode_fc") ) {
                final Object value = values.remove("JointVentureCostRecoveryCode_fc");
                if( (value == null) || (!value.equals(getJointVentureCostRecoveryCode_fc())) ) {
                    setJointVentureCostRecoveryCode_fc(((Short) value));
                }
            }
            if( values.containsKey("JointVentureEquityType_fc") ) {
                final Object value = values.remove("JointVentureEquityType_fc");
                if( (value == null) || (!value.equals(getJointVentureEquityType_fc())) ) {
                    setJointVentureEquityType_fc(((Short) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ProjectElementUUID") ) {
                final Object value = values.remove("ProjectElementUUID");
                if( (value == null) || (!value.equals(getProjectElementUUID())) ) {
                    setProjectElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("JointVenture") ) {
                final Object value = values.remove("JointVenture");
                if( (value == null) || (!value.equals(getJointVenture())) ) {
                    setJointVenture(((String) value));
                }
            }
            if( values.containsKey("JointVentureCostRecoveryCode") ) {
                final Object value = values.remove("JointVentureCostRecoveryCode");
                if( (value == null) || (!value.equals(getJointVentureCostRecoveryCode())) ) {
                    setJointVentureCostRecoveryCode(((String) value));
                }
            }
            if( values.containsKey("JointVentureEquityType") ) {
                final Object value = values.remove("JointVentureEquityType");
                if( (value == null) || (!value.equals(getJointVentureEquityType())) ) {
                    setJointVentureEquityType(((String) value));
                }
            }
            if( values.containsKey("JntVntrProjectType") ) {
                final Object value = values.remove("JntVntrProjectType");
                if( (value == null) || (!value.equals(getJntVntrProjectType())) ) {
                    setJntVntrProjectType(((String) value));
                }
            }
            if( values.containsKey("JntIntrstBillgClass") ) {
                final Object value = values.remove("JntIntrstBillgClass");
                if( (value == null) || (!value.equals(getJntIntrstBillgClass())) ) {
                    setJntIntrstBillgClass(((String) value));
                }
            }
            if( values.containsKey("JntIntrstBillgSubClass") ) {
                final Object value = values.remove("JntIntrstBillgSubClass");
                if( (value == null) || (!value.equals(getJntIntrstBillgSubClass())) ) {
                    setJntIntrstBillgSubClass(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProjectElement") ) {
                final Object value = (values).remove("to_EnterpriseProjectElement");
                if( value instanceof Map ) {
                    if( toEnterpriseProjectElement == null ) {
                        toEnterpriseProjectElement = new EnterpriseProjectElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProjectElement.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EnterpriseProject") ) {
                final Object value = (values).remove("to_EnterpriseProject");
                if( value instanceof Map ) {
                    if( toEnterpriseProject == null ) {
                        toEnterpriseProject = new EnterpriseProject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProject.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EntProjectElementJVAField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EntProjectElementJVAField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EntProjectElementJVAField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EntProjectElementJVAField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProjectElement != null ) {
            (values).put("to_EnterpriseProjectElement", toEnterpriseProjectElement);
        }
        if( toEnterpriseProject != null ) {
            (values).put("to_EnterpriseProject", toEnterpriseProject);
        }
        return values;
    }

    /**
     * Fetches the <b>EnterpriseProjectElement</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProjectElement</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement fetchEnterpriseProjectElement()
    {
        return fetchFieldAsSingle("to_EnterpriseProjectElement", EnterpriseProjectElement.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectElement</b> of a queried <b>EntProjectElementJVA</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement getEnterpriseProjectElementOrFetch()
    {
        if( toEnterpriseProjectElement == null ) {
            toEnterpriseProjectElement = fetchEnterpriseProjectElement();
        }
        return toEnterpriseProjectElement;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjectElementJVA</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProjectElement</b> is already loaded, the
     *         result will contain the <b>EnterpriseProjectElement</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProjectElement> getEnterpriseProjectElementIfPresent()
    {
        return Option.of(toEnterpriseProjectElement);
    }

    /**
     * Overwrites the associated <b>EnterpriseProjectElement</b> entity for the loaded navigation property
     * <b>to_EnterpriseProjectElement</b>.
     *
     * @param value
     *            New <b>EnterpriseProjectElement</b> entity.
     */
    public void setEnterpriseProjectElement( final EnterpriseProjectElement value )
    {
        toEnterpriseProjectElement = value;
    }

    /**
     * Fetches the <b>EnterpriseProject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject fetchEnterpriseProject()
    {
        return fetchFieldAsSingle("to_EnterpriseProject", EnterpriseProject.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>EntProjectElementJVA</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject getEnterpriseProjectOrFetch()
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = fetchEnterpriseProject();
        }
        return toEnterpriseProject;
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjectElementJVA</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProject</b> is already loaded, the result will
     *         contain the <b>EnterpriseProject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProject> getEnterpriseProjectIfPresent()
    {
        return Option.of(toEnterpriseProject);
    }

    /**
     * Overwrites the associated <b>EnterpriseProject</b> entity for the loaded navigation property
     * <b>to_EnterpriseProject</b>.
     *
     * @param value
     *            New <b>EnterpriseProject</b> entity.
     */
    public void setEnterpriseProject( final EnterpriseProject value )
    {
        toEnterpriseProject = value;
    }

    /**
     * Helper class to allow for fluent creation of EntProjectElementJVA instances.
     *
     */
    public final static class EntProjectElementJVABuilder
    {

        private EnterpriseProjectElement toEnterpriseProjectElement;
        private EnterpriseProject toEnterpriseProject;

        private EntProjectElementJVA.EntProjectElementJVABuilder toEnterpriseProjectElement(
            final EnterpriseProjectElement value )
        {
            toEnterpriseProjectElement = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EntProjectElementJVA</b> to single
         * <b>EnterpriseProjectElement</b>.
         *
         * @param value
         *            The EnterpriseProjectElement to build this EntProjectElementJVA with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjectElementJVA.EntProjectElementJVABuilder enterpriseProjectElement(
            final EnterpriseProjectElement value )
        {
            return toEnterpriseProjectElement(value);
        }

        private EntProjectElementJVA.EntProjectElementJVABuilder toEnterpriseProject( final EnterpriseProject value )
        {
            toEnterpriseProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProject</b> for <b>EntProjectElementJVA</b> to single
         * <b>EnterpriseProject</b>.
         *
         * @param value
         *            The EnterpriseProject to build this EntProjectElementJVA with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjectElementJVA.EntProjectElementJVABuilder enterpriseProject( final EnterpriseProject value )
        {
            return toEnterpriseProject(value);
        }

    }

}
