/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EntProjectPublicSectorField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjectPublicSectorOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EntProjectPublicSectorSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Public Sector
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EntProjectPublicSectorType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EntProjectPublicSector extends VdmEntity<EntProjectPublicSector>
{

    /**
     * Selector for all available fields of EntProjectPublicSector.
     *
     */
    public final static EntProjectPublicSectorSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<Boolean> UPDATE_MC =
        new EntProjectPublicSectorField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<UUID> PROJECT_UUID =
        new EntProjectPublicSectorField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<String> FUND = new EntProjectPublicSectorField<String>("Fund");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FundIsFixAssigned</b>
     * </p>
     *
     * @return Indicator for Fund with Fixed Assignment
     */
    @SerializedName( "FundIsFixAssigned" )
    @JsonProperty( "FundIsFixAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FundIsFixAssigned" )
    private Boolean fundIsFixAssigned;
    /**
     * Use with available fluent helpers to apply the <b>FundIsFixAssigned</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<Boolean> FUND_IS_FIX_ASSIGNED =
        new EntProjectPublicSectorField<Boolean>("FundIsFixAssigned");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaIsFixAssigned</b>
     * </p>
     *
     * @return Indicator for Functional Area with Fixed Assignment
     */
    @SerializedName( "FunctionalAreaIsFixAssigned" )
    @JsonProperty( "FunctionalAreaIsFixAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FunctionalAreaIsFixAssigned" )
    private Boolean functionalAreaIsFixAssigned;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalAreaIsFixAssigned</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<Boolean> FUNCTIONAL_AREA_IS_FIX_ASSIGNED =
        new EntProjectPublicSectorField<Boolean>("FunctionalAreaIsFixAssigned");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<String> GRANT_ID =
        new EntProjectPublicSectorField<String>("GrantID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GrantIsFixAssigned</b>
     * </p>
     *
     * @return Indicator for Grant with Fixed Assignment
     */
    @SerializedName( "GrantIsFixAssigned" )
    @JsonProperty( "GrantIsFixAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GrantIsFixAssigned" )
    private Boolean grantIsFixAssigned;
    /**
     * Use with available fluent helpers to apply the <b>GrantIsFixAssigned</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<Boolean> GRANT_IS_FIX_ASSIGNED =
        new EntProjectPublicSectorField<Boolean>("GrantIsFixAssigned");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     *
     * @return Sponsored Program
     */
    @SerializedName( "SponsoredProgram" )
    @JsonProperty( "SponsoredProgram" )
    @Nullable
    @ODataField( odataName = "SponsoredProgram" )
    private String sponsoredProgram;
    /**
     * Use with available fluent helpers to apply the <b>SponsoredProgram</b> field to query operations.
     *
     */
    public final static EntProjectPublicSectorField<String> SPONSORED_PROGRAM =
        new EntProjectPublicSectorField<String>("SponsoredProgram");
    /**
     * Navigation property <b>to_EnterpriseProject</b> for <b>EntProjectPublicSector</b> to single
     * <b>EnterpriseProject</b>.
     *
     */
    @SerializedName( "to_EnterpriseProject" )
    @JsonProperty( "to_EnterpriseProject" )
    @ODataField( odataName = "to_EnterpriseProject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProject toEnterpriseProject;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProject</b> navigation property to query
     * operations.
     *
     */
    public final static EntProjectPublicSectorOneToOneLink<EnterpriseProject> TO_ENTERPRISE_PROJECT =
        new EntProjectPublicSectorOneToOneLink<EnterpriseProject>("to_EnterpriseProject");

    @Nonnull
    @Override
    public Class<EntProjectPublicSector> getType()
    {
        return EntProjectPublicSector.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FundIsFixAssigned</b>
     * </p>
     *
     * @param fundIsFixAssigned
     *            Indicator for Fund with Fixed Assignment
     */
    public void setFundIsFixAssigned( @Nullable final Boolean fundIsFixAssigned )
    {
        rememberChangedField("FundIsFixAssigned", this.fundIsFixAssigned);
        this.fundIsFixAssigned = fundIsFixAssigned;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaIsFixAssigned</b>
     * </p>
     *
     * @param functionalAreaIsFixAssigned
     *            Indicator for Functional Area with Fixed Assignment
     */
    public void setFunctionalAreaIsFixAssigned( @Nullable final Boolean functionalAreaIsFixAssigned )
    {
        rememberChangedField("FunctionalAreaIsFixAssigned", this.functionalAreaIsFixAssigned);
        this.functionalAreaIsFixAssigned = functionalAreaIsFixAssigned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GrantIsFixAssigned</b>
     * </p>
     *
     * @param grantIsFixAssigned
     *            Indicator for Grant with Fixed Assignment
     */
    public void setGrantIsFixAssigned( @Nullable final Boolean grantIsFixAssigned )
    {
        rememberChangedField("GrantIsFixAssigned", this.grantIsFixAssigned);
        this.grantIsFixAssigned = grantIsFixAssigned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     *
     * @param sponsoredProgram
     *            Sponsored Program
     */
    public void setSponsoredProgram( @Nullable final String sponsoredProgram )
    {
        rememberChangedField("SponsoredProgram", this.sponsoredProgram);
        this.sponsoredProgram = sponsoredProgram;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EntProjectPublicSector";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectUUID", getProjectUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Update_mc", getUpdate_mc());
        values.put("ProjectUUID", getProjectUUID());
        values.put("Fund", getFund());
        values.put("FundIsFixAssigned", getFundIsFixAssigned());
        values.put("FunctionalAreaIsFixAssigned", getFunctionalAreaIsFixAssigned());
        values.put("GrantID", getGrantID());
        values.put("GrantIsFixAssigned", getGrantIsFixAssigned());
        values.put("SponsoredProgram", getSponsoredProgram());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("FundIsFixAssigned") ) {
                final Object value = values.remove("FundIsFixAssigned");
                if( (value == null) || (!value.equals(getFundIsFixAssigned())) ) {
                    setFundIsFixAssigned(((Boolean) value));
                }
            }
            if( values.containsKey("FunctionalAreaIsFixAssigned") ) {
                final Object value = values.remove("FunctionalAreaIsFixAssigned");
                if( (value == null) || (!value.equals(getFunctionalAreaIsFixAssigned())) ) {
                    setFunctionalAreaIsFixAssigned(((Boolean) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("GrantIsFixAssigned") ) {
                final Object value = values.remove("GrantIsFixAssigned");
                if( (value == null) || (!value.equals(getGrantIsFixAssigned())) ) {
                    setGrantIsFixAssigned(((Boolean) value));
                }
            }
            if( values.containsKey("SponsoredProgram") ) {
                final Object value = values.remove("SponsoredProgram");
                if( (value == null) || (!value.equals(getSponsoredProgram())) ) {
                    setSponsoredProgram(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProject") ) {
                final Object value = (values).remove("to_EnterpriseProject");
                if( value instanceof Map ) {
                    if( toEnterpriseProject == null ) {
                        toEnterpriseProject = new EnterpriseProject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProject.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EntProjectPublicSectorField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EntProjectPublicSectorField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EntProjectPublicSectorField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EntProjectPublicSectorField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProject != null ) {
            (values).put("to_EnterpriseProject", toEnterpriseProject);
        }
        return values;
    }

    /**
     * Fetches the <b>EnterpriseProject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject fetchEnterpriseProject()
    {
        return fetchFieldAsSingle("to_EnterpriseProject", EnterpriseProject.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>EntProjectPublicSector</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject getEnterpriseProjectOrFetch()
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = fetchEnterpriseProject();
        }
        return toEnterpriseProject;
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjectPublicSector</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProject</b> is already loaded, the result will
     *         contain the <b>EnterpriseProject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProject> getEnterpriseProjectIfPresent()
    {
        return Option.of(toEnterpriseProject);
    }

    /**
     * Overwrites the associated <b>EnterpriseProject</b> entity for the loaded navigation property
     * <b>to_EnterpriseProject</b>.
     *
     * @param value
     *            New <b>EnterpriseProject</b> entity.
     */
    public void setEnterpriseProject( final EnterpriseProject value )
    {
        toEnterpriseProject = value;
    }

    /**
     * Helper class to allow for fluent creation of EntProjectPublicSector instances.
     *
     */
    public final static class EntProjectPublicSectorBuilder
    {

        private EnterpriseProject toEnterpriseProject;

        private EntProjectPublicSector.EntProjectPublicSectorBuilder toEnterpriseProject(
            final EnterpriseProject value )
        {
            toEnterpriseProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProject</b> for <b>EntProjectPublicSector</b> to single
         * <b>EnterpriseProject</b>.
         *
         * @param value
         *            The EnterpriseProject to build this EntProjectPublicSector with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjectPublicSector.EntProjectPublicSectorBuilder enterpriseProject( final EnterpriseProject value )
        {
            return toEnterpriseProject(value);
        }

    }

}
