/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EnterpriseProjBlkFuncField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EnterpriseProjBlkFuncOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EnterpriseProjBlkFuncSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Block Function
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EnterpriseProjBlkFuncType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EnterpriseProjBlkFunc extends VdmEntity<EnterpriseProjBlkFunc>
{

    /**
     * Selector for all available fields of EnterpriseProjBlkFunc.
     *
     */
    public final static EnterpriseProjBlkFuncSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static EnterpriseProjBlkFuncField<Boolean> UPDATE_MC =
        new EnterpriseProjBlkFuncField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjBlkFuncField<UUID> PROJECT_UUID =
        new EnterpriseProjBlkFuncField<UUID>("ProjectUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjTimeRecgIsBlkd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "EntProjTimeRecgIsBlkd" )
    @JsonProperty( "EntProjTimeRecgIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjTimeRecgIsBlkd" )
    private Boolean entProjTimeRecgIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjTimeRecgIsBlkd</b> field to query operations.
     *
     */
    public final static EnterpriseProjBlkFuncField<Boolean> ENT_PROJ_TIME_RECG_IS_BLKD =
        new EnterpriseProjBlkFuncField<Boolean>("EntProjTimeRecgIsBlkd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjStaffExpensePostgIsBlkd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "EntProjStaffExpensePostgIsBlkd" )
    @JsonProperty( "EntProjStaffExpensePostgIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjStaffExpensePostgIsBlkd" )
    private Boolean entProjStaffExpensePostgIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjStaffExpensePostgIsBlkd</b> field to query operations.
     *
     */
    public final static EnterpriseProjBlkFuncField<Boolean> ENT_PROJ_STAFF_EXPENSE_POSTG_IS_BLKD =
        new EnterpriseProjBlkFuncField<Boolean>("EntProjStaffExpensePostgIsBlkd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjServicePostingIsBlkd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "EntProjServicePostingIsBlkd" )
    @JsonProperty( "EntProjServicePostingIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjServicePostingIsBlkd" )
    private Boolean entProjServicePostingIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjServicePostingIsBlkd</b> field to query operations.
     *
     */
    public final static EnterpriseProjBlkFuncField<Boolean> ENT_PROJ_SERVICE_POSTING_IS_BLKD =
        new EnterpriseProjBlkFuncField<Boolean>("EntProjServicePostingIsBlkd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjOtherExpensePostgIsBlkd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "EntProjOtherExpensePostgIsBlkd" )
    @JsonProperty( "EntProjOtherExpensePostgIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjOtherExpensePostgIsBlkd" )
    private Boolean entProjOtherExpensePostgIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjOtherExpensePostgIsBlkd</b> field to query operations.
     *
     */
    public final static EnterpriseProjBlkFuncField<Boolean> ENT_PROJ_OTHER_EXPENSE_POSTG_IS_BLKD =
        new EnterpriseProjBlkFuncField<Boolean>("EntProjOtherExpensePostgIsBlkd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjPurchasingIsBlkd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "EntProjPurchasingIsBlkd" )
    @JsonProperty( "EntProjPurchasingIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjPurchasingIsBlkd" )
    private Boolean entProjPurchasingIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjPurchasingIsBlkd</b> field to query operations.
     *
     */
    public final static EnterpriseProjBlkFuncField<Boolean> ENT_PROJ_PURCHASING_IS_BLKD =
        new EnterpriseProjBlkFuncField<Boolean>("EntProjPurchasingIsBlkd");
    /**
     * Navigation property <b>to_EnterpriseProject</b> for <b>EnterpriseProjBlkFunc</b> to single
     * <b>EnterpriseProject</b>.
     *
     */
    @SerializedName( "to_EnterpriseProject" )
    @JsonProperty( "to_EnterpriseProject" )
    @ODataField( odataName = "to_EnterpriseProject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProject toEnterpriseProject;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProject</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjBlkFuncOneToOneLink<EnterpriseProject> TO_ENTERPRISE_PROJECT =
        new EnterpriseProjBlkFuncOneToOneLink<EnterpriseProject>("to_EnterpriseProject");

    @Nonnull
    @Override
    public Class<EnterpriseProjBlkFunc> getType()
    {
        return EnterpriseProjBlkFunc.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjTimeRecgIsBlkd</b>
     * </p>
     *
     * @param entProjTimeRecgIsBlkd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setEntProjTimeRecgIsBlkd( @Nullable final Boolean entProjTimeRecgIsBlkd )
    {
        rememberChangedField("EntProjTimeRecgIsBlkd", this.entProjTimeRecgIsBlkd);
        this.entProjTimeRecgIsBlkd = entProjTimeRecgIsBlkd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjStaffExpensePostgIsBlkd</b>
     * </p>
     *
     * @param entProjStaffExpensePostgIsBlkd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setEntProjStaffExpensePostgIsBlkd( @Nullable final Boolean entProjStaffExpensePostgIsBlkd )
    {
        rememberChangedField("EntProjStaffExpensePostgIsBlkd", this.entProjStaffExpensePostgIsBlkd);
        this.entProjStaffExpensePostgIsBlkd = entProjStaffExpensePostgIsBlkd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjServicePostingIsBlkd</b>
     * </p>
     *
     * @param entProjServicePostingIsBlkd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setEntProjServicePostingIsBlkd( @Nullable final Boolean entProjServicePostingIsBlkd )
    {
        rememberChangedField("EntProjServicePostingIsBlkd", this.entProjServicePostingIsBlkd);
        this.entProjServicePostingIsBlkd = entProjServicePostingIsBlkd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjOtherExpensePostgIsBlkd</b>
     * </p>
     *
     * @param entProjOtherExpensePostgIsBlkd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setEntProjOtherExpensePostgIsBlkd( @Nullable final Boolean entProjOtherExpensePostgIsBlkd )
    {
        rememberChangedField("EntProjOtherExpensePostgIsBlkd", this.entProjOtherExpensePostgIsBlkd);
        this.entProjOtherExpensePostgIsBlkd = entProjOtherExpensePostgIsBlkd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjPurchasingIsBlkd</b>
     * </p>
     *
     * @param entProjPurchasingIsBlkd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setEntProjPurchasingIsBlkd( @Nullable final Boolean entProjPurchasingIsBlkd )
    {
        rememberChangedField("EntProjPurchasingIsBlkd", this.entProjPurchasingIsBlkd);
        this.entProjPurchasingIsBlkd = entProjPurchasingIsBlkd;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EnterpriseProjBlkFunc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectUUID", getProjectUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Update_mc", getUpdate_mc());
        values.put("ProjectUUID", getProjectUUID());
        values.put("EntProjTimeRecgIsBlkd", getEntProjTimeRecgIsBlkd());
        values.put("EntProjStaffExpensePostgIsBlkd", getEntProjStaffExpensePostgIsBlkd());
        values.put("EntProjServicePostingIsBlkd", getEntProjServicePostingIsBlkd());
        values.put("EntProjOtherExpensePostgIsBlkd", getEntProjOtherExpensePostgIsBlkd());
        values.put("EntProjPurchasingIsBlkd", getEntProjPurchasingIsBlkd());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("EntProjTimeRecgIsBlkd") ) {
                final Object value = values.remove("EntProjTimeRecgIsBlkd");
                if( (value == null) || (!value.equals(getEntProjTimeRecgIsBlkd())) ) {
                    setEntProjTimeRecgIsBlkd(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjStaffExpensePostgIsBlkd") ) {
                final Object value = values.remove("EntProjStaffExpensePostgIsBlkd");
                if( (value == null) || (!value.equals(getEntProjStaffExpensePostgIsBlkd())) ) {
                    setEntProjStaffExpensePostgIsBlkd(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjServicePostingIsBlkd") ) {
                final Object value = values.remove("EntProjServicePostingIsBlkd");
                if( (value == null) || (!value.equals(getEntProjServicePostingIsBlkd())) ) {
                    setEntProjServicePostingIsBlkd(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjOtherExpensePostgIsBlkd") ) {
                final Object value = values.remove("EntProjOtherExpensePostgIsBlkd");
                if( (value == null) || (!value.equals(getEntProjOtherExpensePostgIsBlkd())) ) {
                    setEntProjOtherExpensePostgIsBlkd(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjPurchasingIsBlkd") ) {
                final Object value = values.remove("EntProjPurchasingIsBlkd");
                if( (value == null) || (!value.equals(getEntProjPurchasingIsBlkd())) ) {
                    setEntProjPurchasingIsBlkd(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProject") ) {
                final Object value = (values).remove("to_EnterpriseProject");
                if( value instanceof Map ) {
                    if( toEnterpriseProject == null ) {
                        toEnterpriseProject = new EnterpriseProject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProject.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EnterpriseProjBlkFuncField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EnterpriseProjBlkFuncField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EnterpriseProjBlkFuncField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EnterpriseProjBlkFuncField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProject != null ) {
            (values).put("to_EnterpriseProject", toEnterpriseProject);
        }
        return values;
    }

    /**
     * Fetches the <b>EnterpriseProject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject fetchEnterpriseProject()
    {
        return fetchFieldAsSingle("to_EnterpriseProject", EnterpriseProject.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>EnterpriseProjBlkFunc</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject getEnterpriseProjectOrFetch()
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = fetchEnterpriseProject();
        }
        return toEnterpriseProject;
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjBlkFunc</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProject</b> is already loaded, the result will
     *         contain the <b>EnterpriseProject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProject> getEnterpriseProjectIfPresent()
    {
        return Option.of(toEnterpriseProject);
    }

    /**
     * Overwrites the associated <b>EnterpriseProject</b> entity for the loaded navigation property
     * <b>to_EnterpriseProject</b>.
     *
     * @param value
     *            New <b>EnterpriseProject</b> entity.
     */
    public void setEnterpriseProject( final EnterpriseProject value )
    {
        toEnterpriseProject = value;
    }

    /**
     * Helper class to allow for fluent creation of EnterpriseProjBlkFunc instances.
     *
     */
    public final static class EnterpriseProjBlkFuncBuilder
    {

        private EnterpriseProject toEnterpriseProject;

        private EnterpriseProjBlkFunc.EnterpriseProjBlkFuncBuilder toEnterpriseProject( final EnterpriseProject value )
        {
            toEnterpriseProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProject</b> for <b>EnterpriseProjBlkFunc</b> to single
         * <b>EnterpriseProject</b>.
         *
         * @param value
         *            The EnterpriseProject to build this EnterpriseProjBlkFunc with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjBlkFunc.EnterpriseProjBlkFuncBuilder enterpriseProject( final EnterpriseProject value )
        {
            return toEnterpriseProject(value);
        }

    }

}
