/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EnterpriseProjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EnterpriseProjectLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EnterpriseProjectOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EnterpriseProjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EnterpriseProjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EnterpriseProject extends VdmEntity<EnterpriseProject>
{

    /**
     * Selector for all available fields of EnterpriseProject.
     *
     */
    public final static EnterpriseProjectSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeEntProjProcgStatus_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "ChangeEntProjProcgStatus_ac" )
    @JsonProperty( "ChangeEntProjProcgStatus_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ChangeEntProjProcgStatus_ac" )
    private Boolean changeEntProjProcgStatus_ac;
    /**
     * Use with available fluent helpers to apply the <b>ChangeEntProjProcgStatus_ac</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> CHANGE_ENT_PROJ_PROCG_STATUS_AC =
        new EnterpriseProjectField<Boolean>("ChangeEntProjProcgStatus_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ActualEndDate_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ActualEndDate_fc" )
    @JsonProperty( "ActualEndDate_fc" )
    @Nullable
    @ODataField( odataName = "ActualEndDate_fc" )
    private Short actualEndDate_fc;
    /**
     * Use with available fluent helpers to apply the <b>ActualEndDate_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> ACTUAL_END_DATE_FC =
        new EnterpriseProjectField<Short>("ActualEndDate_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ActualStartDate_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ActualStartDate_fc" )
    @JsonProperty( "ActualStartDate_fc" )
    @Nullable
    @ODataField( odataName = "ActualStartDate_fc" )
    private Short actualStartDate_fc;
    /**
     * Use with available fluent helpers to apply the <b>ActualStartDate_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> ACTUAL_START_DATE_FC =
        new EnterpriseProjectField<Short>("ActualStartDate_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlIsActive_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "AvailabilityControlIsActive_fc" )
    @JsonProperty( "AvailabilityControlIsActive_fc" )
    @Nullable
    @ODataField( odataName = "AvailabilityControlIsActive_fc" )
    private Short availabilityControlIsActive_fc;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityControlIsActive_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> AVAILABILITY_CONTROL_IS_ACTIVE_FC =
        new EnterpriseProjectField<Short>("AvailabilityControlIsActive_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlProfile_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "AvailabilityControlProfile_fc" )
    @JsonProperty( "AvailabilityControlProfile_fc" )
    @Nullable
    @ODataField( odataName = "AvailabilityControlProfile_fc" )
    private Short availabilityControlProfile_fc;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityControlProfile_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> AVAILABILITY_CONTROL_PROFILE_FC =
        new EnterpriseProjectField<Short>("AvailabilityControlProfile_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ControllingArea_fc" )
    @JsonProperty( "ControllingArea_fc" )
    @Nullable
    @ODataField( odataName = "ControllingArea_fc" )
    private Short controllingArea_fc;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> CONTROLLING_AREA_FC =
        new EnterpriseProjectField<Short>("ControllingArea_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "CostingSheet_fc" )
    @JsonProperty( "CostingSheet_fc" )
    @Nullable
    @ODataField( odataName = "CostingSheet_fc" )
    private Short costingSheet_fc;
    /**
     * Use with available fluent helpers to apply the <b>CostingSheet_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> COSTING_SHEET_FC =
        new EnterpriseProjectField<Short>("CostingSheet_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EnterpriseProjectType_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "EnterpriseProjectType_fc" )
    @JsonProperty( "EnterpriseProjectType_fc" )
    @Nullable
    @ODataField( odataName = "EnterpriseProjectType_fc" )
    private Short enterpriseProjectType_fc;
    /**
     * Use with available fluent helpers to apply the <b>EnterpriseProjectType_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> ENTERPRISE_PROJECT_TYPE_FC =
        new EnterpriseProjectField<Short>("EnterpriseProjectType_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjIsMultiSlsOrdItmsEnbld_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "EntProjIsMultiSlsOrdItmsEnbld_fc" )
    @JsonProperty( "EntProjIsMultiSlsOrdItmsEnbld_fc" )
    @Nullable
    @ODataField( odataName = "EntProjIsMultiSlsOrdItmsEnbld_fc" )
    private Short entProjIsMultiSlsOrdItmsEnbld_fc;
    /**
     * Use with available fluent helpers to apply the <b>EntProjIsMultiSlsOrdItmsEnbld_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> ENT_PROJ_IS_MULTI_SLS_ORD_ITMS_ENBLD_FC =
        new EnterpriseProjectField<Short>("EntProjIsMultiSlsOrdItmsEnbld_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "FunctionalArea_fc" )
    @JsonProperty( "FunctionalArea_fc" )
    @Nullable
    @ODataField( odataName = "FunctionalArea_fc" )
    private Short functionalArea_fc;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> FUNCTIONAL_AREA_FC =
        new EnterpriseProjectField<Short>("FunctionalArea_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "FunctionalLocation_fc" )
    @JsonProperty( "FunctionalLocation_fc" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation_fc" )
    private Short functionalLocation_fc;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> FUNCTIONAL_LOCATION_FC =
        new EnterpriseProjectField<Short>("FunctionalLocation_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "InvestmentProfile_fc" )
    @JsonProperty( "InvestmentProfile_fc" )
    @Nullable
    @ODataField( odataName = "InvestmentProfile_fc" )
    private Short investmentProfile_fc;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentProfile_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> INVESTMENT_PROFILE_FC =
        new EnterpriseProjectField<Short>("InvestmentProfile_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBillingRelevant_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "IsBillingRelevant_fc" )
    @JsonProperty( "IsBillingRelevant_fc" )
    @Nullable
    @ODataField( odataName = "IsBillingRelevant_fc" )
    private Short isBillingRelevant_fc;
    /**
     * Use with available fluent helpers to apply the <b>IsBillingRelevant_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> IS_BILLING_RELEVANT_FC =
        new EnterpriseProjectField<Short>("IsBillingRelevant_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Location_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "Location_fc" )
    @JsonProperty( "Location_fc" )
    @Nullable
    @ODataField( odataName = "Location_fc" )
    private Short location_fc;
    /**
     * Use with available fluent helpers to apply the <b>Location_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> LOCATION_FC = new EnterpriseProjectField<Short>("Location_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Plant_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "Plant_fc" )
    @JsonProperty( "Plant_fc" )
    @Nullable
    @ODataField( odataName = "Plant_fc" )
    private Short plant_fc;
    /**
     * Use with available fluent helpers to apply the <b>Plant_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> PLANT_FC = new EnterpriseProjectField<Short>("Plant_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "PriorityCode_fc" )
    @JsonProperty( "PriorityCode_fc" )
    @Nullable
    @ODataField( odataName = "PriorityCode_fc" )
    private Short priorityCode_fc;
    /**
     * Use with available fluent helpers to apply the <b>PriorityCode_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> PRIORITY_CODE_FC =
        new EnterpriseProjectField<Short>("PriorityCode_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProfitCenter_fc" )
    @JsonProperty( "ProfitCenter_fc" )
    @Nullable
    @ODataField( odataName = "ProfitCenter_fc" )
    private Short profitCenter_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> PROFIT_CENTER_FC =
        new EnterpriseProjectField<Short>("ProfitCenter_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Project_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "Project_fc" )
    @JsonProperty( "Project_fc" )
    @Nullable
    @ODataField( odataName = "Project_fc" )
    private Short project_fc;
    /**
     * Use with available fluent helpers to apply the <b>Project_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> PROJECT_FC = new EnterpriseProjectField<Short>("Project_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCurrency_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProjectCurrency_fc" )
    @JsonProperty( "ProjectCurrency_fc" )
    @Nullable
    @ODataField( odataName = "ProjectCurrency_fc" )
    private Short projectCurrency_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProjectCurrency_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> PROJECT_CURRENCY_FC =
        new EnterpriseProjectField<Short>("ProjectCurrency_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDescription_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProjectDescription_fc" )
    @JsonProperty( "ProjectDescription_fc" )
    @Nullable
    @ODataField( odataName = "ProjectDescription_fc" )
    private Short projectDescription_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDescription_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> PROJECT_DESCRIPTION_FC =
        new EnterpriseProjectField<Short>("ProjectDescription_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectEndDate_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProjectEndDate_fc" )
    @JsonProperty( "ProjectEndDate_fc" )
    @Nullable
    @ODataField( odataName = "ProjectEndDate_fc" )
    private Short projectEndDate_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProjectEndDate_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> PROJECT_END_DATE_FC =
        new EnterpriseProjectField<Short>("ProjectEndDate_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProjectProfileCode_fc" )
    @JsonProperty( "ProjectProfileCode_fc" )
    @Nullable
    @ODataField( odataName = "ProjectProfileCode_fc" )
    private Short projectProfileCode_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProjectProfileCode_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> PROJECT_PROFILE_CODE_FC =
        new EnterpriseProjectField<Short>("ProjectProfileCode_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStartDate_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProjectStartDate_fc" )
    @JsonProperty( "ProjectStartDate_fc" )
    @Nullable
    @ODataField( odataName = "ProjectStartDate_fc" )
    private Short projectStartDate_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProjectStartDate_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> PROJECT_START_DATE_FC =
        new EnterpriseProjectField<Short>("ProjectStartDate_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ResponsibleCostCenter_fc" )
    @JsonProperty( "ResponsibleCostCenter_fc" )
    @Nullable
    @ODataField( odataName = "ResponsibleCostCenter_fc" )
    private Short responsibleCostCenter_fc;
    /**
     * Use with available fluent helpers to apply the <b>ResponsibleCostCenter_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Short> RESPONSIBLE_COST_CENTER_FC =
        new EnterpriseProjectField<Short>("ResponsibleCostCenter_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> DELETE_MC = new EnterpriseProjectField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> UPDATE_MC = new EnterpriseProjectField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EnterpriseProjectElement_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_EnterpriseProjectElement_oc" )
    @JsonProperty( "to_EnterpriseProjectElement_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_EnterpriseProjectElement_oc" )
    private Boolean enterpriseProjectElement_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProjectElement_oc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> ENTERPRISE_PROJECT_ELEMENT_OC =
        new EnterpriseProjectField<Boolean>("to_EnterpriseProjectElement_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjBlkFunc_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_EntProjBlkFunc_oc" )
    @JsonProperty( "to_EntProjBlkFunc_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_EntProjBlkFunc_oc" )
    private Boolean entProjBlkFunc_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjBlkFunc_oc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> ENT_PROJ_BLK_FUNC_OC =
        new EnterpriseProjectField<Boolean>("to_EntProjBlkFunc_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjRole_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_EntProjRole_oc" )
    @JsonProperty( "to_EntProjRole_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_EntProjRole_oc" )
    private Boolean entProjRole_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjRole_oc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> ENT_PROJ_ROLE_OC =
        new EnterpriseProjectField<Boolean>("to_EntProjRole_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjTeamMember_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_EntProjTeamMember_oc" )
    @JsonProperty( "to_EntProjTeamMember_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_EntProjTeamMember_oc" )
    private Boolean entProjTeamMember_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjTeamMember_oc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> ENT_PROJ_TEAM_MEMBER_OC =
        new EnterpriseProjectField<Boolean>("to_EntProjTeamMember_oc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<UUID> PROJECT_UUID = new EnterpriseProjectField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjectInternalID</b>
     * </p>
     *
     * @return Project (internal)
     */
    @SerializedName( "ProjectInternalID" )
    @JsonProperty( "ProjectInternalID" )
    @Nullable
    @ODataField( odataName = "ProjectInternalID" )
    private String projectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectInternalID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROJECT_INTERNAL_ID =
        new EnterpriseProjectField<String>("ProjectInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Identification of Entities
     */
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROJECT = new EnterpriseProjectField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDescription</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "ProjectDescription" )
    @JsonProperty( "ProjectDescription" )
    @Nullable
    @ODataField( odataName = "ProjectDescription" )
    private String projectDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProjectDescription</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROJECT_DESCRIPTION =
        new EnterpriseProjectField<String>("ProjectDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EnterpriseProjectType</b>
     * </p>
     *
     * @return Project Type
     */
    @SerializedName( "EnterpriseProjectType" )
    @JsonProperty( "EnterpriseProjectType" )
    @Nullable
    @ODataField( odataName = "EnterpriseProjectType" )
    private String enterpriseProjectType;
    /**
     * Use with available fluent helpers to apply the <b>EnterpriseProjectType</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> ENTERPRISE_PROJECT_TYPE =
        new EnterpriseProjectField<String>("EnterpriseProjectType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     *
     * @return Priority
     */
    @SerializedName( "PriorityCode" )
    @JsonProperty( "PriorityCode" )
    @Nullable
    @ODataField( odataName = "PriorityCode" )
    private String priorityCode;
    /**
     * Use with available fluent helpers to apply the <b>PriorityCode</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PRIORITY_CODE =
        new EnterpriseProjectField<String>("PriorityCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStartDate</b>
     * </p>
     *
     * @return Latest Planned Start
     */
    @SerializedName( "ProjectStartDate" )
    @JsonProperty( "ProjectStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projectStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjectStartDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<LocalDateTime> PROJECT_START_DATE =
        new EnterpriseProjectField<LocalDateTime>("ProjectStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectEndDate</b>
     * </p>
     *
     * @return Latest Planned Finish
     */
    @SerializedName( "ProjectEndDate" )
    @JsonProperty( "ProjectEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime projectEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ProjectEndDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<LocalDateTime> PROJECT_END_DATE =
        new EnterpriseProjectField<LocalDateTime>("ProjectEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualStartDate</b>
     * </p>
     *
     * @return Actual Start
     */
    @SerializedName( "ActualStartDate" )
    @JsonProperty( "ActualStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actualStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ActualStartDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<LocalDateTime> ACTUAL_START_DATE =
        new EnterpriseProjectField<LocalDateTime>("ActualStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualEndDate</b>
     * </p>
     *
     * @return Actual Finish
     */
    @SerializedName( "ActualEndDate" )
    @JsonProperty( "ActualEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actualEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ActualEndDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<LocalDateTime> ACTUAL_END_DATE =
        new EnterpriseProjectField<LocalDateTime>("ActualEndDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerUUID</b>
     * </p>
     *
     * @return Business Partner GUID
     */
    @SerializedName( "CustomerUUID" )
    @JsonProperty( "CustomerUUID" )
    @Nullable
    @ODataField( odataName = "CustomerUUID" )
    private UUID customerUUID;
    /**
     * Use with available fluent helpers to apply the <b>CustomerUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<UUID> CUSTOMER_UUID = new EnterpriseProjectField<UUID>("CustomerUUID");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EnterpriseProjectServiceOrg</b>
     * </p>
     *
     * @return Service Organization
     */
    @SerializedName( "EnterpriseProjectServiceOrg" )
    @JsonProperty( "EnterpriseProjectServiceOrg" )
    @Nullable
    @ODataField( odataName = "EnterpriseProjectServiceOrg" )
    private String enterpriseProjectServiceOrg;
    /**
     * Use with available fluent helpers to apply the <b>EnterpriseProjectServiceOrg</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> ENTERPRISE_PROJECT_SERVICE_ORG =
        new EnterpriseProjectField<String>("EnterpriseProjectServiceOrg");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjectIsConfidential</b>
     * </p>
     *
     * @return Enterprise Project Is Confidential
     */
    @SerializedName( "EntProjectIsConfidential" )
    @JsonProperty( "EntProjectIsConfidential" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjectIsConfidential" )
    private Boolean entProjectIsConfidential;
    /**
     * Use with available fluent helpers to apply the <b>EntProjectIsConfidential</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> ENT_PROJECT_IS_CONFIDENTIAL =
        new EnterpriseProjectField<Boolean>("EntProjectIsConfidential");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RestrictedTimePosting</b>
     * </p>
     *
     * @return Restrict Unstaffed Posting
     */
    @SerializedName( "RestrictedTimePosting" )
    @JsonProperty( "RestrictedTimePosting" )
    @Nullable
    @ODataField( odataName = "RestrictedTimePosting" )
    private String restrictedTimePosting;
    /**
     * Use with available fluent helpers to apply the <b>RestrictedTimePosting</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> RESTRICTED_TIME_POSTING =
        new EnterpriseProjectField<String>("RestrictedTimePosting");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     *
     * @return Object Processing Status
     */
    @SerializedName( "ProcessingStatus" )
    @JsonProperty( "ProcessingStatus" )
    @Nullable
    @ODataField( odataName = "ProcessingStatus" )
    private String processingStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProcessingStatus</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROCESSING_STATUS =
        new EnterpriseProjectField<String>("ProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @return Responsible Cost Center
     */
    @SerializedName( "ResponsibleCostCenter" )
    @JsonProperty( "ResponsibleCostCenter" )
    @Nullable
    @ODataField( odataName = "ResponsibleCostCenter" )
    private String responsibleCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>ResponsibleCostCenter</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> RESPONSIBLE_COST_CENTER =
        new EnterpriseProjectField<String>("ResponsibleCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROFIT_CENTER =
        new EnterpriseProjectField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
     * </p>
     *
     * @return Project Profile
     */
    @SerializedName( "ProjectProfileCode" )
    @JsonProperty( "ProjectProfileCode" )
    @Nullable
    @ODataField( odataName = "ProjectProfileCode" )
    private String projectProfileCode;
    /**
     * Use with available fluent helpers to apply the <b>ProjectProfileCode</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROJECT_PROFILE_CODE =
        new EnterpriseProjectField<String>("ProjectProfileCode");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> FUNCTIONAL_AREA =
        new EnterpriseProjectField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company code for the project
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> COMPANY_CODE = new EnterpriseProjectField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling area for the project
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> CONTROLLING_AREA =
        new EnterpriseProjectField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PLANT = new EnterpriseProjectField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Location</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "Location" )
    @JsonProperty( "Location" )
    @Nullable
    @ODataField( odataName = "Location" )
    private String location;
    /**
     * Use with available fluent helpers to apply the <b>Location</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> LOCATION = new EnterpriseProjectField<String>("Location");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> TAX_JURISDICTION =
        new EnterpriseProjectField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCurrency</b>
     * </p>
     *
     * @return Custom Project Currency
     */
    @SerializedName( "ProjectCurrency" )
    @JsonProperty( "ProjectCurrency" )
    @Nullable
    @ODataField( odataName = "ProjectCurrency" )
    private String projectCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ProjectCurrency</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> PROJECT_CURRENCY =
        new EnterpriseProjectField<String>("ProjectCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlProfile</b>
     * </p>
     *
     * @return Budget Availability Control: Profile
     */
    @SerializedName( "AvailabilityControlProfile" )
    @JsonProperty( "AvailabilityControlProfile" )
    @Nullable
    @ODataField( odataName = "AvailabilityControlProfile" )
    private String availabilityControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityControlProfile</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> AVAILABILITY_CONTROL_PROFILE =
        new EnterpriseProjectField<String>("AvailabilityControlProfile");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlIsActive</b>
     * </p>
     *
     * @return Availability control indicator(AVC)
     */
    @SerializedName( "AvailabilityControlIsActive" )
    @JsonProperty( "AvailabilityControlIsActive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "AvailabilityControlIsActive" )
    private Boolean availabilityControlIsActive;
    /**
     * Use with available fluent helpers to apply the <b>AvailabilityControlIsActive</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> AVAILABILITY_CONTROL_IS_ACTIVE =
        new EnterpriseProjectField<Boolean>("AvailabilityControlIsActive");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> FUNCTIONAL_LOCATION =
        new EnterpriseProjectField<String>("FunctionalLocation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBillingRelevant</b>
     * </p>
     *
     * @return Indicator: Billing element
     */
    @SerializedName( "IsBillingRelevant" )
    @JsonProperty( "IsBillingRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBillingRelevant" )
    private Boolean isBillingRelevant;
    /**
     * Use with available fluent helpers to apply the <b>IsBillingRelevant</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> IS_BILLING_RELEVANT =
        new EnterpriseProjectField<Boolean>("IsBillingRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile</b>
     * </p>
     *
     * @return Investment Measure Profile
     */
    @SerializedName( "InvestmentProfile" )
    @JsonProperty( "InvestmentProfile" )
    @Nullable
    @ODataField( odataName = "InvestmentProfile" )
    private String investmentProfile;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentProfile</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> INVESTMENT_PROFILE =
        new EnterpriseProjectField<String>("InvestmentProfile");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new EnterpriseProjectField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectLastChangedDateTime</b>
     * </p>
     *
     * @return Timestamp on which project data was changed last
     */
    @SerializedName( "ProjectLastChangedDateTime" )
    @JsonProperty( "ProjectLastChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectLastChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime projectLastChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ProjectLastChangedDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<ZonedDateTime> PROJECT_LAST_CHANGED_DATE_TIME =
        new EnterpriseProjectField<ZonedDateTime>("ProjectLastChangedDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> LAST_CHANGED_BY_USER =
        new EnterpriseProjectField<String>("LastChangedByUser");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjIsMultiSlsOrdItmsEnbld</b>
     * </p>
     *
     * @return Enterprise Project Assigned to Multiple SO Items
     */
    @SerializedName( "EntProjIsMultiSlsOrdItmsEnbld" )
    @JsonProperty( "EntProjIsMultiSlsOrdItmsEnbld" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjIsMultiSlsOrdItmsEnbld" )
    private Boolean entProjIsMultiSlsOrdItmsEnbld;
    /**
     * Use with available fluent helpers to apply the <b>EntProjIsMultiSlsOrdItmsEnbld</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<Boolean> ENT_PROJ_IS_MULTI_SLS_ORD_ITMS_ENBLD =
        new EnterpriseProjectField<Boolean>("EntProjIsMultiSlsOrdItmsEnbld");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @return Costing Sheet
     */
    @SerializedName( "CostingSheet" )
    @JsonProperty( "CostingSheet" )
    @Nullable
    @ODataField( odataName = "CostingSheet" )
    private String costingSheet;
    /**
     * Use with available fluent helpers to apply the <b>CostingSheet</b> field to query operations.
     *
     */
    public final static EnterpriseProjectField<String> COSTING_SHEET =
        new EnterpriseProjectField<String>("CostingSheet");
    /**
     * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EnterpriseProject</b> to multiple
     * <b>EnterpriseProjectElement</b>.
     *
     */
    @SerializedName( "to_EnterpriseProjectElement" )
    @JsonProperty( "to_EnterpriseProjectElement" )
    @ODataField( odataName = "to_EnterpriseProjectElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EnterpriseProjectElement> toEnterpriseProjectElement;
    /**
     * Navigation property <b>to_EnterpriseProjectJVA</b> for <b>EnterpriseProject</b> to single
     * <b>EnterpriseProjectJVA</b>.
     *
     */
    @SerializedName( "to_EnterpriseProjectJVA" )
    @JsonProperty( "to_EnterpriseProjectJVA" )
    @ODataField( odataName = "to_EnterpriseProjectJVA" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProjectJVA toEnterpriseProjectJVA;
    /**
     * Navigation property <b>to_EntProjBlkFunc</b> for <b>EnterpriseProject</b> to single <b>EnterpriseProjBlkFunc</b>.
     *
     */
    @SerializedName( "to_EntProjBlkFunc" )
    @JsonProperty( "to_EntProjBlkFunc" )
    @ODataField( odataName = "to_EntProjBlkFunc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProjBlkFunc toEntProjBlkFunc;
    /**
     * Navigation property <b>to_EntProjectPublicSector</b> for <b>EnterpriseProject</b> to single
     * <b>EntProjectPublicSector</b>.
     *
     */
    @SerializedName( "to_EntProjectPublicSector" )
    @JsonProperty( "to_EntProjectPublicSector" )
    @ODataField( odataName = "to_EntProjectPublicSector" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EntProjectPublicSector toEntProjectPublicSector;
    /**
     * Navigation property <b>to_EntProjRole</b> for <b>EnterpriseProject</b> to multiple <b>EnterpriseProjectRole</b>.
     *
     */
    @SerializedName( "to_EntProjRole" )
    @JsonProperty( "to_EntProjRole" )
    @ODataField( odataName = "to_EntProjRole" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EnterpriseProjectRole> toEntProjRole;
    /**
     * Navigation property <b>to_EntProjTeamMember</b> for <b>EnterpriseProject</b> to multiple
     * <b>EnterpriseProjectTeamMember</b>.
     *
     */
    @SerializedName( "to_EntProjTeamMember" )
    @JsonProperty( "to_EntProjTeamMember" )
    @ODataField( odataName = "to_EntProjTeamMember" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EnterpriseProjectTeamMember> toEntProjTeamMember;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProjectElement</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectLink<EnterpriseProjectElement> TO_ENTERPRISE_PROJECT_ELEMENT =
        new EnterpriseProjectLink<EnterpriseProjectElement>("to_EnterpriseProjectElement");
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProjectJVA</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectOneToOneLink<EnterpriseProjectJVA> TO_ENTERPRISE_PROJECT_JVA =
        new EnterpriseProjectOneToOneLink<EnterpriseProjectJVA>("to_EnterpriseProjectJVA");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjBlkFunc</b> navigation property to query operations.
     *
     */
    public final static EnterpriseProjectOneToOneLink<EnterpriseProjBlkFunc> TO_ENT_PROJ_BLK_FUNC =
        new EnterpriseProjectOneToOneLink<EnterpriseProjBlkFunc>("to_EntProjBlkFunc");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjectPublicSector</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectOneToOneLink<EntProjectPublicSector> TO_ENT_PROJECT_PUBLIC_SECTOR =
        new EnterpriseProjectOneToOneLink<EntProjectPublicSector>("to_EntProjectPublicSector");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjRole</b> navigation property to query operations.
     *
     */
    public final static EnterpriseProjectLink<EnterpriseProjectRole> TO_ENT_PROJ_ROLE =
        new EnterpriseProjectLink<EnterpriseProjectRole>("to_EntProjRole");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjTeamMember</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectLink<EnterpriseProjectTeamMember> TO_ENT_PROJ_TEAM_MEMBER =
        new EnterpriseProjectLink<EnterpriseProjectTeamMember>("to_EntProjTeamMember");

    @Nonnull
    @Override
    public Class<EnterpriseProject> getType()
    {
        return EnterpriseProject.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeEntProjProcgStatus_ac</b>
     * </p>
     *
     * @param changeEntProjProcgStatus_ac
     *            Dyn. Action Control
     */
    public void setChangeEntProjProcgStatus_ac( @Nullable final Boolean changeEntProjProcgStatus_ac )
    {
        rememberChangedField("ChangeEntProjProcgStatus_ac", this.changeEntProjProcgStatus_ac);
        this.changeEntProjProcgStatus_ac = changeEntProjProcgStatus_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ActualEndDate_fc</b>
     * </p>
     *
     * @param actualEndDate_fc
     *            Dyn. Field Control
     */
    public void setActualEndDate_fc( @Nullable final Short actualEndDate_fc )
    {
        rememberChangedField("ActualEndDate_fc", this.actualEndDate_fc);
        this.actualEndDate_fc = actualEndDate_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ActualStartDate_fc</b>
     * </p>
     *
     * @param actualStartDate_fc
     *            Dyn. Field Control
     */
    public void setActualStartDate_fc( @Nullable final Short actualStartDate_fc )
    {
        rememberChangedField("ActualStartDate_fc", this.actualStartDate_fc);
        this.actualStartDate_fc = actualStartDate_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlIsActive_fc</b>
     * </p>
     *
     * @param availabilityControlIsActive_fc
     *            Dyn. Field Control
     */
    public void setAvailabilityControlIsActive_fc( @Nullable final Short availabilityControlIsActive_fc )
    {
        rememberChangedField("AvailabilityControlIsActive_fc", this.availabilityControlIsActive_fc);
        this.availabilityControlIsActive_fc = availabilityControlIsActive_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlProfile_fc</b>
     * </p>
     *
     * @param availabilityControlProfile_fc
     *            Dyn. Field Control
     */
    public void setAvailabilityControlProfile_fc( @Nullable final Short availabilityControlProfile_fc )
    {
        rememberChangedField("AvailabilityControlProfile_fc", this.availabilityControlProfile_fc);
        this.availabilityControlProfile_fc = availabilityControlProfile_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea_fc</b>
     * </p>
     *
     * @param controllingArea_fc
     *            Dyn. Field Control
     */
    public void setControllingArea_fc( @Nullable final Short controllingArea_fc )
    {
        rememberChangedField("ControllingArea_fc", this.controllingArea_fc);
        this.controllingArea_fc = controllingArea_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet_fc</b>
     * </p>
     *
     * @param costingSheet_fc
     *            Dyn. Field Control
     */
    public void setCostingSheet_fc( @Nullable final Short costingSheet_fc )
    {
        rememberChangedField("CostingSheet_fc", this.costingSheet_fc);
        this.costingSheet_fc = costingSheet_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EnterpriseProjectType_fc</b>
     * </p>
     *
     * @param enterpriseProjectType_fc
     *            Dyn. Field Control
     */
    public void setEnterpriseProjectType_fc( @Nullable final Short enterpriseProjectType_fc )
    {
        rememberChangedField("EnterpriseProjectType_fc", this.enterpriseProjectType_fc);
        this.enterpriseProjectType_fc = enterpriseProjectType_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjIsMultiSlsOrdItmsEnbld_fc</b>
     * </p>
     *
     * @param entProjIsMultiSlsOrdItmsEnbld_fc
     *            Dyn. Field Control
     */
    public void setEntProjIsMultiSlsOrdItmsEnbld_fc( @Nullable final Short entProjIsMultiSlsOrdItmsEnbld_fc )
    {
        rememberChangedField("EntProjIsMultiSlsOrdItmsEnbld_fc", this.entProjIsMultiSlsOrdItmsEnbld_fc);
        this.entProjIsMultiSlsOrdItmsEnbld_fc = entProjIsMultiSlsOrdItmsEnbld_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_fc</b>
     * </p>
     *
     * @param functionalArea_fc
     *            Dyn. Field Control
     */
    public void setFunctionalArea_fc( @Nullable final Short functionalArea_fc )
    {
        rememberChangedField("FunctionalArea_fc", this.functionalArea_fc);
        this.functionalArea_fc = functionalArea_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation_fc</b>
     * </p>
     *
     * @param functionalLocation_fc
     *            Dyn. Field Control
     */
    public void setFunctionalLocation_fc( @Nullable final Short functionalLocation_fc )
    {
        rememberChangedField("FunctionalLocation_fc", this.functionalLocation_fc);
        this.functionalLocation_fc = functionalLocation_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile_fc</b>
     * </p>
     *
     * @param investmentProfile_fc
     *            Dyn. Field Control
     */
    public void setInvestmentProfile_fc( @Nullable final Short investmentProfile_fc )
    {
        rememberChangedField("InvestmentProfile_fc", this.investmentProfile_fc);
        this.investmentProfile_fc = investmentProfile_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBillingRelevant_fc</b>
     * </p>
     *
     * @param isBillingRelevant_fc
     *            Dyn. Field Control
     */
    public void setIsBillingRelevant_fc( @Nullable final Short isBillingRelevant_fc )
    {
        rememberChangedField("IsBillingRelevant_fc", this.isBillingRelevant_fc);
        this.isBillingRelevant_fc = isBillingRelevant_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Location_fc</b>
     * </p>
     *
     * @param location_fc
     *            Dyn. Field Control
     */
    public void setLocation_fc( @Nullable final Short location_fc )
    {
        rememberChangedField("Location_fc", this.location_fc);
        this.location_fc = location_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Plant_fc</b>
     * </p>
     *
     * @param plant_fc
     *            Dyn. Field Control
     */
    public void setPlant_fc( @Nullable final Short plant_fc )
    {
        rememberChangedField("Plant_fc", this.plant_fc);
        this.plant_fc = plant_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode_fc</b>
     * </p>
     *
     * @param priorityCode_fc
     *            Dyn. Field Control
     */
    public void setPriorityCode_fc( @Nullable final Short priorityCode_fc )
    {
        rememberChangedField("PriorityCode_fc", this.priorityCode_fc);
        this.priorityCode_fc = priorityCode_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_fc</b>
     * </p>
     *
     * @param profitCenter_fc
     *            Dyn. Field Control
     */
    public void setProfitCenter_fc( @Nullable final Short profitCenter_fc )
    {
        rememberChangedField("ProfitCenter_fc", this.profitCenter_fc);
        this.profitCenter_fc = profitCenter_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Project_fc</b>
     * </p>
     *
     * @param project_fc
     *            Dyn. Field Control
     */
    public void setProject_fc( @Nullable final Short project_fc )
    {
        rememberChangedField("Project_fc", this.project_fc);
        this.project_fc = project_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCurrency_fc</b>
     * </p>
     *
     * @param projectCurrency_fc
     *            Dyn. Field Control
     */
    public void setProjectCurrency_fc( @Nullable final Short projectCurrency_fc )
    {
        rememberChangedField("ProjectCurrency_fc", this.projectCurrency_fc);
        this.projectCurrency_fc = projectCurrency_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDescription_fc</b>
     * </p>
     *
     * @param projectDescription_fc
     *            Dyn. Field Control
     */
    public void setProjectDescription_fc( @Nullable final Short projectDescription_fc )
    {
        rememberChangedField("ProjectDescription_fc", this.projectDescription_fc);
        this.projectDescription_fc = projectDescription_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectEndDate_fc</b>
     * </p>
     *
     * @param projectEndDate_fc
     *            Dyn. Field Control
     */
    public void setProjectEndDate_fc( @Nullable final Short projectEndDate_fc )
    {
        rememberChangedField("ProjectEndDate_fc", this.projectEndDate_fc);
        this.projectEndDate_fc = projectEndDate_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode_fc</b>
     * </p>
     *
     * @param projectProfileCode_fc
     *            Dyn. Field Control
     */
    public void setProjectProfileCode_fc( @Nullable final Short projectProfileCode_fc )
    {
        rememberChangedField("ProjectProfileCode_fc", this.projectProfileCode_fc);
        this.projectProfileCode_fc = projectProfileCode_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStartDate_fc</b>
     * </p>
     *
     * @param projectStartDate_fc
     *            Dyn. Field Control
     */
    public void setProjectStartDate_fc( @Nullable final Short projectStartDate_fc )
    {
        rememberChangedField("ProjectStartDate_fc", this.projectStartDate_fc);
        this.projectStartDate_fc = projectStartDate_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter_fc</b>
     * </p>
     *
     * @param responsibleCostCenter_fc
     *            Dyn. Field Control
     */
    public void setResponsibleCostCenter_fc( @Nullable final Short responsibleCostCenter_fc )
    {
        rememberChangedField("ResponsibleCostCenter_fc", this.responsibleCostCenter_fc);
        this.responsibleCostCenter_fc = responsibleCostCenter_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EnterpriseProjectElement_oc</b>
     * </p>
     *
     * @param enterpriseProjectElement_oc
     *            Dynamic CbA-Control
     */
    public void setEnterpriseProjectElement_oc( @Nullable final Boolean enterpriseProjectElement_oc )
    {
        rememberChangedField("to_EnterpriseProjectElement_oc", this.enterpriseProjectElement_oc);
        this.enterpriseProjectElement_oc = enterpriseProjectElement_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjBlkFunc_oc</b>
     * </p>
     *
     * @param entProjBlkFunc_oc
     *            Dynamic CbA-Control
     */
    public void setEntProjBlkFunc_oc( @Nullable final Boolean entProjBlkFunc_oc )
    {
        rememberChangedField("to_EntProjBlkFunc_oc", this.entProjBlkFunc_oc);
        this.entProjBlkFunc_oc = entProjBlkFunc_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjRole_oc</b>
     * </p>
     *
     * @param entProjRole_oc
     *            Dynamic CbA-Control
     */
    public void setEntProjRole_oc( @Nullable final Boolean entProjRole_oc )
    {
        rememberChangedField("to_EntProjRole_oc", this.entProjRole_oc);
        this.entProjRole_oc = entProjRole_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjTeamMember_oc</b>
     * </p>
     *
     * @param entProjTeamMember_oc
     *            Dynamic CbA-Control
     */
    public void setEntProjTeamMember_oc( @Nullable final Boolean entProjTeamMember_oc )
    {
        rememberChangedField("to_EntProjTeamMember_oc", this.entProjTeamMember_oc);
        this.entProjTeamMember_oc = entProjTeamMember_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjectInternalID</b>
     * </p>
     *
     * @param projectInternalID
     *            Project (internal)
     */
    public void setProjectInternalID( @Nullable final String projectInternalID )
    {
        rememberChangedField("ProjectInternalID", this.projectInternalID);
        this.projectInternalID = projectInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Identification of Entities
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProjectDescription</b>
     * </p>
     *
     * @param projectDescription
     *            Description
     */
    public void setProjectDescription( @Nullable final String projectDescription )
    {
        rememberChangedField("ProjectDescription", this.projectDescription);
        this.projectDescription = projectDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EnterpriseProjectType</b>
     * </p>
     *
     * @param enterpriseProjectType
     *            Project Type
     */
    public void setEnterpriseProjectType( @Nullable final String enterpriseProjectType )
    {
        rememberChangedField("EnterpriseProjectType", this.enterpriseProjectType);
        this.enterpriseProjectType = enterpriseProjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     *
     * @param priorityCode
     *            Priority
     */
    public void setPriorityCode( @Nullable final String priorityCode )
    {
        rememberChangedField("PriorityCode", this.priorityCode);
        this.priorityCode = priorityCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectStartDate</b>
     * </p>
     *
     * @param projectStartDate
     *            Latest Planned Start
     */
    public void setProjectStartDate( @Nullable final LocalDateTime projectStartDate )
    {
        rememberChangedField("ProjectStartDate", this.projectStartDate);
        this.projectStartDate = projectStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectEndDate</b>
     * </p>
     *
     * @param projectEndDate
     *            Latest Planned Finish
     */
    public void setProjectEndDate( @Nullable final LocalDateTime projectEndDate )
    {
        rememberChangedField("ProjectEndDate", this.projectEndDate);
        this.projectEndDate = projectEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualStartDate</b>
     * </p>
     *
     * @param actualStartDate
     *            Actual Start
     */
    public void setActualStartDate( @Nullable final LocalDateTime actualStartDate )
    {
        rememberChangedField("ActualStartDate", this.actualStartDate);
        this.actualStartDate = actualStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualEndDate</b>
     * </p>
     *
     * @param actualEndDate
     *            Actual Finish
     */
    public void setActualEndDate( @Nullable final LocalDateTime actualEndDate )
    {
        rememberChangedField("ActualEndDate", this.actualEndDate);
        this.actualEndDate = actualEndDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustomerUUID</b>
     * </p>
     *
     * @param customerUUID
     *            Business Partner GUID
     */
    public void setCustomerUUID( @Nullable final UUID customerUUID )
    {
        rememberChangedField("CustomerUUID", this.customerUUID);
        this.customerUUID = customerUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>EnterpriseProjectServiceOrg</b>
     * </p>
     *
     * @param enterpriseProjectServiceOrg
     *            Service Organization
     */
    public void setEnterpriseProjectServiceOrg( @Nullable final String enterpriseProjectServiceOrg )
    {
        rememberChangedField("EnterpriseProjectServiceOrg", this.enterpriseProjectServiceOrg);
        this.enterpriseProjectServiceOrg = enterpriseProjectServiceOrg;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjectIsConfidential</b>
     * </p>
     *
     * @param entProjectIsConfidential
     *            Enterprise Project Is Confidential
     */
    public void setEntProjectIsConfidential( @Nullable final Boolean entProjectIsConfidential )
    {
        rememberChangedField("EntProjectIsConfidential", this.entProjectIsConfidential);
        this.entProjectIsConfidential = entProjectIsConfidential;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RestrictedTimePosting</b>
     * </p>
     *
     * @param restrictedTimePosting
     *            Restrict Unstaffed Posting
     */
    public void setRestrictedTimePosting( @Nullable final String restrictedTimePosting )
    {
        rememberChangedField("RestrictedTimePosting", this.restrictedTimePosting);
        this.restrictedTimePosting = restrictedTimePosting;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     *
     * @param processingStatus
     *            Object Processing Status
     */
    public void setProcessingStatus( @Nullable final String processingStatus )
    {
        rememberChangedField("ProcessingStatus", this.processingStatus);
        this.processingStatus = processingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @param responsibleCostCenter
     *            Responsible Cost Center
     */
    public void setResponsibleCostCenter( @Nullable final String responsibleCostCenter )
    {
        rememberChangedField("ResponsibleCostCenter", this.responsibleCostCenter);
        this.responsibleCostCenter = responsibleCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjectProfileCode</b>
     * </p>
     *
     * @param projectProfileCode
     *            Project Profile
     */
    public void setProjectProfileCode( @Nullable final String projectProfileCode )
    {
        rememberChangedField("ProjectProfileCode", this.projectProfileCode);
        this.projectProfileCode = projectProfileCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company code for the project
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling area for the project
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Location</b>
     * </p>
     *
     * @param location
     *            Location
     */
    public void setLocation( @Nullable final String location )
    {
        rememberChangedField("Location", this.location);
        this.location = location;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ProjectCurrency</b>
     * </p>
     *
     * @param projectCurrency
     *            Custom Project Currency
     */
    public void setProjectCurrency( @Nullable final String projectCurrency )
    {
        rememberChangedField("ProjectCurrency", this.projectCurrency);
        this.projectCurrency = projectCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlProfile</b>
     * </p>
     *
     * @param availabilityControlProfile
     *            Budget Availability Control: Profile
     */
    public void setAvailabilityControlProfile( @Nullable final String availabilityControlProfile )
    {
        rememberChangedField("AvailabilityControlProfile", this.availabilityControlProfile);
        this.availabilityControlProfile = availabilityControlProfile;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>AvailabilityControlIsActive</b>
     * </p>
     *
     * @param availabilityControlIsActive
     *            Availability control indicator(AVC)
     */
    public void setAvailabilityControlIsActive( @Nullable final Boolean availabilityControlIsActive )
    {
        rememberChangedField("AvailabilityControlIsActive", this.availabilityControlIsActive);
        this.availabilityControlIsActive = availabilityControlIsActive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional Location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBillingRelevant</b>
     * </p>
     *
     * @param isBillingRelevant
     *            Indicator: Billing element
     */
    public void setIsBillingRelevant( @Nullable final Boolean isBillingRelevant )
    {
        rememberChangedField("IsBillingRelevant", this.isBillingRelevant);
        this.isBillingRelevant = isBillingRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile</b>
     * </p>
     *
     * @param investmentProfile
     *            Investment Measure Profile
     */
    public void setInvestmentProfile( @Nullable final String investmentProfile )
    {
        rememberChangedField("InvestmentProfile", this.investmentProfile);
        this.investmentProfile = investmentProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Timestamp of Last Object Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectLastChangedDateTime</b>
     * </p>
     *
     * @param projectLastChangedDateTime
     *            Timestamp on which project data was changed last
     */
    public void setProjectLastChangedDateTime( @Nullable final ZonedDateTime projectLastChangedDateTime )
    {
        rememberChangedField("ProjectLastChangedDateTime", this.projectLastChangedDateTime);
        this.projectLastChangedDateTime = projectLastChangedDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjIsMultiSlsOrdItmsEnbld</b>
     * </p>
     *
     * @param entProjIsMultiSlsOrdItmsEnbld
     *            Enterprise Project Assigned to Multiple SO Items
     */
    public void setEntProjIsMultiSlsOrdItmsEnbld( @Nullable final Boolean entProjIsMultiSlsOrdItmsEnbld )
    {
        rememberChangedField("EntProjIsMultiSlsOrdItmsEnbld", this.entProjIsMultiSlsOrdItmsEnbld);
        this.entProjIsMultiSlsOrdItmsEnbld = entProjIsMultiSlsOrdItmsEnbld;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @param costingSheet
     *            Costing Sheet
     */
    public void setCostingSheet( @Nullable final String costingSheet )
    {
        rememberChangedField("CostingSheet", this.costingSheet);
        this.costingSheet = costingSheet;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EnterpriseProject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectUUID", getProjectUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ChangeEntProjProcgStatus_ac", getChangeEntProjProcgStatus_ac());
        values.put("ActualEndDate_fc", getActualEndDate_fc());
        values.put("ActualStartDate_fc", getActualStartDate_fc());
        values.put("AvailabilityControlIsActive_fc", getAvailabilityControlIsActive_fc());
        values.put("AvailabilityControlProfile_fc", getAvailabilityControlProfile_fc());
        values.put("ControllingArea_fc", getControllingArea_fc());
        values.put("CostingSheet_fc", getCostingSheet_fc());
        values.put("EnterpriseProjectType_fc", getEnterpriseProjectType_fc());
        values.put("EntProjIsMultiSlsOrdItmsEnbld_fc", getEntProjIsMultiSlsOrdItmsEnbld_fc());
        values.put("FunctionalArea_fc", getFunctionalArea_fc());
        values.put("FunctionalLocation_fc", getFunctionalLocation_fc());
        values.put("InvestmentProfile_fc", getInvestmentProfile_fc());
        values.put("IsBillingRelevant_fc", getIsBillingRelevant_fc());
        values.put("Location_fc", getLocation_fc());
        values.put("Plant_fc", getPlant_fc());
        values.put("PriorityCode_fc", getPriorityCode_fc());
        values.put("ProfitCenter_fc", getProfitCenter_fc());
        values.put("Project_fc", getProject_fc());
        values.put("ProjectCurrency_fc", getProjectCurrency_fc());
        values.put("ProjectDescription_fc", getProjectDescription_fc());
        values.put("ProjectEndDate_fc", getProjectEndDate_fc());
        values.put("ProjectProfileCode_fc", getProjectProfileCode_fc());
        values.put("ProjectStartDate_fc", getProjectStartDate_fc());
        values.put("ResponsibleCostCenter_fc", getResponsibleCostCenter_fc());
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("to_EnterpriseProjectElement_oc", getEnterpriseProjectElement_oc());
        values.put("to_EntProjBlkFunc_oc", getEntProjBlkFunc_oc());
        values.put("to_EntProjRole_oc", getEntProjRole_oc());
        values.put("to_EntProjTeamMember_oc", getEntProjTeamMember_oc());
        values.put("ProjectUUID", getProjectUUID());
        values.put("ProjectInternalID", getProjectInternalID());
        values.put("Project", getProject());
        values.put("ProjectDescription", getProjectDescription());
        values.put("EnterpriseProjectType", getEnterpriseProjectType());
        values.put("PriorityCode", getPriorityCode());
        values.put("ProjectStartDate", getProjectStartDate());
        values.put("ProjectEndDate", getProjectEndDate());
        values.put("ActualStartDate", getActualStartDate());
        values.put("ActualEndDate", getActualEndDate());
        values.put("CustomerUUID", getCustomerUUID());
        values.put("EnterpriseProjectServiceOrg", getEnterpriseProjectServiceOrg());
        values.put("EntProjectIsConfidential", getEntProjectIsConfidential());
        values.put("RestrictedTimePosting", getRestrictedTimePosting());
        values.put("ProcessingStatus", getProcessingStatus());
        values.put("ResponsibleCostCenter", getResponsibleCostCenter());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProjectProfileCode", getProjectProfileCode());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("CompanyCode", getCompanyCode());
        values.put("ControllingArea", getControllingArea());
        values.put("Plant", getPlant());
        values.put("Location", getLocation());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("ProjectCurrency", getProjectCurrency());
        values.put("AvailabilityControlProfile", getAvailabilityControlProfile());
        values.put("AvailabilityControlIsActive", getAvailabilityControlIsActive());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("IsBillingRelevant", getIsBillingRelevant());
        values.put("InvestmentProfile", getInvestmentProfile());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("ProjectLastChangedDateTime", getProjectLastChangedDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("EntProjIsMultiSlsOrdItmsEnbld", getEntProjIsMultiSlsOrdItmsEnbld());
        values.put("CostingSheet", getCostingSheet());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ChangeEntProjProcgStatus_ac") ) {
                final Object value = values.remove("ChangeEntProjProcgStatus_ac");
                if( (value == null) || (!value.equals(getChangeEntProjProcgStatus_ac())) ) {
                    setChangeEntProjProcgStatus_ac(((Boolean) value));
                }
            }
            if( values.containsKey("ActualEndDate_fc") ) {
                final Object value = values.remove("ActualEndDate_fc");
                if( (value == null) || (!value.equals(getActualEndDate_fc())) ) {
                    setActualEndDate_fc(((Short) value));
                }
            }
            if( values.containsKey("ActualStartDate_fc") ) {
                final Object value = values.remove("ActualStartDate_fc");
                if( (value == null) || (!value.equals(getActualStartDate_fc())) ) {
                    setActualStartDate_fc(((Short) value));
                }
            }
            if( values.containsKey("AvailabilityControlIsActive_fc") ) {
                final Object value = values.remove("AvailabilityControlIsActive_fc");
                if( (value == null) || (!value.equals(getAvailabilityControlIsActive_fc())) ) {
                    setAvailabilityControlIsActive_fc(((Short) value));
                }
            }
            if( values.containsKey("AvailabilityControlProfile_fc") ) {
                final Object value = values.remove("AvailabilityControlProfile_fc");
                if( (value == null) || (!value.equals(getAvailabilityControlProfile_fc())) ) {
                    setAvailabilityControlProfile_fc(((Short) value));
                }
            }
            if( values.containsKey("ControllingArea_fc") ) {
                final Object value = values.remove("ControllingArea_fc");
                if( (value == null) || (!value.equals(getControllingArea_fc())) ) {
                    setControllingArea_fc(((Short) value));
                }
            }
            if( values.containsKey("CostingSheet_fc") ) {
                final Object value = values.remove("CostingSheet_fc");
                if( (value == null) || (!value.equals(getCostingSheet_fc())) ) {
                    setCostingSheet_fc(((Short) value));
                }
            }
            if( values.containsKey("EnterpriseProjectType_fc") ) {
                final Object value = values.remove("EnterpriseProjectType_fc");
                if( (value == null) || (!value.equals(getEnterpriseProjectType_fc())) ) {
                    setEnterpriseProjectType_fc(((Short) value));
                }
            }
            if( values.containsKey("EntProjIsMultiSlsOrdItmsEnbld_fc") ) {
                final Object value = values.remove("EntProjIsMultiSlsOrdItmsEnbld_fc");
                if( (value == null) || (!value.equals(getEntProjIsMultiSlsOrdItmsEnbld_fc())) ) {
                    setEntProjIsMultiSlsOrdItmsEnbld_fc(((Short) value));
                }
            }
            if( values.containsKey("FunctionalArea_fc") ) {
                final Object value = values.remove("FunctionalArea_fc");
                if( (value == null) || (!value.equals(getFunctionalArea_fc())) ) {
                    setFunctionalArea_fc(((Short) value));
                }
            }
            if( values.containsKey("FunctionalLocation_fc") ) {
                final Object value = values.remove("FunctionalLocation_fc");
                if( (value == null) || (!value.equals(getFunctionalLocation_fc())) ) {
                    setFunctionalLocation_fc(((Short) value));
                }
            }
            if( values.containsKey("InvestmentProfile_fc") ) {
                final Object value = values.remove("InvestmentProfile_fc");
                if( (value == null) || (!value.equals(getInvestmentProfile_fc())) ) {
                    setInvestmentProfile_fc(((Short) value));
                }
            }
            if( values.containsKey("IsBillingRelevant_fc") ) {
                final Object value = values.remove("IsBillingRelevant_fc");
                if( (value == null) || (!value.equals(getIsBillingRelevant_fc())) ) {
                    setIsBillingRelevant_fc(((Short) value));
                }
            }
            if( values.containsKey("Location_fc") ) {
                final Object value = values.remove("Location_fc");
                if( (value == null) || (!value.equals(getLocation_fc())) ) {
                    setLocation_fc(((Short) value));
                }
            }
            if( values.containsKey("Plant_fc") ) {
                final Object value = values.remove("Plant_fc");
                if( (value == null) || (!value.equals(getPlant_fc())) ) {
                    setPlant_fc(((Short) value));
                }
            }
            if( values.containsKey("PriorityCode_fc") ) {
                final Object value = values.remove("PriorityCode_fc");
                if( (value == null) || (!value.equals(getPriorityCode_fc())) ) {
                    setPriorityCode_fc(((Short) value));
                }
            }
            if( values.containsKey("ProfitCenter_fc") ) {
                final Object value = values.remove("ProfitCenter_fc");
                if( (value == null) || (!value.equals(getProfitCenter_fc())) ) {
                    setProfitCenter_fc(((Short) value));
                }
            }
            if( values.containsKey("Project_fc") ) {
                final Object value = values.remove("Project_fc");
                if( (value == null) || (!value.equals(getProject_fc())) ) {
                    setProject_fc(((Short) value));
                }
            }
            if( values.containsKey("ProjectCurrency_fc") ) {
                final Object value = values.remove("ProjectCurrency_fc");
                if( (value == null) || (!value.equals(getProjectCurrency_fc())) ) {
                    setProjectCurrency_fc(((Short) value));
                }
            }
            if( values.containsKey("ProjectDescription_fc") ) {
                final Object value = values.remove("ProjectDescription_fc");
                if( (value == null) || (!value.equals(getProjectDescription_fc())) ) {
                    setProjectDescription_fc(((Short) value));
                }
            }
            if( values.containsKey("ProjectEndDate_fc") ) {
                final Object value = values.remove("ProjectEndDate_fc");
                if( (value == null) || (!value.equals(getProjectEndDate_fc())) ) {
                    setProjectEndDate_fc(((Short) value));
                }
            }
            if( values.containsKey("ProjectProfileCode_fc") ) {
                final Object value = values.remove("ProjectProfileCode_fc");
                if( (value == null) || (!value.equals(getProjectProfileCode_fc())) ) {
                    setProjectProfileCode_fc(((Short) value));
                }
            }
            if( values.containsKey("ProjectStartDate_fc") ) {
                final Object value = values.remove("ProjectStartDate_fc");
                if( (value == null) || (!value.equals(getProjectStartDate_fc())) ) {
                    setProjectStartDate_fc(((Short) value));
                }
            }
            if( values.containsKey("ResponsibleCostCenter_fc") ) {
                final Object value = values.remove("ResponsibleCostCenter_fc");
                if( (value == null) || (!value.equals(getResponsibleCostCenter_fc())) ) {
                    setResponsibleCostCenter_fc(((Short) value));
                }
            }
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_EnterpriseProjectElement_oc") ) {
                final Object value = values.remove("to_EnterpriseProjectElement_oc");
                if( (value == null) || (!value.equals(getEnterpriseProjectElement_oc())) ) {
                    setEnterpriseProjectElement_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_EntProjBlkFunc_oc") ) {
                final Object value = values.remove("to_EntProjBlkFunc_oc");
                if( (value == null) || (!value.equals(getEntProjBlkFunc_oc())) ) {
                    setEntProjBlkFunc_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_EntProjRole_oc") ) {
                final Object value = values.remove("to_EntProjRole_oc");
                if( (value == null) || (!value.equals(getEntProjRole_oc())) ) {
                    setEntProjRole_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_EntProjTeamMember_oc") ) {
                final Object value = values.remove("to_EntProjTeamMember_oc");
                if( (value == null) || (!value.equals(getEntProjTeamMember_oc())) ) {
                    setEntProjTeamMember_oc(((Boolean) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectInternalID") ) {
                final Object value = values.remove("ProjectInternalID");
                if( (value == null) || (!value.equals(getProjectInternalID())) ) {
                    setProjectInternalID(((String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("ProjectDescription") ) {
                final Object value = values.remove("ProjectDescription");
                if( (value == null) || (!value.equals(getProjectDescription())) ) {
                    setProjectDescription(((String) value));
                }
            }
            if( values.containsKey("EnterpriseProjectType") ) {
                final Object value = values.remove("EnterpriseProjectType");
                if( (value == null) || (!value.equals(getEnterpriseProjectType())) ) {
                    setEnterpriseProjectType(((String) value));
                }
            }
            if( values.containsKey("PriorityCode") ) {
                final Object value = values.remove("PriorityCode");
                if( (value == null) || (!value.equals(getPriorityCode())) ) {
                    setPriorityCode(((String) value));
                }
            }
            if( values.containsKey("ProjectStartDate") ) {
                final Object value = values.remove("ProjectStartDate");
                if( (value == null) || (!value.equals(getProjectStartDate())) ) {
                    setProjectStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProjectEndDate") ) {
                final Object value = values.remove("ProjectEndDate");
                if( (value == null) || (!value.equals(getProjectEndDate())) ) {
                    setProjectEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualStartDate") ) {
                final Object value = values.remove("ActualStartDate");
                if( (value == null) || (!value.equals(getActualStartDate())) ) {
                    setActualStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualEndDate") ) {
                final Object value = values.remove("ActualEndDate");
                if( (value == null) || (!value.equals(getActualEndDate())) ) {
                    setActualEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CustomerUUID") ) {
                final Object value = values.remove("CustomerUUID");
                if( (value == null) || (!value.equals(getCustomerUUID())) ) {
                    setCustomerUUID(((UUID) value));
                }
            }
            if( values.containsKey("EnterpriseProjectServiceOrg") ) {
                final Object value = values.remove("EnterpriseProjectServiceOrg");
                if( (value == null) || (!value.equals(getEnterpriseProjectServiceOrg())) ) {
                    setEnterpriseProjectServiceOrg(((String) value));
                }
            }
            if( values.containsKey("EntProjectIsConfidential") ) {
                final Object value = values.remove("EntProjectIsConfidential");
                if( (value == null) || (!value.equals(getEntProjectIsConfidential())) ) {
                    setEntProjectIsConfidential(((Boolean) value));
                }
            }
            if( values.containsKey("RestrictedTimePosting") ) {
                final Object value = values.remove("RestrictedTimePosting");
                if( (value == null) || (!value.equals(getRestrictedTimePosting())) ) {
                    setRestrictedTimePosting(((String) value));
                }
            }
            if( values.containsKey("ProcessingStatus") ) {
                final Object value = values.remove("ProcessingStatus");
                if( (value == null) || (!value.equals(getProcessingStatus())) ) {
                    setProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("ResponsibleCostCenter") ) {
                final Object value = values.remove("ResponsibleCostCenter");
                if( (value == null) || (!value.equals(getResponsibleCostCenter())) ) {
                    setResponsibleCostCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProjectProfileCode") ) {
                final Object value = values.remove("ProjectProfileCode");
                if( (value == null) || (!value.equals(getProjectProfileCode())) ) {
                    setProjectProfileCode(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Location") ) {
                final Object value = values.remove("Location");
                if( (value == null) || (!value.equals(getLocation())) ) {
                    setLocation(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("ProjectCurrency") ) {
                final Object value = values.remove("ProjectCurrency");
                if( (value == null) || (!value.equals(getProjectCurrency())) ) {
                    setProjectCurrency(((String) value));
                }
            }
            if( values.containsKey("AvailabilityControlProfile") ) {
                final Object value = values.remove("AvailabilityControlProfile");
                if( (value == null) || (!value.equals(getAvailabilityControlProfile())) ) {
                    setAvailabilityControlProfile(((String) value));
                }
            }
            if( values.containsKey("AvailabilityControlIsActive") ) {
                final Object value = values.remove("AvailabilityControlIsActive");
                if( (value == null) || (!value.equals(getAvailabilityControlIsActive())) ) {
                    setAvailabilityControlIsActive(((Boolean) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("IsBillingRelevant") ) {
                final Object value = values.remove("IsBillingRelevant");
                if( (value == null) || (!value.equals(getIsBillingRelevant())) ) {
                    setIsBillingRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("InvestmentProfile") ) {
                final Object value = values.remove("InvestmentProfile");
                if( (value == null) || (!value.equals(getInvestmentProfile())) ) {
                    setInvestmentProfile(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ProjectLastChangedDateTime") ) {
                final Object value = values.remove("ProjectLastChangedDateTime");
                if( (value == null) || (!value.equals(getProjectLastChangedDateTime())) ) {
                    setProjectLastChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("EntProjIsMultiSlsOrdItmsEnbld") ) {
                final Object value = values.remove("EntProjIsMultiSlsOrdItmsEnbld");
                if( (value == null) || (!value.equals(getEntProjIsMultiSlsOrdItmsEnbld())) ) {
                    setEntProjIsMultiSlsOrdItmsEnbld(((Boolean) value));
                }
            }
            if( values.containsKey("CostingSheet") ) {
                final Object value = values.remove("CostingSheet");
                if( (value == null) || (!value.equals(getCostingSheet())) ) {
                    setCostingSheet(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProjectElement") ) {
                final Object value = (values).remove("to_EnterpriseProjectElement");
                if( value instanceof Iterable ) {
                    if( toEnterpriseProjectElement == null ) {
                        toEnterpriseProjectElement = Lists.newArrayList();
                    } else {
                        toEnterpriseProjectElement = Lists.newArrayList(toEnterpriseProjectElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EnterpriseProjectElement entity;
                        if( toEnterpriseProjectElement.size() > i ) {
                            entity = toEnterpriseProjectElement.get(i);
                        } else {
                            entity = new EnterpriseProjectElement();
                            toEnterpriseProjectElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_EnterpriseProjectJVA") ) {
                final Object value = (values).remove("to_EnterpriseProjectJVA");
                if( value instanceof Map ) {
                    if( toEnterpriseProjectJVA == null ) {
                        toEnterpriseProjectJVA = new EnterpriseProjectJVA();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProjectJVA.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EntProjBlkFunc") ) {
                final Object value = (values).remove("to_EntProjBlkFunc");
                if( value instanceof Map ) {
                    if( toEntProjBlkFunc == null ) {
                        toEntProjBlkFunc = new EnterpriseProjBlkFunc();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEntProjBlkFunc.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EntProjectPublicSector") ) {
                final Object value = (values).remove("to_EntProjectPublicSector");
                if( value instanceof Map ) {
                    if( toEntProjectPublicSector == null ) {
                        toEntProjectPublicSector = new EntProjectPublicSector();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEntProjectPublicSector.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EntProjRole") ) {
                final Object value = (values).remove("to_EntProjRole");
                if( value instanceof Iterable ) {
                    if( toEntProjRole == null ) {
                        toEntProjRole = Lists.newArrayList();
                    } else {
                        toEntProjRole = Lists.newArrayList(toEntProjRole);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EnterpriseProjectRole entity;
                        if( toEntProjRole.size() > i ) {
                            entity = toEntProjRole.get(i);
                        } else {
                            entity = new EnterpriseProjectRole();
                            toEntProjRole.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_EntProjTeamMember") ) {
                final Object value = (values).remove("to_EntProjTeamMember");
                if( value instanceof Iterable ) {
                    if( toEntProjTeamMember == null ) {
                        toEntProjTeamMember = Lists.newArrayList();
                    } else {
                        toEntProjTeamMember = Lists.newArrayList(toEntProjTeamMember);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EnterpriseProjectTeamMember entity;
                        if( toEntProjTeamMember.size() > i ) {
                            entity = toEntProjTeamMember.get(i);
                        } else {
                            entity = new EnterpriseProjectTeamMember();
                            toEntProjTeamMember.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EnterpriseProjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EnterpriseProjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EnterpriseProjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EnterpriseProjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProjectElement != null ) {
            (values).put("to_EnterpriseProjectElement", toEnterpriseProjectElement);
        }
        if( toEnterpriseProjectJVA != null ) {
            (values).put("to_EnterpriseProjectJVA", toEnterpriseProjectJVA);
        }
        if( toEntProjBlkFunc != null ) {
            (values).put("to_EntProjBlkFunc", toEntProjBlkFunc);
        }
        if( toEntProjectPublicSector != null ) {
            (values).put("to_EntProjectPublicSector", toEntProjectPublicSector);
        }
        if( toEntProjRole != null ) {
            (values).put("to_EntProjRole", toEntProjRole);
        }
        if( toEntProjTeamMember != null ) {
            (values).put("to_EntProjTeamMember", toEntProjTeamMember);
        }
        return values;
    }

    /**
     * Fetches the <b>EnterpriseProjectElement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EnterpriseProjectElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectElement> fetchEnterpriseProjectElement()
    {
        return fetchFieldAsList("to_EnterpriseProjectElement", EnterpriseProjectElement.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectElement</b> of a queried <b>EnterpriseProject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectElement> getEnterpriseProjectElementOrFetch()
    {
        if( toEnterpriseProjectElement == null ) {
            toEnterpriseProjectElement = fetchEnterpriseProjectElement();
        }
        return toEnterpriseProjectElement;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProjectElement</b> is already loaded, the
     *         result will contain the <b>EnterpriseProjectElement</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EnterpriseProjectElement>> getEnterpriseProjectElementIfPresent()
    {
        return Option.of(toEnterpriseProjectElement);
    }

    /**
     * Overwrites the list of associated <b>EnterpriseProjectElement</b> entities for the loaded navigation property
     * <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectElement</b> of a queried <b>EnterpriseProject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EnterpriseProjectElement</b> entities.
     */
    public void setEnterpriseProjectElement( @Nonnull final List<EnterpriseProjectElement> value )
    {
        if( toEnterpriseProjectElement == null ) {
            toEnterpriseProjectElement = Lists.newArrayList();
        }
        toEnterpriseProjectElement.clear();
        toEnterpriseProjectElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EnterpriseProjectElement</b> entities. This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectElement</b> of a queried <b>EnterpriseProject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EnterpriseProjectElement</b> entities.
     */
    public void addEnterpriseProjectElement( EnterpriseProjectElement... entity )
    {
        if( toEnterpriseProjectElement == null ) {
            toEnterpriseProjectElement = Lists.newArrayList();
        }
        toEnterpriseProjectElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>EnterpriseProjectJVA</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EnterpriseProjectJVA</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProjectJVA</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectJVA fetchEnterpriseProjectJVA()
    {
        return fetchFieldAsSingle("to_EnterpriseProjectJVA", EnterpriseProjectJVA.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectJVA</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProjectJVA</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectJVA</b> of a queried <b>EnterpriseProject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectJVA</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectJVA getEnterpriseProjectJVAOrFetch()
    {
        if( toEnterpriseProjectJVA == null ) {
            toEnterpriseProjectJVA = fetchEnterpriseProjectJVA();
        }
        return toEnterpriseProjectJVA;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectJVA</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProjectJVA</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProjectJVA</b> is already loaded, the result
     *         will contain the <b>EnterpriseProjectJVA</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProjectJVA> getEnterpriseProjectJVAIfPresent()
    {
        return Option.of(toEnterpriseProjectJVA);
    }

    /**
     * Overwrites the associated <b>EnterpriseProjectJVA</b> entity for the loaded navigation property
     * <b>to_EnterpriseProjectJVA</b>.
     *
     * @param value
     *            New <b>EnterpriseProjectJVA</b> entity.
     */
    public void setEnterpriseProjectJVA( final EnterpriseProjectJVA value )
    {
        toEnterpriseProjectJVA = value;
    }

    /**
     * Fetches the <b>EnterpriseProjBlkFunc</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EntProjBlkFunc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProjBlkFunc</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjBlkFunc fetchEntProjBlkFunc()
    {
        return fetchFieldAsSingle("to_EntProjBlkFunc", EnterpriseProjBlkFunc.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjBlkFunc</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjBlkFunc</b>.
     * <p>
     * If the navigation property <b>to_EntProjBlkFunc</b> of a queried <b>EnterpriseProject</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjBlkFunc</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjBlkFunc getEntProjBlkFuncOrFetch()
    {
        if( toEntProjBlkFunc == null ) {
            toEntProjBlkFunc = fetchEntProjBlkFunc();
        }
        return toEntProjBlkFunc;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjBlkFunc</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjBlkFunc</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjBlkFunc</b> is already loaded, the result will
     *         contain the <b>EnterpriseProjBlkFunc</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProjBlkFunc> getEntProjBlkFuncIfPresent()
    {
        return Option.of(toEntProjBlkFunc);
    }

    /**
     * Overwrites the associated <b>EnterpriseProjBlkFunc</b> entity for the loaded navigation property
     * <b>to_EntProjBlkFunc</b>.
     *
     * @param value
     *            New <b>EnterpriseProjBlkFunc</b> entity.
     */
    public void setEntProjBlkFunc( final EnterpriseProjBlkFunc value )
    {
        toEntProjBlkFunc = value;
    }

    /**
     * Fetches the <b>EntProjectPublicSector</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_EntProjectPublicSector</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EntProjectPublicSector</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjectPublicSector fetchEntProjectPublicSector()
    {
        return fetchFieldAsSingle("to_EntProjectPublicSector", EntProjectPublicSector.class);
    }

    /**
     * Retrieval of associated <b>EntProjectPublicSector</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjectPublicSector</b>.
     * <p>
     * If the navigation property <b>to_EntProjectPublicSector</b> of a queried <b>EnterpriseProject</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjectPublicSector</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjectPublicSector getEntProjectPublicSectorOrFetch()
    {
        if( toEntProjectPublicSector == null ) {
            toEntProjectPublicSector = fetchEntProjectPublicSector();
        }
        return toEntProjectPublicSector;
    }

    /**
     * Retrieval of associated <b>EntProjectPublicSector</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjectPublicSector</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjectPublicSector</b> is already loaded, the result
     *         will contain the <b>EntProjectPublicSector</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EntProjectPublicSector> getEntProjectPublicSectorIfPresent()
    {
        return Option.of(toEntProjectPublicSector);
    }

    /**
     * Overwrites the associated <b>EntProjectPublicSector</b> entity for the loaded navigation property
     * <b>to_EntProjectPublicSector</b>.
     *
     * @param value
     *            New <b>EntProjectPublicSector</b> entity.
     */
    public void setEntProjectPublicSector( final EntProjectPublicSector value )
    {
        toEntProjectPublicSector = value;
    }

    /**
     * Fetches the <b>EnterpriseProjectRole</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_EntProjRole</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EnterpriseProjectRole</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectRole> fetchEntProjRole()
    {
        return fetchFieldAsList("to_EntProjRole", EnterpriseProjectRole.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectRole</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjRole</b>.
     * <p>
     * If the navigation property <b>to_EntProjRole</b> of a queried <b>EnterpriseProject</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectRole</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectRole> getEntProjRoleOrFetch()
    {
        if( toEntProjRole == null ) {
            toEntProjRole = fetchEntProjRole();
        }
        return toEntProjRole;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectRole</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjRole</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjRole</b> is already loaded, the result will
     *         contain the <b>EnterpriseProjectRole</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EnterpriseProjectRole>> getEntProjRoleIfPresent()
    {
        return Option.of(toEntProjRole);
    }

    /**
     * Overwrites the list of associated <b>EnterpriseProjectRole</b> entities for the loaded navigation property
     * <b>to_EntProjRole</b>.
     * <p>
     * If the navigation property <b>to_EntProjRole</b> of a queried <b>EnterpriseProject</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EnterpriseProjectRole</b> entities.
     */
    public void setEntProjRole( @Nonnull final List<EnterpriseProjectRole> value )
    {
        if( toEntProjRole == null ) {
            toEntProjRole = Lists.newArrayList();
        }
        toEntProjRole.clear();
        toEntProjRole.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EnterpriseProjectRole</b> entities. This corresponds to the OData
     * navigation property <b>to_EntProjRole</b>.
     * <p>
     * If the navigation property <b>to_EntProjRole</b> of a queried <b>EnterpriseProject</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EnterpriseProjectRole</b> entities.
     */
    public void addEntProjRole( EnterpriseProjectRole... entity )
    {
        if( toEntProjRole == null ) {
            toEntProjRole = Lists.newArrayList();
        }
        toEntProjRole.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>EnterpriseProjectTeamMember</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_EntProjTeamMember</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EnterpriseProjectTeamMember</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectTeamMember> fetchEntProjTeamMember()
    {
        return fetchFieldAsList("to_EntProjTeamMember", EnterpriseProjectTeamMember.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectTeamMember</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjTeamMember</b>.
     * <p>
     * If the navigation property <b>to_EntProjTeamMember</b> of a queried <b>EnterpriseProject</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectTeamMember</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectTeamMember> getEntProjTeamMemberOrFetch()
    {
        if( toEntProjTeamMember == null ) {
            toEntProjTeamMember = fetchEntProjTeamMember();
        }
        return toEntProjTeamMember;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectTeamMember</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjTeamMember</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProject</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjTeamMember</b> is already loaded, the result will
     *         contain the <b>EnterpriseProjectTeamMember</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EnterpriseProjectTeamMember>> getEntProjTeamMemberIfPresent()
    {
        return Option.of(toEntProjTeamMember);
    }

    /**
     * Overwrites the list of associated <b>EnterpriseProjectTeamMember</b> entities for the loaded navigation property
     * <b>to_EntProjTeamMember</b>.
     * <p>
     * If the navigation property <b>to_EntProjTeamMember</b> of a queried <b>EnterpriseProject</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EnterpriseProjectTeamMember</b> entities.
     */
    public void setEntProjTeamMember( @Nonnull final List<EnterpriseProjectTeamMember> value )
    {
        if( toEntProjTeamMember == null ) {
            toEntProjTeamMember = Lists.newArrayList();
        }
        toEntProjTeamMember.clear();
        toEntProjTeamMember.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EnterpriseProjectTeamMember</b> entities. This corresponds to the
     * OData navigation property <b>to_EntProjTeamMember</b>.
     * <p>
     * If the navigation property <b>to_EntProjTeamMember</b> of a queried <b>EnterpriseProject</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EnterpriseProjectTeamMember</b> entities.
     */
    public void addEntProjTeamMember( EnterpriseProjectTeamMember... entity )
    {
        if( toEntProjTeamMember == null ) {
            toEntProjTeamMember = Lists.newArrayList();
        }
        toEntProjTeamMember.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of EnterpriseProject instances.
     *
     */
    public final static class EnterpriseProjectBuilder
    {

        private List<EnterpriseProjectElement> toEnterpriseProjectElement = Lists.newArrayList();
        private EnterpriseProjectJVA toEnterpriseProjectJVA;
        private EnterpriseProjBlkFunc toEntProjBlkFunc;
        private EntProjectPublicSector toEntProjectPublicSector;
        private List<EnterpriseProjectRole> toEntProjRole = Lists.newArrayList();
        private List<EnterpriseProjectTeamMember> toEntProjTeamMember = Lists.newArrayList();

        private EnterpriseProject.EnterpriseProjectBuilder toEnterpriseProjectElement(
            final List<EnterpriseProjectElement> value )
        {
            toEnterpriseProjectElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EnterpriseProject</b> to multiple
         * <b>EnterpriseProjectElement</b>.
         *
         * @param value
         *            The EnterpriseProjectElements to build this EnterpriseProject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProject.EnterpriseProjectBuilder enterpriseProjectElement( EnterpriseProjectElement... value )
        {
            return toEnterpriseProjectElement(Lists.newArrayList(value));
        }

        private EnterpriseProject.EnterpriseProjectBuilder toEnterpriseProjectJVA( final EnterpriseProjectJVA value )
        {
            toEnterpriseProjectJVA = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProjectJVA</b> for <b>EnterpriseProject</b> to single
         * <b>EnterpriseProjectJVA</b>.
         *
         * @param value
         *            The EnterpriseProjectJVA to build this EnterpriseProject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProject.EnterpriseProjectBuilder enterpriseProjectJVA( final EnterpriseProjectJVA value )
        {
            return toEnterpriseProjectJVA(value);
        }

        private EnterpriseProject.EnterpriseProjectBuilder toEntProjBlkFunc( final EnterpriseProjBlkFunc value )
        {
            toEntProjBlkFunc = value;
            return this;
        }

        /**
         * Navigation property <b>to_EntProjBlkFunc</b> for <b>EnterpriseProject</b> to single
         * <b>EnterpriseProjBlkFunc</b>.
         *
         * @param value
         *            The EnterpriseProjBlkFunc to build this EnterpriseProject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProject.EnterpriseProjectBuilder entProjBlkFunc( final EnterpriseProjBlkFunc value )
        {
            return toEntProjBlkFunc(value);
        }

        private EnterpriseProject.EnterpriseProjectBuilder toEntProjectPublicSector(
            final EntProjectPublicSector value )
        {
            toEntProjectPublicSector = value;
            return this;
        }

        /**
         * Navigation property <b>to_EntProjectPublicSector</b> for <b>EnterpriseProject</b> to single
         * <b>EntProjectPublicSector</b>.
         *
         * @param value
         *            The EntProjectPublicSector to build this EnterpriseProject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProject.EnterpriseProjectBuilder entProjectPublicSector( final EntProjectPublicSector value )
        {
            return toEntProjectPublicSector(value);
        }

        private EnterpriseProject.EnterpriseProjectBuilder toEntProjRole( final List<EnterpriseProjectRole> value )
        {
            toEntProjRole.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EntProjRole</b> for <b>EnterpriseProject</b> to multiple
         * <b>EnterpriseProjectRole</b>.
         *
         * @param value
         *            The EnterpriseProjectRoles to build this EnterpriseProject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProject.EnterpriseProjectBuilder entProjRole( EnterpriseProjectRole... value )
        {
            return toEntProjRole(Lists.newArrayList(value));
        }

        private EnterpriseProject.EnterpriseProjectBuilder toEntProjTeamMember(
            final List<EnterpriseProjectTeamMember> value )
        {
            toEntProjTeamMember.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EntProjTeamMember</b> for <b>EnterpriseProject</b> to multiple
         * <b>EnterpriseProjectTeamMember</b>.
         *
         * @param value
         *            The EnterpriseProjectTeamMembers to build this EnterpriseProject with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProject.EnterpriseProjectBuilder entProjTeamMember( EnterpriseProjectTeamMember... value )
        {
            return toEntProjTeamMember(Lists.newArrayList(value));
        }

    }

}
