/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EnterpriseProjectElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EnterpriseProjectElementLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EnterpriseProjectElementOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EnterpriseProjectElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EnterpriseProjectElementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EnterpriseProjectElement extends VdmEntity<EnterpriseProjectElement>
{

    /**
     * Selector for all available fields of EnterpriseProjectElement.
     *
     */
    public final static EnterpriseProjectElementSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeEntProjElmntPosition_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "ChangeEntProjElmntPosition_ac" )
    @JsonProperty( "ChangeEntProjElmntPosition_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ChangeEntProjElmntPosition_ac" )
    private Boolean changeEntProjElmntPosition_ac;
    /**
     * Use with available fluent helpers to apply the <b>ChangeEntProjElmntPosition_ac</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> CHANGE_ENT_PROJ_ELMNT_POSITION_AC =
        new EnterpriseProjectElementField<Boolean>("ChangeEntProjElmntPosition_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeEntProjElmntProcgStatus_ac</b>
     * </p>
     *
     * @return Dyn. Action Control
     */
    @SerializedName( "ChangeEntProjElmntProcgStatus_ac" )
    @JsonProperty( "ChangeEntProjElmntProcgStatus_ac" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ChangeEntProjElmntProcgStatus_ac" )
    private Boolean changeEntProjElmntProcgStatus_ac;
    /**
     * Use with available fluent helpers to apply the <b>ChangeEntProjElmntProcgStatus_ac</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> CHANGE_ENT_PROJ_ELMNT_PROCG_STATUS_AC =
        new EnterpriseProjectElementField<Boolean>("ChangeEntProjElmntProcgStatus_ac");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ActualEndDate_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ActualEndDate_fc" )
    @JsonProperty( "ActualEndDate_fc" )
    @Nullable
    @ODataField( odataName = "ActualEndDate_fc" )
    private Short actualEndDate_fc;
    /**
     * Use with available fluent helpers to apply the <b>ActualEndDate_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> ACTUAL_END_DATE_FC =
        new EnterpriseProjectElementField<Short>("ActualEndDate_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ActualStartDate_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ActualStartDate_fc" )
    @JsonProperty( "ActualStartDate_fc" )
    @Nullable
    @ODataField( odataName = "ActualStartDate_fc" )
    private Short actualStartDate_fc;
    /**
     * Use with available fluent helpers to apply the <b>ActualStartDate_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> ACTUAL_START_DATE_FC =
        new EnterpriseProjectElementField<Short>("ActualStartDate_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ControllingArea_fc" )
    @JsonProperty( "ControllingArea_fc" )
    @Nullable
    @ODataField( odataName = "ControllingArea_fc" )
    private Short controllingArea_fc;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> CONTROLLING_AREA_FC =
        new EnterpriseProjectElementField<Short>("ControllingArea_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "CostingSheet_fc" )
    @JsonProperty( "CostingSheet_fc" )
    @Nullable
    @ODataField( odataName = "CostingSheet_fc" )
    private Short costingSheet_fc;
    /**
     * Use with available fluent helpers to apply the <b>CostingSheet_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> COSTING_SHEET_FC =
        new EnterpriseProjectElementField<Short>("CostingSheet_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "FactoryCalendar_fc" )
    @JsonProperty( "FactoryCalendar_fc" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar_fc" )
    private Short factoryCalendar_fc;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> FACTORY_CALENDAR_FC =
        new EnterpriseProjectElementField<Short>("FactoryCalendar_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "FunctionalArea_fc" )
    @JsonProperty( "FunctionalArea_fc" )
    @Nullable
    @ODataField( odataName = "FunctionalArea_fc" )
    private Short functionalArea_fc;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> FUNCTIONAL_AREA_FC =
        new EnterpriseProjectElementField<Short>("FunctionalArea_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "FunctionalLocation_fc" )
    @JsonProperty( "FunctionalLocation_fc" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation_fc" )
    private Short functionalLocation_fc;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> FUNCTIONAL_LOCATION_FC =
        new EnterpriseProjectElementField<Short>("FunctionalLocation_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Location_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "Location_fc" )
    @JsonProperty( "Location_fc" )
    @Nullable
    @ODataField( odataName = "Location_fc" )
    private Short location_fc;
    /**
     * Use with available fluent helpers to apply the <b>Location_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> LOCATION_FC =
        new EnterpriseProjectElementField<Short>("Location_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedEndDate_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "PlannedEndDate_fc" )
    @JsonProperty( "PlannedEndDate_fc" )
    @Nullable
    @ODataField( odataName = "PlannedEndDate_fc" )
    private Short plannedEndDate_fc;
    /**
     * Use with available fluent helpers to apply the <b>PlannedEndDate_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> PLANNED_END_DATE_FC =
        new EnterpriseProjectElementField<Short>("PlannedEndDate_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartDate_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "PlannedStartDate_fc" )
    @JsonProperty( "PlannedStartDate_fc" )
    @Nullable
    @ODataField( odataName = "PlannedStartDate_fc" )
    private Short plannedStartDate_fc;
    /**
     * Use with available fluent helpers to apply the <b>PlannedStartDate_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> PLANNED_START_DATE_FC =
        new EnterpriseProjectElementField<Short>("PlannedStartDate_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Plant_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "Plant_fc" )
    @JsonProperty( "Plant_fc" )
    @Nullable
    @ODataField( odataName = "Plant_fc" )
    private Short plant_fc;
    /**
     * Use with available fluent helpers to apply the <b>Plant_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> PLANT_FC =
        new EnterpriseProjectElementField<Short>("Plant_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProfitCenter_fc" )
    @JsonProperty( "ProfitCenter_fc" )
    @Nullable
    @ODataField( odataName = "ProfitCenter_fc" )
    private Short profitCenter_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> PROFIT_CENTER_FC =
        new EnterpriseProjectElementField<Short>("ProfitCenter_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElement_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProjectElement_fc" )
    @JsonProperty( "ProjectElement_fc" )
    @Nullable
    @ODataField( odataName = "ProjectElement_fc" )
    private Short projectElement_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElement_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> PROJECT_ELEMENT_FC =
        new EnterpriseProjectElementField<Short>("ProjectElement_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementDescription_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ProjectElementDescription_fc" )
    @JsonProperty( "ProjectElementDescription_fc" )
    @Nullable
    @ODataField( odataName = "ProjectElementDescription_fc" )
    private Short projectElementDescription_fc;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementDescription_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> PROJECT_ELEMENT_DESCRIPTION_FC =
        new EnterpriseProjectElementField<Short>("ProjectElementDescription_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "ResponsibleCostCenter_fc" )
    @JsonProperty( "ResponsibleCostCenter_fc" )
    @Nullable
    @ODataField( odataName = "ResponsibleCostCenter_fc" )
    private Short responsibleCostCenter_fc;
    /**
     * Use with available fluent helpers to apply the <b>ResponsibleCostCenter_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> RESPONSIBLE_COST_CENTER_FC =
        new EnterpriseProjectElementField<Short>("ResponsibleCostCenter_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "TaxJurisdiction_fc" )
    @JsonProperty( "TaxJurisdiction_fc" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction_fc" )
    private Short taxJurisdiction_fc;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> TAX_JURISDICTION_FC =
        new EnterpriseProjectElementField<Short>("TaxJurisdiction_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsBillingElement_fc</b>
     * </p>
     *
     * @return Dyn. Field Control
     */
    @SerializedName( "WBSElementIsBillingElement_fc" )
    @JsonProperty( "WBSElementIsBillingElement_fc" )
    @Nullable
    @ODataField( odataName = "WBSElementIsBillingElement_fc" )
    private Short wBSElementIsBillingElement_fc;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementIsBillingElement_fc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Short> WBS_ELEMENT_IS_BILLING_ELEMENT_FC =
        new EnterpriseProjectElementField<Short>("WBSElementIsBillingElement_fc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> DELETE_MC =
        new EnterpriseProjectElementField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> UPDATE_MC =
        new EnterpriseProjectElementField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjElmntBlkFunc_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_EntProjElmntBlkFunc_oc" )
    @JsonProperty( "to_EntProjElmntBlkFunc_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_EntProjElmntBlkFunc_oc" )
    private Boolean entProjElmntBlkFunc_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjElmntBlkFunc_oc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> ENT_PROJ_ELMNT_BLK_FUNC_OC =
        new EnterpriseProjectElementField<Boolean>("to_EntProjElmntBlkFunc_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjElmntDlvbrl_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_EntProjElmntDlvbrl_oc" )
    @JsonProperty( "to_EntProjElmntDlvbrl_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_EntProjElmntDlvbrl_oc" )
    private Boolean entProjElmntDlvbrl_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjElmntDlvbrl_oc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> ENT_PROJ_ELMNT_DLVBRL_OC =
        new EnterpriseProjectElementField<Boolean>("to_EntProjElmntDlvbrl_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjElmntWorkItem_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_EntProjElmntWorkItem_oc" )
    @JsonProperty( "to_EntProjElmntWorkItem_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_EntProjElmntWorkItem_oc" )
    private Boolean entProjElmntWorkItem_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjElmntWorkItem_oc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> ENT_PROJ_ELMNT_WORK_ITEM_OC =
        new EnterpriseProjectElementField<Boolean>("to_EntProjElmntWorkItem_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_SubProjElement_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_SubProjElement_oc" )
    @JsonProperty( "to_SubProjElement_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_SubProjElement_oc" )
    private Boolean subProjElement_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_SubProjElement_oc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> SUB_PROJ_ELEMENT_OC =
        new EnterpriseProjectElementField<Boolean>("to_SubProjElement_oc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "ProjectElementUUID" )
    @JsonProperty( "ProjectElementUUID" )
    @Nullable
    @ODataField( odataName = "ProjectElementUUID" )
    private UUID projectElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<UUID> PROJECT_ELEMENT_UUID =
        new EnterpriseProjectElementField<UUID>("ProjectElementUUID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElement</b>
     * </p>
     *
     * @return Identification of Entities
     */
    @SerializedName( "ProjectElement" )
    @JsonProperty( "ProjectElement" )
    @Nullable
    @ODataField( odataName = "ProjectElement" )
    private String projectElement;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElement</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> PROJECT_ELEMENT =
        new EnterpriseProjectElementField<String>("ProjectElement");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> WBS_ELEMENT_INTERNAL_ID =
        new EnterpriseProjectElementField<String>("WBSElementInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<UUID> PROJECT_UUID =
        new EnterpriseProjectElementField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementDescription</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "ProjectElementDescription" )
    @JsonProperty( "ProjectElementDescription" )
    @Nullable
    @ODataField( odataName = "ProjectElementDescription" )
    private String projectElementDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementDescription</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> PROJECT_ELEMENT_DESCRIPTION =
        new EnterpriseProjectElementField<String>("ProjectElementDescription");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ParentObjectUUID</b>
     * </p>
     *
     * @return Parent Entity Guid
     */
    @SerializedName( "ParentObjectUUID" )
    @JsonProperty( "ParentObjectUUID" )
    @Nullable
    @ODataField( odataName = "ParentObjectUUID" )
    private UUID parentObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ParentObjectUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<UUID> PARENT_OBJECT_UUID =
        new EnterpriseProjectElementField<UUID>("ParentObjectUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementOrdinalNumber</b>
     * </p>
     *
     * @return Sortnumber
     */
    @SerializedName( "ProjectElementOrdinalNumber" )
    @JsonProperty( "ProjectElementOrdinalNumber" )
    @Nullable
    @ODataField( odataName = "ProjectElementOrdinalNumber" )
    private Integer projectElementOrdinalNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementOrdinalNumber</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Integer> PROJECT_ELEMENT_ORDINAL_NUMBER =
        new EnterpriseProjectElementField<Integer>("ProjectElementOrdinalNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     *
     * @return Object Processing Status
     */
    @SerializedName( "ProcessingStatus" )
    @JsonProperty( "ProcessingStatus" )
    @Nullable
    @ODataField( odataName = "ProcessingStatus" )
    private String processingStatus;
    /**
     * Use with available fluent helpers to apply the <b>ProcessingStatus</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> PROCESSING_STATUS =
        new EnterpriseProjectElementField<String>("ProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>EntProjectElementType</b>
     * </p>
     *
     * @return Task Type
     */
    @SerializedName( "EntProjectElementType" )
    @JsonProperty( "EntProjectElementType" )
    @Nullable
    @ODataField( odataName = "EntProjectElementType" )
    private String entProjectElementType;
    /**
     * Use with available fluent helpers to apply the <b>EntProjectElementType</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> ENT_PROJECT_ELEMENT_TYPE =
        new EnterpriseProjectElementField<String>("EntProjectElementType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartDate</b>
     * </p>
     *
     * @return Latest Planned Start
     */
    @SerializedName( "PlannedStartDate" )
    @JsonProperty( "PlannedStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plannedStartDate;
    /**
     * Use with available fluent helpers to apply the <b>PlannedStartDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<LocalDateTime> PLANNED_START_DATE =
        new EnterpriseProjectElementField<LocalDateTime>("PlannedStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedEndDate</b>
     * </p>
     *
     * @return Latest Planned Finish
     */
    @SerializedName( "PlannedEndDate" )
    @JsonProperty( "PlannedEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PlannedEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime plannedEndDate;
    /**
     * Use with available fluent helpers to apply the <b>PlannedEndDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<LocalDateTime> PLANNED_END_DATE =
        new EnterpriseProjectElementField<LocalDateTime>("PlannedEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualStartDate</b>
     * </p>
     *
     * @return Actual Start
     */
    @SerializedName( "ActualStartDate" )
    @JsonProperty( "ActualStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actualStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ActualStartDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<LocalDateTime> ACTUAL_START_DATE =
        new EnterpriseProjectElementField<LocalDateTime>("ActualStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualEndDate</b>
     * </p>
     *
     * @return Actual Finish
     */
    @SerializedName( "ActualEndDate" )
    @JsonProperty( "ActualEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actualEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ActualEndDate</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<LocalDateTime> ACTUAL_END_DATE =
        new EnterpriseProjectElementField<LocalDateTime>("ActualEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @return Responsible Cost Center
     */
    @SerializedName( "ResponsibleCostCenter" )
    @JsonProperty( "ResponsibleCostCenter" )
    @Nullable
    @ODataField( odataName = "ResponsibleCostCenter" )
    private String responsibleCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>ResponsibleCostCenter</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> RESPONSIBLE_COST_CENTER =
        new EnterpriseProjectElementField<String>("ResponsibleCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company code for WBS element
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> COMPANY_CODE =
        new EnterpriseProjectElementField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> PROFIT_CENTER =
        new EnterpriseProjectElementField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> FUNCTIONAL_AREA =
        new EnterpriseProjectElementField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling area for WBS element
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> CONTROLLING_AREA =
        new EnterpriseProjectElementField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> PLANT =
        new EnterpriseProjectElementField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Location</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "Location" )
    @JsonProperty( "Location" )
    @Nullable
    @ODataField( odataName = "Location" )
    private String location;
    /**
     * Use with available fluent helpers to apply the <b>Location</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> LOCATION =
        new EnterpriseProjectElementField<String>("Location");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> TAX_JURISDICTION =
        new EnterpriseProjectElementField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> FUNCTIONAL_LOCATION =
        new EnterpriseProjectElementField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Factory calendar key
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> FACTORY_CALENDAR =
        new EnterpriseProjectElementField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @return Costing Sheet
     */
    @SerializedName( "CostingSheet" )
    @JsonProperty( "CostingSheet" )
    @Nullable
    @ODataField( odataName = "CostingSheet" )
    private String costingSheet;
    /**
     * Use with available fluent helpers to apply the <b>CostingSheet</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> COSTING_SHEET =
        new EnterpriseProjectElementField<String>("CostingSheet");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile</b>
     * </p>
     *
     * @return Investment Measure Profile
     */
    @SerializedName( "InvestmentProfile" )
    @JsonProperty( "InvestmentProfile" )
    @Nullable
    @ODataField( odataName = "InvestmentProfile" )
    private String investmentProfile;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentProfile</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> INVESTMENT_PROFILE =
        new EnterpriseProjectElementField<String>("InvestmentProfile");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsStatisticalWBSElement</b>
     * </p>
     *
     * @return Statistical WBS element
     */
    @SerializedName( "WBSIsStatisticalWBSElement" )
    @JsonProperty( "WBSIsStatisticalWBSElement" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSIsStatisticalWBSElement" )
    private Boolean wBSIsStatisticalWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSIsStatisticalWBSElement</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> WBS_IS_STATISTICAL_WBS_ELEMENT =
        new EnterpriseProjectElementField<Boolean>("WBSIsStatisticalWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost center to which costs are actually posted
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> COST_CENTER =
        new EnterpriseProjectElementField<String>("CostCenter");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsBillingElement</b>
     * </p>
     *
     * @return Indicator: Billing element
     */
    @SerializedName( "WBSElementIsBillingElement" )
    @JsonProperty( "WBSElementIsBillingElement" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSElementIsBillingElement" )
    private Boolean wBSElementIsBillingElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementIsBillingElement</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<Boolean> WBS_ELEMENT_IS_BILLING_ELEMENT =
        new EnterpriseProjectElementField<Boolean>("WBSElementIsBillingElement");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Who Created Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> CREATED_BY_USER =
        new EnterpriseProjectElementField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Timestamp of Object Creation
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<ZonedDateTime> CREATION_DATE_TIME =
        new EnterpriseProjectElementField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new EnterpriseProjectElementField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static EnterpriseProjectElementField<String> LAST_CHANGED_BY_USER =
        new EnterpriseProjectElementField<String>("LastChangedByUser");
    /**
     * Navigation property <b>to_EntProjectElementJVA</b> for <b>EnterpriseProjectElement</b> to single
     * <b>EntProjectElementJVA</b>.
     *
     */
    @SerializedName( "to_EntProjectElementJVA" )
    @JsonProperty( "to_EntProjectElementJVA" )
    @ODataField( odataName = "to_EntProjectElementJVA" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EntProjectElementJVA toEntProjectElementJVA;
    /**
     * Navigation property <b>to_EntProjectElmntPublicSector</b> for <b>EnterpriseProjectElement</b> to single
     * <b>EntProjectElmntPublicSector</b>.
     *
     */
    @SerializedName( "to_EntProjectElmntPublicSector" )
    @JsonProperty( "to_EntProjectElmntPublicSector" )
    @ODataField( odataName = "to_EntProjectElmntPublicSector" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EntProjectElmntPublicSector toEntProjectElmntPublicSector;
    /**
     * Navigation property <b>to_EntProjElmntBlkFunc</b> for <b>EnterpriseProjectElement</b> to single
     * <b>EntProjElmntBlockFunc</b>.
     *
     */
    @SerializedName( "to_EntProjElmntBlkFunc" )
    @JsonProperty( "to_EntProjElmntBlkFunc" )
    @ODataField( odataName = "to_EntProjElmntBlkFunc" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EntProjElmntBlockFunc toEntProjElmntBlkFunc;
    /**
     * Navigation property <b>to_EntProjElmntDlvbrl</b> for <b>EnterpriseProjectElement</b> to multiple
     * <b>EntProjElmntDlvbrl</b>.
     *
     */
    @SerializedName( "to_EntProjElmntDlvbrl" )
    @JsonProperty( "to_EntProjElmntDlvbrl" )
    @ODataField( odataName = "to_EntProjElmntDlvbrl" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EntProjElmntDlvbrl> toEntProjElmntDlvbrl;
    /**
     * Navigation property <b>to_EntProjElmntWorkItem</b> for <b>EnterpriseProjectElement</b> to multiple
     * <b>EntProjElmntWorkItem</b>.
     *
     */
    @SerializedName( "to_EntProjElmntWorkItem" )
    @JsonProperty( "to_EntProjElmntWorkItem" )
    @ODataField( odataName = "to_EntProjElmntWorkItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EntProjElmntWorkItem> toEntProjElmntWorkItem;
    /**
     * Navigation property <b>to_ParentProjElement</b> for <b>EnterpriseProjectElement</b> to single
     * <b>EnterpriseProjectElement</b>.
     *
     */
    @SerializedName( "to_ParentProjElement" )
    @JsonProperty( "to_ParentProjElement" )
    @ODataField( odataName = "to_ParentProjElement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProjectElement toParentProjElement;
    /**
     * Navigation property <b>to_SubProjElement</b> for <b>EnterpriseProjectElement</b> to multiple
     * <b>EnterpriseProjectElement</b>.
     *
     */
    @SerializedName( "to_SubProjElement" )
    @JsonProperty( "to_SubProjElement" )
    @ODataField( odataName = "to_SubProjElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EnterpriseProjectElement> toSubProjElement;
    /**
     * Navigation property <b>to_EnterpriseProject</b> for <b>EnterpriseProjectElement</b> to single
     * <b>EnterpriseProject</b>.
     *
     */
    @SerializedName( "to_EnterpriseProject" )
    @JsonProperty( "to_EnterpriseProject" )
    @ODataField( odataName = "to_EnterpriseProject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProject toEnterpriseProject;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjectElementJVA</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementOneToOneLink<EntProjectElementJVA> TO_ENT_PROJECT_ELEMENT_JVA =
        new EnterpriseProjectElementOneToOneLink<EntProjectElementJVA>("to_EntProjectElementJVA");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjectElmntPublicSector</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementOneToOneLink<EntProjectElmntPublicSector> TO_ENT_PROJECT_ELMNT_PUBLIC_SECTOR =
        new EnterpriseProjectElementOneToOneLink<EntProjectElmntPublicSector>("to_EntProjectElmntPublicSector");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjElmntBlkFunc</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementOneToOneLink<EntProjElmntBlockFunc> TO_ENT_PROJ_ELMNT_BLK_FUNC =
        new EnterpriseProjectElementOneToOneLink<EntProjElmntBlockFunc>("to_EntProjElmntBlkFunc");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjElmntDlvbrl</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementLink<EntProjElmntDlvbrl> TO_ENT_PROJ_ELMNT_DLVBRL =
        new EnterpriseProjectElementLink<EntProjElmntDlvbrl>("to_EntProjElmntDlvbrl");
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjElmntWorkItem</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementLink<EntProjElmntWorkItem> TO_ENT_PROJ_ELMNT_WORK_ITEM =
        new EnterpriseProjectElementLink<EntProjElmntWorkItem>("to_EntProjElmntWorkItem");
    /**
     * Use with available fluent helpers to apply the <b>to_ParentProjElement</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementOneToOneLink<EnterpriseProjectElement> TO_PARENT_PROJ_ELEMENT =
        new EnterpriseProjectElementOneToOneLink<EnterpriseProjectElement>("to_ParentProjElement");
    /**
     * Use with available fluent helpers to apply the <b>to_SubProjElement</b> navigation property to query operations.
     *
     */
    public final static EnterpriseProjectElementLink<EnterpriseProjectElement> TO_SUB_PROJ_ELEMENT =
        new EnterpriseProjectElementLink<EnterpriseProjectElement>("to_SubProjElement");
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProject</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectElementOneToOneLink<EnterpriseProject> TO_ENTERPRISE_PROJECT =
        new EnterpriseProjectElementOneToOneLink<EnterpriseProject>("to_EnterpriseProject");

    @Nonnull
    @Override
    public Class<EnterpriseProjectElement> getType()
    {
        return EnterpriseProjectElement.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeEntProjElmntPosition_ac</b>
     * </p>
     *
     * @param changeEntProjElmntPosition_ac
     *            Dyn. Action Control
     */
    public void setChangeEntProjElmntPosition_ac( @Nullable final Boolean changeEntProjElmntPosition_ac )
    {
        rememberChangedField("ChangeEntProjElmntPosition_ac", this.changeEntProjElmntPosition_ac);
        this.changeEntProjElmntPosition_ac = changeEntProjElmntPosition_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ChangeEntProjElmntProcgStatus_ac</b>
     * </p>
     *
     * @param changeEntProjElmntProcgStatus_ac
     *            Dyn. Action Control
     */
    public void setChangeEntProjElmntProcgStatus_ac( @Nullable final Boolean changeEntProjElmntProcgStatus_ac )
    {
        rememberChangedField("ChangeEntProjElmntProcgStatus_ac", this.changeEntProjElmntProcgStatus_ac);
        this.changeEntProjElmntProcgStatus_ac = changeEntProjElmntProcgStatus_ac;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ActualEndDate_fc</b>
     * </p>
     *
     * @param actualEndDate_fc
     *            Dyn. Field Control
     */
    public void setActualEndDate_fc( @Nullable final Short actualEndDate_fc )
    {
        rememberChangedField("ActualEndDate_fc", this.actualEndDate_fc);
        this.actualEndDate_fc = actualEndDate_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ActualStartDate_fc</b>
     * </p>
     *
     * @param actualStartDate_fc
     *            Dyn. Field Control
     */
    public void setActualStartDate_fc( @Nullable final Short actualStartDate_fc )
    {
        rememberChangedField("ActualStartDate_fc", this.actualStartDate_fc);
        this.actualStartDate_fc = actualStartDate_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea_fc</b>
     * </p>
     *
     * @param controllingArea_fc
     *            Dyn. Field Control
     */
    public void setControllingArea_fc( @Nullable final Short controllingArea_fc )
    {
        rememberChangedField("ControllingArea_fc", this.controllingArea_fc);
        this.controllingArea_fc = controllingArea_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet_fc</b>
     * </p>
     *
     * @param costingSheet_fc
     *            Dyn. Field Control
     */
    public void setCostingSheet_fc( @Nullable final Short costingSheet_fc )
    {
        rememberChangedField("CostingSheet_fc", this.costingSheet_fc);
        this.costingSheet_fc = costingSheet_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar_fc</b>
     * </p>
     *
     * @param factoryCalendar_fc
     *            Dyn. Field Control
     */
    public void setFactoryCalendar_fc( @Nullable final Short factoryCalendar_fc )
    {
        rememberChangedField("FactoryCalendar_fc", this.factoryCalendar_fc);
        this.factoryCalendar_fc = factoryCalendar_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea_fc</b>
     * </p>
     *
     * @param functionalArea_fc
     *            Dyn. Field Control
     */
    public void setFunctionalArea_fc( @Nullable final Short functionalArea_fc )
    {
        rememberChangedField("FunctionalArea_fc", this.functionalArea_fc);
        this.functionalArea_fc = functionalArea_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation_fc</b>
     * </p>
     *
     * @param functionalLocation_fc
     *            Dyn. Field Control
     */
    public void setFunctionalLocation_fc( @Nullable final Short functionalLocation_fc )
    {
        rememberChangedField("FunctionalLocation_fc", this.functionalLocation_fc);
        this.functionalLocation_fc = functionalLocation_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Location_fc</b>
     * </p>
     *
     * @param location_fc
     *            Dyn. Field Control
     */
    public void setLocation_fc( @Nullable final Short location_fc )
    {
        rememberChangedField("Location_fc", this.location_fc);
        this.location_fc = location_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedEndDate_fc</b>
     * </p>
     *
     * @param plannedEndDate_fc
     *            Dyn. Field Control
     */
    public void setPlannedEndDate_fc( @Nullable final Short plannedEndDate_fc )
    {
        rememberChangedField("PlannedEndDate_fc", this.plannedEndDate_fc);
        this.plannedEndDate_fc = plannedEndDate_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartDate_fc</b>
     * </p>
     *
     * @param plannedStartDate_fc
     *            Dyn. Field Control
     */
    public void setPlannedStartDate_fc( @Nullable final Short plannedStartDate_fc )
    {
        rememberChangedField("PlannedStartDate_fc", this.plannedStartDate_fc);
        this.plannedStartDate_fc = plannedStartDate_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Plant_fc</b>
     * </p>
     *
     * @param plant_fc
     *            Dyn. Field Control
     */
    public void setPlant_fc( @Nullable final Short plant_fc )
    {
        rememberChangedField("Plant_fc", this.plant_fc);
        this.plant_fc = plant_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_fc</b>
     * </p>
     *
     * @param profitCenter_fc
     *            Dyn. Field Control
     */
    public void setProfitCenter_fc( @Nullable final Short profitCenter_fc )
    {
        rememberChangedField("ProfitCenter_fc", this.profitCenter_fc);
        this.profitCenter_fc = profitCenter_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElement_fc</b>
     * </p>
     *
     * @param projectElement_fc
     *            Dyn. Field Control
     */
    public void setProjectElement_fc( @Nullable final Short projectElement_fc )
    {
        rememberChangedField("ProjectElement_fc", this.projectElement_fc);
        this.projectElement_fc = projectElement_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementDescription_fc</b>
     * </p>
     *
     * @param projectElementDescription_fc
     *            Dyn. Field Control
     */
    public void setProjectElementDescription_fc( @Nullable final Short projectElementDescription_fc )
    {
        rememberChangedField("ProjectElementDescription_fc", this.projectElementDescription_fc);
        this.projectElementDescription_fc = projectElementDescription_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter_fc</b>
     * </p>
     *
     * @param responsibleCostCenter_fc
     *            Dyn. Field Control
     */
    public void setResponsibleCostCenter_fc( @Nullable final Short responsibleCostCenter_fc )
    {
        rememberChangedField("ResponsibleCostCenter_fc", this.responsibleCostCenter_fc);
        this.responsibleCostCenter_fc = responsibleCostCenter_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction_fc</b>
     * </p>
     *
     * @param taxJurisdiction_fc
     *            Dyn. Field Control
     */
    public void setTaxJurisdiction_fc( @Nullable final Short taxJurisdiction_fc )
    {
        rememberChangedField("TaxJurisdiction_fc", this.taxJurisdiction_fc);
        this.taxJurisdiction_fc = taxJurisdiction_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsBillingElement_fc</b>
     * </p>
     *
     * @param wBSElementIsBillingElement_fc
     *            Dyn. Field Control
     */
    public void setWBSElementIsBillingElement_fc( @Nullable final Short wBSElementIsBillingElement_fc )
    {
        rememberChangedField("WBSElementIsBillingElement_fc", this.wBSElementIsBillingElement_fc);
        this.wBSElementIsBillingElement_fc = wBSElementIsBillingElement_fc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjElmntBlkFunc_oc</b>
     * </p>
     *
     * @param entProjElmntBlkFunc_oc
     *            Dynamic CbA-Control
     */
    public void setEntProjElmntBlkFunc_oc( @Nullable final Boolean entProjElmntBlkFunc_oc )
    {
        rememberChangedField("to_EntProjElmntBlkFunc_oc", this.entProjElmntBlkFunc_oc);
        this.entProjElmntBlkFunc_oc = entProjElmntBlkFunc_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjElmntDlvbrl_oc</b>
     * </p>
     *
     * @param entProjElmntDlvbrl_oc
     *            Dynamic CbA-Control
     */
    public void setEntProjElmntDlvbrl_oc( @Nullable final Boolean entProjElmntDlvbrl_oc )
    {
        rememberChangedField("to_EntProjElmntDlvbrl_oc", this.entProjElmntDlvbrl_oc);
        this.entProjElmntDlvbrl_oc = entProjElmntDlvbrl_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjElmntWorkItem_oc</b>
     * </p>
     *
     * @param entProjElmntWorkItem_oc
     *            Dynamic CbA-Control
     */
    public void setEntProjElmntWorkItem_oc( @Nullable final Boolean entProjElmntWorkItem_oc )
    {
        rememberChangedField("to_EntProjElmntWorkItem_oc", this.entProjElmntWorkItem_oc);
        this.entProjElmntWorkItem_oc = entProjElmntWorkItem_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_SubProjElement_oc</b>
     * </p>
     *
     * @param subProjElement_oc
     *            Dynamic CbA-Control
     */
    public void setSubProjElement_oc( @Nullable final Boolean subProjElement_oc )
    {
        rememberChangedField("to_SubProjElement_oc", this.subProjElement_oc);
        this.subProjElement_oc = subProjElement_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @param projectElementUUID
     *            Entity Guid
     */
    public void setProjectElementUUID( @Nullable final UUID projectElementUUID )
    {
        rememberChangedField("ProjectElementUUID", this.projectElementUUID);
        this.projectElementUUID = projectElementUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElement</b>
     * </p>
     *
     * @param projectElement
     *            Identification of Entities
     */
    public void setProjectElement( @Nullable final String projectElement )
    {
        rememberChangedField("ProjectElement", this.projectElement);
        this.projectElement = projectElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementDescription</b>
     * </p>
     *
     * @param projectElementDescription
     *            Description
     */
    public void setProjectElementDescription( @Nullable final String projectElementDescription )
    {
        rememberChangedField("ProjectElementDescription", this.projectElementDescription);
        this.projectElementDescription = projectElementDescription;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ParentObjectUUID</b>
     * </p>
     *
     * @param parentObjectUUID
     *            Parent Entity Guid
     */
    public void setParentObjectUUID( @Nullable final UUID parentObjectUUID )
    {
        rememberChangedField("ParentObjectUUID", this.parentObjectUUID);
        this.parentObjectUUID = parentObjectUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementOrdinalNumber</b>
     * </p>
     *
     * @param projectElementOrdinalNumber
     *            Sortnumber
     */
    public void setProjectElementOrdinalNumber( @Nullable final Integer projectElementOrdinalNumber )
    {
        rememberChangedField("ProjectElementOrdinalNumber", this.projectElementOrdinalNumber);
        this.projectElementOrdinalNumber = projectElementOrdinalNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessingStatus</b>
     * </p>
     *
     * @param processingStatus
     *            Object Processing Status
     */
    public void setProcessingStatus( @Nullable final String processingStatus )
    {
        rememberChangedField("ProcessingStatus", this.processingStatus);
        this.processingStatus = processingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>EntProjectElementType</b>
     * </p>
     *
     * @param entProjectElementType
     *            Task Type
     */
    public void setEntProjectElementType( @Nullable final String entProjectElementType )
    {
        rememberChangedField("EntProjectElementType", this.entProjectElementType);
        this.entProjectElementType = entProjectElementType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedStartDate</b>
     * </p>
     *
     * @param plannedStartDate
     *            Latest Planned Start
     */
    public void setPlannedStartDate( @Nullable final LocalDateTime plannedStartDate )
    {
        rememberChangedField("PlannedStartDate", this.plannedStartDate);
        this.plannedStartDate = plannedStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PlannedEndDate</b>
     * </p>
     *
     * @param plannedEndDate
     *            Latest Planned Finish
     */
    public void setPlannedEndDate( @Nullable final LocalDateTime plannedEndDate )
    {
        rememberChangedField("PlannedEndDate", this.plannedEndDate);
        this.plannedEndDate = plannedEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualStartDate</b>
     * </p>
     *
     * @param actualStartDate
     *            Actual Start
     */
    public void setActualStartDate( @Nullable final LocalDateTime actualStartDate )
    {
        rememberChangedField("ActualStartDate", this.actualStartDate);
        this.actualStartDate = actualStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualEndDate</b>
     * </p>
     *
     * @param actualEndDate
     *            Actual Finish
     */
    public void setActualEndDate( @Nullable final LocalDateTime actualEndDate )
    {
        rememberChangedField("ActualEndDate", this.actualEndDate);
        this.actualEndDate = actualEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @param responsibleCostCenter
     *            Responsible Cost Center
     */
    public void setResponsibleCostCenter( @Nullable final String responsibleCostCenter )
    {
        rememberChangedField("ResponsibleCostCenter", this.responsibleCostCenter);
        this.responsibleCostCenter = responsibleCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company code for WBS element
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling area for WBS element
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Location</b>
     * </p>
     *
     * @param location
     *            Location
     */
    public void setLocation( @Nullable final String location )
    {
        rememberChangedField("Location", this.location);
        this.location = location;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional Location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Factory calendar key
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @param costingSheet
     *            Costing Sheet
     */
    public void setCostingSheet( @Nullable final String costingSheet )
    {
        rememberChangedField("CostingSheet", this.costingSheet);
        this.costingSheet = costingSheet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile</b>
     * </p>
     *
     * @param investmentProfile
     *            Investment Measure Profile
     */
    public void setInvestmentProfile( @Nullable final String investmentProfile )
    {
        rememberChangedField("InvestmentProfile", this.investmentProfile);
        this.investmentProfile = investmentProfile;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsStatisticalWBSElement</b>
     * </p>
     *
     * @param wBSIsStatisticalWBSElement
     *            Statistical WBS element
     */
    public void setWBSIsStatisticalWBSElement( @Nullable final Boolean wBSIsStatisticalWBSElement )
    {
        rememberChangedField("WBSIsStatisticalWBSElement", this.wBSIsStatisticalWBSElement);
        this.wBSIsStatisticalWBSElement = wBSIsStatisticalWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost center to which costs are actually posted
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsBillingElement</b>
     * </p>
     *
     * @param wBSElementIsBillingElement
     *            Indicator: Billing element
     */
    public void setWBSElementIsBillingElement( @Nullable final Boolean wBSElementIsBillingElement )
    {
        rememberChangedField("WBSElementIsBillingElement", this.wBSElementIsBillingElement);
        this.wBSElementIsBillingElement = wBSElementIsBillingElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Who Created Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Timestamp of Object Creation
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Timestamp of Last Object Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EnterpriseProjectElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectElementUUID", getProjectElementUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ChangeEntProjElmntPosition_ac", getChangeEntProjElmntPosition_ac());
        values.put("ChangeEntProjElmntProcgStatus_ac", getChangeEntProjElmntProcgStatus_ac());
        values.put("ActualEndDate_fc", getActualEndDate_fc());
        values.put("ActualStartDate_fc", getActualStartDate_fc());
        values.put("ControllingArea_fc", getControllingArea_fc());
        values.put("CostingSheet_fc", getCostingSheet_fc());
        values.put("FactoryCalendar_fc", getFactoryCalendar_fc());
        values.put("FunctionalArea_fc", getFunctionalArea_fc());
        values.put("FunctionalLocation_fc", getFunctionalLocation_fc());
        values.put("Location_fc", getLocation_fc());
        values.put("PlannedEndDate_fc", getPlannedEndDate_fc());
        values.put("PlannedStartDate_fc", getPlannedStartDate_fc());
        values.put("Plant_fc", getPlant_fc());
        values.put("ProfitCenter_fc", getProfitCenter_fc());
        values.put("ProjectElement_fc", getProjectElement_fc());
        values.put("ProjectElementDescription_fc", getProjectElementDescription_fc());
        values.put("ResponsibleCostCenter_fc", getResponsibleCostCenter_fc());
        values.put("TaxJurisdiction_fc", getTaxJurisdiction_fc());
        values.put("WBSElementIsBillingElement_fc", getWBSElementIsBillingElement_fc());
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("to_EntProjElmntBlkFunc_oc", getEntProjElmntBlkFunc_oc());
        values.put("to_EntProjElmntDlvbrl_oc", getEntProjElmntDlvbrl_oc());
        values.put("to_EntProjElmntWorkItem_oc", getEntProjElmntWorkItem_oc());
        values.put("to_SubProjElement_oc", getSubProjElement_oc());
        values.put("ProjectElementUUID", getProjectElementUUID());
        values.put("ProjectElement", getProjectElement());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("ProjectUUID", getProjectUUID());
        values.put("ProjectElementDescription", getProjectElementDescription());
        values.put("ParentObjectUUID", getParentObjectUUID());
        values.put("ProjectElementOrdinalNumber", getProjectElementOrdinalNumber());
        values.put("ProcessingStatus", getProcessingStatus());
        values.put("EntProjectElementType", getEntProjectElementType());
        values.put("PlannedStartDate", getPlannedStartDate());
        values.put("PlannedEndDate", getPlannedEndDate());
        values.put("ActualStartDate", getActualStartDate());
        values.put("ActualEndDate", getActualEndDate());
        values.put("ResponsibleCostCenter", getResponsibleCostCenter());
        values.put("CompanyCode", getCompanyCode());
        values.put("ProfitCenter", getProfitCenter());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("ControllingArea", getControllingArea());
        values.put("Plant", getPlant());
        values.put("Location", getLocation());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("CostingSheet", getCostingSheet());
        values.put("InvestmentProfile", getInvestmentProfile());
        values.put("WBSIsStatisticalWBSElement", getWBSIsStatisticalWBSElement());
        values.put("CostCenter", getCostCenter());
        values.put("WBSElementIsBillingElement", getWBSElementIsBillingElement());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ChangeEntProjElmntPosition_ac") ) {
                final Object value = values.remove("ChangeEntProjElmntPosition_ac");
                if( (value == null) || (!value.equals(getChangeEntProjElmntPosition_ac())) ) {
                    setChangeEntProjElmntPosition_ac(((Boolean) value));
                }
            }
            if( values.containsKey("ChangeEntProjElmntProcgStatus_ac") ) {
                final Object value = values.remove("ChangeEntProjElmntProcgStatus_ac");
                if( (value == null) || (!value.equals(getChangeEntProjElmntProcgStatus_ac())) ) {
                    setChangeEntProjElmntProcgStatus_ac(((Boolean) value));
                }
            }
            if( values.containsKey("ActualEndDate_fc") ) {
                final Object value = values.remove("ActualEndDate_fc");
                if( (value == null) || (!value.equals(getActualEndDate_fc())) ) {
                    setActualEndDate_fc(((Short) value));
                }
            }
            if( values.containsKey("ActualStartDate_fc") ) {
                final Object value = values.remove("ActualStartDate_fc");
                if( (value == null) || (!value.equals(getActualStartDate_fc())) ) {
                    setActualStartDate_fc(((Short) value));
                }
            }
            if( values.containsKey("ControllingArea_fc") ) {
                final Object value = values.remove("ControllingArea_fc");
                if( (value == null) || (!value.equals(getControllingArea_fc())) ) {
                    setControllingArea_fc(((Short) value));
                }
            }
            if( values.containsKey("CostingSheet_fc") ) {
                final Object value = values.remove("CostingSheet_fc");
                if( (value == null) || (!value.equals(getCostingSheet_fc())) ) {
                    setCostingSheet_fc(((Short) value));
                }
            }
            if( values.containsKey("FactoryCalendar_fc") ) {
                final Object value = values.remove("FactoryCalendar_fc");
                if( (value == null) || (!value.equals(getFactoryCalendar_fc())) ) {
                    setFactoryCalendar_fc(((Short) value));
                }
            }
            if( values.containsKey("FunctionalArea_fc") ) {
                final Object value = values.remove("FunctionalArea_fc");
                if( (value == null) || (!value.equals(getFunctionalArea_fc())) ) {
                    setFunctionalArea_fc(((Short) value));
                }
            }
            if( values.containsKey("FunctionalLocation_fc") ) {
                final Object value = values.remove("FunctionalLocation_fc");
                if( (value == null) || (!value.equals(getFunctionalLocation_fc())) ) {
                    setFunctionalLocation_fc(((Short) value));
                }
            }
            if( values.containsKey("Location_fc") ) {
                final Object value = values.remove("Location_fc");
                if( (value == null) || (!value.equals(getLocation_fc())) ) {
                    setLocation_fc(((Short) value));
                }
            }
            if( values.containsKey("PlannedEndDate_fc") ) {
                final Object value = values.remove("PlannedEndDate_fc");
                if( (value == null) || (!value.equals(getPlannedEndDate_fc())) ) {
                    setPlannedEndDate_fc(((Short) value));
                }
            }
            if( values.containsKey("PlannedStartDate_fc") ) {
                final Object value = values.remove("PlannedStartDate_fc");
                if( (value == null) || (!value.equals(getPlannedStartDate_fc())) ) {
                    setPlannedStartDate_fc(((Short) value));
                }
            }
            if( values.containsKey("Plant_fc") ) {
                final Object value = values.remove("Plant_fc");
                if( (value == null) || (!value.equals(getPlant_fc())) ) {
                    setPlant_fc(((Short) value));
                }
            }
            if( values.containsKey("ProfitCenter_fc") ) {
                final Object value = values.remove("ProfitCenter_fc");
                if( (value == null) || (!value.equals(getProfitCenter_fc())) ) {
                    setProfitCenter_fc(((Short) value));
                }
            }
            if( values.containsKey("ProjectElement_fc") ) {
                final Object value = values.remove("ProjectElement_fc");
                if( (value == null) || (!value.equals(getProjectElement_fc())) ) {
                    setProjectElement_fc(((Short) value));
                }
            }
            if( values.containsKey("ProjectElementDescription_fc") ) {
                final Object value = values.remove("ProjectElementDescription_fc");
                if( (value == null) || (!value.equals(getProjectElementDescription_fc())) ) {
                    setProjectElementDescription_fc(((Short) value));
                }
            }
            if( values.containsKey("ResponsibleCostCenter_fc") ) {
                final Object value = values.remove("ResponsibleCostCenter_fc");
                if( (value == null) || (!value.equals(getResponsibleCostCenter_fc())) ) {
                    setResponsibleCostCenter_fc(((Short) value));
                }
            }
            if( values.containsKey("TaxJurisdiction_fc") ) {
                final Object value = values.remove("TaxJurisdiction_fc");
                if( (value == null) || (!value.equals(getTaxJurisdiction_fc())) ) {
                    setTaxJurisdiction_fc(((Short) value));
                }
            }
            if( values.containsKey("WBSElementIsBillingElement_fc") ) {
                final Object value = values.remove("WBSElementIsBillingElement_fc");
                if( (value == null) || (!value.equals(getWBSElementIsBillingElement_fc())) ) {
                    setWBSElementIsBillingElement_fc(((Short) value));
                }
            }
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_EntProjElmntBlkFunc_oc") ) {
                final Object value = values.remove("to_EntProjElmntBlkFunc_oc");
                if( (value == null) || (!value.equals(getEntProjElmntBlkFunc_oc())) ) {
                    setEntProjElmntBlkFunc_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_EntProjElmntDlvbrl_oc") ) {
                final Object value = values.remove("to_EntProjElmntDlvbrl_oc");
                if( (value == null) || (!value.equals(getEntProjElmntDlvbrl_oc())) ) {
                    setEntProjElmntDlvbrl_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_EntProjElmntWorkItem_oc") ) {
                final Object value = values.remove("to_EntProjElmntWorkItem_oc");
                if( (value == null) || (!value.equals(getEntProjElmntWorkItem_oc())) ) {
                    setEntProjElmntWorkItem_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_SubProjElement_oc") ) {
                final Object value = values.remove("to_SubProjElement_oc");
                if( (value == null) || (!value.equals(getSubProjElement_oc())) ) {
                    setSubProjElement_oc(((Boolean) value));
                }
            }
            if( values.containsKey("ProjectElementUUID") ) {
                final Object value = values.remove("ProjectElementUUID");
                if( (value == null) || (!value.equals(getProjectElementUUID())) ) {
                    setProjectElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectElement") ) {
                final Object value = values.remove("ProjectElement");
                if( (value == null) || (!value.equals(getProjectElement())) ) {
                    setProjectElement(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectElementDescription") ) {
                final Object value = values.remove("ProjectElementDescription");
                if( (value == null) || (!value.equals(getProjectElementDescription())) ) {
                    setProjectElementDescription(((String) value));
                }
            }
            if( values.containsKey("ParentObjectUUID") ) {
                final Object value = values.remove("ParentObjectUUID");
                if( (value == null) || (!value.equals(getParentObjectUUID())) ) {
                    setParentObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectElementOrdinalNumber") ) {
                final Object value = values.remove("ProjectElementOrdinalNumber");
                if( (value == null) || (!value.equals(getProjectElementOrdinalNumber())) ) {
                    setProjectElementOrdinalNumber(((Integer) value));
                }
            }
            if( values.containsKey("ProcessingStatus") ) {
                final Object value = values.remove("ProcessingStatus");
                if( (value == null) || (!value.equals(getProcessingStatus())) ) {
                    setProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("EntProjectElementType") ) {
                final Object value = values.remove("EntProjectElementType");
                if( (value == null) || (!value.equals(getEntProjectElementType())) ) {
                    setEntProjectElementType(((String) value));
                }
            }
            if( values.containsKey("PlannedStartDate") ) {
                final Object value = values.remove("PlannedStartDate");
                if( (value == null) || (!value.equals(getPlannedStartDate())) ) {
                    setPlannedStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PlannedEndDate") ) {
                final Object value = values.remove("PlannedEndDate");
                if( (value == null) || (!value.equals(getPlannedEndDate())) ) {
                    setPlannedEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualStartDate") ) {
                final Object value = values.remove("ActualStartDate");
                if( (value == null) || (!value.equals(getActualStartDate())) ) {
                    setActualStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualEndDate") ) {
                final Object value = values.remove("ActualEndDate");
                if( (value == null) || (!value.equals(getActualEndDate())) ) {
                    setActualEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ResponsibleCostCenter") ) {
                final Object value = values.remove("ResponsibleCostCenter");
                if( (value == null) || (!value.equals(getResponsibleCostCenter())) ) {
                    setResponsibleCostCenter(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Location") ) {
                final Object value = values.remove("Location");
                if( (value == null) || (!value.equals(getLocation())) ) {
                    setLocation(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("CostingSheet") ) {
                final Object value = values.remove("CostingSheet");
                if( (value == null) || (!value.equals(getCostingSheet())) ) {
                    setCostingSheet(((String) value));
                }
            }
            if( values.containsKey("InvestmentProfile") ) {
                final Object value = values.remove("InvestmentProfile");
                if( (value == null) || (!value.equals(getInvestmentProfile())) ) {
                    setInvestmentProfile(((String) value));
                }
            }
            if( values.containsKey("WBSIsStatisticalWBSElement") ) {
                final Object value = values.remove("WBSIsStatisticalWBSElement");
                if( (value == null) || (!value.equals(getWBSIsStatisticalWBSElement())) ) {
                    setWBSIsStatisticalWBSElement(((Boolean) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("WBSElementIsBillingElement") ) {
                final Object value = values.remove("WBSElementIsBillingElement");
                if( (value == null) || (!value.equals(getWBSElementIsBillingElement())) ) {
                    setWBSElementIsBillingElement(((Boolean) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EntProjectElementJVA") ) {
                final Object value = (values).remove("to_EntProjectElementJVA");
                if( value instanceof Map ) {
                    if( toEntProjectElementJVA == null ) {
                        toEntProjectElementJVA = new EntProjectElementJVA();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEntProjectElementJVA.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EntProjectElmntPublicSector") ) {
                final Object value = (values).remove("to_EntProjectElmntPublicSector");
                if( value instanceof Map ) {
                    if( toEntProjectElmntPublicSector == null ) {
                        toEntProjectElmntPublicSector = new EntProjectElmntPublicSector();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEntProjectElmntPublicSector.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EntProjElmntBlkFunc") ) {
                final Object value = (values).remove("to_EntProjElmntBlkFunc");
                if( value instanceof Map ) {
                    if( toEntProjElmntBlkFunc == null ) {
                        toEntProjElmntBlkFunc = new EntProjElmntBlockFunc();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEntProjElmntBlkFunc.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_EntProjElmntDlvbrl") ) {
                final Object value = (values).remove("to_EntProjElmntDlvbrl");
                if( value instanceof Iterable ) {
                    if( toEntProjElmntDlvbrl == null ) {
                        toEntProjElmntDlvbrl = Lists.newArrayList();
                    } else {
                        toEntProjElmntDlvbrl = Lists.newArrayList(toEntProjElmntDlvbrl);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EntProjElmntDlvbrl entity;
                        if( toEntProjElmntDlvbrl.size() > i ) {
                            entity = toEntProjElmntDlvbrl.get(i);
                        } else {
                            entity = new EntProjElmntDlvbrl();
                            toEntProjElmntDlvbrl.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_EntProjElmntWorkItem") ) {
                final Object value = (values).remove("to_EntProjElmntWorkItem");
                if( value instanceof Iterable ) {
                    if( toEntProjElmntWorkItem == null ) {
                        toEntProjElmntWorkItem = Lists.newArrayList();
                    } else {
                        toEntProjElmntWorkItem = Lists.newArrayList(toEntProjElmntWorkItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EntProjElmntWorkItem entity;
                        if( toEntProjElmntWorkItem.size() > i ) {
                            entity = toEntProjElmntWorkItem.get(i);
                        } else {
                            entity = new EntProjElmntWorkItem();
                            toEntProjElmntWorkItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ParentProjElement") ) {
                final Object value = (values).remove("to_ParentProjElement");
                if( value instanceof Map ) {
                    if( toParentProjElement == null ) {
                        toParentProjElement = new EnterpriseProjectElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toParentProjElement.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SubProjElement") ) {
                final Object value = (values).remove("to_SubProjElement");
                if( value instanceof Iterable ) {
                    if( toSubProjElement == null ) {
                        toSubProjElement = Lists.newArrayList();
                    } else {
                        toSubProjElement = Lists.newArrayList(toSubProjElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EnterpriseProjectElement entity;
                        if( toSubProjElement.size() > i ) {
                            entity = toSubProjElement.get(i);
                        } else {
                            entity = new EnterpriseProjectElement();
                            toSubProjElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_EnterpriseProject") ) {
                final Object value = (values).remove("to_EnterpriseProject");
                if( value instanceof Map ) {
                    if( toEnterpriseProject == null ) {
                        toEnterpriseProject = new EnterpriseProject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProject.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EnterpriseProjectElementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EnterpriseProjectElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EnterpriseProjectElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EnterpriseProjectElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEntProjectElementJVA != null ) {
            (values).put("to_EntProjectElementJVA", toEntProjectElementJVA);
        }
        if( toEntProjectElmntPublicSector != null ) {
            (values).put("to_EntProjectElmntPublicSector", toEntProjectElmntPublicSector);
        }
        if( toEntProjElmntBlkFunc != null ) {
            (values).put("to_EntProjElmntBlkFunc", toEntProjElmntBlkFunc);
        }
        if( toEntProjElmntDlvbrl != null ) {
            (values).put("to_EntProjElmntDlvbrl", toEntProjElmntDlvbrl);
        }
        if( toEntProjElmntWorkItem != null ) {
            (values).put("to_EntProjElmntWorkItem", toEntProjElmntWorkItem);
        }
        if( toParentProjElement != null ) {
            (values).put("to_ParentProjElement", toParentProjElement);
        }
        if( toSubProjElement != null ) {
            (values).put("to_SubProjElement", toSubProjElement);
        }
        if( toEnterpriseProject != null ) {
            (values).put("to_EnterpriseProject", toEnterpriseProject);
        }
        return values;
    }

    /**
     * Fetches the <b>EntProjectElementJVA</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EntProjectElementJVA</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EntProjectElementJVA</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjectElementJVA fetchEntProjectElementJVA()
    {
        return fetchFieldAsSingle("to_EntProjectElementJVA", EntProjectElementJVA.class);
    }

    /**
     * Retrieval of associated <b>EntProjectElementJVA</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EntProjectElementJVA</b>.
     * <p>
     * If the navigation property <b>to_EntProjectElementJVA</b> of a queried <b>EnterpriseProjectElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjectElementJVA</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjectElementJVA getEntProjectElementJVAOrFetch()
    {
        if( toEntProjectElementJVA == null ) {
            toEntProjectElementJVA = fetchEntProjectElementJVA();
        }
        return toEntProjectElementJVA;
    }

    /**
     * Retrieval of associated <b>EntProjectElementJVA</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EntProjectElementJVA</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjectElementJVA</b> is already loaded, the result
     *         will contain the <b>EntProjectElementJVA</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EntProjectElementJVA> getEntProjectElementJVAIfPresent()
    {
        return Option.of(toEntProjectElementJVA);
    }

    /**
     * Overwrites the associated <b>EntProjectElementJVA</b> entity for the loaded navigation property
     * <b>to_EntProjectElementJVA</b>.
     *
     * @param value
     *            New <b>EntProjectElementJVA</b> entity.
     */
    public void setEntProjectElementJVA( final EntProjectElementJVA value )
    {
        toEntProjectElementJVA = value;
    }

    /**
     * Fetches the <b>EntProjectElmntPublicSector</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_EntProjectElmntPublicSector</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EntProjectElmntPublicSector</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjectElmntPublicSector fetchEntProjectElmntPublicSector()
    {
        return fetchFieldAsSingle("to_EntProjectElmntPublicSector", EntProjectElmntPublicSector.class);
    }

    /**
     * Retrieval of associated <b>EntProjectElmntPublicSector</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjectElmntPublicSector</b>.
     * <p>
     * If the navigation property <b>to_EntProjectElmntPublicSector</b> of a queried <b>EnterpriseProjectElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjectElmntPublicSector</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjectElmntPublicSector getEntProjectElmntPublicSectorOrFetch()
    {
        if( toEntProjectElmntPublicSector == null ) {
            toEntProjectElmntPublicSector = fetchEntProjectElmntPublicSector();
        }
        return toEntProjectElmntPublicSector;
    }

    /**
     * Retrieval of associated <b>EntProjectElmntPublicSector</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjectElmntPublicSector</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjectElmntPublicSector</b> is already loaded, the
     *         result will contain the <b>EntProjectElmntPublicSector</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EntProjectElmntPublicSector> getEntProjectElmntPublicSectorIfPresent()
    {
        return Option.of(toEntProjectElmntPublicSector);
    }

    /**
     * Overwrites the associated <b>EntProjectElmntPublicSector</b> entity for the loaded navigation property
     * <b>to_EntProjectElmntPublicSector</b>.
     *
     * @param value
     *            New <b>EntProjectElmntPublicSector</b> entity.
     */
    public void setEntProjectElmntPublicSector( final EntProjectElmntPublicSector value )
    {
        toEntProjectElmntPublicSector = value;
    }

    /**
     * Fetches the <b>EntProjElmntBlockFunc</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EntProjElmntBlkFunc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EntProjElmntBlockFunc</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjElmntBlockFunc fetchEntProjElmntBlkFunc()
    {
        return fetchFieldAsSingle("to_EntProjElmntBlkFunc", EntProjElmntBlockFunc.class);
    }

    /**
     * Retrieval of associated <b>EntProjElmntBlockFunc</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjElmntBlkFunc</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntBlkFunc</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjElmntBlockFunc</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EntProjElmntBlockFunc getEntProjElmntBlkFuncOrFetch()
    {
        if( toEntProjElmntBlkFunc == null ) {
            toEntProjElmntBlkFunc = fetchEntProjElmntBlkFunc();
        }
        return toEntProjElmntBlkFunc;
    }

    /**
     * Retrieval of associated <b>EntProjElmntBlockFunc</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EntProjElmntBlkFunc</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjElmntBlkFunc</b> is already loaded, the result
     *         will contain the <b>EntProjElmntBlockFunc</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EntProjElmntBlockFunc> getEntProjElmntBlkFuncIfPresent()
    {
        return Option.of(toEntProjElmntBlkFunc);
    }

    /**
     * Overwrites the associated <b>EntProjElmntBlockFunc</b> entity for the loaded navigation property
     * <b>to_EntProjElmntBlkFunc</b>.
     *
     * @param value
     *            New <b>EntProjElmntBlockFunc</b> entity.
     */
    public void setEntProjElmntBlkFunc( final EntProjElmntBlockFunc value )
    {
        toEntProjElmntBlkFunc = value;
    }

    /**
     * Fetches the <b>EntProjElmntDlvbrl</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EntProjElmntDlvbrl</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EntProjElmntDlvbrl</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EntProjElmntDlvbrl> fetchEntProjElmntDlvbrl()
    {
        return fetchFieldAsList("to_EntProjElmntDlvbrl", EntProjElmntDlvbrl.class);
    }

    /**
     * Retrieval of associated <b>EntProjElmntDlvbrl</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjElmntDlvbrl</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntDlvbrl</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjElmntDlvbrl</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EntProjElmntDlvbrl> getEntProjElmntDlvbrlOrFetch()
    {
        if( toEntProjElmntDlvbrl == null ) {
            toEntProjElmntDlvbrl = fetchEntProjElmntDlvbrl();
        }
        return toEntProjElmntDlvbrl;
    }

    /**
     * Retrieval of associated <b>EntProjElmntDlvbrl</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjElmntDlvbrl</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjElmntDlvbrl</b> is already loaded, the result
     *         will contain the <b>EntProjElmntDlvbrl</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EntProjElmntDlvbrl>> getEntProjElmntDlvbrlIfPresent()
    {
        return Option.of(toEntProjElmntDlvbrl);
    }

    /**
     * Overwrites the list of associated <b>EntProjElmntDlvbrl</b> entities for the loaded navigation property
     * <b>to_EntProjElmntDlvbrl</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntDlvbrl</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EntProjElmntDlvbrl</b> entities.
     */
    public void setEntProjElmntDlvbrl( @Nonnull final List<EntProjElmntDlvbrl> value )
    {
        if( toEntProjElmntDlvbrl == null ) {
            toEntProjElmntDlvbrl = Lists.newArrayList();
        }
        toEntProjElmntDlvbrl.clear();
        toEntProjElmntDlvbrl.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EntProjElmntDlvbrl</b> entities. This corresponds to the OData
     * navigation property <b>to_EntProjElmntDlvbrl</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntDlvbrl</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EntProjElmntDlvbrl</b> entities.
     */
    public void addEntProjElmntDlvbrl( EntProjElmntDlvbrl... entity )
    {
        if( toEntProjElmntDlvbrl == null ) {
            toEntProjElmntDlvbrl = Lists.newArrayList();
        }
        toEntProjElmntDlvbrl.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>EntProjElmntWorkItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_EntProjElmntWorkItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EntProjElmntWorkItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EntProjElmntWorkItem> fetchEntProjElmntWorkItem()
    {
        return fetchFieldAsList("to_EntProjElmntWorkItem", EntProjElmntWorkItem.class);
    }

    /**
     * Retrieval of associated <b>EntProjElmntWorkItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjElmntWorkItem</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntWorkItem</b> of a queried <b>EnterpriseProjectElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntProjElmntWorkItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EntProjElmntWorkItem> getEntProjElmntWorkItemOrFetch()
    {
        if( toEntProjElmntWorkItem == null ) {
            toEntProjElmntWorkItem = fetchEntProjElmntWorkItem();
        }
        return toEntProjElmntWorkItem;
    }

    /**
     * Retrieval of associated <b>EntProjElmntWorkItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjElmntWorkItem</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjElmntWorkItem</b> is already loaded, the result
     *         will contain the <b>EntProjElmntWorkItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EntProjElmntWorkItem>> getEntProjElmntWorkItemIfPresent()
    {
        return Option.of(toEntProjElmntWorkItem);
    }

    /**
     * Overwrites the list of associated <b>EntProjElmntWorkItem</b> entities for the loaded navigation property
     * <b>to_EntProjElmntWorkItem</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntWorkItem</b> of a queried <b>EnterpriseProjectElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EntProjElmntWorkItem</b> entities.
     */
    public void setEntProjElmntWorkItem( @Nonnull final List<EntProjElmntWorkItem> value )
    {
        if( toEntProjElmntWorkItem == null ) {
            toEntProjElmntWorkItem = Lists.newArrayList();
        }
        toEntProjElmntWorkItem.clear();
        toEntProjElmntWorkItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EntProjElmntWorkItem</b> entities. This corresponds to the OData
     * navigation property <b>to_EntProjElmntWorkItem</b>.
     * <p>
     * If the navigation property <b>to_EntProjElmntWorkItem</b> of a queried <b>EnterpriseProjectElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EntProjElmntWorkItem</b> entities.
     */
    public void addEntProjElmntWorkItem( EntProjElmntWorkItem... entity )
    {
        if( toEntProjElmntWorkItem == null ) {
            toEntProjElmntWorkItem = Lists.newArrayList();
        }
        toEntProjElmntWorkItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>EnterpriseProjectElement</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ParentProjElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProjectElement</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement fetchParentProjElement()
    {
        return fetchFieldAsSingle("to_ParentProjElement", EnterpriseProjectElement.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ParentProjElement</b>.
     * <p>
     * If the navigation property <b>to_ParentProjElement</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement getParentProjElementOrFetch()
    {
        if( toParentProjElement == null ) {
            toParentProjElement = fetchParentProjElement();
        }
        return toParentProjElement;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ParentProjElement</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ParentProjElement</b> is already loaded, the result will
     *         contain the <b>EnterpriseProjectElement</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProjectElement> getParentProjElementIfPresent()
    {
        return Option.of(toParentProjElement);
    }

    /**
     * Overwrites the associated <b>EnterpriseProjectElement</b> entity for the loaded navigation property
     * <b>to_ParentProjElement</b>.
     *
     * @param value
     *            New <b>EnterpriseProjectElement</b> entity.
     */
    public void setParentProjElement( final EnterpriseProjectElement value )
    {
        toParentProjElement = value;
    }

    /**
     * Fetches the <b>EnterpriseProjectElement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SubProjElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EnterpriseProjectElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectElement> fetchSubProjElement()
    {
        return fetchFieldAsList("to_SubProjElement", EnterpriseProjectElement.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubProjElement</b>.
     * <p>
     * If the navigation property <b>to_SubProjElement</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EnterpriseProjectElement> getSubProjElementOrFetch()
    {
        if( toSubProjElement == null ) {
            toSubProjElement = fetchSubProjElement();
        }
        return toSubProjElement;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubProjElement</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubProjElement</b> is already loaded, the result will
     *         contain the <b>EnterpriseProjectElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EnterpriseProjectElement>> getSubProjElementIfPresent()
    {
        return Option.of(toSubProjElement);
    }

    /**
     * Overwrites the list of associated <b>EnterpriseProjectElement</b> entities for the loaded navigation property
     * <b>to_SubProjElement</b>.
     * <p>
     * If the navigation property <b>to_SubProjElement</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EnterpriseProjectElement</b> entities.
     */
    public void setSubProjElement( @Nonnull final List<EnterpriseProjectElement> value )
    {
        if( toSubProjElement == null ) {
            toSubProjElement = Lists.newArrayList();
        }
        toSubProjElement.clear();
        toSubProjElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EnterpriseProjectElement</b> entities. This corresponds to the OData
     * navigation property <b>to_SubProjElement</b>.
     * <p>
     * If the navigation property <b>to_SubProjElement</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EnterpriseProjectElement</b> entities.
     */
    public void addSubProjElement( EnterpriseProjectElement... entity )
    {
        if( toSubProjElement == null ) {
            toSubProjElement = Lists.newArrayList();
        }
        toSubProjElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>EnterpriseProject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject fetchEnterpriseProject()
    {
        return fetchFieldAsSingle("to_EnterpriseProject", EnterpriseProject.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>EnterpriseProjectElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject getEnterpriseProjectOrFetch()
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = fetchEnterpriseProject();
        }
        return toEnterpriseProject;
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProject</b> is already loaded, the result will
     *         contain the <b>EnterpriseProject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProject> getEnterpriseProjectIfPresent()
    {
        return Option.of(toEnterpriseProject);
    }

    /**
     * Overwrites the associated <b>EnterpriseProject</b> entity for the loaded navigation property
     * <b>to_EnterpriseProject</b>.
     *
     * @param value
     *            New <b>EnterpriseProject</b> entity.
     */
    public void setEnterpriseProject( final EnterpriseProject value )
    {
        toEnterpriseProject = value;
    }

    /**
     * Helper class to allow for fluent creation of EnterpriseProjectElement instances.
     *
     */
    public final static class EnterpriseProjectElementBuilder
    {

        private EntProjectElementJVA toEntProjectElementJVA;
        private EntProjectElmntPublicSector toEntProjectElmntPublicSector;
        private EntProjElmntBlockFunc toEntProjElmntBlkFunc;
        private List<EntProjElmntDlvbrl> toEntProjElmntDlvbrl = Lists.newArrayList();
        private List<EntProjElmntWorkItem> toEntProjElmntWorkItem = Lists.newArrayList();
        private EnterpriseProjectElement toParentProjElement;
        private List<EnterpriseProjectElement> toSubProjElement = Lists.newArrayList();
        private EnterpriseProject toEnterpriseProject;

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toEntProjectElementJVA(
            final EntProjectElementJVA value )
        {
            toEntProjectElementJVA = value;
            return this;
        }

        /**
         * Navigation property <b>to_EntProjectElementJVA</b> for <b>EnterpriseProjectElement</b> to single
         * <b>EntProjectElementJVA</b>.
         *
         * @param value
         *            The EntProjectElementJVA to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder entProjectElementJVA(
            final EntProjectElementJVA value )
        {
            return toEntProjectElementJVA(value);
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toEntProjectElmntPublicSector(
            final EntProjectElmntPublicSector value )
        {
            toEntProjectElmntPublicSector = value;
            return this;
        }

        /**
         * Navigation property <b>to_EntProjectElmntPublicSector</b> for <b>EnterpriseProjectElement</b> to single
         * <b>EntProjectElmntPublicSector</b>.
         *
         * @param value
         *            The EntProjectElmntPublicSector to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder entProjectElmntPublicSector(
            final EntProjectElmntPublicSector value )
        {
            return toEntProjectElmntPublicSector(value);
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toEntProjElmntBlkFunc(
            final EntProjElmntBlockFunc value )
        {
            toEntProjElmntBlkFunc = value;
            return this;
        }

        /**
         * Navigation property <b>to_EntProjElmntBlkFunc</b> for <b>EnterpriseProjectElement</b> to single
         * <b>EntProjElmntBlockFunc</b>.
         *
         * @param value
         *            The EntProjElmntBlockFunc to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder entProjElmntBlkFunc(
            final EntProjElmntBlockFunc value )
        {
            return toEntProjElmntBlkFunc(value);
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toEntProjElmntDlvbrl(
            final List<EntProjElmntDlvbrl> value )
        {
            toEntProjElmntDlvbrl.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EntProjElmntDlvbrl</b> for <b>EnterpriseProjectElement</b> to multiple
         * <b>EntProjElmntDlvbrl</b>.
         *
         * @param value
         *            The EntProjElmntDlvbrls to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder entProjElmntDlvbrl(
            EntProjElmntDlvbrl... value )
        {
            return toEntProjElmntDlvbrl(Lists.newArrayList(value));
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toEntProjElmntWorkItem(
            final List<EntProjElmntWorkItem> value )
        {
            toEntProjElmntWorkItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EntProjElmntWorkItem</b> for <b>EnterpriseProjectElement</b> to multiple
         * <b>EntProjElmntWorkItem</b>.
         *
         * @param value
         *            The EntProjElmntWorkItems to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder entProjElmntWorkItem(
            EntProjElmntWorkItem... value )
        {
            return toEntProjElmntWorkItem(Lists.newArrayList(value));
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toParentProjElement(
            final EnterpriseProjectElement value )
        {
            toParentProjElement = value;
            return this;
        }

        /**
         * Navigation property <b>to_ParentProjElement</b> for <b>EnterpriseProjectElement</b> to single
         * <b>EnterpriseProjectElement</b>.
         *
         * @param value
         *            The EnterpriseProjectElement to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder parentProjElement(
            final EnterpriseProjectElement value )
        {
            return toParentProjElement(value);
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toSubProjElement(
            final List<EnterpriseProjectElement> value )
        {
            toSubProjElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubProjElement</b> for <b>EnterpriseProjectElement</b> to multiple
         * <b>EnterpriseProjectElement</b>.
         *
         * @param value
         *            The EnterpriseProjectElements to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder subProjElement(
            EnterpriseProjectElement... value )
        {
            return toSubProjElement(Lists.newArrayList(value));
        }

        private EnterpriseProjectElement.EnterpriseProjectElementBuilder toEnterpriseProject(
            final EnterpriseProject value )
        {
            toEnterpriseProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProject</b> for <b>EnterpriseProjectElement</b> to single
         * <b>EnterpriseProject</b>.
         *
         * @param value
         *            The EnterpriseProject to build this EnterpriseProjectElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectElement.EnterpriseProjectElementBuilder enterpriseProject(
            final EnterpriseProject value )
        {
            return toEnterpriseProject(value);
        }

    }

}
