/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EnterpriseProjectRoleField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EnterpriseProjectRoleOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EnterpriseProjectRoleSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Role
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EnterpriseProjectRoleType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EnterpriseProjectRole extends VdmEntity<EnterpriseProjectRole>
{

    /**
     * Selector for all available fields of EnterpriseProjectRole.
     *
     */
    public final static EnterpriseProjectRoleSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleUUID</b>
     * </p>
     *
     * @return Role GUID
     */
    @Key
    @SerializedName( "ProjectRoleUUID" )
    @JsonProperty( "ProjectRoleUUID" )
    @Nullable
    @ODataField( odataName = "ProjectRoleUUID" )
    private UUID projectRoleUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectRoleUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectRoleField<UUID> PROJECT_ROLE_UUID =
        new EnterpriseProjectRoleField<UUID>("ProjectRoleUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Project GUID
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectRoleField<UUID> PROJECT_UUID =
        new EnterpriseProjectRoleField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleType</b>
     * </p>
     *
     * @return Role Type
     */
    @SerializedName( "ProjectRoleType" )
    @JsonProperty( "ProjectRoleType" )
    @Nullable
    @ODataField( odataName = "ProjectRoleType" )
    private String projectRoleType;
    /**
     * Use with available fluent helpers to apply the <b>ProjectRoleType</b> field to query operations.
     *
     */
    public final static EnterpriseProjectRoleField<String> PROJECT_ROLE_TYPE =
        new EnterpriseProjectRoleField<String>("ProjectRoleType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleCategory</b>
     * </p>
     *
     * @return Role Category
     */
    @SerializedName( "ProjectRoleCategory" )
    @JsonProperty( "ProjectRoleCategory" )
    @Nullable
    @ODataField( odataName = "ProjectRoleCategory" )
    private String projectRoleCategory;
    /**
     * Use with available fluent helpers to apply the <b>ProjectRoleCategory</b> field to query operations.
     *
     */
    public final static EnterpriseProjectRoleField<String> PROJECT_ROLE_CATEGORY =
        new EnterpriseProjectRoleField<String>("ProjectRoleCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleName</b>
     * </p>
     *
     * @return Role Name
     */
    @SerializedName( "ProjectRoleName" )
    @JsonProperty( "ProjectRoleName" )
    @Nullable
    @ODataField( odataName = "ProjectRoleName" )
    private String projectRoleName;
    /**
     * Use with available fluent helpers to apply the <b>ProjectRoleName</b> field to query operations.
     *
     */
    public final static EnterpriseProjectRoleField<String> PROJECT_ROLE_NAME =
        new EnterpriseProjectRoleField<String>("ProjectRoleName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Who Created Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static EnterpriseProjectRoleField<String> CREATED_BY_USER =
        new EnterpriseProjectRoleField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Timestamp of Object Creation
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectRoleField<ZonedDateTime> CREATION_DATE_TIME =
        new EnterpriseProjectRoleField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static EnterpriseProjectRoleField<String> LAST_CHANGED_BY_USER =
        new EnterpriseProjectRoleField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectRoleField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new EnterpriseProjectRoleField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_EnterpriseProject</b> for <b>EnterpriseProjectRole</b> to single
     * <b>EnterpriseProject</b>.
     *
     */
    @SerializedName( "to_EnterpriseProject" )
    @JsonProperty( "to_EnterpriseProject" )
    @ODataField( odataName = "to_EnterpriseProject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProject toEnterpriseProject;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProject</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectRoleOneToOneLink<EnterpriseProject> TO_ENTERPRISE_PROJECT =
        new EnterpriseProjectRoleOneToOneLink<EnterpriseProject>("to_EnterpriseProject");

    @Nonnull
    @Override
    public Class<EnterpriseProjectRole> getType()
    {
        return EnterpriseProjectRole.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleUUID</b>
     * </p>
     *
     * @param projectRoleUUID
     *            Role GUID
     */
    public void setProjectRoleUUID( @Nullable final UUID projectRoleUUID )
    {
        rememberChangedField("ProjectRoleUUID", this.projectRoleUUID);
        this.projectRoleUUID = projectRoleUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Project GUID
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleType</b>
     * </p>
     *
     * @param projectRoleType
     *            Role Type
     */
    public void setProjectRoleType( @Nullable final String projectRoleType )
    {
        rememberChangedField("ProjectRoleType", this.projectRoleType);
        this.projectRoleType = projectRoleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleCategory</b>
     * </p>
     *
     * @param projectRoleCategory
     *            Role Category
     */
    public void setProjectRoleCategory( @Nullable final String projectRoleCategory )
    {
        rememberChangedField("ProjectRoleCategory", this.projectRoleCategory);
        this.projectRoleCategory = projectRoleCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectRoleName</b>
     * </p>
     *
     * @param projectRoleName
     *            Role Name
     */
    public void setProjectRoleName( @Nullable final String projectRoleName )
    {
        rememberChangedField("ProjectRoleName", this.projectRoleName);
        this.projectRoleName = projectRoleName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Who Created Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Timestamp of Object Creation
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Timestamp of Last Object Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EnterpriseProjectRole";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectRoleUUID", getProjectRoleUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectRoleUUID", getProjectRoleUUID());
        values.put("ProjectUUID", getProjectUUID());
        values.put("ProjectRoleType", getProjectRoleType());
        values.put("ProjectRoleCategory", getProjectRoleCategory());
        values.put("ProjectRoleName", getProjectRoleName());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectRoleUUID") ) {
                final Object value = values.remove("ProjectRoleUUID");
                if( (value == null) || (!value.equals(getProjectRoleUUID())) ) {
                    setProjectRoleUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectRoleType") ) {
                final Object value = values.remove("ProjectRoleType");
                if( (value == null) || (!value.equals(getProjectRoleType())) ) {
                    setProjectRoleType(((String) value));
                }
            }
            if( values.containsKey("ProjectRoleCategory") ) {
                final Object value = values.remove("ProjectRoleCategory");
                if( (value == null) || (!value.equals(getProjectRoleCategory())) ) {
                    setProjectRoleCategory(((String) value));
                }
            }
            if( values.containsKey("ProjectRoleName") ) {
                final Object value = values.remove("ProjectRoleName");
                if( (value == null) || (!value.equals(getProjectRoleName())) ) {
                    setProjectRoleName(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProject") ) {
                final Object value = (values).remove("to_EnterpriseProject");
                if( value instanceof Map ) {
                    if( toEnterpriseProject == null ) {
                        toEnterpriseProject = new EnterpriseProject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProject.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EnterpriseProjectRoleField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EnterpriseProjectRoleField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EnterpriseProjectRoleField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EnterpriseProjectRoleField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProject != null ) {
            (values).put("to_EnterpriseProject", toEnterpriseProject);
        }
        return values;
    }

    /**
     * Fetches the <b>EnterpriseProject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject fetchEnterpriseProject()
    {
        return fetchFieldAsSingle("to_EnterpriseProject", EnterpriseProject.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>EnterpriseProjectRole</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject getEnterpriseProjectOrFetch()
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = fetchEnterpriseProject();
        }
        return toEnterpriseProject;
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectRole</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProject</b> is already loaded, the result will
     *         contain the <b>EnterpriseProject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProject> getEnterpriseProjectIfPresent()
    {
        return Option.of(toEnterpriseProject);
    }

    /**
     * Overwrites the associated <b>EnterpriseProject</b> entity for the loaded navigation property
     * <b>to_EnterpriseProject</b>.
     *
     * @param value
     *            New <b>EnterpriseProject</b> entity.
     */
    public void setEnterpriseProject( final EnterpriseProject value )
    {
        toEnterpriseProject = value;
    }

    /**
     * Helper class to allow for fluent creation of EnterpriseProjectRole instances.
     *
     */
    public final static class EnterpriseProjectRoleBuilder
    {

        private EnterpriseProject toEnterpriseProject;

        private EnterpriseProjectRole.EnterpriseProjectRoleBuilder toEnterpriseProject( final EnterpriseProject value )
        {
            toEnterpriseProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProject</b> for <b>EnterpriseProjectRole</b> to single
         * <b>EnterpriseProject</b>.
         *
         * @param value
         *            The EnterpriseProject to build this EnterpriseProjectRole with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectRole.EnterpriseProjectRoleBuilder enterpriseProject( final EnterpriseProject value )
        {
            return toEnterpriseProject(value);
        }

    }

}
