/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EnterpriseProjectRoleSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
 * EnterpriseProjectRole} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class EnterpriseProjectRoleByKeyFluentHelper
    extends
    FluentHelperByKey<EnterpriseProjectRoleByKeyFluentHelper, EnterpriseProjectRole, EnterpriseProjectRoleSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
     * EnterpriseProjectRole} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param projectRoleUUID
     *            Role GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code EnterpriseProjectRole}
     * @param servicePath
     *            Service path to be used to fetch a single {@code EnterpriseProjectRole}
     */
    public EnterpriseProjectRoleByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID projectRoleUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("ProjectRoleUUID", projectRoleUUID);
    }

    @Override
    @Nonnull
    protected Class<EnterpriseProjectRole> getEntityClass()
    {
        return EnterpriseProjectRole.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
