/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EnterpriseProjectTeamMemberField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EnterpriseProjectTeamMemberLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EnterpriseProjectTeamMemberOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EnterpriseProjectTeamMemberSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Team Member
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EnterpriseProjectTeamMemberType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EnterpriseProjectTeamMember extends VdmEntity<EnterpriseProjectTeamMember>
{

    /**
     * Selector for all available fields of EnterpriseProjectTeamMember.
     *
     */
    public final static EnterpriseProjectTeamMemberSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjEntitlement_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_EntProjEntitlement_oc" )
    @JsonProperty( "to_EntProjEntitlement_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_EntProjEntitlement_oc" )
    private Boolean entProjEntitlement_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjEntitlement_oc</b> field to query operations.
     *
     */
    public final static EnterpriseProjectTeamMemberField<Boolean> ENT_PROJ_ENTITLEMENT_OC =
        new EnterpriseProjectTeamMemberField<Boolean>("to_EntProjEntitlement_oc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TeamMemberUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "TeamMemberUUID" )
    @JsonProperty( "TeamMemberUUID" )
    @Nullable
    @ODataField( odataName = "TeamMemberUUID" )
    private UUID teamMemberUUID;
    /**
     * Use with available fluent helpers to apply the <b>TeamMemberUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectTeamMemberField<UUID> TEAM_MEMBER_UUID =
        new EnterpriseProjectTeamMemberField<UUID>("TeamMemberUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerUUID</b>
     * </p>
     *
     * @return Business Partner GUID
     */
    @SerializedName( "BusinessPartnerUUID" )
    @JsonProperty( "BusinessPartnerUUID" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerUUID" )
    private UUID businessPartnerUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectTeamMemberField<UUID> BUSINESS_PARTNER_UUID =
        new EnterpriseProjectTeamMemberField<UUID>("BusinessPartnerUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EnterpriseProjectTeamMemberField<UUID> PROJECT_UUID =
        new EnterpriseProjectTeamMemberField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Who Created Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static EnterpriseProjectTeamMemberField<String> CREATED_BY_USER =
        new EnterpriseProjectTeamMemberField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Timestamp of Object Creation
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectTeamMemberField<ZonedDateTime> CREATION_DATE_TIME =
        new EnterpriseProjectTeamMemberField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static EnterpriseProjectTeamMemberField<String> LAST_CHANGED_BY_USER =
        new EnterpriseProjectTeamMemberField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static EnterpriseProjectTeamMemberField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new EnterpriseProjectTeamMemberField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>to_EntProjEntitlement</b> for <b>EnterpriseProjectTeamMember</b> to multiple
     * <b>EntTeamMemberEntitlement</b>.
     *
     */
    @SerializedName( "to_EntProjEntitlement" )
    @JsonProperty( "to_EntProjEntitlement" )
    @ODataField( odataName = "to_EntProjEntitlement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EntTeamMemberEntitlement> toEntProjEntitlement;
    /**
     * Navigation property <b>to_EnterpriseProject</b> for <b>EnterpriseProjectTeamMember</b> to single
     * <b>EnterpriseProject</b>.
     *
     */
    @SerializedName( "to_EnterpriseProject" )
    @JsonProperty( "to_EnterpriseProject" )
    @ODataField( odataName = "to_EnterpriseProject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProject toEnterpriseProject;
    /**
     * Use with available fluent helpers to apply the <b>to_EntProjEntitlement</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectTeamMemberLink<EntTeamMemberEntitlement> TO_ENT_PROJ_ENTITLEMENT =
        new EnterpriseProjectTeamMemberLink<EntTeamMemberEntitlement>("to_EntProjEntitlement");
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProject</b> navigation property to query
     * operations.
     *
     */
    public final static EnterpriseProjectTeamMemberOneToOneLink<EnterpriseProject> TO_ENTERPRISE_PROJECT =
        new EnterpriseProjectTeamMemberOneToOneLink<EnterpriseProject>("to_EnterpriseProject");

    @Nonnull
    @Override
    public Class<EnterpriseProjectTeamMember> getType()
    {
        return EnterpriseProjectTeamMember.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_EntProjEntitlement_oc</b>
     * </p>
     *
     * @param entProjEntitlement_oc
     *            Dynamic CbA-Control
     */
    public void setEntProjEntitlement_oc( @Nullable final Boolean entProjEntitlement_oc )
    {
        rememberChangedField("to_EntProjEntitlement_oc", this.entProjEntitlement_oc);
        this.entProjEntitlement_oc = entProjEntitlement_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>TeamMemberUUID</b>
     * </p>
     *
     * @param teamMemberUUID
     *            Entity Guid
     */
    public void setTeamMemberUUID( @Nullable final UUID teamMemberUUID )
    {
        rememberChangedField("TeamMemberUUID", this.teamMemberUUID);
        this.teamMemberUUID = teamMemberUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerUUID</b>
     * </p>
     *
     * @param businessPartnerUUID
     *            Business Partner GUID
     */
    public void setBusinessPartnerUUID( @Nullable final UUID businessPartnerUUID )
    {
        rememberChangedField("BusinessPartnerUUID", this.businessPartnerUUID);
        this.businessPartnerUUID = businessPartnerUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Who Created Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Timestamp of Object Creation
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Timestamp of Last Object Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EnterpriseProjectTeamMember";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("TeamMemberUUID", getTeamMemberUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("to_EntProjEntitlement_oc", getEntProjEntitlement_oc());
        values.put("TeamMemberUUID", getTeamMemberUUID());
        values.put("BusinessPartnerUUID", getBusinessPartnerUUID());
        values.put("ProjectUUID", getProjectUUID());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("to_EntProjEntitlement_oc") ) {
                final Object value = values.remove("to_EntProjEntitlement_oc");
                if( (value == null) || (!value.equals(getEntProjEntitlement_oc())) ) {
                    setEntProjEntitlement_oc(((Boolean) value));
                }
            }
            if( values.containsKey("TeamMemberUUID") ) {
                final Object value = values.remove("TeamMemberUUID");
                if( (value == null) || (!value.equals(getTeamMemberUUID())) ) {
                    setTeamMemberUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusinessPartnerUUID") ) {
                final Object value = values.remove("BusinessPartnerUUID");
                if( (value == null) || (!value.equals(getBusinessPartnerUUID())) ) {
                    setBusinessPartnerUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EntProjEntitlement") ) {
                final Object value = (values).remove("to_EntProjEntitlement");
                if( value instanceof Iterable ) {
                    if( toEntProjEntitlement == null ) {
                        toEntProjEntitlement = Lists.newArrayList();
                    } else {
                        toEntProjEntitlement = Lists.newArrayList(toEntProjEntitlement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EntTeamMemberEntitlement entity;
                        if( toEntProjEntitlement.size() > i ) {
                            entity = toEntProjEntitlement.get(i);
                        } else {
                            entity = new EntTeamMemberEntitlement();
                            toEntProjEntitlement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_EnterpriseProject") ) {
                final Object value = (values).remove("to_EnterpriseProject");
                if( value instanceof Map ) {
                    if( toEnterpriseProject == null ) {
                        toEnterpriseProject = new EnterpriseProject();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProject.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> EnterpriseProjectTeamMemberField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new EnterpriseProjectTeamMemberField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EnterpriseProjectTeamMemberField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EnterpriseProjectTeamMemberField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEntProjEntitlement != null ) {
            (values).put("to_EntProjEntitlement", toEntProjEntitlement);
        }
        if( toEnterpriseProject != null ) {
            (values).put("to_EnterpriseProject", toEnterpriseProject);
        }
        return values;
    }

    /**
     * Fetches the <b>EntTeamMemberEntitlement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_EntProjEntitlement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EntTeamMemberEntitlement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EntTeamMemberEntitlement> fetchEntProjEntitlement()
    {
        return fetchFieldAsList("to_EntProjEntitlement", EntTeamMemberEntitlement.class);
    }

    /**
     * Retrieval of associated <b>EntTeamMemberEntitlement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjEntitlement</b>.
     * <p>
     * If the navigation property <b>to_EntProjEntitlement</b> of a queried <b>EnterpriseProjectTeamMember</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EntTeamMemberEntitlement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EntTeamMemberEntitlement> getEntProjEntitlementOrFetch()
    {
        if( toEntProjEntitlement == null ) {
            toEntProjEntitlement = fetchEntProjEntitlement();
        }
        return toEntProjEntitlement;
    }

    /**
     * Retrieval of associated <b>EntTeamMemberEntitlement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EntProjEntitlement</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectTeamMember</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EntProjEntitlement</b> is already loaded, the result
     *         will contain the <b>EntTeamMemberEntitlement</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EntTeamMemberEntitlement>> getEntProjEntitlementIfPresent()
    {
        return Option.of(toEntProjEntitlement);
    }

    /**
     * Overwrites the list of associated <b>EntTeamMemberEntitlement</b> entities for the loaded navigation property
     * <b>to_EntProjEntitlement</b>.
     * <p>
     * If the navigation property <b>to_EntProjEntitlement</b> of a queried <b>EnterpriseProjectTeamMember</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EntTeamMemberEntitlement</b> entities.
     */
    public void setEntProjEntitlement( @Nonnull final List<EntTeamMemberEntitlement> value )
    {
        if( toEntProjEntitlement == null ) {
            toEntProjEntitlement = Lists.newArrayList();
        }
        toEntProjEntitlement.clear();
        toEntProjEntitlement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EntTeamMemberEntitlement</b> entities. This corresponds to the OData
     * navigation property <b>to_EntProjEntitlement</b>.
     * <p>
     * If the navigation property <b>to_EntProjEntitlement</b> of a queried <b>EnterpriseProjectTeamMember</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EntTeamMemberEntitlement</b> entities.
     */
    public void addEntProjEntitlement( EntTeamMemberEntitlement... entity )
    {
        if( toEntProjEntitlement == null ) {
            toEntProjEntitlement = Lists.newArrayList();
        }
        toEntProjEntitlement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>EnterpriseProject</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProject</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject fetchEnterpriseProject()
    {
        return fetchFieldAsSingle("to_EnterpriseProject", EnterpriseProject.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>EnterpriseProjectTeamMember</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProject</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProject getEnterpriseProjectOrFetch()
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = fetchEnterpriseProject();
        }
        return toEnterpriseProject;
    }

    /**
     * Retrieval of associated <b>EnterpriseProject</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property for an entity <b>EnterpriseProjectTeamMember</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProject</b> is already loaded, the result will
     *         contain the <b>EnterpriseProject</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProject> getEnterpriseProjectIfPresent()
    {
        return Option.of(toEnterpriseProject);
    }

    /**
     * Overwrites the associated <b>EnterpriseProject</b> entity for the loaded navigation property
     * <b>to_EnterpriseProject</b>.
     *
     * @param value
     *            New <b>EnterpriseProject</b> entity.
     */
    public void setEnterpriseProject( final EnterpriseProject value )
    {
        toEnterpriseProject = value;
    }

    /**
     * Helper class to allow for fluent creation of EnterpriseProjectTeamMember instances.
     *
     */
    public final static class EnterpriseProjectTeamMemberBuilder
    {

        private List<EntTeamMemberEntitlement> toEntProjEntitlement = Lists.newArrayList();
        private EnterpriseProject toEnterpriseProject;

        private EnterpriseProjectTeamMember.EnterpriseProjectTeamMemberBuilder toEntProjEntitlement(
            final List<EntTeamMemberEntitlement> value )
        {
            toEntProjEntitlement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EntProjEntitlement</b> for <b>EnterpriseProjectTeamMember</b> to multiple
         * <b>EntTeamMemberEntitlement</b>.
         *
         * @param value
         *            The EntTeamMemberEntitlements to build this EnterpriseProjectTeamMember with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectTeamMember.EnterpriseProjectTeamMemberBuilder entProjEntitlement(
            EntTeamMemberEntitlement... value )
        {
            return toEntProjEntitlement(Lists.newArrayList(value));
        }

        private EnterpriseProjectTeamMember.EnterpriseProjectTeamMemberBuilder toEnterpriseProject(
            final EnterpriseProject value )
        {
            toEnterpriseProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProject</b> for <b>EnterpriseProjectTeamMember</b> to single
         * <b>EnterpriseProject</b>.
         *
         * @param value
         *            The EnterpriseProject to build this EnterpriseProjectTeamMember with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EnterpriseProjectTeamMember.EnterpriseProjectTeamMemberBuilder enterpriseProject(
            final EnterpriseProject value )
        {
            return toEnterpriseProject(value);
        }

    }

}
