/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable.EnterpriseProjectTeamMemberSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
 * EnterpriseProjectTeamMember} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class EnterpriseProjectTeamMemberByKeyFluentHelper
    extends
    FluentHelperByKey<EnterpriseProjectTeamMemberByKeyFluentHelper, EnterpriseProjectTeamMember, EnterpriseProjectTeamMemberSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
     * EnterpriseProjectTeamMember} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param teamMemberUUID
     *            Entity Guid
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code EnterpriseProjectTeamMember}
     * @param servicePath
     *            Service path to be used to fetch a single {@code EnterpriseProjectTeamMember}
     */
    public EnterpriseProjectTeamMemberByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID teamMemberUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("TeamMemberUUID", teamMemberUUID);
    }

    @Override
    @Nonnull
    protected Class<EnterpriseProjectTeamMember> getEntityClass()
    {
        return EnterpriseProjectTeamMember.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
