/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link EnterpriseProjectV2ServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service EnterpriseProjectV2Service},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultEnterpriseProjectV2ServiceBatch
    extends
    BatchFluentHelperBasic<EnterpriseProjectV2ServiceBatch, EnterpriseProjectV2ServiceBatchChangeSet>
    implements
    EnterpriseProjectV2ServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultEnterpriseProjectV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultEnterpriseProjectV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultEnterpriseProjectV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultEnterpriseProjectV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultEnterpriseProjectV2ServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultEnterpriseProjectV2ServiceBatchChangeSet(this, service);
    }

}
