/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember;

/**
 * Implementation of the {@link EnterpriseProjectV2ServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service EnterpriseProjectV2Service}.
 *
 */
public class DefaultEnterpriseProjectV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<EnterpriseProjectV2ServiceBatch, EnterpriseProjectV2ServiceBatchChangeSet>
    implements
    EnterpriseProjectV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultEnterpriseProjectV2ServiceBatchChangeSet(
        @Nonnull final DefaultEnterpriseProjectV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultEnterpriseProjectV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet createEnterpriseProjBlkFunc(
        @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc )
    {
        return addRequestCreate(service::createEnterpriseProjBlkFunc, enterpriseProjBlkFunc);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEnterpriseProjBlkFunc(
        @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc )
    {
        return addRequestUpdate(service::updateEnterpriseProjBlkFunc, enterpriseProjBlkFunc);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet createEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return addRequestCreate(service::createEnterpriseProjectElement, enterpriseProjectElement);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return addRequestUpdate(service::updateEnterpriseProjectElement, enterpriseProjectElement);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet deleteEnterpriseProjectElement(
        @Nonnull final EnterpriseProjectElement enterpriseProjectElement )
    {
        return addRequestDelete(service::deleteEnterpriseProjectElement, enterpriseProjectElement);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEnterpriseProjectJVA(
        @Nonnull final EnterpriseProjectJVA enterpriseProjectJVA )
    {
        return addRequestUpdate(service::updateEnterpriseProjectJVA, enterpriseProjectJVA);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet createEnterpriseProjectRole(
        @Nonnull final EnterpriseProjectRole enterpriseProjectRole )
    {
        return addRequestCreate(service::createEnterpriseProjectRole, enterpriseProjectRole);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet createEnterpriseProjectTeamMember(
        @Nonnull final EnterpriseProjectTeamMember enterpriseProjectTeamMember )
    {
        return addRequestCreate(service::createEnterpriseProjectTeamMember, enterpriseProjectTeamMember);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet createEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return addRequestCreate(service::createEnterpriseProject, enterpriseProject);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return addRequestUpdate(service::updateEnterpriseProject, enterpriseProject);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet deleteEnterpriseProject(
        @Nonnull final EnterpriseProject enterpriseProject )
    {
        return addRequestDelete(service::deleteEnterpriseProject, enterpriseProject);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEntProjectElementJVA(
        @Nonnull final EntProjectElementJVA entProjectElementJVA )
    {
        return addRequestUpdate(service::updateEntProjectElementJVA, entProjectElementJVA);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEntProjectPublicSector(
        @Nonnull final EntProjectPublicSector entProjectPublicSector )
    {
        return addRequestUpdate(service::updateEntProjectPublicSector, entProjectPublicSector);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet createEntProjElmntBlockFunc(
        @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc )
    {
        return addRequestCreate(service::createEntProjElmntBlockFunc, entProjElmntBlockFunc);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEntProjElmntBlockFunc(
        @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc )
    {
        return addRequestUpdate(service::updateEntProjElmntBlockFunc, entProjElmntBlockFunc);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet createEntProjElmntDlvbrl(
        @Nonnull final EntProjElmntDlvbrl entProjElmntDlvbrl )
    {
        return addRequestCreate(service::createEntProjElmntDlvbrl, entProjElmntDlvbrl);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEntProjElmntDlvbrl(
        @Nonnull final EntProjElmntDlvbrl entProjElmntDlvbrl )
    {
        return addRequestUpdate(service::updateEntProjElmntDlvbrl, entProjElmntDlvbrl);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEntProjElmntDlvbrlDistr(
        @Nonnull final EntProjElmntDlvbrlDistr entProjElmntDlvbrlDistr )
    {
        return addRequestUpdate(service::updateEntProjElmntDlvbrlDistr, entProjElmntDlvbrlDistr);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEntProjectElmntPublicSector(
        @Nonnull final EntProjectElmntPublicSector entProjectElmntPublicSector )
    {
        return addRequestUpdate(service::updateEntProjectElmntPublicSector, entProjectElmntPublicSector);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEntProjElmntWorkItem(
        @Nonnull final EntProjElmntWorkItem entProjElmntWorkItem )
    {
        return addRequestUpdate(service::updateEntProjElmntWorkItem, entProjElmntWorkItem);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet deleteEntProjElmntWorkItem(
        @Nonnull final EntProjElmntWorkItem entProjElmntWorkItem )
    {
        return addRequestDelete(service::deleteEntProjElmntWorkItem, entProjElmntWorkItem);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet createEntTeamMemberEntitlement(
        @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement )
    {
        return addRequestCreate(service::createEntTeamMemberEntitlement, entTeamMemberEntitlement);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet updateEntTeamMemberEntitlement(
        @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement )
    {
        return addRequestUpdate(service::updateEntTeamMemberEntitlement, entTeamMemberEntitlement);
    }

    @Nonnull
    @Override
    public EnterpriseProjectV2ServiceBatchChangeSet deleteEntTeamMemberEntitlement(
        @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement )
    {
        return addRequestDelete(service::deleteEntTeamMemberEntitlement, entTeamMemberEntitlement);
    }

}
