/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectV2Service
 * EnterpriseProjectV2Service}.
 *
 */
public interface EnterpriseProjectV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<EnterpriseProjectV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<EnterpriseProjectV2ServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjBlkFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     *            EnterpriseProjBlkFunc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        createEnterpriseProjBlkFunc( @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     * EnterpriseProjBlkFunc} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjBlkFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjBlkFunc
     *            EnterpriseProjBlkFunc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEnterpriseProjBlkFunc( @Nonnull final EnterpriseProjBlkFunc enterpriseProjBlkFunc );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     * EnterpriseProjectElement} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        createEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     * EnterpriseProjectElement} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     * EnterpriseProjectElement} entity in the S/4HANA system.
     *
     * @param enterpriseProjectElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectElement
     *            EnterpriseProjectElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        deleteEnterpriseProjectElement( @Nonnull final EnterpriseProjectElement enterpriseProjectElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA
     * EnterpriseProjectJVA} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectJVA
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA
     *            EnterpriseProjectJVA} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEnterpriseProjectJVA( @Nonnull final EnterpriseProjectJVA enterpriseProjectJVA );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
     * EnterpriseProjectRole} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectRole
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectRole
     *            EnterpriseProjectRole} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        createEnterpriseProjectRole( @Nonnull final EnterpriseProjectRole enterpriseProjectRole );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
     * EnterpriseProjectTeamMember} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProjectTeamMember
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectTeamMember
     *            EnterpriseProjectTeamMember} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        createEnterpriseProjectTeamMember( @Nonnull final EnterpriseProjectTeamMember enterpriseProjectTeamMember );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     * EnterpriseProject} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *            EnterpriseProject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        createEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     * EnterpriseProject} entity and save it to the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *            EnterpriseProject} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     * EnterpriseProject} entity in the S/4HANA system.
     *
     * @param enterpriseProject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject
     *            EnterpriseProject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        deleteEnterpriseProject( @Nonnull final EnterpriseProject enterpriseProject );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA
     * EntProjectElementJVA} entity and save it to the S/4HANA system.
     *
     * @param entProjectElementJVA
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA
     *            EntProjectElementJVA} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEntProjectElementJVA( @Nonnull final EntProjectElementJVA entProjectElementJVA );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector
     * EntProjectPublicSector} entity and save it to the S/4HANA system.
     *
     * @param entProjectPublicSector
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectPublicSector
     *            EntProjectPublicSector} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEntProjectPublicSector( @Nonnull final EntProjectPublicSector entProjectPublicSector );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntBlockFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     *            EntProjElmntBlockFunc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        createEntProjElmntBlockFunc( @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     * EntProjElmntBlockFunc} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntBlockFunc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntBlockFunc
     *            EntProjElmntBlockFunc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEntProjElmntBlockFunc( @Nonnull final EntProjElmntBlockFunc entProjElmntBlockFunc );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     * EntProjElmntDlvbrl} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntDlvbrl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     *            EntProjElmntDlvbrl} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        createEntProjElmntDlvbrl( @Nonnull final EntProjElmntDlvbrl entProjElmntDlvbrl );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     * EntProjElmntDlvbrl} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntDlvbrl
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
     *            EntProjElmntDlvbrl} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEntProjElmntDlvbrl( @Nonnull final EntProjElmntDlvbrl entProjElmntDlvbrl );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr
     * EntProjElmntDlvbrlDistr} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntDlvbrlDistr
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr
     *            EntProjElmntDlvbrlDistr} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEntProjElmntDlvbrlDistr( @Nonnull final EntProjElmntDlvbrlDistr entProjElmntDlvbrlDistr );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector
     * EntProjectElmntPublicSector} entity and save it to the S/4HANA system.
     *
     * @param entProjectElmntPublicSector
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector
     *            EntProjectElmntPublicSector} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEntProjectElmntPublicSector( @Nonnull final EntProjectElmntPublicSector entProjectElmntPublicSector );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     * EntProjElmntWorkItem} entity and save it to the S/4HANA system.
     *
     * @param entProjElmntWorkItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     *            EntProjElmntWorkItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEntProjElmntWorkItem( @Nonnull final EntProjElmntWorkItem entProjElmntWorkItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     * EntProjElmntWorkItem} entity in the S/4HANA system.
     *
     * @param entProjElmntWorkItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
     *            EntProjElmntWorkItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        deleteEntProjElmntWorkItem( @Nonnull final EntProjElmntWorkItem entProjElmntWorkItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     * EntTeamMemberEntitlement} entity and save it to the S/4HANA system.
     *
     * @param entTeamMemberEntitlement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *            EntTeamMemberEntitlement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        createEntTeamMemberEntitlement( @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     * EntTeamMemberEntitlement} entity and save it to the S/4HANA system.
     *
     * @param entTeamMemberEntitlement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *            EntTeamMemberEntitlement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        updateEntTeamMemberEntitlement( @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     * EntTeamMemberEntitlement} entity in the S/4HANA system.
     *
     * @param entTeamMemberEntitlement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntTeamMemberEntitlement
     *            EntTeamMemberEntitlement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EnterpriseProjectV2ServiceBatchChangeSet
        deleteEntTeamMemberEntitlement( @Nonnull final EntTeamMemberEntitlement entTeamMemberEntitlement );

}
