/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr
 * EntProjElmntDlvbrlDistr}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EntProjElmntDlvbrlDistrField
 * EntProjElmntDlvbrlDistrField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjElmntDlvbrlDistrLink
 * EntProjElmntDlvbrlDistrLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr#ENT_PROJ_ELMNT_DLVBRL_DISTR_UUID
 * ENT_PROJ_ELMNT_DLVBRL_DISTR_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr#ENT_PROJ_ELMNT_DELIVERABLE_UUID
 * ENT_PROJ_ELMNT_DELIVERABLE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr#PROJECT_ELEMENT_UUID
 * PROJECT_ELEMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr#ENT_PROJ_ELMNT_DLVBRL_DISTR_YEAR_VAL
 * ENT_PROJ_ELMNT_DLVBRL_DISTR_YEAR_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr#ENT_PROJ_ELMNT_DLVBRL_DISTR_PERD_VAL
 * ENT_PROJ_ELMNT_DLVBRL_DISTR_PERD_VAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr#ENT_PROJ_ELMNT_DLVBRL_DISTR_QTY
 * ENT_PROJ_ELMNT_DLVBRL_DISTR_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr#ENT_PROJ_ELMNT_DLVBRL_DISTR_QTY_UNIT
 * ENT_PROJ_ELMNT_DLVBRL_DISTR_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrlDistr#TO_ENT_PROJ_ELMNT_DLVBRL
 * TO_ENT_PROJ_ELMNT_DLVBRL}</li>
 * </ul>
 *
 */
public interface EntProjElmntDlvbrlDistrSelectable extends EntitySelectable<EntProjElmntDlvbrlDistr>
{

}
