/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl
 * EntProjElmntDlvbrl}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EntProjElmntDlvbrlField
 * EntProjElmntDlvbrlField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjElmntDlvbrlLink
 * EntProjElmntDlvbrlLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#ENT_PROJ_ELMNT_DLV_DISTR_OC
 * ENT_PROJ_ELMNT_DLV_DISTR_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#ENT_PROJ_ELMNT_DELIVERABLE_UUID
 * ENT_PROJ_ELMNT_DELIVERABLE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#PROJECT_ELEMENT_UUID
 * PROJECT_ELEMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#ENT_PROJ_ELMNT_DELIVERABLE_TYPE
 * ENT_PROJ_ELMNT_DELIVERABLE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#ENT_PROJ_ELMNT_DLVBRL_QUANTITY
 * ENT_PROJ_ELMNT_DLVBRL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#ENT_PROJ_ELMNT_DLVBRL_QUANTITY_UNIT
 * ENT_PROJ_ELMNT_DLVBRL_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#TO_ENTERPRISE_PROJECT_ELEMENT
 * TO_ENTERPRISE_PROJECT_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntDlvbrl#TO_ENT_PROJ_ELMNT_DLV_DISTR
 * TO_ENT_PROJ_ELMNT_DLV_DISTR}</li>
 * </ul>
 *
 */
public interface EntProjElmntDlvbrlSelectable extends EntitySelectable<EntProjElmntDlvbrl>
{

}
