/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem
 * EntProjElmntWorkItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EntProjElmntWorkItemField
 * EntProjElmntWorkItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjElmntWorkItemLink
 * EntProjElmntWorkItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#ENT_PROJ_ELMNT_WORK_ITEM_UUID
 * ENT_PROJ_ELMNT_WORK_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#ENT_PROJ_ELMNT_WORK_ITEM
 * ENT_PROJ_ELMNT_WORK_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#ENT_PROJ_ELMNT_WORK_ITEM_NAME
 * ENT_PROJ_ELMNT_WORK_ITEM_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#ENT_PROJ_ELMNT_WORK_ITEM_IS_INACTIVE
 * ENT_PROJ_ELMNT_WORK_ITEM_IS_INACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#ENT_PROJ_ELMNT_WORK_ITEM_IS_CNFGRD
 * ENT_PROJ_ELMNT_WORK_ITEM_IS_CNFGRD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#PROJECT_ELEMENT_UUID
 * PROJECT_ELEMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#ENT_PROJ_ELMNT_WRK_ITM_LAST_UPDT_SRCE
 * ENT_PROJ_ELMNT_WRK_ITM_LAST_UPDT_SRCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#ENT_PROJ_ELMNT_WRK_ITM_CRTED_BY_USR
 * ENT_PROJ_ELMNT_WRK_ITM_CRTED_BY_USR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#ENT_PROJ_ELMNT_WRK_ITM_CRTN_DTE_TME
 * ENT_PROJ_ELMNT_WRK_ITM_CRTN_DTE_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#ENT_PROJ_ELMNT_WRK_ITM_LST_CHG_BY_USR
 * ENT_PROJ_ELMNT_WRK_ITM_LST_CHG_BY_USR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#ENT_PROJ_ELMNT_WRK_ITM_LST_CHG_DTE_TME
 * ENT_PROJ_ELMNT_WRK_ITM_LST_CHG_DTE_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#TO_ENTERPRISE_PROJECT_ELEMENT
 * TO_ENTERPRISE_PROJECT_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjElmntWorkItem#TO_ENTERPRISE_PROJECT
 * TO_ENTERPRISE_PROJECT}</li>
 * </ul>
 *
 */
public interface EntProjElmntWorkItemSelectable extends EntitySelectable<EntProjElmntWorkItem>
{

}
