/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA
 * EntProjectElementJVA}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EntProjectElementJVAField
 * EntProjectElementJVAField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjectElementJVALink
 * EntProjectElementJVALink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JNT_INTRST_BILLG_CLASS_FC
 * JNT_INTRST_BILLG_CLASS_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JNT_INTRST_BILLG_SUB_CLASS_FC
 * JNT_INTRST_BILLG_SUB_CLASS_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JNT_VNTR_PROJECT_TYPE_FC
 * JNT_VNTR_PROJECT_TYPE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JOINT_VENTURE_FC
 * JOINT_VENTURE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JOINT_VENTURE_COST_RECOVERY_CODE_FC
 * JOINT_VENTURE_COST_RECOVERY_CODE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JOINT_VENTURE_EQUITY_TYPE_FC
 * JOINT_VENTURE_EQUITY_TYPE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#PROJECT_ELEMENT_UUID
 * PROJECT_ELEMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JOINT_VENTURE
 * JOINT_VENTURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JOINT_VENTURE_COST_RECOVERY_CODE
 * JOINT_VENTURE_COST_RECOVERY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JOINT_VENTURE_EQUITY_TYPE
 * JOINT_VENTURE_EQUITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JNT_VNTR_PROJECT_TYPE
 * JNT_VNTR_PROJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JNT_INTRST_BILLG_CLASS
 * JNT_INTRST_BILLG_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#JNT_INTRST_BILLG_SUB_CLASS
 * JNT_INTRST_BILLG_SUB_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#TO_ENTERPRISE_PROJECT_ELEMENT
 * TO_ENTERPRISE_PROJECT_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElementJVA#TO_ENTERPRISE_PROJECT
 * TO_ENTERPRISE_PROJECT}</li>
 * </ul>
 *
 */
public interface EntProjectElementJVASelectable extends EntitySelectable<EntProjectElementJVA>
{

}
