/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector
 * EntProjectElmntPublicSector}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EntProjectElmntPublicSectorField
 * EntProjectElmntPublicSectorField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EntProjectElmntPublicSectorLink
 * EntProjectElmntPublicSectorLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#FUNCTIONAL_AREA_IS_FIX_ASSIGNED_FC
 * FUNCTIONAL_AREA_IS_FIX_ASSIGNED_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#FUND_FC
 * FUND_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#FUND_IS_FIX_ASSIGNED_FC
 * FUND_IS_FIX_ASSIGNED_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#GRANT_ID_FC
 * GRANT_ID_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#GRANT_IS_FIX_ASSIGNED_FC
 * GRANT_IS_FIX_ASSIGNED_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#SPONSORED_PROGRAM_FC
 * SPONSORED_PROGRAM_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#PROJECT_ELEMENT_UUID
 * PROJECT_ELEMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#FUND_IS_FIX_ASSIGNED
 * FUND_IS_FIX_ASSIGNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#FUNCTIONAL_AREA_IS_FIX_ASSIGNED
 * FUNCTIONAL_AREA_IS_FIX_ASSIGNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#GRANT_IS_FIX_ASSIGNED
 * GRANT_IS_FIX_ASSIGNED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#SPONSORED_PROGRAM
 * SPONSORED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#TO_ENTERPRISE_PROJECT_ELEMENT
 * TO_ENTERPRISE_PROJECT_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EntProjectElmntPublicSector#TO_ENTERPRISE_PROJECT
 * TO_ENTERPRISE_PROJECT}</li>
 * </ul>
 *
 */
public interface EntProjectElmntPublicSectorSelectable extends EntitySelectable<EntProjectElmntPublicSector>
{

}
