/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA
 * EnterpriseProjectJVA}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EnterpriseProjectJVAField
 * EnterpriseProjectJVAField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EnterpriseProjectJVALink
 * EnterpriseProjectJVALink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA#JOINT_VENTURE
 * JOINT_VENTURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA#JOINT_VENTURE_COST_RECOVERY_CODE
 * JOINT_VENTURE_COST_RECOVERY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA#JOINT_VENTURE_EQUITY_TYPE
 * JOINT_VENTURE_EQUITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA#JNT_VNTR_PROJECT_TYPE
 * JNT_VNTR_PROJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA#JNT_INTRST_BILLG_CLASS
 * JNT_INTRST_BILLG_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA#JNT_INTRST_BILLG_SUB_CLASS
 * JNT_INTRST_BILLG_SUB_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProjectJVA#TO_ENTERPRISE_PROJECT
 * TO_ENTERPRISE_PROJECT}</li>
 * </ul>
 *
 */
public interface EnterpriseProjectJVASelectable extends EntitySelectable<EnterpriseProjectJVA>
{

}
