/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject EnterpriseProject}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.field.EnterpriseProjectField
 * EnterpriseProjectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.link.EnterpriseProjectLink
 * EnterpriseProjectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#CHANGE_ENT_PROJ_PROCG_STATUS_AC
 * CHANGE_ENT_PROJ_PROCG_STATUS_AC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ACTUAL_END_DATE_FC
 * ACTUAL_END_DATE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ACTUAL_START_DATE_FC
 * ACTUAL_START_DATE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#AVAILABILITY_CONTROL_IS_ACTIVE_FC
 * AVAILABILITY_CONTROL_IS_ACTIVE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#AVAILABILITY_CONTROL_PROFILE_FC
 * AVAILABILITY_CONTROL_PROFILE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#CONTROLLING_AREA_FC
 * CONTROLLING_AREA_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#COSTING_SHEET_FC
 * COSTING_SHEET_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ENTERPRISE_PROJECT_TYPE_FC
 * ENTERPRISE_PROJECT_TYPE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ENT_PROJ_IS_MULTI_SLS_ORD_ITMS_ENBLD_FC
 * ENT_PROJ_IS_MULTI_SLS_ORD_ITMS_ENBLD_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#FUNCTIONAL_AREA_FC
 * FUNCTIONAL_AREA_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#FUNCTIONAL_LOCATION_FC
 * FUNCTIONAL_LOCATION_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#INVESTMENT_PROFILE_FC
 * INVESTMENT_PROFILE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#IS_BILLING_RELEVANT_FC
 * IS_BILLING_RELEVANT_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#LOCATION_FC
 * LOCATION_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PLANT_FC
 * PLANT_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PRIORITY_CODE_FC
 * PRIORITY_CODE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROFIT_CENTER_FC
 * PROFIT_CENTER_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_FC
 * PROJECT_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_CURRENCY_FC
 * PROJECT_CURRENCY_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_DESCRIPTION_FC
 * PROJECT_DESCRIPTION_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_END_DATE_FC
 * PROJECT_END_DATE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_PROFILE_CODE_FC
 * PROJECT_PROFILE_CODE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_START_DATE_FC
 * PROJECT_START_DATE_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#RESPONSIBLE_COST_CENTER_FC
 * RESPONSIBLE_COST_CENTER_FC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ENTERPRISE_PROJECT_ELEMENT_OC
 * ENTERPRISE_PROJECT_ELEMENT_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ENT_PROJ_BLK_FUNC_OC
 * ENT_PROJ_BLK_FUNC_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ENT_PROJ_ROLE_OC
 * ENT_PROJ_ROLE_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ENT_PROJ_TEAM_MEMBER_OC
 * ENT_PROJ_TEAM_MEMBER_OC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_UUID
 * PROJECT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_INTERNAL_ID
 * PROJECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT
 * PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_DESCRIPTION
 * PROJECT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ENTERPRISE_PROJECT_TYPE
 * ENTERPRISE_PROJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PRIORITY_CODE
 * PRIORITY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_START_DATE
 * PROJECT_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_END_DATE
 * PROJECT_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ACTUAL_START_DATE
 * ACTUAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ACTUAL_END_DATE
 * ACTUAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#CUSTOMER_UUID
 * CUSTOMER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ENTERPRISE_PROJECT_SERVICE_ORG
 * ENTERPRISE_PROJECT_SERVICE_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ENT_PROJECT_IS_CONFIDENTIAL
 * ENT_PROJECT_IS_CONFIDENTIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#RESTRICTED_TIME_POSTING
 * RESTRICTED_TIME_POSTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROCESSING_STATUS
 * PROCESSING_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#RESPONSIBLE_COST_CENTER
 * RESPONSIBLE_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_PROFILE_CODE
 * PROJECT_PROFILE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#LOCATION
 * LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_CURRENCY
 * PROJECT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#AVAILABILITY_CONTROL_PROFILE
 * AVAILABILITY_CONTROL_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#AVAILABILITY_CONTROL_IS_ACTIVE
 * AVAILABILITY_CONTROL_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#IS_BILLING_RELEVANT
 * IS_BILLING_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#INVESTMENT_PROFILE
 * INVESTMENT_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#PROJECT_LAST_CHANGED_DATE_TIME
 * PROJECT_LAST_CHANGED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#ENT_PROJ_IS_MULTI_SLS_ORD_ITMS_ENBLD
 * ENT_PROJ_IS_MULTI_SLS_ORD_ITMS_ENBLD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#COSTING_SHEET
 * COSTING_SHEET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#TO_ENTERPRISE_PROJECT_ELEMENT
 * TO_ENTERPRISE_PROJECT_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#TO_ENTERPRISE_PROJECT_JVA
 * TO_ENTERPRISE_PROJECT_JVA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#TO_ENT_PROJ_BLK_FUNC
 * TO_ENT_PROJ_BLK_FUNC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#TO_ENT_PROJECT_PUBLIC_SECTOR
 * TO_ENT_PROJECT_PUBLIC_SECTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#TO_ENT_PROJ_ROLE
 * TO_ENT_PROJ_ROLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseprojectv2.EnterpriseProject#TO_ENT_PROJ_TEAM_MEMBER
 * TO_ENT_PROJ_TEAM_MEMBER}</li>
 * </ul>
 *
 */
public interface EnterpriseProjectSelectable extends EntitySelectable<EnterpriseProject>
{

}
