/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipClassCharacteristicValueField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipClassCharacteristicValueOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable.EquipClassCharacteristicValueSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Equipment Characteristic Values
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EquipClassCharacteristicValueType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EquipClassCharacteristicValue extends VdmEntity<EquipClassCharacteristicValue>
{

    /**
     * Selector for all available fields of EquipClassCharacteristicValue.
     *
     */
    public final static EquipClassCharacteristicValueSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> EQUIPMENT =
        new EquipClassCharacteristicValueField<String>("Equipment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @Key
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CLASS_TYPE =
        new EquipClassCharacteristicValueField<String>("ClassType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValuePositionNumber</b>
     * </p>
     *
     * @return Characteristic value counter
     */
    @Key
    @SerializedName( "CharcValuePositionNumber" )
    @JsonProperty( "CharcValuePositionNumber" )
    @Nullable
    @ODataField( odataName = "CharcValuePositionNumber" )
    private String charcValuePositionNumber;
    /**
     * Use with available fluent helpers to apply the <b>CharcValuePositionNumber</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CHARC_VALUE_POSITION_NUMBER =
        new EquipClassCharacteristicValueField<String>("CharcValuePositionNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharacteristicInternalID" )
    @JsonProperty( "CharacteristicInternalID" )
    @Nullable
    @ODataField( odataName = "CharacteristicInternalID" )
    private String characteristicInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicInternalID</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CHARACTERISTIC_INTERNAL_ID =
        new EquipClassCharacteristicValueField<String>("CharacteristicInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "Characteristic" )
    @JsonProperty( "Characteristic" )
    @Nullable
    @ODataField( odataName = "Characteristic" )
    private String characteristic;
    /**
     * Use with available fluent helpers to apply the <b>Characteristic</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CHARACTERISTIC =
        new EquipClassCharacteristicValueField<String>("Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @return Data type of characteristic
     */
    @SerializedName( "CharcDataType" )
    @JsonProperty( "CharcDataType" )
    @Nullable
    @ODataField( odataName = "CharcDataType" )
    private String charcDataType;
    /**
     * Use with available fluent helpers to apply the <b>CharcDataType</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CHARC_DATA_TYPE =
        new EquipClassCharacteristicValueField<String>("CharcDataType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CLASS_INTERNAL_ID =
        new EquipClassCharacteristicValueField<String>("ClassInternalID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return The keyDate contained in this entity.
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<LocalDateTime> KEY_DATE =
        new EquipClassCharacteristicValueField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CHANGE_NUMBER =
        new EquipClassCharacteristicValueField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueDependency</b>
     * </p>
     *
     * @return Code for value dependency
     */
    @SerializedName( "CharcValueDependency" )
    @JsonProperty( "CharcValueDependency" )
    @Nullable
    @ODataField( odataName = "CharcValueDependency" )
    private String charcValueDependency;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueDependency</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CHARC_VALUE_DEPENDENCY =
        new EquipClassCharacteristicValueField<String>("CharcValueDependency");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @return Characteristic Value
     */
    @SerializedName( "CharcValue" )
    @JsonProperty( "CharcValue" )
    @Nullable
    @ODataField( odataName = "CharcValue" )
    private String charcValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcValue</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CHARC_VALUE =
        new EquipClassCharacteristicValueField<String>("CharcValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValue</b>
     * </p>
     *
     * @return Internal floating point from
     */
    @SerializedName( "CharcFromNumericValue" )
    @JsonProperty( "CharcFromNumericValue" )
    @Nullable
    @ODataField( odataName = "CharcFromNumericValue" )
    private Double charcFromNumericValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromNumericValue</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<Double> CHARC_FROM_NUMERIC_VALUE =
        new EquipClassCharacteristicValueField<Double>("CharcFromNumericValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcFromNumericValueUnit" )
    @JsonProperty( "CharcFromNumericValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcFromNumericValueUnit" )
    private String charcFromNumericValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromNumericValueUnit</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CHARC_FROM_NUMERIC_VALUE_UNIT =
        new EquipClassCharacteristicValueField<String>("CharcFromNumericValueUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValue</b>
     * </p>
     *
     * @return Internal floating point value to
     */
    @SerializedName( "CharcToNumericValue" )
    @JsonProperty( "CharcToNumericValue" )
    @Nullable
    @ODataField( odataName = "CharcToNumericValue" )
    private Double charcToNumericValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcToNumericValue</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<Double> CHARC_TO_NUMERIC_VALUE =
        new EquipClassCharacteristicValueField<Double>("CharcToNumericValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcToNumericValueUnit" )
    @JsonProperty( "CharcToNumericValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcToNumericValueUnit" )
    private String charcToNumericValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcToNumericValueUnit</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CHARC_TO_NUMERIC_VALUE_UNIT =
        new EquipClassCharacteristicValueField<String>("CharcToNumericValueUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDecimalValue</b>
     * </p>
     *
     * @return Lower Boundary for Numeric Field
     */
    @SerializedName( "CharcFromDecimalValue" )
    @JsonProperty( "CharcFromDecimalValue" )
    @Nullable
    @ODataField( odataName = "CharcFromDecimalValue" )
    private BigDecimal charcFromDecimalValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromDecimalValue</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<BigDecimal> CHARC_FROM_DECIMAL_VALUE =
        new EquipClassCharacteristicValueField<BigDecimal>("CharcFromDecimalValue");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDecimalValue</b>
     * </p>
     *
     * @return Upper Boundary for Numeric Field
     */
    @SerializedName( "CharcToDecimalValue" )
    @JsonProperty( "CharcToDecimalValue" )
    @Nullable
    @ODataField( odataName = "CharcToDecimalValue" )
    private BigDecimal charcToDecimalValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcToDecimalValue</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<BigDecimal> CHARC_TO_DECIMAL_VALUE =
        new EquipClassCharacteristicValueField<BigDecimal>("CharcToDecimalValue");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromAmount</b>
     * </p>
     *
     * @return Lower Boundary for Currency Field
     */
    @SerializedName( "CharcFromAmount" )
    @JsonProperty( "CharcFromAmount" )
    @Nullable
    @ODataField( odataName = "CharcFromAmount" )
    private BigDecimal charcFromAmount;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromAmount</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<BigDecimal> CHARC_FROM_AMOUNT =
        new EquipClassCharacteristicValueField<BigDecimal>("CharcFromAmount");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToAmount</b>
     * </p>
     *
     * @return Upper Boundary for Currency Field
     */
    @SerializedName( "CharcToAmount" )
    @JsonProperty( "CharcToAmount" )
    @Nullable
    @ODataField( odataName = "CharcToAmount" )
    private BigDecimal charcToAmount;
    /**
     * Use with available fluent helpers to apply the <b>CharcToAmount</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<BigDecimal> CHARC_TO_AMOUNT =
        new EquipClassCharacteristicValueField<BigDecimal>("CharcToAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<String> CURRENCY =
        new EquipClassCharacteristicValueField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDate</b>
     * </p>
     *
     * @return Lower Boundary for Date-Interval
     */
    @SerializedName( "CharcFromDate" )
    @JsonProperty( "CharcFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcFromDate;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromDate</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<LocalDateTime> CHARC_FROM_DATE =
        new EquipClassCharacteristicValueField<LocalDateTime>("CharcFromDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDate</b>
     * </p>
     *
     * @return Upper Boundary for Date-Interval
     */
    @SerializedName( "CharcToDate" )
    @JsonProperty( "CharcToDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcToDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcToDate;
    /**
     * Use with available fluent helpers to apply the <b>CharcToDate</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<LocalDateTime> CHARC_TO_DATE =
        new EquipClassCharacteristicValueField<LocalDateTime>("CharcToDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromTime</b>
     * </p>
     *
     * @return Lower Boundary for Time-Interval
     */
    @SerializedName( "CharcFromTime" )
    @JsonProperty( "CharcFromTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CharcFromTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime charcFromTime;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromTime</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<LocalTime> CHARC_FROM_TIME =
        new EquipClassCharacteristicValueField<LocalTime>("CharcFromTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToTime</b>
     * </p>
     *
     * @return Upper Boundary for Time-Interval
     */
    @SerializedName( "CharcToTime" )
    @JsonProperty( "CharcToTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CharcToTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime charcToTime;
    /**
     * Use with available fluent helpers to apply the <b>CharcToTime</b> field to query operations.
     *
     */
    public final static EquipClassCharacteristicValueField<LocalTime> CHARC_TO_TIME =
        new EquipClassCharacteristicValueField<LocalTime>("CharcToTime");
    /**
     * Navigation property <b>to_Equipment</b> for <b>EquipClassCharacteristicValue</b> to single <b>Equipment</b>.
     *
     */
    @SerializedName( "to_Equipment" )
    @JsonProperty( "to_Equipment" )
    @ODataField( odataName = "to_Equipment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Equipment toEquipment;
    /**
     * Navigation property <b>to_Characteristic</b> for <b>EquipClassCharacteristicValue</b> to single
     * <b>EquipmentClassCharacteristic</b>.
     *
     */
    @SerializedName( "to_Characteristic" )
    @JsonProperty( "to_Characteristic" )
    @ODataField( odataName = "to_Characteristic" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EquipmentClassCharacteristic toCharacteristic;
    /**
     * Use with available fluent helpers to apply the <b>to_Equipment</b> navigation property to query operations.
     *
     */
    public final static EquipClassCharacteristicValueOneToOneLink<Equipment> TO_EQUIPMENT =
        new EquipClassCharacteristicValueOneToOneLink<Equipment>("to_Equipment");
    /**
     * Use with available fluent helpers to apply the <b>to_Characteristic</b> navigation property to query operations.
     *
     */
    public final static EquipClassCharacteristicValueOneToOneLink<EquipmentClassCharacteristic> TO_CHARACTERISTIC =
        new EquipClassCharacteristicValueOneToOneLink<EquipmentClassCharacteristic>("to_Characteristic");

    @Nonnull
    @Override
    public Class<EquipClassCharacteristicValue> getType()
    {
        return EquipClassCharacteristicValue.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValuePositionNumber</b>
     * </p>
     *
     * @param charcValuePositionNumber
     *            Characteristic value counter
     */
    public void setCharcValuePositionNumber( @Nullable final String charcValuePositionNumber )
    {
        rememberChangedField("CharcValuePositionNumber", this.charcValuePositionNumber);
        this.charcValuePositionNumber = charcValuePositionNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicInternalID</b>
     * </p>
     *
     * @param characteristicInternalID
     *            Characteristic Internal ID
     */
    public void setCharacteristicInternalID( @Nullable final String characteristicInternalID )
    {
        rememberChangedField("CharacteristicInternalID", this.characteristicInternalID);
        this.characteristicInternalID = characteristicInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @param charcDataType
     *            Data type of characteristic
     */
    public void setCharcDataType( @Nullable final String charcDataType )
    {
        rememberChangedField("CharcDataType", this.charcDataType);
        this.charcDataType = charcDataType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            The keyDate to set.
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueDependency</b>
     * </p>
     *
     * @param charcValueDependency
     *            Code for value dependency
     */
    public void setCharcValueDependency( @Nullable final String charcValueDependency )
    {
        rememberChangedField("CharcValueDependency", this.charcValueDependency);
        this.charcValueDependency = charcValueDependency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @param charcValue
     *            Characteristic Value
     */
    public void setCharcValue( @Nullable final String charcValue )
    {
        rememberChangedField("CharcValue", this.charcValue);
        this.charcValue = charcValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValue</b>
     * </p>
     *
     * @param charcFromNumericValue
     *            Internal floating point from
     */
    public void setCharcFromNumericValue( @Nullable final Double charcFromNumericValue )
    {
        rememberChangedField("CharcFromNumericValue", this.charcFromNumericValue);
        this.charcFromNumericValue = charcFromNumericValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValueUnit</b>
     * </p>
     *
     * @param charcFromNumericValueUnit
     *            Unit of Measurement
     */
    public void setCharcFromNumericValueUnit( @Nullable final String charcFromNumericValueUnit )
    {
        rememberChangedField("CharcFromNumericValueUnit", this.charcFromNumericValueUnit);
        this.charcFromNumericValueUnit = charcFromNumericValueUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValue</b>
     * </p>
     *
     * @param charcToNumericValue
     *            Internal floating point value to
     */
    public void setCharcToNumericValue( @Nullable final Double charcToNumericValue )
    {
        rememberChangedField("CharcToNumericValue", this.charcToNumericValue);
        this.charcToNumericValue = charcToNumericValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValueUnit</b>
     * </p>
     *
     * @param charcToNumericValueUnit
     *            Unit of Measurement
     */
    public void setCharcToNumericValueUnit( @Nullable final String charcToNumericValueUnit )
    {
        rememberChangedField("CharcToNumericValueUnit", this.charcToNumericValueUnit);
        this.charcToNumericValueUnit = charcToNumericValueUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDecimalValue</b>
     * </p>
     *
     * @param charcFromDecimalValue
     *            Lower Boundary for Numeric Field
     */
    public void setCharcFromDecimalValue( @Nullable final BigDecimal charcFromDecimalValue )
    {
        rememberChangedField("CharcFromDecimalValue", this.charcFromDecimalValue);
        this.charcFromDecimalValue = charcFromDecimalValue;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDecimalValue</b>
     * </p>
     *
     * @param charcToDecimalValue
     *            Upper Boundary for Numeric Field
     */
    public void setCharcToDecimalValue( @Nullable final BigDecimal charcToDecimalValue )
    {
        rememberChangedField("CharcToDecimalValue", this.charcToDecimalValue);
        this.charcToDecimalValue = charcToDecimalValue;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromAmount</b>
     * </p>
     *
     * @param charcFromAmount
     *            Lower Boundary for Currency Field
     */
    public void setCharcFromAmount( @Nullable final BigDecimal charcFromAmount )
    {
        rememberChangedField("CharcFromAmount", this.charcFromAmount);
        this.charcFromAmount = charcFromAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToAmount</b>
     * </p>
     *
     * @param charcToAmount
     *            Upper Boundary for Currency Field
     */
    public void setCharcToAmount( @Nullable final BigDecimal charcToAmount )
    {
        rememberChangedField("CharcToAmount", this.charcToAmount);
        this.charcToAmount = charcToAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDate</b>
     * </p>
     *
     * @param charcFromDate
     *            Lower Boundary for Date-Interval
     */
    public void setCharcFromDate( @Nullable final LocalDateTime charcFromDate )
    {
        rememberChangedField("CharcFromDate", this.charcFromDate);
        this.charcFromDate = charcFromDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDate</b>
     * </p>
     *
     * @param charcToDate
     *            Upper Boundary for Date-Interval
     */
    public void setCharcToDate( @Nullable final LocalDateTime charcToDate )
    {
        rememberChangedField("CharcToDate", this.charcToDate);
        this.charcToDate = charcToDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromTime</b>
     * </p>
     *
     * @param charcFromTime
     *            Lower Boundary for Time-Interval
     */
    public void setCharcFromTime( @Nullable final LocalTime charcFromTime )
    {
        rememberChangedField("CharcFromTime", this.charcFromTime);
        this.charcFromTime = charcFromTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToTime</b>
     * </p>
     *
     * @param charcToTime
     *            Upper Boundary for Time-Interval
     */
    public void setCharcToTime( @Nullable final LocalTime charcToTime )
    {
        rememberChangedField("CharcToTime", this.charcToTime);
        this.charcToTime = charcToTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "EquipClassCharacteristicValue";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Equipment", getEquipment());
        result.put("ClassType", getClassType());
        result.put("CharcValuePositionNumber", getCharcValuePositionNumber());
        result.put("CharacteristicInternalID", getCharacteristicInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Equipment", getEquipment());
        values.put("ClassType", getClassType());
        values.put("CharcValuePositionNumber", getCharcValuePositionNumber());
        values.put("CharacteristicInternalID", getCharacteristicInternalID());
        values.put("Characteristic", getCharacteristic());
        values.put("CharcDataType", getCharcDataType());
        values.put("ClassInternalID", getClassInternalID());
        values.put("KeyDate", getKeyDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("CharcValueDependency", getCharcValueDependency());
        values.put("CharcValue", getCharcValue());
        values.put("CharcFromNumericValue", getCharcFromNumericValue());
        values.put("CharcFromNumericValueUnit", getCharcFromNumericValueUnit());
        values.put("CharcToNumericValue", getCharcToNumericValue());
        values.put("CharcToNumericValueUnit", getCharcToNumericValueUnit());
        values.put("CharcFromDecimalValue", getCharcFromDecimalValue());
        values.put("CharcToDecimalValue", getCharcToDecimalValue());
        values.put("CharcFromAmount", getCharcFromAmount());
        values.put("CharcToAmount", getCharcToAmount());
        values.put("Currency", getCurrency());
        values.put("CharcFromDate", getCharcFromDate());
        values.put("CharcToDate", getCharcToDate());
        values.put("CharcFromTime", getCharcFromTime());
        values.put("CharcToTime", getCharcToTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("CharcValuePositionNumber") ) {
                final Object value = values.remove("CharcValuePositionNumber");
                if( (value == null) || (!value.equals(getCharcValuePositionNumber())) ) {
                    setCharcValuePositionNumber(((String) value));
                }
            }
            if( values.containsKey("CharacteristicInternalID") ) {
                final Object value = values.remove("CharacteristicInternalID");
                if( (value == null) || (!value.equals(getCharacteristicInternalID())) ) {
                    setCharacteristicInternalID(((String) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((String) value));
                }
            }
            if( values.containsKey("CharcDataType") ) {
                final Object value = values.remove("CharcDataType");
                if( (value == null) || (!value.equals(getCharcDataType())) ) {
                    setCharcDataType(((String) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("CharcValueDependency") ) {
                final Object value = values.remove("CharcValueDependency");
                if( (value == null) || (!value.equals(getCharcValueDependency())) ) {
                    setCharcValueDependency(((String) value));
                }
            }
            if( values.containsKey("CharcValue") ) {
                final Object value = values.remove("CharcValue");
                if( (value == null) || (!value.equals(getCharcValue())) ) {
                    setCharcValue(((String) value));
                }
            }
            if( values.containsKey("CharcFromNumericValue") ) {
                final Object value = values.remove("CharcFromNumericValue");
                if( (value == null) || (!value.equals(getCharcFromNumericValue())) ) {
                    setCharcFromNumericValue(((Double) value));
                }
            }
            if( values.containsKey("CharcFromNumericValueUnit") ) {
                final Object value = values.remove("CharcFromNumericValueUnit");
                if( (value == null) || (!value.equals(getCharcFromNumericValueUnit())) ) {
                    setCharcFromNumericValueUnit(((String) value));
                }
            }
            if( values.containsKey("CharcToNumericValue") ) {
                final Object value = values.remove("CharcToNumericValue");
                if( (value == null) || (!value.equals(getCharcToNumericValue())) ) {
                    setCharcToNumericValue(((Double) value));
                }
            }
            if( values.containsKey("CharcToNumericValueUnit") ) {
                final Object value = values.remove("CharcToNumericValueUnit");
                if( (value == null) || (!value.equals(getCharcToNumericValueUnit())) ) {
                    setCharcToNumericValueUnit(((String) value));
                }
            }
            if( values.containsKey("CharcFromDecimalValue") ) {
                final Object value = values.remove("CharcFromDecimalValue");
                if( (value == null) || (!value.equals(getCharcFromDecimalValue())) ) {
                    setCharcFromDecimalValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcToDecimalValue") ) {
                final Object value = values.remove("CharcToDecimalValue");
                if( (value == null) || (!value.equals(getCharcToDecimalValue())) ) {
                    setCharcToDecimalValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcFromAmount") ) {
                final Object value = values.remove("CharcFromAmount");
                if( (value == null) || (!value.equals(getCharcFromAmount())) ) {
                    setCharcFromAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcToAmount") ) {
                final Object value = values.remove("CharcToAmount");
                if( (value == null) || (!value.equals(getCharcToAmount())) ) {
                    setCharcToAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("CharcFromDate") ) {
                final Object value = values.remove("CharcFromDate");
                if( (value == null) || (!value.equals(getCharcFromDate())) ) {
                    setCharcFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcToDate") ) {
                final Object value = values.remove("CharcToDate");
                if( (value == null) || (!value.equals(getCharcToDate())) ) {
                    setCharcToDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcFromTime") ) {
                final Object value = values.remove("CharcFromTime");
                if( (value == null) || (!value.equals(getCharcFromTime())) ) {
                    setCharcFromTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CharcToTime") ) {
                final Object value = values.remove("CharcToTime");
                if( (value == null) || (!value.equals(getCharcToTime())) ) {
                    setCharcToTime(((LocalTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Equipment") ) {
                final Object value = (values).remove("to_Equipment");
                if( value instanceof Map ) {
                    if( toEquipment == null ) {
                        toEquipment = new Equipment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEquipment.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Characteristic") ) {
                final Object value = (values).remove("to_Characteristic");
                if( value instanceof Map ) {
                    if( toCharacteristic == null ) {
                        toCharacteristic = new EquipmentClassCharacteristic();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCharacteristic.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> EquipClassCharacteristicValueField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new EquipClassCharacteristicValueField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EquipClassCharacteristicValueField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EquipClassCharacteristicValueField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EquipmentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEquipment != null ) {
            (values).put("to_Equipment", toEquipment);
        }
        if( toCharacteristic != null ) {
            (values).put("to_Characteristic", toCharacteristic);
        }
        return values;
    }

    /**
     * Fetches the <b>Equipment</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Equipment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Equipment</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Equipment fetchEquipment()
    {
        return fetchFieldAsSingle("to_Equipment", Equipment.class);
    }

    /**
     * Retrieval of associated <b>Equipment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Equipment</b>.
     * <p>
     * If the navigation property <b>to_Equipment</b> of a queried <b>EquipClassCharacteristicValue</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Equipment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Equipment getEquipmentOrFetch()
    {
        if( toEquipment == null ) {
            toEquipment = fetchEquipment();
        }
        return toEquipment;
    }

    /**
     * Retrieval of associated <b>Equipment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Equipment</b>.
     * <p>
     * If the navigation property for an entity <b>EquipClassCharacteristicValue</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Equipment</b> is already loaded, the result will contain
     *         the <b>Equipment</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Equipment> getEquipmentIfPresent()
    {
        return Option.of(toEquipment);
    }

    /**
     * Overwrites the associated <b>Equipment</b> entity for the loaded navigation property <b>to_Equipment</b>.
     *
     * @param value
     *            New <b>Equipment</b> entity.
     */
    public void setEquipment( final Equipment value )
    {
        toEquipment = value;
    }

    /**
     * Fetches the <b>EquipmentClassCharacteristic</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Characteristic</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EquipmentClassCharacteristic</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EquipmentClassCharacteristic fetchCharacteristic()
    {
        return fetchFieldAsSingle("to_Characteristic", EquipmentClassCharacteristic.class);
    }

    /**
     * Retrieval of associated <b>EquipmentClassCharacteristic</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Characteristic</b>.
     * <p>
     * If the navigation property <b>to_Characteristic</b> of a queried <b>EquipClassCharacteristicValue</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EquipmentClassCharacteristic</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EquipmentClassCharacteristic getCharacteristicOrFetch()
    {
        if( toCharacteristic == null ) {
            toCharacteristic = fetchCharacteristic();
        }
        return toCharacteristic;
    }

    /**
     * Retrieval of associated <b>EquipmentClassCharacteristic</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Characteristic</b>.
     * <p>
     * If the navigation property for an entity <b>EquipClassCharacteristicValue</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Characteristic</b> is already loaded, the result will
     *         contain the <b>EquipmentClassCharacteristic</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EquipmentClassCharacteristic> getCharacteristicIfPresent()
    {
        return Option.of(toCharacteristic);
    }

    /**
     * Overwrites the associated <b>EquipmentClassCharacteristic</b> entity for the loaded navigation property
     * <b>to_Characteristic</b>.
     *
     * @param value
     *            New <b>EquipmentClassCharacteristic</b> entity.
     */
    public void setCharacteristic( final EquipmentClassCharacteristic value )
    {
        toCharacteristic = value;
    }

    /**
     * Helper class to allow for fluent creation of EquipClassCharacteristicValue instances.
     *
     */
    public final static class EquipClassCharacteristicValueBuilder
    {

        private Equipment toEquipment;
        private String equipment = null;
        private EquipmentClassCharacteristic toCharacteristic;
        private String characteristic = null;

        private EquipClassCharacteristicValue.EquipClassCharacteristicValueBuilder toEquipment( final Equipment value )
        {
            toEquipment = value;
            return this;
        }

        /**
         * Navigation property <b>to_Equipment</b> for <b>EquipClassCharacteristicValue</b> to single <b>Equipment</b>.
         *
         * @param value
         *            The Equipment to build this EquipClassCharacteristicValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipClassCharacteristicValue.EquipClassCharacteristicValueBuilder equipment( final Equipment value )
        {
            return toEquipment(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 18
         * <p>
         * Original property name from the Odata EDM: <b>Equipment</b>
         * </p>
         *
         * @param value
         *            The equipment to build this EquipClassCharacteristicValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipClassCharacteristicValue.EquipClassCharacteristicValueBuilder equipment( final String value )
        {
            equipment = value;
            return this;
        }

        private EquipClassCharacteristicValue.EquipClassCharacteristicValueBuilder toCharacteristic(
            final EquipmentClassCharacteristic value )
        {
            toCharacteristic = value;
            return this;
        }

        /**
         * Navigation property <b>to_Characteristic</b> for <b>EquipClassCharacteristicValue</b> to single
         * <b>EquipmentClassCharacteristic</b>.
         *
         * @param value
         *            The EquipmentClassCharacteristic to build this EquipClassCharacteristicValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipClassCharacteristicValue.EquipClassCharacteristicValueBuilder characteristic(
            final EquipmentClassCharacteristic value )
        {
            return toCharacteristic(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 30
         * <p>
         * Original property name from the Odata EDM: <b>Characteristic</b>
         * </p>
         *
         * @param value
         *            The characteristic to build this EquipClassCharacteristicValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipClassCharacteristicValue.EquipClassCharacteristicValueBuilder characteristic( final String value )
        {
            characteristic = value;
            return this;
        }

    }

}
