/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable.EquipmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Equipment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EquipmentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Equipment extends VdmEntity<Equipment>
{

    /**
     * Selector for all available fields of Equipment.
     *
     */
    public final static EquipmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static EquipmentField<String> EQUIPMENT = new EquipmentField<String>("Equipment");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static EquipmentField<LocalDateTime> VALIDITY_END_DATE =
        new EquipmentField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndTime</b>
     * </p>
     *
     * @return Equipment usage period time stamp
     */
    @SerializedName( "ValidityEndTime" )
    @JsonProperty( "ValidityEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime validityEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndTime</b> field to query operations.
     *
     */
    public final static EquipmentField<LocalTime> VALIDITY_END_TIME = new EquipmentField<LocalTime>("ValidityEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentValidityEndDateTime</b>
     * </p>
     *
     * @return The equipmentValidityEndDateTime contained in this entity.
     */
    @SerializedName( "EquipmentValidityEndDateTime" )
    @JsonProperty( "EquipmentValidityEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "EquipmentValidityEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime equipmentValidityEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentValidityEndDateTime</b> field to query operations.
     *
     */
    public final static EquipmentField<ZonedDateTime> EQUIPMENT_VALIDITY_END_DATE_TIME =
        new EquipmentField<ZonedDateTime>("EquipmentValidityEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static EquipmentField<LocalDateTime> VALIDITY_START_DATE =
        new EquipmentField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentOID</b>
     * </p>
     *
     * @return Object Instance ID of an Equipment
     */
    @SerializedName( "EquipmentOID" )
    @JsonProperty( "EquipmentOID" )
    @Nullable
    @ODataField( odataName = "EquipmentOID" )
    private String equipmentOID;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentOID</b> field to query operations.
     *
     */
    public final static EquipmentField<String> EQUIPMENT_OID = new EquipmentField<String>("EquipmentOID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentName</b>
     * </p>
     *
     * @return Description of technical object
     */
    @SerializedName( "EquipmentName" )
    @JsonProperty( "EquipmentName" )
    @Nullable
    @ODataField( odataName = "EquipmentName" )
    private String equipmentName;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentName</b> field to query operations.
     *
     */
    public final static EquipmentField<String> EQUIPMENT_NAME = new EquipmentField<String>("EquipmentName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentCategory</b>
     * </p>
     *
     * @return Equipment category
     */
    @SerializedName( "EquipmentCategory" )
    @JsonProperty( "EquipmentCategory" )
    @Nullable
    @ODataField( odataName = "EquipmentCategory" )
    private String equipmentCategory;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentCategory</b> field to query operations.
     *
     */
    public final static EquipmentField<String> EQUIPMENT_CATEGORY = new EquipmentField<String>("EquipmentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     *
     * @return Type of Technical Object
     */
    @SerializedName( "TechnicalObjectType" )
    @JsonProperty( "TechnicalObjectType" )
    @Nullable
    @ODataField( odataName = "TechnicalObjectType" )
    private String technicalObjectType;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObjectType</b> field to query operations.
     *
     */
    public final static EquipmentField<String> TECHNICAL_OBJECT_TYPE =
        new EquipmentField<String>("TechnicalObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Technical Object Authorization Group
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static EquipmentField<String> AUTHORIZATION_GROUP = new EquipmentField<String>("AuthorizationGroup");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     *
     * @return Weight of object
     */
    @SerializedName( "GrossWeight" )
    @JsonProperty( "GrossWeight" )
    @Nullable
    @ODataField( odataName = "GrossWeight" )
    private BigDecimal grossWeight;
    /**
     * Use with available fluent helpers to apply the <b>GrossWeight</b> field to query operations.
     *
     */
    public final static EquipmentField<BigDecimal> GROSS_WEIGHT = new EquipmentField<BigDecimal>("GrossWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeightUnit</b>
     * </p>
     *
     * @return Unit of weight
     */
    @SerializedName( "GrossWeightUnit" )
    @JsonProperty( "GrossWeightUnit" )
    @Nullable
    @ODataField( odataName = "GrossWeightUnit" )
    private String grossWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>GrossWeightUnit</b> field to query operations.
     *
     */
    public final static EquipmentField<String> GROSS_WEIGHT_UNIT = new EquipmentField<String>("GrossWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SizeOrDimensionText</b>
     * </p>
     *
     * @return Size/dimension
     */
    @SerializedName( "SizeOrDimensionText" )
    @JsonProperty( "SizeOrDimensionText" )
    @Nullable
    @ODataField( odataName = "SizeOrDimensionText" )
    private String sizeOrDimensionText;
    /**
     * Use with available fluent helpers to apply the <b>SizeOrDimensionText</b> field to query operations.
     *
     */
    public final static EquipmentField<String> SIZE_OR_DIMENSION_TEXT =
        new EquipmentField<String>("SizeOrDimensionText");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>InventoryNumber</b>
     * </p>
     *
     * @return Inventory number
     */
    @SerializedName( "InventoryNumber" )
    @JsonProperty( "InventoryNumber" )
    @Nullable
    @ODataField( odataName = "InventoryNumber" )
    private String inventoryNumber;
    /**
     * Use with available fluent helpers to apply the <b>InventoryNumber</b> field to query operations.
     *
     */
    public final static EquipmentField<String> INVENTORY_NUMBER = new EquipmentField<String>("InventoryNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationStartDate</b>
     * </p>
     *
     * @return Start-up Date of the Technical Object
     */
    @SerializedName( "OperationStartDate" )
    @JsonProperty( "OperationStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OperationStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime operationStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationStartDate</b> field to query operations.
     *
     */
    public final static EquipmentField<LocalDateTime> OPERATION_START_DATE =
        new EquipmentField<LocalDateTime>("OperationStartDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AcquisitionValue</b>
     * </p>
     *
     * @return Acquisition Value
     */
    @SerializedName( "AcquisitionValue" )
    @JsonProperty( "AcquisitionValue" )
    @Nullable
    @ODataField( odataName = "AcquisitionValue" )
    private BigDecimal acquisitionValue;
    /**
     * Use with available fluent helpers to apply the <b>AcquisitionValue</b> field to query operations.
     *
     */
    public final static EquipmentField<BigDecimal> ACQUISITION_VALUE =
        new EquipmentField<BigDecimal>("AcquisitionValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static EquipmentField<String> CURRENCY = new EquipmentField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AcquisitionDate</b>
     * </p>
     *
     * @return Acquisition date
     */
    @SerializedName( "AcquisitionDate" )
    @JsonProperty( "AcquisitionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "AcquisitionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime acquisitionDate;
    /**
     * Use with available fluent helpers to apply the <b>AcquisitionDate</b> field to query operations.
     *
     */
    public final static EquipmentField<LocalDateTime> ACQUISITION_DATE =
        new EquipmentField<LocalDateTime>("AcquisitionDate");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AssetManufacturerName</b>
     * </p>
     *
     * @return Manufacturer of asset
     */
    @SerializedName( "AssetManufacturerName" )
    @JsonProperty( "AssetManufacturerName" )
    @Nullable
    @ODataField( odataName = "AssetManufacturerName" )
    private String assetManufacturerName;
    /**
     * Use with available fluent helpers to apply the <b>AssetManufacturerName</b> field to query operations.
     *
     */
    public final static EquipmentField<String> ASSET_MANUFACTURER_NAME =
        new EquipmentField<String>("AssetManufacturerName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartTypeName</b>
     * </p>
     *
     * @return Manufacturer model number
     */
    @SerializedName( "ManufacturerPartTypeName" )
    @JsonProperty( "ManufacturerPartTypeName" )
    @Nullable
    @ODataField( odataName = "ManufacturerPartTypeName" )
    private String manufacturerPartTypeName;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerPartTypeName</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MANUFACTURER_PART_TYPE_NAME =
        new EquipmentField<String>("ManufacturerPartTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerCountry</b>
     * </p>
     *
     * @return Country/Region of Manufacture
     */
    @SerializedName( "ManufacturerCountry" )
    @JsonProperty( "ManufacturerCountry" )
    @Nullable
    @ODataField( odataName = "ManufacturerCountry" )
    private String manufacturerCountry;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerCountry</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MANUFACTURER_COUNTRY = new EquipmentField<String>("ManufacturerCountry");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConstructionYear</b>
     * </p>
     *
     * @return Year of construction
     */
    @SerializedName( "ConstructionYear" )
    @JsonProperty( "ConstructionYear" )
    @Nullable
    @ODataField( odataName = "ConstructionYear" )
    private String constructionYear;
    /**
     * Use with available fluent helpers to apply the <b>ConstructionYear</b> field to query operations.
     *
     */
    public final static EquipmentField<String> CONSTRUCTION_YEAR = new EquipmentField<String>("ConstructionYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConstructionMonth</b>
     * </p>
     *
     * @return Month of construction
     */
    @SerializedName( "ConstructionMonth" )
    @JsonProperty( "ConstructionMonth" )
    @Nullable
    @ODataField( odataName = "ConstructionMonth" )
    private String constructionMonth;
    /**
     * Use with available fluent helpers to apply the <b>ConstructionMonth</b> field to query operations.
     *
     */
    public final static EquipmentField<String> CONSTRUCTION_MONTH = new EquipmentField<String>("ConstructionMonth");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartNmbr</b>
     * </p>
     *
     * @return Manufacturer part number
     */
    @SerializedName( "ManufacturerPartNmbr" )
    @JsonProperty( "ManufacturerPartNmbr" )
    @Nullable
    @ODataField( odataName = "ManufacturerPartNmbr" )
    private String manufacturerPartNmbr;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerPartNmbr</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MANUFACTURER_PART_NMBR =
        new EquipmentField<String>("ManufacturerPartNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerSerialNumber</b>
     * </p>
     *
     * @return Manufacturer's Serial Number
     */
    @SerializedName( "ManufacturerSerialNumber" )
    @JsonProperty( "ManufacturerSerialNumber" )
    @Nullable
    @ODataField( odataName = "ManufacturerSerialNumber" )
    private String manufacturerSerialNumber;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturerSerialNumber</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MANUFACTURER_SERIAL_NUMBER =
        new EquipmentField<String>("ManufacturerSerialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlant</b>
     * </p>
     *
     * @return Maintenance Plant
     */
    @SerializedName( "MaintenancePlant" )
    @JsonProperty( "MaintenancePlant" )
    @Nullable
    @ODataField( odataName = "MaintenancePlant" )
    private String maintenancePlant;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlant</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MAINTENANCE_PLANT = new EquipmentField<String>("MaintenancePlant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetLocation</b>
     * </p>
     *
     * @return Location of maintenance object
     */
    @SerializedName( "AssetLocation" )
    @JsonProperty( "AssetLocation" )
    @Nullable
    @ODataField( odataName = "AssetLocation" )
    private String assetLocation;
    /**
     * Use with available fluent helpers to apply the <b>AssetLocation</b> field to query operations.
     *
     */
    public final static EquipmentField<String> ASSET_LOCATION = new EquipmentField<String>("AssetLocation");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetRoom</b>
     * </p>
     *
     * @return Room
     */
    @SerializedName( "AssetRoom" )
    @JsonProperty( "AssetRoom" )
    @Nullable
    @ODataField( odataName = "AssetRoom" )
    private String assetRoom;
    /**
     * Use with available fluent helpers to apply the <b>AssetRoom</b> field to query operations.
     *
     */
    public final static EquipmentField<String> ASSET_ROOM = new EquipmentField<String>("AssetRoom");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantSection</b>
     * </p>
     *
     * @return Plant Section
     */
    @SerializedName( "PlantSection" )
    @JsonProperty( "PlantSection" )
    @Nullable
    @ODataField( odataName = "PlantSection" )
    private String plantSection;
    /**
     * Use with available fluent helpers to apply the <b>PlantSection</b> field to query operations.
     *
     */
    public final static EquipmentField<String> PLANT_SECTION = new EquipmentField<String>("PlantSection");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static EquipmentField<String> WORK_CENTER = new EquipmentField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of PP work center
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static EquipmentField<String> WORK_CENTER_INTERNAL_ID =
        new EquipmentField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "WorkCenterPlant" )
    @JsonProperty( "WorkCenterPlant" )
    @Nullable
    @ODataField( odataName = "WorkCenterPlant" )
    private String workCenterPlant;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterPlant</b> field to query operations.
     *
     */
    public final static EquipmentField<String> WORK_CENTER_PLANT = new EquipmentField<String>("WorkCenterPlant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @return ABC Indicator for Technical Object
     */
    @SerializedName( "ABCIndicator" )
    @JsonProperty( "ABCIndicator" )
    @Nullable
    @ODataField( odataName = "ABCIndicator" )
    private String aBCIndicator;
    /**
     * Use with available fluent helpers to apply the <b>ABCIndicator</b> field to query operations.
     *
     */
    public final static EquipmentField<String> ABC_INDICATOR = new EquipmentField<String>("ABCIndicator");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectFreeDefinedAttrib</b>
     * </p>
     *
     * @return Sort Field
     */
    @SerializedName( "MaintObjectFreeDefinedAttrib" )
    @JsonProperty( "MaintObjectFreeDefinedAttrib" )
    @Nullable
    @ODataField( odataName = "MaintObjectFreeDefinedAttrib" )
    private String maintObjectFreeDefinedAttrib;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectFreeDefinedAttrib</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MAINT_OBJECT_FREE_DEFINED_ATTRIB =
        new EquipmentField<String>("MaintObjectFreeDefinedAttrib");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @return Form-of-Address Key
     */
    @SerializedName( "FormOfAddress" )
    @JsonProperty( "FormOfAddress" )
    @Nullable
    @ODataField( odataName = "FormOfAddress" )
    private String formOfAddress;
    /**
     * Use with available fluent helpers to apply the <b>FormOfAddress</b> field to query operations.
     *
     */
    public final static EquipmentField<String> FORM_OF_ADDRESS = new EquipmentField<String>("FormOfAddress");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "BusinessPartnerName1" )
    @JsonProperty( "BusinessPartnerName1" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName1" )
    private String businessPartnerName1;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName1</b> field to query operations.
     *
     */
    public final static EquipmentField<String> BUSINESS_PARTNER_NAME1 =
        new EquipmentField<String>("BusinessPartnerName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "BusinessPartnerName2" )
    @JsonProperty( "BusinessPartnerName2" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName2" )
    private String businessPartnerName2;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName2</b> field to query operations.
     *
     */
    public final static EquipmentField<String> BUSINESS_PARTNER_NAME2 =
        new EquipmentField<String>("BusinessPartnerName2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static EquipmentField<String> CITY_NAME = new EquipmentField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "HouseNumber" )
    @JsonProperty( "HouseNumber" )
    @Nullable
    @ODataField( odataName = "HouseNumber" )
    private String houseNumber;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumber</b> field to query operations.
     *
     */
    public final static EquipmentField<String> HOUSE_NUMBER = new EquipmentField<String>("HouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumberSupplementText</b>
     * </p>
     *
     * @return House number supplement
     */
    @SerializedName( "HouseNumberSupplementText" )
    @JsonProperty( "HouseNumberSupplementText" )
    @Nullable
    @ODataField( odataName = "HouseNumberSupplementText" )
    private String houseNumberSupplementText;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumberSupplementText</b> field to query operations.
     *
     */
    public final static EquipmentField<String> HOUSE_NUMBER_SUPPLEMENT_TEXT =
        new EquipmentField<String>("HouseNumberSupplementText");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Building</b>
     * </p>
     *
     * @return Building (Number or Code)
     */
    @SerializedName( "Building" )
    @JsonProperty( "Building" )
    @Nullable
    @ODataField( odataName = "Building" )
    private String building;
    /**
     * Use with available fluent helpers to apply the <b>Building</b> field to query operations.
     *
     */
    public final static EquipmentField<String> BUILDING = new EquipmentField<String>("Building");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Floor</b>
     * </p>
     *
     * @return Floor in building
     */
    @SerializedName( "Floor" )
    @JsonProperty( "Floor" )
    @Nullable
    @ODataField( odataName = "Floor" )
    private String floor;
    /**
     * Use with available fluent helpers to apply the <b>Floor</b> field to query operations.
     *
     */
    public final static EquipmentField<String> FLOOR = new EquipmentField<String>("Floor");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RoomNumber</b>
     * </p>
     *
     * @return Room or Apartment Number
     */
    @SerializedName( "RoomNumber" )
    @JsonProperty( "RoomNumber" )
    @Nullable
    @ODataField( odataName = "RoomNumber" )
    private String roomNumber;
    /**
     * Use with available fluent helpers to apply the <b>RoomNumber</b> field to query operations.
     *
     */
    public final static EquipmentField<String> ROOM_NUMBER = new EquipmentField<String>("RoomNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return City Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static EquipmentField<String> POSTAL_CODE = new EquipmentField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Use with available fluent helpers to apply the <b>StreetName</b> field to query operations.
     *
     */
    public final static EquipmentField<String> STREET_NAME = new EquipmentField<String>("StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static EquipmentField<String> REGION = new EquipmentField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static EquipmentField<String> COUNTRY = new EquipmentField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @return Telephone No.: Dialing Code + Number
     */
    @SerializedName( "PhoneNumber" )
    @JsonProperty( "PhoneNumber" )
    @Nullable
    @ODataField( odataName = "PhoneNumber" )
    private String phoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber</b> field to query operations.
     *
     */
    public final static EquipmentField<String> PHONE_NUMBER = new EquipmentField<String>("PhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @return Fax Number: Dialing Code+Number
     */
    @SerializedName( "FaxNumber" )
    @JsonProperty( "FaxNumber" )
    @Nullable
    @ODataField( odataName = "FaxNumber" )
    private String faxNumber;
    /**
     * Use with available fluent helpers to apply the <b>FaxNumber</b> field to query operations.
     *
     */
    public final static EquipmentField<String> FAX_NUMBER = new EquipmentField<String>("FaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static EquipmentField<String> COMPANY_CODE = new EquipmentField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static EquipmentField<String> BUSINESS_AREA = new EquipmentField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @return Main Asset Number
     */
    @SerializedName( "MasterFixedAsset" )
    @JsonProperty( "MasterFixedAsset" )
    @Nullable
    @ODataField( odataName = "MasterFixedAsset" )
    private String masterFixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>MasterFixedAsset</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MASTER_FIXED_ASSET = new EquipmentField<String>("MasterFixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @return Asset Subnumber
     */
    @SerializedName( "FixedAsset" )
    @JsonProperty( "FixedAsset" )
    @Nullable
    @ODataField( odataName = "FixedAsset" )
    private String fixedAsset;
    /**
     * Use with available fluent helpers to apply the <b>FixedAsset</b> field to query operations.
     *
     */
    public final static EquipmentField<String> FIXED_ASSET = new EquipmentField<String>("FixedAsset");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static EquipmentField<String> COST_CENTER = new EquipmentField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static EquipmentField<String> CONTROLLING_AREA = new EquipmentField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static EquipmentField<String> WBS_ELEMENT_EXTERNAL_ID =
        new EquipmentField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SettlementOrder</b>
     * </p>
     *
     * @return Settlement order
     */
    @SerializedName( "SettlementOrder" )
    @JsonProperty( "SettlementOrder" )
    @Nullable
    @ODataField( odataName = "SettlementOrder" )
    private String settlementOrder;
    /**
     * Use with available fluent helpers to apply the <b>SettlementOrder</b> field to query operations.
     *
     */
    public final static EquipmentField<String> SETTLEMENT_ORDER = new EquipmentField<String>("SettlementOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     *
     * @return Maintenance Planning Plant
     */
    @SerializedName( "MaintenancePlanningPlant" )
    @JsonProperty( "MaintenancePlanningPlant" )
    @Nullable
    @ODataField( odataName = "MaintenancePlanningPlant" )
    private String maintenancePlanningPlant;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlanningPlant</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MAINTENANCE_PLANNING_PLANT =
        new EquipmentField<String>("MaintenancePlanningPlant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroup</b>
     * </p>
     *
     * @return Planner Group for Customer Service and Plant Maintenance
     */
    @SerializedName( "MaintenancePlannerGroup" )
    @JsonProperty( "MaintenancePlannerGroup" )
    @Nullable
    @ODataField( odataName = "MaintenancePlannerGroup" )
    private String maintenancePlannerGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaintenancePlannerGroup</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MAINTENANCE_PLANNER_GROUP =
        new EquipmentField<String>("MaintenancePlannerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @return Main work center for maintenance tasks
     */
    @SerializedName( "MainWorkCenter" )
    @JsonProperty( "MainWorkCenter" )
    @Nullable
    @ODataField( odataName = "MainWorkCenter" )
    private String mainWorkCenter;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenter</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MAIN_WORK_CENTER = new EquipmentField<String>("MainWorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the Work Center
     */
    @SerializedName( "MainWorkCenterInternalID" )
    @JsonProperty( "MainWorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterInternalID" )
    private String mainWorkCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterInternalID</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MAIN_WORK_CENTER_INTERNAL_ID =
        new EquipmentField<String>("MainWorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlant</b>
     * </p>
     *
     * @return Plant associated with main work center
     */
    @SerializedName( "MainWorkCenterPlant" )
    @JsonProperty( "MainWorkCenterPlant" )
    @Nullable
    @ODataField( odataName = "MainWorkCenterPlant" )
    private String mainWorkCenterPlant;
    /**
     * Use with available fluent helpers to apply the <b>MainWorkCenterPlant</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MAIN_WORK_CENTER_PLANT =
        new EquipmentField<String>("MainWorkCenterPlant");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>CatalogProfile</b>
     * </p>
     *
     * @return Catalog Profile
     */
    @SerializedName( "CatalogProfile" )
    @JsonProperty( "CatalogProfile" )
    @Nullable
    @ODataField( odataName = "CatalogProfile" )
    private String catalogProfile;
    /**
     * Use with available fluent helpers to apply the <b>CatalogProfile</b> field to query operations.
     *
     */
    public final static EquipmentField<String> CATALOG_PROFILE = new EquipmentField<String>("CatalogProfile");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Object ID of Functional Location or Equipment
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static EquipmentField<String> FUNCTIONAL_LOCATION = new EquipmentField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @return Functional Location Label
     */
    @SerializedName( "FunctionalLocationLabelName" )
    @JsonProperty( "FunctionalLocationLabelName" )
    @Nullable
    @ODataField( odataName = "FunctionalLocationLabelName" )
    private String functionalLocationLabelName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocationLabelName</b> field to query operations.
     *
     */
    public final static EquipmentField<String> FUNCTIONAL_LOCATION_LABEL_NAME =
        new EquipmentField<String>("FunctionalLocationLabelName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationName</b>
     * </p>
     *
     * @return Description of functional location
     */
    @SerializedName( "FunctionalLocationName" )
    @JsonProperty( "FunctionalLocationName" )
    @Nullable
    @ODataField( odataName = "FunctionalLocationName" )
    private String functionalLocationName;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocationName</b> field to query operations.
     *
     */
    public final static EquipmentField<String> FUNCTIONAL_LOCATION_NAME =
        new EquipmentField<String>("FunctionalLocationName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EquipInstallationPositionNmbr</b>
     * </p>
     *
     * @return Equipment position at InstallLoc (Superior Equip./FunctLoc)
     */
    @SerializedName( "EquipInstallationPositionNmbr" )
    @JsonProperty( "EquipInstallationPositionNmbr" )
    @Nullable
    @ODataField( odataName = "EquipInstallationPositionNmbr" )
    private String equipInstallationPositionNmbr;
    /**
     * Use with available fluent helpers to apply the <b>EquipInstallationPositionNmbr</b> field to query operations.
     *
     */
    public final static EquipmentField<String> EQUIP_INSTALLATION_POSITION_NMBR =
        new EquipmentField<String>("EquipInstallationPositionNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SuperordinateEquipment</b>
     * </p>
     *
     * @return Superordinate Equipment
     */
    @SerializedName( "SuperordinateEquipment" )
    @JsonProperty( "SuperordinateEquipment" )
    @Nullable
    @ODataField( odataName = "SuperordinateEquipment" )
    private String superordinateEquipment;
    /**
     * Use with available fluent helpers to apply the <b>SuperordinateEquipment</b> field to query operations.
     *
     */
    public final static EquipmentField<String> SUPERORDINATE_EQUIPMENT =
        new EquipmentField<String>("SuperordinateEquipment");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectSortCode</b>
     * </p>
     *
     * @return Technical identification number
     */
    @SerializedName( "TechnicalObjectSortCode" )
    @JsonProperty( "TechnicalObjectSortCode" )
    @Nullable
    @ODataField( odataName = "TechnicalObjectSortCode" )
    private String technicalObjectSortCode;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObjectSortCode</b> field to query operations.
     *
     */
    public final static EquipmentField<String> TECHNICAL_OBJECT_SORT_CODE =
        new EquipmentField<String>("TechnicalObjectSortCode");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConstructionMaterial</b>
     * </p>
     *
     * @return Construction type material of the object
     */
    @SerializedName( "ConstructionMaterial" )
    @JsonProperty( "ConstructionMaterial" )
    @Nullable
    @ODataField( odataName = "ConstructionMaterial" )
    private String constructionMaterial;
    /**
     * Use with available fluent helpers to apply the <b>ConstructionMaterial</b> field to query operations.
     *
     */
    public final static EquipmentField<String> CONSTRUCTION_MATERIAL =
        new EquipmentField<String>("ConstructionMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MATERIAL = new EquipmentField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @return Serial Number
     */
    @SerializedName( "SerialNumber" )
    @JsonProperty( "SerialNumber" )
    @Nullable
    @ODataField( odataName = "SerialNumber" )
    private String serialNumber;
    /**
     * Use with available fluent helpers to apply the <b>SerialNumber</b> field to query operations.
     *
     */
    public final static EquipmentField<String> SERIAL_NUMBER = new EquipmentField<String>("SerialNumber");
    /**
     * Constraints: Not nullable, Maximum length: 72
     * <p>
     * Original property name from the Odata EDM: <b>UniqueItemIdentifier</b>
     * </p>
     *
     * @return Unique Item Identifier
     */
    @SerializedName( "UniqueItemIdentifier" )
    @JsonProperty( "UniqueItemIdentifier" )
    @Nullable
    @ODataField( odataName = "UniqueItemIdentifier" )
    private String uniqueItemIdentifier;
    /**
     * Use with available fluent helpers to apply the <b>UniqueItemIdentifier</b> field to query operations.
     *
     */
    public final static EquipmentField<String> UNIQUE_ITEM_IDENTIFIER =
        new EquipmentField<String>("UniqueItemIdentifier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>UniqueItemIdentifierStrucType</b>
     * </p>
     *
     * @return Structure Type of UII
     */
    @SerializedName( "UniqueItemIdentifierStrucType" )
    @JsonProperty( "UniqueItemIdentifierStrucType" )
    @Nullable
    @ODataField( odataName = "UniqueItemIdentifierStrucType" )
    private String uniqueItemIdentifierStrucType;
    /**
     * Use with available fluent helpers to apply the <b>UniqueItemIdentifierStrucType</b> field to query operations.
     *
     */
    public final static EquipmentField<String> UNIQUE_ITEM_IDENTIFIER_STRUC_TYPE =
        new EquipmentField<String>("UniqueItemIdentifierStrucType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>UniqueItemIdentifierRespPlant</b>
     * </p>
     *
     * @return Plant Responsible for UII
     */
    @SerializedName( "UniqueItemIdentifierRespPlant" )
    @JsonProperty( "UniqueItemIdentifierRespPlant" )
    @Nullable
    @ODataField( odataName = "UniqueItemIdentifierRespPlant" )
    private String uniqueItemIdentifierRespPlant;
    /**
     * Use with available fluent helpers to apply the <b>UniqueItemIdentifierRespPlant</b> field to query operations.
     *
     */
    public final static EquipmentField<String> UNIQUE_ITEM_IDENTIFIER_RESP_PLANT =
        new EquipmentField<String>("UniqueItemIdentifierRespPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static EquipmentField<String> SALES_ORGANIZATION = new EquipmentField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static EquipmentField<String> DISTRIBUTION_CHANNEL = new EquipmentField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static EquipmentField<String> ORGANIZATION_DIVISION =
        new EquipmentField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static EquipmentField<String> SALES_GROUP = new EquipmentField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static EquipmentField<String> SALES_OFFICE = new EquipmentField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static EquipmentField<LocalDateTime> CREATION_DATE = new EquipmentField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static EquipmentField<String> CREATED_BY_USER = new EquipmentField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static EquipmentField<String> LAST_CHANGED_BY_USER = new EquipmentField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static EquipmentField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new EquipmentField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NextEquipUsagePeriodSqncNmbr</b>
     * </p>
     *
     * @return Number of next EquipUsagePeriod on same day
     */
    @SerializedName( "NextEquipUsagePeriodSqncNmbr" )
    @JsonProperty( "NextEquipUsagePeriodSqncNmbr" )
    @Nullable
    @ODataField( odataName = "NextEquipUsagePeriodSqncNmbr" )
    private String nextEquipUsagePeriodSqncNmbr;
    /**
     * Use with available fluent helpers to apply the <b>NextEquipUsagePeriodSqncNmbr</b> field to query operations.
     *
     */
    public final static EquipmentField<String> NEXT_EQUIP_USAGE_PERIOD_SQNC_NMBR =
        new EquipmentField<String>("NextEquipUsagePeriodSqncNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectLocAcctAssgmtNmbr</b>
     * </p>
     *
     * @return Location and account assignment for technical object
     */
    @SerializedName( "MaintObjectLocAcctAssgmtNmbr" )
    @JsonProperty( "MaintObjectLocAcctAssgmtNmbr" )
    @Nullable
    @ODataField( odataName = "MaintObjectLocAcctAssgmtNmbr" )
    private String maintObjectLocAcctAssgmtNmbr;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectLocAcctAssgmtNmbr</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR =
        new EquipmentField<String>("MaintObjectLocAcctAssgmtNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectInternalID</b>
     * </p>
     *
     * @return Object Number
     */
    @SerializedName( "MaintObjectInternalID" )
    @JsonProperty( "MaintObjectInternalID" )
    @Nullable
    @ODataField( odataName = "MaintObjectInternalID" )
    private String maintObjectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>MaintObjectInternalID</b> field to query operations.
     *
     */
    public final static EquipmentField<String> MAINT_OBJECT_INTERNAL_ID =
        new EquipmentField<String>("MaintObjectInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EquipUsagePeriodSequenceNumber</b>
     * </p>
     *
     * @return Consecutive numbering of EquipUsagePeriods on same day
     */
    @SerializedName( "EquipUsagePeriodSequenceNumber" )
    @JsonProperty( "EquipUsagePeriodSequenceNumber" )
    @Nullable
    @ODataField( odataName = "EquipUsagePeriodSequenceNumber" )
    private String equipUsagePeriodSequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>EquipUsagePeriodSequenceNumber</b> field to query operations.
     *
     */
    public final static EquipmentField<String> EQUIP_USAGE_PERIOD_SEQUENCE_NUMBER =
        new EquipmentField<String>("EquipUsagePeriodSequenceNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsAtCustomer</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "EquipmentIsAtCustomer" )
    @JsonProperty( "EquipmentIsAtCustomer" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EquipmentIsAtCustomer" )
    private Boolean equipmentIsAtCustomer;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentIsAtCustomer</b> field to query operations.
     *
     */
    public final static EquipmentField<Boolean> EQUIPMENT_IS_AT_CUSTOMER =
        new EquipmentField<Boolean>("EquipmentIsAtCustomer");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsAvailable</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "EquipmentIsAvailable" )
    @JsonProperty( "EquipmentIsAvailable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EquipmentIsAvailable" )
    private Boolean equipmentIsAvailable;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentIsAvailable</b> field to query operations.
     *
     */
    public final static EquipmentField<Boolean> EQUIPMENT_IS_AVAILABLE =
        new EquipmentField<Boolean>("EquipmentIsAvailable");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsInWarehouse</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "EquipmentIsInWarehouse" )
    @JsonProperty( "EquipmentIsInWarehouse" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EquipmentIsInWarehouse" )
    private Boolean equipmentIsInWarehouse;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentIsInWarehouse</b> field to query operations.
     *
     */
    public final static EquipmentField<Boolean> EQUIPMENT_IS_IN_WAREHOUSE =
        new EquipmentField<Boolean>("EquipmentIsInWarehouse");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsAssignedToDelivery</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "EquipmentIsAssignedToDelivery" )
    @JsonProperty( "EquipmentIsAssignedToDelivery" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EquipmentIsAssignedToDelivery" )
    private Boolean equipmentIsAssignedToDelivery;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentIsAssignedToDelivery</b> field to query operations.
     *
     */
    public final static EquipmentField<Boolean> EQUIPMENT_IS_ASSIGNED_TO_DELIVERY =
        new EquipmentField<Boolean>("EquipmentIsAssignedToDelivery");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsMarkedForDeletion</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "EquipmentIsMarkedForDeletion" )
    @JsonProperty( "EquipmentIsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EquipmentIsMarkedForDeletion" )
    private Boolean equipmentIsMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentIsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static EquipmentField<Boolean> EQUIPMENT_IS_MARKED_FOR_DELETION =
        new EquipmentField<Boolean>("EquipmentIsMarkedForDeletion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsInstalled</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "EquipmentIsInstalled" )
    @JsonProperty( "EquipmentIsInstalled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EquipmentIsInstalled" )
    private Boolean equipmentIsInstalled;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentIsInstalled</b> field to query operations.
     *
     */
    public final static EquipmentField<Boolean> EQUIPMENT_IS_INSTALLED =
        new EquipmentField<Boolean>("EquipmentIsInstalled");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipIsAllocToSuperiorEquip</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "EquipIsAllocToSuperiorEquip" )
    @JsonProperty( "EquipIsAllocToSuperiorEquip" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EquipIsAllocToSuperiorEquip" )
    private Boolean equipIsAllocToSuperiorEquip;
    /**
     * Use with available fluent helpers to apply the <b>EquipIsAllocToSuperiorEquip</b> field to query operations.
     *
     */
    public final static EquipmentField<Boolean> EQUIP_IS_ALLOC_TO_SUPERIOR_EQUIP =
        new EquipmentField<Boolean>("EquipIsAllocToSuperiorEquip");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsInactive</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "EquipmentIsInactive" )
    @JsonProperty( "EquipmentIsInactive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EquipmentIsInactive" )
    private Boolean equipmentIsInactive;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentIsInactive</b> field to query operations.
     *
     */
    public final static EquipmentField<Boolean> EQUIPMENT_IS_INACTIVE =
        new EquipmentField<Boolean>("EquipmentIsInactive");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EquipHasSubOrdinateEquipment</b>
     * </p>
     *
     * @return The equipHasSubOrdinateEquipment contained in this entity.
     */
    @SerializedName( "EquipHasSubOrdinateEquipment" )
    @JsonProperty( "EquipHasSubOrdinateEquipment" )
    @Nullable
    @ODataField( odataName = "EquipHasSubOrdinateEquipment" )
    private String equipHasSubOrdinateEquipment;
    /**
     * Use with available fluent helpers to apply the <b>EquipHasSubOrdinateEquipment</b> field to query operations.
     *
     */
    public final static EquipmentField<String> EQUIP_HAS_SUB_ORDINATE_EQUIPMENT =
        new EquipmentField<String>("EquipHasSubOrdinateEquipment");
    /**
     * Navigation property <b>to_Classification</b> for <b>Equipment</b> to multiple <b>EquipmentClass</b>.
     *
     */
    @SerializedName( "to_Classification" )
    @JsonProperty( "to_Classification" )
    @ODataField( odataName = "to_Classification" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EquipmentClass> toClassification;
    /**
     * Navigation property <b>to_LongText</b> for <b>Equipment</b> to single <b>EquipmentLongText</b>.
     *
     */
    @SerializedName( "to_LongText" )
    @JsonProperty( "to_LongText" )
    @ODataField( odataName = "to_LongText" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EquipmentLongText toLongText;
    /**
     * Navigation property <b>to_Partner</b> for <b>Equipment</b> to multiple <b>EquipmentPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EquipmentPartner> toPartner;
    /**
     * Navigation property <b>to_Warranty</b> for <b>Equipment</b> to multiple <b>EquipmentWarranty</b>.
     *
     */
    @SerializedName( "to_Warranty" )
    @JsonProperty( "to_Warranty" )
    @ODataField( odataName = "to_Warranty" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EquipmentWarranty> toWarranty;
    /**
     * Use with available fluent helpers to apply the <b>to_Classification</b> navigation property to query operations.
     *
     */
    public final static EquipmentLink<EquipmentClass> TO_CLASSIFICATION =
        new EquipmentLink<EquipmentClass>("to_Classification");
    /**
     * Use with available fluent helpers to apply the <b>to_LongText</b> navigation property to query operations.
     *
     */
    public final static EquipmentOneToOneLink<EquipmentLongText> TO_LONG_TEXT =
        new EquipmentOneToOneLink<EquipmentLongText>("to_LongText");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static EquipmentLink<EquipmentPartner> TO_PARTNER = new EquipmentLink<EquipmentPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_Warranty</b> navigation property to query operations.
     *
     */
    public final static EquipmentLink<EquipmentWarranty> TO_WARRANTY =
        new EquipmentLink<EquipmentWarranty>("to_Warranty");

    @Nonnull
    @Override
    public Class<Equipment> getType()
    {
        return Equipment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndTime</b>
     * </p>
     *
     * @param validityEndTime
     *            Equipment usage period time stamp
     */
    public void setValidityEndTime( @Nullable final LocalTime validityEndTime )
    {
        rememberChangedField("ValidityEndTime", this.validityEndTime);
        this.validityEndTime = validityEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentValidityEndDateTime</b>
     * </p>
     *
     * @param equipmentValidityEndDateTime
     *            The equipmentValidityEndDateTime to set.
     */
    public void setEquipmentValidityEndDateTime( @Nullable final ZonedDateTime equipmentValidityEndDateTime )
    {
        rememberChangedField("EquipmentValidityEndDateTime", this.equipmentValidityEndDateTime);
        this.equipmentValidityEndDateTime = equipmentValidityEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentOID</b>
     * </p>
     *
     * @param equipmentOID
     *            Object Instance ID of an Equipment
     */
    public void setEquipmentOID( @Nullable final String equipmentOID )
    {
        rememberChangedField("EquipmentOID", this.equipmentOID);
        this.equipmentOID = equipmentOID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentName</b>
     * </p>
     *
     * @param equipmentName
     *            Description of technical object
     */
    public void setEquipmentName( @Nullable final String equipmentName )
    {
        rememberChangedField("EquipmentName", this.equipmentName);
        this.equipmentName = equipmentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentCategory</b>
     * </p>
     *
     * @param equipmentCategory
     *            Equipment category
     */
    public void setEquipmentCategory( @Nullable final String equipmentCategory )
    {
        rememberChangedField("EquipmentCategory", this.equipmentCategory);
        this.equipmentCategory = equipmentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     *
     * @param technicalObjectType
     *            Type of Technical Object
     */
    public void setTechnicalObjectType( @Nullable final String technicalObjectType )
    {
        rememberChangedField("TechnicalObjectType", this.technicalObjectType);
        this.technicalObjectType = technicalObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Technical Object Authorization Group
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeight</b>
     * </p>
     *
     * @param grossWeight
     *            Weight of object
     */
    public void setGrossWeight( @Nullable final BigDecimal grossWeight )
    {
        rememberChangedField("GrossWeight", this.grossWeight);
        this.grossWeight = grossWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GrossWeightUnit</b>
     * </p>
     *
     * @param grossWeightUnit
     *            Unit of weight
     */
    public void setGrossWeightUnit( @Nullable final String grossWeightUnit )
    {
        rememberChangedField("GrossWeightUnit", this.grossWeightUnit);
        this.grossWeightUnit = grossWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SizeOrDimensionText</b>
     * </p>
     *
     * @param sizeOrDimensionText
     *            Size/dimension
     */
    public void setSizeOrDimensionText( @Nullable final String sizeOrDimensionText )
    {
        rememberChangedField("SizeOrDimensionText", this.sizeOrDimensionText);
        this.sizeOrDimensionText = sizeOrDimensionText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>InventoryNumber</b>
     * </p>
     *
     * @param inventoryNumber
     *            Inventory number
     */
    public void setInventoryNumber( @Nullable final String inventoryNumber )
    {
        rememberChangedField("InventoryNumber", this.inventoryNumber);
        this.inventoryNumber = inventoryNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OperationStartDate</b>
     * </p>
     *
     * @param operationStartDate
     *            Start-up Date of the Technical Object
     */
    public void setOperationStartDate( @Nullable final LocalDateTime operationStartDate )
    {
        rememberChangedField("OperationStartDate", this.operationStartDate);
        this.operationStartDate = operationStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AcquisitionValue</b>
     * </p>
     *
     * @param acquisitionValue
     *            Acquisition Value
     */
    public void setAcquisitionValue( @Nullable final BigDecimal acquisitionValue )
    {
        rememberChangedField("AcquisitionValue", this.acquisitionValue);
        this.acquisitionValue = acquisitionValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AcquisitionDate</b>
     * </p>
     *
     * @param acquisitionDate
     *            Acquisition date
     */
    public void setAcquisitionDate( @Nullable final LocalDateTime acquisitionDate )
    {
        rememberChangedField("AcquisitionDate", this.acquisitionDate);
        this.acquisitionDate = acquisitionDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AssetManufacturerName</b>
     * </p>
     *
     * @param assetManufacturerName
     *            Manufacturer of asset
     */
    public void setAssetManufacturerName( @Nullable final String assetManufacturerName )
    {
        rememberChangedField("AssetManufacturerName", this.assetManufacturerName);
        this.assetManufacturerName = assetManufacturerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartTypeName</b>
     * </p>
     *
     * @param manufacturerPartTypeName
     *            Manufacturer model number
     */
    public void setManufacturerPartTypeName( @Nullable final String manufacturerPartTypeName )
    {
        rememberChangedField("ManufacturerPartTypeName", this.manufacturerPartTypeName);
        this.manufacturerPartTypeName = manufacturerPartTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerCountry</b>
     * </p>
     *
     * @param manufacturerCountry
     *            Country/Region of Manufacture
     */
    public void setManufacturerCountry( @Nullable final String manufacturerCountry )
    {
        rememberChangedField("ManufacturerCountry", this.manufacturerCountry);
        this.manufacturerCountry = manufacturerCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConstructionYear</b>
     * </p>
     *
     * @param constructionYear
     *            Year of construction
     */
    public void setConstructionYear( @Nullable final String constructionYear )
    {
        rememberChangedField("ConstructionYear", this.constructionYear);
        this.constructionYear = constructionYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConstructionMonth</b>
     * </p>
     *
     * @param constructionMonth
     *            Month of construction
     */
    public void setConstructionMonth( @Nullable final String constructionMonth )
    {
        rememberChangedField("ConstructionMonth", this.constructionMonth);
        this.constructionMonth = constructionMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerPartNmbr</b>
     * </p>
     *
     * @param manufacturerPartNmbr
     *            Manufacturer part number
     */
    public void setManufacturerPartNmbr( @Nullable final String manufacturerPartNmbr )
    {
        rememberChangedField("ManufacturerPartNmbr", this.manufacturerPartNmbr);
        this.manufacturerPartNmbr = manufacturerPartNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturerSerialNumber</b>
     * </p>
     *
     * @param manufacturerSerialNumber
     *            Manufacturer's Serial Number
     */
    public void setManufacturerSerialNumber( @Nullable final String manufacturerSerialNumber )
    {
        rememberChangedField("ManufacturerSerialNumber", this.manufacturerSerialNumber);
        this.manufacturerSerialNumber = manufacturerSerialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlant</b>
     * </p>
     *
     * @param maintenancePlant
     *            Maintenance Plant
     */
    public void setMaintenancePlant( @Nullable final String maintenancePlant )
    {
        rememberChangedField("MaintenancePlant", this.maintenancePlant);
        this.maintenancePlant = maintenancePlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AssetLocation</b>
     * </p>
     *
     * @param assetLocation
     *            Location of maintenance object
     */
    public void setAssetLocation( @Nullable final String assetLocation )
    {
        rememberChangedField("AssetLocation", this.assetLocation);
        this.assetLocation = assetLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>AssetRoom</b>
     * </p>
     *
     * @param assetRoom
     *            Room
     */
    public void setAssetRoom( @Nullable final String assetRoom )
    {
        rememberChangedField("AssetRoom", this.assetRoom);
        this.assetRoom = assetRoom;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PlantSection</b>
     * </p>
     *
     * @param plantSection
     *            Plant Section
     */
    public void setPlantSection( @Nullable final String plantSection )
    {
        rememberChangedField("PlantSection", this.plantSection);
        this.plantSection = plantSection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of PP work center
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterPlant</b>
     * </p>
     *
     * @param workCenterPlant
     *            Plant
     */
    public void setWorkCenterPlant( @Nullable final String workCenterPlant )
    {
        rememberChangedField("WorkCenterPlant", this.workCenterPlant);
        this.workCenterPlant = workCenterPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ABCIndicator</b>
     * </p>
     *
     * @param aBCIndicator
     *            ABC Indicator for Technical Object
     */
    public void setABCIndicator( @Nullable final String aBCIndicator )
    {
        rememberChangedField("ABCIndicator", this.aBCIndicator);
        this.aBCIndicator = aBCIndicator;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectFreeDefinedAttrib</b>
     * </p>
     *
     * @param maintObjectFreeDefinedAttrib
     *            Sort Field
     */
    public void setMaintObjectFreeDefinedAttrib( @Nullable final String maintObjectFreeDefinedAttrib )
    {
        rememberChangedField("MaintObjectFreeDefinedAttrib", this.maintObjectFreeDefinedAttrib);
        this.maintObjectFreeDefinedAttrib = maintObjectFreeDefinedAttrib;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @param formOfAddress
     *            Form-of-Address Key
     */
    public void setFormOfAddress( @Nullable final String formOfAddress )
    {
        rememberChangedField("FormOfAddress", this.formOfAddress);
        this.formOfAddress = formOfAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName1</b>
     * </p>
     *
     * @param businessPartnerName1
     *            Name 1
     */
    public void setBusinessPartnerName1( @Nullable final String businessPartnerName1 )
    {
        rememberChangedField("BusinessPartnerName1", this.businessPartnerName1);
        this.businessPartnerName1 = businessPartnerName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName2</b>
     * </p>
     *
     * @param businessPartnerName2
     *            Name 2
     */
    public void setBusinessPartnerName2( @Nullable final String businessPartnerName2 )
    {
        rememberChangedField("BusinessPartnerName2", this.businessPartnerName2);
        this.businessPartnerName2 = businessPartnerName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @param houseNumber
     *            House Number
     */
    public void setHouseNumber( @Nullable final String houseNumber )
    {
        rememberChangedField("HouseNumber", this.houseNumber);
        this.houseNumber = houseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumberSupplementText</b>
     * </p>
     *
     * @param houseNumberSupplementText
     *            House number supplement
     */
    public void setHouseNumberSupplementText( @Nullable final String houseNumberSupplementText )
    {
        rememberChangedField("HouseNumberSupplementText", this.houseNumberSupplementText);
        this.houseNumberSupplementText = houseNumberSupplementText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Building</b>
     * </p>
     *
     * @param building
     *            Building (Number or Code)
     */
    public void setBuilding( @Nullable final String building )
    {
        rememberChangedField("Building", this.building);
        this.building = building;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Floor</b>
     * </p>
     *
     * @param floor
     *            Floor in building
     */
    public void setFloor( @Nullable final String floor )
    {
        rememberChangedField("Floor", this.floor);
        this.floor = floor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RoomNumber</b>
     * </p>
     *
     * @param roomNumber
     *            Room or Apartment Number
     */
    public void setRoomNumber( @Nullable final String roomNumber )
    {
        rememberChangedField("RoomNumber", this.roomNumber);
        this.roomNumber = roomNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            City Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @param phoneNumber
     *            Telephone No.: Dialing Code + Number
     */
    public void setPhoneNumber( @Nullable final String phoneNumber )
    {
        rememberChangedField("PhoneNumber", this.phoneNumber);
        this.phoneNumber = phoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @param faxNumber
     *            Fax Number: Dialing Code+Number
     */
    public void setFaxNumber( @Nullable final String faxNumber )
    {
        rememberChangedField("FaxNumber", this.faxNumber);
        this.faxNumber = faxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MasterFixedAsset</b>
     * </p>
     *
     * @param masterFixedAsset
     *            Main Asset Number
     */
    public void setMasterFixedAsset( @Nullable final String masterFixedAsset )
    {
        rememberChangedField("MasterFixedAsset", this.masterFixedAsset);
        this.masterFixedAsset = masterFixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FixedAsset</b>
     * </p>
     *
     * @param fixedAsset
     *            Asset Subnumber
     */
    public void setFixedAsset( @Nullable final String fixedAsset )
    {
        rememberChangedField("FixedAsset", this.fixedAsset);
        this.fixedAsset = fixedAsset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SettlementOrder</b>
     * </p>
     *
     * @param settlementOrder
     *            Settlement order
     */
    public void setSettlementOrder( @Nullable final String settlementOrder )
    {
        rememberChangedField("SettlementOrder", this.settlementOrder);
        this.settlementOrder = settlementOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlanningPlant</b>
     * </p>
     *
     * @param maintenancePlanningPlant
     *            Maintenance Planning Plant
     */
    public void setMaintenancePlanningPlant( @Nullable final String maintenancePlanningPlant )
    {
        rememberChangedField("MaintenancePlanningPlant", this.maintenancePlanningPlant);
        this.maintenancePlanningPlant = maintenancePlanningPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaintenancePlannerGroup</b>
     * </p>
     *
     * @param maintenancePlannerGroup
     *            Planner Group for Customer Service and Plant Maintenance
     */
    public void setMaintenancePlannerGroup( @Nullable final String maintenancePlannerGroup )
    {
        rememberChangedField("MaintenancePlannerGroup", this.maintenancePlannerGroup);
        this.maintenancePlannerGroup = maintenancePlannerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenter</b>
     * </p>
     *
     * @param mainWorkCenter
     *            Main work center for maintenance tasks
     */
    public void setMainWorkCenter( @Nullable final String mainWorkCenter )
    {
        rememberChangedField("MainWorkCenter", this.mainWorkCenter);
        this.mainWorkCenter = mainWorkCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterInternalID</b>
     * </p>
     *
     * @param mainWorkCenterInternalID
     *            Object ID of the Work Center
     */
    public void setMainWorkCenterInternalID( @Nullable final String mainWorkCenterInternalID )
    {
        rememberChangedField("MainWorkCenterInternalID", this.mainWorkCenterInternalID);
        this.mainWorkCenterInternalID = mainWorkCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MainWorkCenterPlant</b>
     * </p>
     *
     * @param mainWorkCenterPlant
     *            Plant associated with main work center
     */
    public void setMainWorkCenterPlant( @Nullable final String mainWorkCenterPlant )
    {
        rememberChangedField("MainWorkCenterPlant", this.mainWorkCenterPlant);
        this.mainWorkCenterPlant = mainWorkCenterPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>CatalogProfile</b>
     * </p>
     *
     * @param catalogProfile
     *            Catalog Profile
     */
    public void setCatalogProfile( @Nullable final String catalogProfile )
    {
        rememberChangedField("CatalogProfile", this.catalogProfile);
        this.catalogProfile = catalogProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Object ID of Functional Location or Equipment
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationLabelName</b>
     * </p>
     *
     * @param functionalLocationLabelName
     *            Functional Location Label
     */
    public void setFunctionalLocationLabelName( @Nullable final String functionalLocationLabelName )
    {
        rememberChangedField("FunctionalLocationLabelName", this.functionalLocationLabelName);
        this.functionalLocationLabelName = functionalLocationLabelName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocationName</b>
     * </p>
     *
     * @param functionalLocationName
     *            Description of functional location
     */
    public void setFunctionalLocationName( @Nullable final String functionalLocationName )
    {
        rememberChangedField("FunctionalLocationName", this.functionalLocationName);
        this.functionalLocationName = functionalLocationName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>EquipInstallationPositionNmbr</b>
     * </p>
     *
     * @param equipInstallationPositionNmbr
     *            Equipment position at InstallLoc (Superior Equip./FunctLoc)
     */
    public void setEquipInstallationPositionNmbr( @Nullable final String equipInstallationPositionNmbr )
    {
        rememberChangedField("EquipInstallationPositionNmbr", this.equipInstallationPositionNmbr);
        this.equipInstallationPositionNmbr = equipInstallationPositionNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SuperordinateEquipment</b>
     * </p>
     *
     * @param superordinateEquipment
     *            Superordinate Equipment
     */
    public void setSuperordinateEquipment( @Nullable final String superordinateEquipment )
    {
        rememberChangedField("SuperordinateEquipment", this.superordinateEquipment);
        this.superordinateEquipment = superordinateEquipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectSortCode</b>
     * </p>
     *
     * @param technicalObjectSortCode
     *            Technical identification number
     */
    public void setTechnicalObjectSortCode( @Nullable final String technicalObjectSortCode )
    {
        rememberChangedField("TechnicalObjectSortCode", this.technicalObjectSortCode);
        this.technicalObjectSortCode = technicalObjectSortCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConstructionMaterial</b>
     * </p>
     *
     * @param constructionMaterial
     *            Construction type material of the object
     */
    public void setConstructionMaterial( @Nullable final String constructionMaterial )
    {
        rememberChangedField("ConstructionMaterial", this.constructionMaterial);
        this.constructionMaterial = constructionMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SerialNumber</b>
     * </p>
     *
     * @param serialNumber
     *            Serial Number
     */
    public void setSerialNumber( @Nullable final String serialNumber )
    {
        rememberChangedField("SerialNumber", this.serialNumber);
        this.serialNumber = serialNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 72
     * <p>
     * Original property name from the Odata EDM: <b>UniqueItemIdentifier</b>
     * </p>
     *
     * @param uniqueItemIdentifier
     *            Unique Item Identifier
     */
    public void setUniqueItemIdentifier( @Nullable final String uniqueItemIdentifier )
    {
        rememberChangedField("UniqueItemIdentifier", this.uniqueItemIdentifier);
        this.uniqueItemIdentifier = uniqueItemIdentifier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>UniqueItemIdentifierStrucType</b>
     * </p>
     *
     * @param uniqueItemIdentifierStrucType
     *            Structure Type of UII
     */
    public void setUniqueItemIdentifierStrucType( @Nullable final String uniqueItemIdentifierStrucType )
    {
        rememberChangedField("UniqueItemIdentifierStrucType", this.uniqueItemIdentifierStrucType);
        this.uniqueItemIdentifierStrucType = uniqueItemIdentifierStrucType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>UniqueItemIdentifierRespPlant</b>
     * </p>
     *
     * @param uniqueItemIdentifierRespPlant
     *            Plant Responsible for UII
     */
    public void setUniqueItemIdentifierRespPlant( @Nullable final String uniqueItemIdentifierRespPlant )
    {
        rememberChangedField("UniqueItemIdentifierRespPlant", this.uniqueItemIdentifierRespPlant);
        this.uniqueItemIdentifierRespPlant = uniqueItemIdentifierRespPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>NextEquipUsagePeriodSqncNmbr</b>
     * </p>
     *
     * @param nextEquipUsagePeriodSqncNmbr
     *            Number of next EquipUsagePeriod on same day
     */
    public void setNextEquipUsagePeriodSqncNmbr( @Nullable final String nextEquipUsagePeriodSqncNmbr )
    {
        rememberChangedField("NextEquipUsagePeriodSqncNmbr", this.nextEquipUsagePeriodSqncNmbr);
        this.nextEquipUsagePeriodSqncNmbr = nextEquipUsagePeriodSqncNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectLocAcctAssgmtNmbr</b>
     * </p>
     *
     * @param maintObjectLocAcctAssgmtNmbr
     *            Location and account assignment for technical object
     */
    public void setMaintObjectLocAcctAssgmtNmbr( @Nullable final String maintObjectLocAcctAssgmtNmbr )
    {
        rememberChangedField("MaintObjectLocAcctAssgmtNmbr", this.maintObjectLocAcctAssgmtNmbr);
        this.maintObjectLocAcctAssgmtNmbr = maintObjectLocAcctAssgmtNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>MaintObjectInternalID</b>
     * </p>
     *
     * @param maintObjectInternalID
     *            Object Number
     */
    public void setMaintObjectInternalID( @Nullable final String maintObjectInternalID )
    {
        rememberChangedField("MaintObjectInternalID", this.maintObjectInternalID);
        this.maintObjectInternalID = maintObjectInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EquipUsagePeriodSequenceNumber</b>
     * </p>
     *
     * @param equipUsagePeriodSequenceNumber
     *            Consecutive numbering of EquipUsagePeriods on same day
     */
    public void setEquipUsagePeriodSequenceNumber( @Nullable final String equipUsagePeriodSequenceNumber )
    {
        rememberChangedField("EquipUsagePeriodSequenceNumber", this.equipUsagePeriodSequenceNumber);
        this.equipUsagePeriodSequenceNumber = equipUsagePeriodSequenceNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsAtCustomer</b>
     * </p>
     *
     * @param equipmentIsAtCustomer
     *            Checkbox
     */
    public void setEquipmentIsAtCustomer( @Nullable final Boolean equipmentIsAtCustomer )
    {
        rememberChangedField("EquipmentIsAtCustomer", this.equipmentIsAtCustomer);
        this.equipmentIsAtCustomer = equipmentIsAtCustomer;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsAvailable</b>
     * </p>
     *
     * @param equipmentIsAvailable
     *            Checkbox
     */
    public void setEquipmentIsAvailable( @Nullable final Boolean equipmentIsAvailable )
    {
        rememberChangedField("EquipmentIsAvailable", this.equipmentIsAvailable);
        this.equipmentIsAvailable = equipmentIsAvailable;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsInWarehouse</b>
     * </p>
     *
     * @param equipmentIsInWarehouse
     *            Checkbox
     */
    public void setEquipmentIsInWarehouse( @Nullable final Boolean equipmentIsInWarehouse )
    {
        rememberChangedField("EquipmentIsInWarehouse", this.equipmentIsInWarehouse);
        this.equipmentIsInWarehouse = equipmentIsInWarehouse;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsAssignedToDelivery</b>
     * </p>
     *
     * @param equipmentIsAssignedToDelivery
     *            Checkbox
     */
    public void setEquipmentIsAssignedToDelivery( @Nullable final Boolean equipmentIsAssignedToDelivery )
    {
        rememberChangedField("EquipmentIsAssignedToDelivery", this.equipmentIsAssignedToDelivery);
        this.equipmentIsAssignedToDelivery = equipmentIsAssignedToDelivery;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsMarkedForDeletion</b>
     * </p>
     *
     * @param equipmentIsMarkedForDeletion
     *            Checkbox
     */
    public void setEquipmentIsMarkedForDeletion( @Nullable final Boolean equipmentIsMarkedForDeletion )
    {
        rememberChangedField("EquipmentIsMarkedForDeletion", this.equipmentIsMarkedForDeletion);
        this.equipmentIsMarkedForDeletion = equipmentIsMarkedForDeletion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsInstalled</b>
     * </p>
     *
     * @param equipmentIsInstalled
     *            Checkbox
     */
    public void setEquipmentIsInstalled( @Nullable final Boolean equipmentIsInstalled )
    {
        rememberChangedField("EquipmentIsInstalled", this.equipmentIsInstalled);
        this.equipmentIsInstalled = equipmentIsInstalled;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipIsAllocToSuperiorEquip</b>
     * </p>
     *
     * @param equipIsAllocToSuperiorEquip
     *            Checkbox
     */
    public void setEquipIsAllocToSuperiorEquip( @Nullable final Boolean equipIsAllocToSuperiorEquip )
    {
        rememberChangedField("EquipIsAllocToSuperiorEquip", this.equipIsAllocToSuperiorEquip);
        this.equipIsAllocToSuperiorEquip = equipIsAllocToSuperiorEquip;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentIsInactive</b>
     * </p>
     *
     * @param equipmentIsInactive
     *            Checkbox
     */
    public void setEquipmentIsInactive( @Nullable final Boolean equipmentIsInactive )
    {
        rememberChangedField("EquipmentIsInactive", this.equipmentIsInactive);
        this.equipmentIsInactive = equipmentIsInactive;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EquipHasSubOrdinateEquipment</b>
     * </p>
     *
     * @param equipHasSubOrdinateEquipment
     *            The equipHasSubOrdinateEquipment to set.
     */
    public void setEquipHasSubOrdinateEquipment( @Nullable final String equipHasSubOrdinateEquipment )
    {
        rememberChangedField("EquipHasSubOrdinateEquipment", this.equipHasSubOrdinateEquipment);
        this.equipHasSubOrdinateEquipment = equipHasSubOrdinateEquipment;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Equipment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Equipment", getEquipment());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Equipment", getEquipment());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityEndTime", getValidityEndTime());
        values.put("EquipmentValidityEndDateTime", getEquipmentValidityEndDateTime());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("EquipmentOID", getEquipmentOID());
        values.put("EquipmentName", getEquipmentName());
        values.put("EquipmentCategory", getEquipmentCategory());
        values.put("TechnicalObjectType", getTechnicalObjectType());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("GrossWeight", getGrossWeight());
        values.put("GrossWeightUnit", getGrossWeightUnit());
        values.put("SizeOrDimensionText", getSizeOrDimensionText());
        values.put("InventoryNumber", getInventoryNumber());
        values.put("OperationStartDate", getOperationStartDate());
        values.put("AcquisitionValue", getAcquisitionValue());
        values.put("Currency", getCurrency());
        values.put("AcquisitionDate", getAcquisitionDate());
        values.put("AssetManufacturerName", getAssetManufacturerName());
        values.put("ManufacturerPartTypeName", getManufacturerPartTypeName());
        values.put("ManufacturerCountry", getManufacturerCountry());
        values.put("ConstructionYear", getConstructionYear());
        values.put("ConstructionMonth", getConstructionMonth());
        values.put("ManufacturerPartNmbr", getManufacturerPartNmbr());
        values.put("ManufacturerSerialNumber", getManufacturerSerialNumber());
        values.put("MaintenancePlant", getMaintenancePlant());
        values.put("AssetLocation", getAssetLocation());
        values.put("AssetRoom", getAssetRoom());
        values.put("PlantSection", getPlantSection());
        values.put("WorkCenter", getWorkCenter());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterPlant", getWorkCenterPlant());
        values.put("ABCIndicator", getABCIndicator());
        values.put("MaintObjectFreeDefinedAttrib", getMaintObjectFreeDefinedAttrib());
        values.put("FormOfAddress", getFormOfAddress());
        values.put("BusinessPartnerName1", getBusinessPartnerName1());
        values.put("BusinessPartnerName2", getBusinessPartnerName2());
        values.put("CityName", getCityName());
        values.put("HouseNumber", getHouseNumber());
        values.put("HouseNumberSupplementText", getHouseNumberSupplementText());
        values.put("Building", getBuilding());
        values.put("Floor", getFloor());
        values.put("RoomNumber", getRoomNumber());
        values.put("PostalCode", getPostalCode());
        values.put("StreetName", getStreetName());
        values.put("Region", getRegion());
        values.put("Country", getCountry());
        values.put("PhoneNumber", getPhoneNumber());
        values.put("FaxNumber", getFaxNumber());
        values.put("CompanyCode", getCompanyCode());
        values.put("BusinessArea", getBusinessArea());
        values.put("MasterFixedAsset", getMasterFixedAsset());
        values.put("FixedAsset", getFixedAsset());
        values.put("CostCenter", getCostCenter());
        values.put("ControllingArea", getControllingArea());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("SettlementOrder", getSettlementOrder());
        values.put("MaintenancePlanningPlant", getMaintenancePlanningPlant());
        values.put("MaintenancePlannerGroup", getMaintenancePlannerGroup());
        values.put("MainWorkCenter", getMainWorkCenter());
        values.put("MainWorkCenterInternalID", getMainWorkCenterInternalID());
        values.put("MainWorkCenterPlant", getMainWorkCenterPlant());
        values.put("CatalogProfile", getCatalogProfile());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("FunctionalLocationLabelName", getFunctionalLocationLabelName());
        values.put("FunctionalLocationName", getFunctionalLocationName());
        values.put("EquipInstallationPositionNmbr", getEquipInstallationPositionNmbr());
        values.put("SuperordinateEquipment", getSuperordinateEquipment());
        values.put("TechnicalObjectSortCode", getTechnicalObjectSortCode());
        values.put("ConstructionMaterial", getConstructionMaterial());
        values.put("Material", getMaterial());
        values.put("SerialNumber", getSerialNumber());
        values.put("UniqueItemIdentifier", getUniqueItemIdentifier());
        values.put("UniqueItemIdentifierStrucType", getUniqueItemIdentifierStrucType());
        values.put("UniqueItemIdentifierRespPlant", getUniqueItemIdentifierRespPlant());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("SalesGroup", getSalesGroup());
        values.put("SalesOffice", getSalesOffice());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("NextEquipUsagePeriodSqncNmbr", getNextEquipUsagePeriodSqncNmbr());
        values.put("MaintObjectLocAcctAssgmtNmbr", getMaintObjectLocAcctAssgmtNmbr());
        values.put("MaintObjectInternalID", getMaintObjectInternalID());
        values.put("EquipUsagePeriodSequenceNumber", getEquipUsagePeriodSequenceNumber());
        values.put("EquipmentIsAtCustomer", getEquipmentIsAtCustomer());
        values.put("EquipmentIsAvailable", getEquipmentIsAvailable());
        values.put("EquipmentIsInWarehouse", getEquipmentIsInWarehouse());
        values.put("EquipmentIsAssignedToDelivery", getEquipmentIsAssignedToDelivery());
        values.put("EquipmentIsMarkedForDeletion", getEquipmentIsMarkedForDeletion());
        values.put("EquipmentIsInstalled", getEquipmentIsInstalled());
        values.put("EquipIsAllocToSuperiorEquip", getEquipIsAllocToSuperiorEquip());
        values.put("EquipmentIsInactive", getEquipmentIsInactive());
        values.put("EquipHasSubOrdinateEquipment", getEquipHasSubOrdinateEquipment());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndTime") ) {
                final Object value = values.remove("ValidityEndTime");
                if( (value == null) || (!value.equals(getValidityEndTime())) ) {
                    setValidityEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("EquipmentValidityEndDateTime") ) {
                final Object value = values.remove("EquipmentValidityEndDateTime");
                if( (value == null) || (!value.equals(getEquipmentValidityEndDateTime())) ) {
                    setEquipmentValidityEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EquipmentOID") ) {
                final Object value = values.remove("EquipmentOID");
                if( (value == null) || (!value.equals(getEquipmentOID())) ) {
                    setEquipmentOID(((String) value));
                }
            }
            if( values.containsKey("EquipmentName") ) {
                final Object value = values.remove("EquipmentName");
                if( (value == null) || (!value.equals(getEquipmentName())) ) {
                    setEquipmentName(((String) value));
                }
            }
            if( values.containsKey("EquipmentCategory") ) {
                final Object value = values.remove("EquipmentCategory");
                if( (value == null) || (!value.equals(getEquipmentCategory())) ) {
                    setEquipmentCategory(((String) value));
                }
            }
            if( values.containsKey("TechnicalObjectType") ) {
                final Object value = values.remove("TechnicalObjectType");
                if( (value == null) || (!value.equals(getTechnicalObjectType())) ) {
                    setTechnicalObjectType(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("GrossWeight") ) {
                final Object value = values.remove("GrossWeight");
                if( (value == null) || (!value.equals(getGrossWeight())) ) {
                    setGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("GrossWeightUnit") ) {
                final Object value = values.remove("GrossWeightUnit");
                if( (value == null) || (!value.equals(getGrossWeightUnit())) ) {
                    setGrossWeightUnit(((String) value));
                }
            }
            if( values.containsKey("SizeOrDimensionText") ) {
                final Object value = values.remove("SizeOrDimensionText");
                if( (value == null) || (!value.equals(getSizeOrDimensionText())) ) {
                    setSizeOrDimensionText(((String) value));
                }
            }
            if( values.containsKey("InventoryNumber") ) {
                final Object value = values.remove("InventoryNumber");
                if( (value == null) || (!value.equals(getInventoryNumber())) ) {
                    setInventoryNumber(((String) value));
                }
            }
            if( values.containsKey("OperationStartDate") ) {
                final Object value = values.remove("OperationStartDate");
                if( (value == null) || (!value.equals(getOperationStartDate())) ) {
                    setOperationStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AcquisitionValue") ) {
                final Object value = values.remove("AcquisitionValue");
                if( (value == null) || (!value.equals(getAcquisitionValue())) ) {
                    setAcquisitionValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("AcquisitionDate") ) {
                final Object value = values.remove("AcquisitionDate");
                if( (value == null) || (!value.equals(getAcquisitionDate())) ) {
                    setAcquisitionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AssetManufacturerName") ) {
                final Object value = values.remove("AssetManufacturerName");
                if( (value == null) || (!value.equals(getAssetManufacturerName())) ) {
                    setAssetManufacturerName(((String) value));
                }
            }
            if( values.containsKey("ManufacturerPartTypeName") ) {
                final Object value = values.remove("ManufacturerPartTypeName");
                if( (value == null) || (!value.equals(getManufacturerPartTypeName())) ) {
                    setManufacturerPartTypeName(((String) value));
                }
            }
            if( values.containsKey("ManufacturerCountry") ) {
                final Object value = values.remove("ManufacturerCountry");
                if( (value == null) || (!value.equals(getManufacturerCountry())) ) {
                    setManufacturerCountry(((String) value));
                }
            }
            if( values.containsKey("ConstructionYear") ) {
                final Object value = values.remove("ConstructionYear");
                if( (value == null) || (!value.equals(getConstructionYear())) ) {
                    setConstructionYear(((String) value));
                }
            }
            if( values.containsKey("ConstructionMonth") ) {
                final Object value = values.remove("ConstructionMonth");
                if( (value == null) || (!value.equals(getConstructionMonth())) ) {
                    setConstructionMonth(((String) value));
                }
            }
            if( values.containsKey("ManufacturerPartNmbr") ) {
                final Object value = values.remove("ManufacturerPartNmbr");
                if( (value == null) || (!value.equals(getManufacturerPartNmbr())) ) {
                    setManufacturerPartNmbr(((String) value));
                }
            }
            if( values.containsKey("ManufacturerSerialNumber") ) {
                final Object value = values.remove("ManufacturerSerialNumber");
                if( (value == null) || (!value.equals(getManufacturerSerialNumber())) ) {
                    setManufacturerSerialNumber(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlant") ) {
                final Object value = values.remove("MaintenancePlant");
                if( (value == null) || (!value.equals(getMaintenancePlant())) ) {
                    setMaintenancePlant(((String) value));
                }
            }
            if( values.containsKey("AssetLocation") ) {
                final Object value = values.remove("AssetLocation");
                if( (value == null) || (!value.equals(getAssetLocation())) ) {
                    setAssetLocation(((String) value));
                }
            }
            if( values.containsKey("AssetRoom") ) {
                final Object value = values.remove("AssetRoom");
                if( (value == null) || (!value.equals(getAssetRoom())) ) {
                    setAssetRoom(((String) value));
                }
            }
            if( values.containsKey("PlantSection") ) {
                final Object value = values.remove("PlantSection");
                if( (value == null) || (!value.equals(getPlantSection())) ) {
                    setPlantSection(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterPlant") ) {
                final Object value = values.remove("WorkCenterPlant");
                if( (value == null) || (!value.equals(getWorkCenterPlant())) ) {
                    setWorkCenterPlant(((String) value));
                }
            }
            if( values.containsKey("ABCIndicator") ) {
                final Object value = values.remove("ABCIndicator");
                if( (value == null) || (!value.equals(getABCIndicator())) ) {
                    setABCIndicator(((String) value));
                }
            }
            if( values.containsKey("MaintObjectFreeDefinedAttrib") ) {
                final Object value = values.remove("MaintObjectFreeDefinedAttrib");
                if( (value == null) || (!value.equals(getMaintObjectFreeDefinedAttrib())) ) {
                    setMaintObjectFreeDefinedAttrib(((String) value));
                }
            }
            if( values.containsKey("FormOfAddress") ) {
                final Object value = values.remove("FormOfAddress");
                if( (value == null) || (!value.equals(getFormOfAddress())) ) {
                    setFormOfAddress(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName1") ) {
                final Object value = values.remove("BusinessPartnerName1");
                if( (value == null) || (!value.equals(getBusinessPartnerName1())) ) {
                    setBusinessPartnerName1(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName2") ) {
                final Object value = values.remove("BusinessPartnerName2");
                if( (value == null) || (!value.equals(getBusinessPartnerName2())) ) {
                    setBusinessPartnerName2(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("HouseNumber") ) {
                final Object value = values.remove("HouseNumber");
                if( (value == null) || (!value.equals(getHouseNumber())) ) {
                    setHouseNumber(((String) value));
                }
            }
            if( values.containsKey("HouseNumberSupplementText") ) {
                final Object value = values.remove("HouseNumberSupplementText");
                if( (value == null) || (!value.equals(getHouseNumberSupplementText())) ) {
                    setHouseNumberSupplementText(((String) value));
                }
            }
            if( values.containsKey("Building") ) {
                final Object value = values.remove("Building");
                if( (value == null) || (!value.equals(getBuilding())) ) {
                    setBuilding(((String) value));
                }
            }
            if( values.containsKey("Floor") ) {
                final Object value = values.remove("Floor");
                if( (value == null) || (!value.equals(getFloor())) ) {
                    setFloor(((String) value));
                }
            }
            if( values.containsKey("RoomNumber") ) {
                final Object value = values.remove("RoomNumber");
                if( (value == null) || (!value.equals(getRoomNumber())) ) {
                    setRoomNumber(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber") ) {
                final Object value = values.remove("PhoneNumber");
                if( (value == null) || (!value.equals(getPhoneNumber())) ) {
                    setPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("FaxNumber") ) {
                final Object value = values.remove("FaxNumber");
                if( (value == null) || (!value.equals(getFaxNumber())) ) {
                    setFaxNumber(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("MasterFixedAsset") ) {
                final Object value = values.remove("MasterFixedAsset");
                if( (value == null) || (!value.equals(getMasterFixedAsset())) ) {
                    setMasterFixedAsset(((String) value));
                }
            }
            if( values.containsKey("FixedAsset") ) {
                final Object value = values.remove("FixedAsset");
                if( (value == null) || (!value.equals(getFixedAsset())) ) {
                    setFixedAsset(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("SettlementOrder") ) {
                final Object value = values.remove("SettlementOrder");
                if( (value == null) || (!value.equals(getSettlementOrder())) ) {
                    setSettlementOrder(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlanningPlant") ) {
                final Object value = values.remove("MaintenancePlanningPlant");
                if( (value == null) || (!value.equals(getMaintenancePlanningPlant())) ) {
                    setMaintenancePlanningPlant(((String) value));
                }
            }
            if( values.containsKey("MaintenancePlannerGroup") ) {
                final Object value = values.remove("MaintenancePlannerGroup");
                if( (value == null) || (!value.equals(getMaintenancePlannerGroup())) ) {
                    setMaintenancePlannerGroup(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenter") ) {
                final Object value = values.remove("MainWorkCenter");
                if( (value == null) || (!value.equals(getMainWorkCenter())) ) {
                    setMainWorkCenter(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterInternalID") ) {
                final Object value = values.remove("MainWorkCenterInternalID");
                if( (value == null) || (!value.equals(getMainWorkCenterInternalID())) ) {
                    setMainWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("MainWorkCenterPlant") ) {
                final Object value = values.remove("MainWorkCenterPlant");
                if( (value == null) || (!value.equals(getMainWorkCenterPlant())) ) {
                    setMainWorkCenterPlant(((String) value));
                }
            }
            if( values.containsKey("CatalogProfile") ) {
                final Object value = values.remove("CatalogProfile");
                if( (value == null) || (!value.equals(getCatalogProfile())) ) {
                    setCatalogProfile(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocationLabelName") ) {
                final Object value = values.remove("FunctionalLocationLabelName");
                if( (value == null) || (!value.equals(getFunctionalLocationLabelName())) ) {
                    setFunctionalLocationLabelName(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocationName") ) {
                final Object value = values.remove("FunctionalLocationName");
                if( (value == null) || (!value.equals(getFunctionalLocationName())) ) {
                    setFunctionalLocationName(((String) value));
                }
            }
            if( values.containsKey("EquipInstallationPositionNmbr") ) {
                final Object value = values.remove("EquipInstallationPositionNmbr");
                if( (value == null) || (!value.equals(getEquipInstallationPositionNmbr())) ) {
                    setEquipInstallationPositionNmbr(((String) value));
                }
            }
            if( values.containsKey("SuperordinateEquipment") ) {
                final Object value = values.remove("SuperordinateEquipment");
                if( (value == null) || (!value.equals(getSuperordinateEquipment())) ) {
                    setSuperordinateEquipment(((String) value));
                }
            }
            if( values.containsKey("TechnicalObjectSortCode") ) {
                final Object value = values.remove("TechnicalObjectSortCode");
                if( (value == null) || (!value.equals(getTechnicalObjectSortCode())) ) {
                    setTechnicalObjectSortCode(((String) value));
                }
            }
            if( values.containsKey("ConstructionMaterial") ) {
                final Object value = values.remove("ConstructionMaterial");
                if( (value == null) || (!value.equals(getConstructionMaterial())) ) {
                    setConstructionMaterial(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("SerialNumber") ) {
                final Object value = values.remove("SerialNumber");
                if( (value == null) || (!value.equals(getSerialNumber())) ) {
                    setSerialNumber(((String) value));
                }
            }
            if( values.containsKey("UniqueItemIdentifier") ) {
                final Object value = values.remove("UniqueItemIdentifier");
                if( (value == null) || (!value.equals(getUniqueItemIdentifier())) ) {
                    setUniqueItemIdentifier(((String) value));
                }
            }
            if( values.containsKey("UniqueItemIdentifierStrucType") ) {
                final Object value = values.remove("UniqueItemIdentifierStrucType");
                if( (value == null) || (!value.equals(getUniqueItemIdentifierStrucType())) ) {
                    setUniqueItemIdentifierStrucType(((String) value));
                }
            }
            if( values.containsKey("UniqueItemIdentifierRespPlant") ) {
                final Object value = values.remove("UniqueItemIdentifierRespPlant");
                if( (value == null) || (!value.equals(getUniqueItemIdentifierRespPlant())) ) {
                    setUniqueItemIdentifierRespPlant(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("NextEquipUsagePeriodSqncNmbr") ) {
                final Object value = values.remove("NextEquipUsagePeriodSqncNmbr");
                if( (value == null) || (!value.equals(getNextEquipUsagePeriodSqncNmbr())) ) {
                    setNextEquipUsagePeriodSqncNmbr(((String) value));
                }
            }
            if( values.containsKey("MaintObjectLocAcctAssgmtNmbr") ) {
                final Object value = values.remove("MaintObjectLocAcctAssgmtNmbr");
                if( (value == null) || (!value.equals(getMaintObjectLocAcctAssgmtNmbr())) ) {
                    setMaintObjectLocAcctAssgmtNmbr(((String) value));
                }
            }
            if( values.containsKey("MaintObjectInternalID") ) {
                final Object value = values.remove("MaintObjectInternalID");
                if( (value == null) || (!value.equals(getMaintObjectInternalID())) ) {
                    setMaintObjectInternalID(((String) value));
                }
            }
            if( values.containsKey("EquipUsagePeriodSequenceNumber") ) {
                final Object value = values.remove("EquipUsagePeriodSequenceNumber");
                if( (value == null) || (!value.equals(getEquipUsagePeriodSequenceNumber())) ) {
                    setEquipUsagePeriodSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("EquipmentIsAtCustomer") ) {
                final Object value = values.remove("EquipmentIsAtCustomer");
                if( (value == null) || (!value.equals(getEquipmentIsAtCustomer())) ) {
                    setEquipmentIsAtCustomer(((Boolean) value));
                }
            }
            if( values.containsKey("EquipmentIsAvailable") ) {
                final Object value = values.remove("EquipmentIsAvailable");
                if( (value == null) || (!value.equals(getEquipmentIsAvailable())) ) {
                    setEquipmentIsAvailable(((Boolean) value));
                }
            }
            if( values.containsKey("EquipmentIsInWarehouse") ) {
                final Object value = values.remove("EquipmentIsInWarehouse");
                if( (value == null) || (!value.equals(getEquipmentIsInWarehouse())) ) {
                    setEquipmentIsInWarehouse(((Boolean) value));
                }
            }
            if( values.containsKey("EquipmentIsAssignedToDelivery") ) {
                final Object value = values.remove("EquipmentIsAssignedToDelivery");
                if( (value == null) || (!value.equals(getEquipmentIsAssignedToDelivery())) ) {
                    setEquipmentIsAssignedToDelivery(((Boolean) value));
                }
            }
            if( values.containsKey("EquipmentIsMarkedForDeletion") ) {
                final Object value = values.remove("EquipmentIsMarkedForDeletion");
                if( (value == null) || (!value.equals(getEquipmentIsMarkedForDeletion())) ) {
                    setEquipmentIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("EquipmentIsInstalled") ) {
                final Object value = values.remove("EquipmentIsInstalled");
                if( (value == null) || (!value.equals(getEquipmentIsInstalled())) ) {
                    setEquipmentIsInstalled(((Boolean) value));
                }
            }
            if( values.containsKey("EquipIsAllocToSuperiorEquip") ) {
                final Object value = values.remove("EquipIsAllocToSuperiorEquip");
                if( (value == null) || (!value.equals(getEquipIsAllocToSuperiorEquip())) ) {
                    setEquipIsAllocToSuperiorEquip(((Boolean) value));
                }
            }
            if( values.containsKey("EquipmentIsInactive") ) {
                final Object value = values.remove("EquipmentIsInactive");
                if( (value == null) || (!value.equals(getEquipmentIsInactive())) ) {
                    setEquipmentIsInactive(((Boolean) value));
                }
            }
            if( values.containsKey("EquipHasSubOrdinateEquipment") ) {
                final Object value = values.remove("EquipHasSubOrdinateEquipment");
                if( (value == null) || (!value.equals(getEquipHasSubOrdinateEquipment())) ) {
                    setEquipHasSubOrdinateEquipment(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Classification") ) {
                final Object value = (values).remove("to_Classification");
                if( value instanceof Iterable ) {
                    if( toClassification == null ) {
                        toClassification = Lists.newArrayList();
                    } else {
                        toClassification = Lists.newArrayList(toClassification);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EquipmentClass entity;
                        if( toClassification.size() > i ) {
                            entity = toClassification.get(i);
                        } else {
                            entity = new EquipmentClass();
                            toClassification.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_LongText") ) {
                final Object value = (values).remove("to_LongText");
                if( value instanceof Map ) {
                    if( toLongText == null ) {
                        toLongText = new EquipmentLongText();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toLongText.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EquipmentPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new EquipmentPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Warranty") ) {
                final Object value = (values).remove("to_Warranty");
                if( value instanceof Iterable ) {
                    if( toWarranty == null ) {
                        toWarranty = Lists.newArrayList();
                    } else {
                        toWarranty = Lists.newArrayList(toWarranty);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EquipmentWarranty entity;
                        if( toWarranty.size() > i ) {
                            entity = toWarranty.get(i);
                        } else {
                            entity = new EquipmentWarranty();
                            toWarranty.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> EquipmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EquipmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EquipmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EquipmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EquipmentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toClassification != null ) {
            (values).put("to_Classification", toClassification);
        }
        if( toLongText != null ) {
            (values).put("to_LongText", toLongText);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toWarranty != null ) {
            (values).put("to_Warranty", toWarranty);
        }
        return values;
    }

    /**
     * Fetches the <b>EquipmentClass</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Classification</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EquipmentClass</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EquipmentClass> fetchClassification()
    {
        return fetchFieldAsList("to_Classification", EquipmentClass.class);
    }

    /**
     * Retrieval of associated <b>EquipmentClass</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>Equipment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EquipmentClass</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EquipmentClass> getClassificationOrFetch()
    {
        if( toClassification == null ) {
            toClassification = fetchClassification();
        }
        return toClassification;
    }

    /**
     * Retrieval of associated <b>EquipmentClass</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Classification</b>.
     * <p>
     * If the navigation property for an entity <b>Equipment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Classification</b> is already loaded, the result will
     *         contain the <b>EquipmentClass</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EquipmentClass>> getClassificationIfPresent()
    {
        return Option.of(toClassification);
    }

    /**
     * Overwrites the list of associated <b>EquipmentClass</b> entities for the loaded navigation property
     * <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>Equipment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EquipmentClass</b> entities.
     */
    public void setClassification( @Nonnull final List<EquipmentClass> value )
    {
        if( toClassification == null ) {
            toClassification = Lists.newArrayList();
        }
        toClassification.clear();
        toClassification.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EquipmentClass</b> entities. This corresponds to the OData navigation
     * property <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>Equipment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EquipmentClass</b> entities.
     */
    public void addClassification( EquipmentClass... entity )
    {
        if( toClassification == null ) {
            toClassification = Lists.newArrayList();
        }
        toClassification.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>EquipmentLongText</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_LongText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EquipmentLongText</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EquipmentLongText fetchLongText()
    {
        return fetchFieldAsSingle("to_LongText", EquipmentLongText.class);
    }

    /**
     * Retrieval of associated <b>EquipmentLongText</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_LongText</b>.
     * <p>
     * If the navigation property <b>to_LongText</b> of a queried <b>Equipment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EquipmentLongText</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EquipmentLongText getLongTextOrFetch()
    {
        if( toLongText == null ) {
            toLongText = fetchLongText();
        }
        return toLongText;
    }

    /**
     * Retrieval of associated <b>EquipmentLongText</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_LongText</b>.
     * <p>
     * If the navigation property for an entity <b>Equipment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LongText</b> is already loaded, the result will contain
     *         the <b>EquipmentLongText</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<EquipmentLongText> getLongTextIfPresent()
    {
        return Option.of(toLongText);
    }

    /**
     * Overwrites the associated <b>EquipmentLongText</b> entity for the loaded navigation property <b>to_LongText</b>.
     *
     * @param value
     *            New <b>EquipmentLongText</b> entity.
     */
    public void setLongText( final EquipmentLongText value )
    {
        toLongText = value;
    }

    /**
     * Fetches the <b>EquipmentPartner</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EquipmentPartner</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EquipmentPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", EquipmentPartner.class);
    }

    /**
     * Retrieval of associated <b>EquipmentPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>Equipment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EquipmentPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EquipmentPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>EquipmentPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>Equipment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>EquipmentPartner</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<EquipmentPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>EquipmentPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>Equipment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EquipmentPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<EquipmentPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EquipmentPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>Equipment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EquipmentPartner</b> entities.
     */
    public void addPartner( EquipmentPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>EquipmentWarranty</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Warranty</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EquipmentWarranty</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EquipmentWarranty> fetchWarranty()
    {
        return fetchFieldAsList("to_Warranty", EquipmentWarranty.class);
    }

    /**
     * Retrieval of associated <b>EquipmentWarranty</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Warranty</b>.
     * <p>
     * If the navigation property <b>to_Warranty</b> of a queried <b>Equipment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EquipmentWarranty</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EquipmentWarranty> getWarrantyOrFetch()
    {
        if( toWarranty == null ) {
            toWarranty = fetchWarranty();
        }
        return toWarranty;
    }

    /**
     * Retrieval of associated <b>EquipmentWarranty</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Warranty</b>.
     * <p>
     * If the navigation property for an entity <b>Equipment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Warranty</b> is already loaded, the result will contain
     *         the <b>EquipmentWarranty</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EquipmentWarranty>> getWarrantyIfPresent()
    {
        return Option.of(toWarranty);
    }

    /**
     * Overwrites the list of associated <b>EquipmentWarranty</b> entities for the loaded navigation property
     * <b>to_Warranty</b>.
     * <p>
     * If the navigation property <b>to_Warranty</b> of a queried <b>Equipment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EquipmentWarranty</b> entities.
     */
    public void setWarranty( @Nonnull final List<EquipmentWarranty> value )
    {
        if( toWarranty == null ) {
            toWarranty = Lists.newArrayList();
        }
        toWarranty.clear();
        toWarranty.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EquipmentWarranty</b> entities. This corresponds to the OData
     * navigation property <b>to_Warranty</b>.
     * <p>
     * If the navigation property <b>to_Warranty</b> of a queried <b>Equipment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EquipmentWarranty</b> entities.
     */
    public void addWarranty( EquipmentWarranty... entity )
    {
        if( toWarranty == null ) {
            toWarranty = Lists.newArrayList();
        }
        toWarranty.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Equipment instances.
     *
     */
    public final static class EquipmentBuilder
    {

        private List<EquipmentClass> toClassification = Lists.newArrayList();
        private EquipmentLongText toLongText;
        private List<EquipmentPartner> toPartner = Lists.newArrayList();
        private List<EquipmentWarranty> toWarranty = Lists.newArrayList();

        private Equipment.EquipmentBuilder toClassification( final List<EquipmentClass> value )
        {
            toClassification.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Classification</b> for <b>Equipment</b> to multiple <b>EquipmentClass</b>.
         *
         * @param value
         *            The EquipmentClasss to build this Equipment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Equipment.EquipmentBuilder classification( EquipmentClass... value )
        {
            return toClassification(Lists.newArrayList(value));
        }

        private Equipment.EquipmentBuilder toLongText( final EquipmentLongText value )
        {
            toLongText = value;
            return this;
        }

        /**
         * Navigation property <b>to_LongText</b> for <b>Equipment</b> to single <b>EquipmentLongText</b>.
         *
         * @param value
         *            The EquipmentLongText to build this Equipment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Equipment.EquipmentBuilder longText( final EquipmentLongText value )
        {
            return toLongText(value);
        }

        private Equipment.EquipmentBuilder toPartner( final List<EquipmentPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>Equipment</b> to multiple <b>EquipmentPartner</b>.
         *
         * @param value
         *            The EquipmentPartners to build this Equipment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Equipment.EquipmentBuilder partner( EquipmentPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private Equipment.EquipmentBuilder toWarranty( final List<EquipmentWarranty> value )
        {
            toWarranty.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Warranty</b> for <b>Equipment</b> to multiple <b>EquipmentWarranty</b>.
         *
         * @param value
         *            The EquipmentWarrantys to build this Equipment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Equipment.EquipmentBuilder warranty( EquipmentWarranty... value )
        {
            return toWarranty(Lists.newArrayList(value));
        }

    }

}
