/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentClassCharacteristicField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentClassCharacteristicLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentClassCharacteristicOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable.EquipmentClassCharacteristicSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Equipment Class Characteristics
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EquipmentClassCharacteristicType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EquipmentClassCharacteristic extends VdmEntity<EquipmentClassCharacteristic>
{

    /**
     * Selector for all available fields of EquipmentClassCharacteristic.
     *
     */
    public final static EquipmentClassCharacteristicSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static EquipmentClassCharacteristicField<String> EQUIPMENT =
        new EquipmentClassCharacteristicField<String>("Equipment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @Key
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static EquipmentClassCharacteristicField<String> CLASS_INTERNAL_ID =
        new EquipmentClassCharacteristicField<String>("ClassInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharacteristicInternalID" )
    @JsonProperty( "CharacteristicInternalID" )
    @Nullable
    @ODataField( odataName = "CharacteristicInternalID" )
    private String characteristicInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicInternalID</b> field to query operations.
     *
     */
    public final static EquipmentClassCharacteristicField<String> CHARACTERISTIC_INTERNAL_ID =
        new EquipmentClassCharacteristicField<String>("CharacteristicInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "Characteristic" )
    @JsonProperty( "Characteristic" )
    @Nullable
    @ODataField( odataName = "Characteristic" )
    private String characteristic;
    /**
     * Use with available fluent helpers to apply the <b>Characteristic</b> field to query operations.
     *
     */
    public final static EquipmentClassCharacteristicField<String> CHARACTERISTIC =
        new EquipmentClassCharacteristicField<String>("Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @return Data type of characteristic
     */
    @SerializedName( "CharcDataType" )
    @JsonProperty( "CharcDataType" )
    @Nullable
    @ODataField( odataName = "CharcDataType" )
    private String charcDataType;
    /**
     * Use with available fluent helpers to apply the <b>CharcDataType</b> field to query operations.
     *
     */
    public final static EquipmentClassCharacteristicField<String> CHARC_DATA_TYPE =
        new EquipmentClassCharacteristicField<String>("CharcDataType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return The keyDate contained in this entity.
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static EquipmentClassCharacteristicField<LocalDateTime> KEY_DATE =
        new EquipmentClassCharacteristicField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static EquipmentClassCharacteristicField<String> CHANGE_NUMBER =
        new EquipmentClassCharacteristicField<String>("ChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static EquipmentClassCharacteristicField<String> CLASS_TYPE =
        new EquipmentClassCharacteristicField<String>("ClassType");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @return Class number
     */
    @SerializedName( "Class" )
    @JsonProperty( "Class" )
    @Nullable
    @ODataField( odataName = "Class" )
    private String classProperty;
    /**
     * Use with available fluent helpers to apply the <b>Class</b> field to query operations.
     *
     */
    public final static EquipmentClassCharacteristicField<String> CLASS_PROPERTY =
        new EquipmentClassCharacteristicField<String>("Class");
    /**
     * Navigation property <b>to_EquipmentClass</b> for <b>EquipmentClassCharacteristic</b> to single
     * <b>EquipmentClass</b>.
     *
     */
    @SerializedName( "to_EquipmentClass" )
    @JsonProperty( "to_EquipmentClass" )
    @ODataField( odataName = "to_EquipmentClass" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EquipmentClass toEquipmentClass;
    /**
     * Navigation property <b>to_Equipment</b> for <b>EquipmentClassCharacteristic</b> to single <b>Equipment</b>.
     *
     */
    @SerializedName( "to_Equipment" )
    @JsonProperty( "to_Equipment" )
    @ODataField( odataName = "to_Equipment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Equipment toEquipment;
    /**
     * Navigation property <b>to_Value</b> for <b>EquipmentClassCharacteristic</b> to multiple
     * <b>EquipClassCharacteristicValue</b>.
     *
     */
    @SerializedName( "to_Value" )
    @JsonProperty( "to_Value" )
    @ODataField( odataName = "to_Value" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EquipClassCharacteristicValue> toValue;
    /**
     * Use with available fluent helpers to apply the <b>to_EquipmentClass</b> navigation property to query operations.
     *
     */
    public final static EquipmentClassCharacteristicOneToOneLink<EquipmentClass> TO_EQUIPMENT_CLASS =
        new EquipmentClassCharacteristicOneToOneLink<EquipmentClass>("to_EquipmentClass");
    /**
     * Use with available fluent helpers to apply the <b>to_Equipment</b> navigation property to query operations.
     *
     */
    public final static EquipmentClassCharacteristicOneToOneLink<Equipment> TO_EQUIPMENT =
        new EquipmentClassCharacteristicOneToOneLink<Equipment>("to_Equipment");
    /**
     * Use with available fluent helpers to apply the <b>to_Value</b> navigation property to query operations.
     *
     */
    public final static EquipmentClassCharacteristicLink<EquipClassCharacteristicValue> TO_VALUE =
        new EquipmentClassCharacteristicLink<EquipClassCharacteristicValue>("to_Value");

    @Nonnull
    @Override
    public Class<EquipmentClassCharacteristic> getType()
    {
        return EquipmentClassCharacteristic.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicInternalID</b>
     * </p>
     *
     * @param characteristicInternalID
     *            Characteristic Internal ID
     */
    public void setCharacteristicInternalID( @Nullable final String characteristicInternalID )
    {
        rememberChangedField("CharacteristicInternalID", this.characteristicInternalID);
        this.characteristicInternalID = characteristicInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharcDataType</b>
     * </p>
     *
     * @param charcDataType
     *            Data type of characteristic
     */
    public void setCharcDataType( @Nullable final String charcDataType )
    {
        rememberChangedField("CharcDataType", this.charcDataType);
        this.charcDataType = charcDataType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            The keyDate to set.
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Class</b>
     * </p>
     *
     * @param classProperty
     *            Class number
     */
    public void setClassProperty( @Nullable final String classProperty )
    {
        rememberChangedField("Class", this.classProperty);
        this.classProperty = classProperty;
    }

    @Override
    protected String getEntityCollection()
    {
        return "EquipmentClassCharacteristic";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Equipment", getEquipment());
        result.put("ClassInternalID", getClassInternalID());
        result.put("CharacteristicInternalID", getCharacteristicInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Equipment", getEquipment());
        values.put("ClassInternalID", getClassInternalID());
        values.put("CharacteristicInternalID", getCharacteristicInternalID());
        values.put("Characteristic", getCharacteristic());
        values.put("CharcDataType", getCharcDataType());
        values.put("KeyDate", getKeyDate());
        values.put("ChangeNumber", getChangeNumber());
        values.put("ClassType", getClassType());
        values.put("Class", getClassProperty());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("CharacteristicInternalID") ) {
                final Object value = values.remove("CharacteristicInternalID");
                if( (value == null) || (!value.equals(getCharacteristicInternalID())) ) {
                    setCharacteristicInternalID(((String) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((String) value));
                }
            }
            if( values.containsKey("CharcDataType") ) {
                final Object value = values.remove("CharcDataType");
                if( (value == null) || (!value.equals(getCharcDataType())) ) {
                    setCharcDataType(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("Class") ) {
                final Object value = values.remove("Class");
                if( (value == null) || (!value.equals(getClassProperty())) ) {
                    setClassProperty(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EquipmentClass") ) {
                final Object value = (values).remove("to_EquipmentClass");
                if( value instanceof Map ) {
                    if( toEquipmentClass == null ) {
                        toEquipmentClass = new EquipmentClass();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEquipmentClass.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Equipment") ) {
                final Object value = (values).remove("to_Equipment");
                if( value instanceof Map ) {
                    if( toEquipment == null ) {
                        toEquipment = new Equipment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEquipment.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Value") ) {
                final Object value = (values).remove("to_Value");
                if( value instanceof Iterable ) {
                    if( toValue == null ) {
                        toValue = Lists.newArrayList();
                    } else {
                        toValue = Lists.newArrayList(toValue);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EquipClassCharacteristicValue entity;
                        if( toValue.size() > i ) {
                            entity = toValue.get(i);
                        } else {
                            entity = new EquipClassCharacteristicValue();
                            toValue.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> EquipmentClassCharacteristicField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new EquipmentClassCharacteristicField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EquipmentClassCharacteristicField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EquipmentClassCharacteristicField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EquipmentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEquipmentClass != null ) {
            (values).put("to_EquipmentClass", toEquipmentClass);
        }
        if( toEquipment != null ) {
            (values).put("to_Equipment", toEquipment);
        }
        if( toValue != null ) {
            (values).put("to_Value", toValue);
        }
        return values;
    }

    /**
     * Fetches the <b>EquipmentClass</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_EquipmentClass</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EquipmentClass</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EquipmentClass fetchEquipmentClass()
    {
        return fetchFieldAsSingle("to_EquipmentClass", EquipmentClass.class);
    }

    /**
     * Retrieval of associated <b>EquipmentClass</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EquipmentClass</b>.
     * <p>
     * If the navigation property <b>to_EquipmentClass</b> of a queried <b>EquipmentClassCharacteristic</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EquipmentClass</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EquipmentClass getEquipmentClassOrFetch()
    {
        if( toEquipmentClass == null ) {
            toEquipmentClass = fetchEquipmentClass();
        }
        return toEquipmentClass;
    }

    /**
     * Retrieval of associated <b>EquipmentClass</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_EquipmentClass</b>.
     * <p>
     * If the navigation property for an entity <b>EquipmentClassCharacteristic</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EquipmentClass</b> is already loaded, the result will
     *         contain the <b>EquipmentClass</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EquipmentClass> getEquipmentClassIfPresent()
    {
        return Option.of(toEquipmentClass);
    }

    /**
     * Overwrites the associated <b>EquipmentClass</b> entity for the loaded navigation property
     * <b>to_EquipmentClass</b>.
     *
     * @param value
     *            New <b>EquipmentClass</b> entity.
     */
    public void setEquipmentClass( final EquipmentClass value )
    {
        toEquipmentClass = value;
    }

    /**
     * Fetches the <b>Equipment</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Equipment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Equipment</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Equipment fetchEquipment()
    {
        return fetchFieldAsSingle("to_Equipment", Equipment.class);
    }

    /**
     * Retrieval of associated <b>Equipment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Equipment</b>.
     * <p>
     * If the navigation property <b>to_Equipment</b> of a queried <b>EquipmentClassCharacteristic</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Equipment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Equipment getEquipmentOrFetch()
    {
        if( toEquipment == null ) {
            toEquipment = fetchEquipment();
        }
        return toEquipment;
    }

    /**
     * Retrieval of associated <b>Equipment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Equipment</b>.
     * <p>
     * If the navigation property for an entity <b>EquipmentClassCharacteristic</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Equipment</b> is already loaded, the result will contain
     *         the <b>Equipment</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Equipment> getEquipmentIfPresent()
    {
        return Option.of(toEquipment);
    }

    /**
     * Overwrites the associated <b>Equipment</b> entity for the loaded navigation property <b>to_Equipment</b>.
     *
     * @param value
     *            New <b>Equipment</b> entity.
     */
    public void setEquipment( final Equipment value )
    {
        toEquipment = value;
    }

    /**
     * Fetches the <b>EquipClassCharacteristicValue</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Value</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EquipClassCharacteristicValue</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EquipClassCharacteristicValue> fetchValue()
    {
        return fetchFieldAsList("to_Value", EquipClassCharacteristicValue.class);
    }

    /**
     * Retrieval of associated <b>EquipClassCharacteristicValue</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_Value</b>.
     * <p>
     * If the navigation property <b>to_Value</b> of a queried <b>EquipmentClassCharacteristic</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EquipClassCharacteristicValue</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EquipClassCharacteristicValue> getValueOrFetch()
    {
        if( toValue == null ) {
            toValue = fetchValue();
        }
        return toValue;
    }

    /**
     * Retrieval of associated <b>EquipClassCharacteristicValue</b> entities (one to many). This corresponds to the
     * OData navigation property <b>to_Value</b>.
     * <p>
     * If the navigation property for an entity <b>EquipmentClassCharacteristic</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Value</b> is already loaded, the result will contain the
     *         <b>EquipClassCharacteristicValue</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EquipClassCharacteristicValue>> getValueIfPresent()
    {
        return Option.of(toValue);
    }

    /**
     * Overwrites the list of associated <b>EquipClassCharacteristicValue</b> entities for the loaded navigation
     * property <b>to_Value</b>.
     * <p>
     * If the navigation property <b>to_Value</b> of a queried <b>EquipmentClassCharacteristic</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EquipClassCharacteristicValue</b> entities.
     */
    public void setValue( @Nonnull final List<EquipClassCharacteristicValue> value )
    {
        if( toValue == null ) {
            toValue = Lists.newArrayList();
        }
        toValue.clear();
        toValue.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EquipClassCharacteristicValue</b> entities. This corresponds to the
     * OData navigation property <b>to_Value</b>.
     * <p>
     * If the navigation property <b>to_Value</b> of a queried <b>EquipmentClassCharacteristic</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EquipClassCharacteristicValue</b> entities.
     */
    public void addValue( EquipClassCharacteristicValue... entity )
    {
        if( toValue == null ) {
            toValue = Lists.newArrayList();
        }
        toValue.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of EquipmentClassCharacteristic instances.
     *
     */
    public final static class EquipmentClassCharacteristicBuilder
    {

        private EquipmentClass toEquipmentClass;
        private Equipment toEquipment;
        private String equipment = null;
        private List<EquipClassCharacteristicValue> toValue = Lists.newArrayList();

        private EquipmentClassCharacteristic.EquipmentClassCharacteristicBuilder toEquipmentClass(
            final EquipmentClass value )
        {
            toEquipmentClass = value;
            return this;
        }

        /**
         * Navigation property <b>to_EquipmentClass</b> for <b>EquipmentClassCharacteristic</b> to single
         * <b>EquipmentClass</b>.
         *
         * @param value
         *            The EquipmentClass to build this EquipmentClassCharacteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipmentClassCharacteristic.EquipmentClassCharacteristicBuilder equipmentClass(
            final EquipmentClass value )
        {
            return toEquipmentClass(value);
        }

        private EquipmentClassCharacteristic.EquipmentClassCharacteristicBuilder toEquipment( final Equipment value )
        {
            toEquipment = value;
            return this;
        }

        /**
         * Navigation property <b>to_Equipment</b> for <b>EquipmentClassCharacteristic</b> to single <b>Equipment</b>.
         *
         * @param value
         *            The Equipment to build this EquipmentClassCharacteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipmentClassCharacteristic.EquipmentClassCharacteristicBuilder equipment( final Equipment value )
        {
            return toEquipment(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 18
         * <p>
         * Original property name from the Odata EDM: <b>Equipment</b>
         * </p>
         *
         * @param value
         *            The equipment to build this EquipmentClassCharacteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipmentClassCharacteristic.EquipmentClassCharacteristicBuilder equipment( final String value )
        {
            equipment = value;
            return this;
        }

        private EquipmentClassCharacteristic.EquipmentClassCharacteristicBuilder toValue(
            final List<EquipClassCharacteristicValue> value )
        {
            toValue.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Value</b> for <b>EquipmentClassCharacteristic</b> to multiple
         * <b>EquipClassCharacteristicValue</b>.
         *
         * @param value
         *            The EquipClassCharacteristicValues to build this EquipmentClassCharacteristic with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipmentClassCharacteristic.EquipmentClassCharacteristicBuilder value(
            EquipClassCharacteristicValue... value )
        {
            return toValue(Lists.newArrayList(value));
        }

    }

}
