/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentLongTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentLongTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable.EquipmentLongTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Equipment Long Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EquipmentLongTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EquipmentLongText extends VdmEntity<EquipmentLongText>
{

    /**
     * Selector for all available fields of EquipmentLongText.
     *
     */
    public final static EquipmentLongTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static EquipmentLongTextField<String> EQUIPMENT = new EquipmentLongTextField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectKey</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "TextObjectKey" )
    @JsonProperty( "TextObjectKey" )
    @Nullable
    @ODataField( odataName = "TextObjectKey" )
    private String textObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>TextObjectKey</b> field to query operations.
     *
     */
    public final static EquipmentLongTextField<String> TEXT_OBJECT_KEY =
        new EquipmentLongTextField<String>("TextObjectKey");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static EquipmentLongTextField<String> LANGUAGE = new EquipmentLongTextField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentLongText</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "EquipmentLongText" )
    @JsonProperty( "EquipmentLongText" )
    @Nullable
    @ODataField( odataName = "EquipmentLongText" )
    private String equipmentLongText;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentLongText</b> field to query operations.
     *
     */
    public final static EquipmentLongTextField<String> EQUIPMENT_LONG_TEXT =
        new EquipmentLongTextField<String>("EquipmentLongText");
    /**
     * Navigation property <b>to_Equipment</b> for <b>EquipmentLongText</b> to single <b>Equipment</b>.
     *
     */
    @SerializedName( "to_Equipment" )
    @JsonProperty( "to_Equipment" )
    @ODataField( odataName = "to_Equipment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Equipment toEquipment;
    /**
     * Use with available fluent helpers to apply the <b>to_Equipment</b> navigation property to query operations.
     *
     */
    public final static EquipmentLongTextOneToOneLink<Equipment> TO_EQUIPMENT =
        new EquipmentLongTextOneToOneLink<Equipment>("to_Equipment");

    @Nonnull
    @Override
    public Class<EquipmentLongText> getType()
    {
        return EquipmentLongText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>TextObjectKey</b>
     * </p>
     *
     * @param textObjectKey
     *            Equipment Number
     */
    public void setTextObjectKey( @Nullable final String textObjectKey )
    {
        rememberChangedField("TextObjectKey", this.textObjectKey);
        this.textObjectKey = textObjectKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentLongText</b>
     * </p>
     *
     * @param equipmentLongText
     *            Long Text
     */
    public void setEquipmentLongText( @Nullable final String equipmentLongText )
    {
        rememberChangedField("EquipmentLongText", this.equipmentLongText);
        this.equipmentLongText = equipmentLongText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "EquipmentLongText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Equipment", getEquipment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Equipment", getEquipment());
        values.put("TextObjectKey", getTextObjectKey());
        values.put("Language", getLanguage());
        values.put("EquipmentLongText", getEquipmentLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("TextObjectKey") ) {
                final Object value = values.remove("TextObjectKey");
                if( (value == null) || (!value.equals(getTextObjectKey())) ) {
                    setTextObjectKey(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("EquipmentLongText") ) {
                final Object value = values.remove("EquipmentLongText");
                if( (value == null) || (!value.equals(getEquipmentLongText())) ) {
                    setEquipmentLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Equipment") ) {
                final Object value = (values).remove("to_Equipment");
                if( value instanceof Map ) {
                    if( toEquipment == null ) {
                        toEquipment = new Equipment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEquipment.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EquipmentLongTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EquipmentLongTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EquipmentLongTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EquipmentLongTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EquipmentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEquipment != null ) {
            (values).put("to_Equipment", toEquipment);
        }
        return values;
    }

    /**
     * Fetches the <b>Equipment</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Equipment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Equipment</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Equipment fetchEquipment()
    {
        return fetchFieldAsSingle("to_Equipment", Equipment.class);
    }

    /**
     * Retrieval of associated <b>Equipment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Equipment</b>.
     * <p>
     * If the navigation property <b>to_Equipment</b> of a queried <b>EquipmentLongText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Equipment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Equipment getEquipmentOrFetch()
    {
        if( toEquipment == null ) {
            toEquipment = fetchEquipment();
        }
        return toEquipment;
    }

    /**
     * Retrieval of associated <b>Equipment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Equipment</b>.
     * <p>
     * If the navigation property for an entity <b>EquipmentLongText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Equipment</b> is already loaded, the result will contain
     *         the <b>Equipment</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Equipment> getEquipmentIfPresent()
    {
        return Option.of(toEquipment);
    }

    /**
     * Overwrites the associated <b>Equipment</b> entity for the loaded navigation property <b>to_Equipment</b>.
     *
     * @param value
     *            New <b>Equipment</b> entity.
     */
    public void setEquipment( final Equipment value )
    {
        toEquipment = value;
    }

    /**
     * Helper class to allow for fluent creation of EquipmentLongText instances.
     *
     */
    public final static class EquipmentLongTextBuilder
    {

        private Equipment toEquipment;
        private String equipment = null;

        private EquipmentLongText.EquipmentLongTextBuilder toEquipment( final Equipment value )
        {
            toEquipment = value;
            return this;
        }

        /**
         * Navigation property <b>to_Equipment</b> for <b>EquipmentLongText</b> to single <b>Equipment</b>.
         *
         * @param value
         *            The Equipment to build this EquipmentLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipmentLongText.EquipmentLongTextBuilder equipment( final Equipment value )
        {
            return toEquipment(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 18
         * <p>
         * Original property name from the Odata EDM: <b>Equipment</b>
         * </p>
         *
         * @param value
         *            The equipment to build this EquipmentLongText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipmentLongText.EquipmentLongTextBuilder equipment( final String value )
        {
            equipment = value;
            return this;
        }

    }

}
