/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable.EquipmentLongTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText EquipmentLongText} entity
 * using key fields. This fluent helper allows methods which modify the underlying query to be called before executing
 * the query itself.
 *
 */
public class EquipmentLongTextByKeyFluentHelper
    extends
    FluentHelperByKey<EquipmentLongTextByKeyFluentHelper, EquipmentLongText, EquipmentLongTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText EquipmentLongText} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code EquipmentLongText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code EquipmentLongText}
     * @param equipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     */
    public EquipmentLongTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String equipment )
    {
        super(servicePath, entityCollection);
        this.key.put("Equipment", equipment);
    }

    @Override
    @Nonnull
    protected Class<EquipmentLongText> getEntityClass()
    {
        return EquipmentLongText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
