/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable.EquipmentPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Equipment Partner Functions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EquipmentPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EquipmentPartner extends VdmEntity<EquipmentPartner>
{

    /**
     * Selector for all available fields of EquipmentPartner.
     *
     */
    public final static EquipmentPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static EquipmentPartnerField<String> EQUIPMENT = new EquipmentPartnerField<String>("Equipment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static EquipmentPartnerField<String> PARTNER_FUNCTION =
        new EquipmentPartnerField<String>("PartnerFunction");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentPartnerObjectNmbr</b>
     * </p>
     *
     * @return Counter for differentiation 6-digit
     */
    @Key
    @SerializedName( "EquipmentPartnerObjectNmbr" )
    @JsonProperty( "EquipmentPartnerObjectNmbr" )
    @Nullable
    @ODataField( odataName = "EquipmentPartnerObjectNmbr" )
    private String equipmentPartnerObjectNmbr;
    /**
     * Use with available fluent helpers to apply the <b>EquipmentPartnerObjectNmbr</b> field to query operations.
     *
     */
    public final static EquipmentPartnerField<String> EQUIPMENT_PARTNER_OBJECT_NMBR =
        new EquipmentPartnerField<String>("EquipmentPartnerObjectNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Partner</b>
     * </p>
     *
     * @return Partner
     */
    @SerializedName( "Partner" )
    @JsonProperty( "Partner" )
    @Nullable
    @ODataField( odataName = "Partner" )
    private String partner;
    /**
     * Use with available fluent helpers to apply the <b>Partner</b> field to query operations.
     *
     */
    public final static EquipmentPartnerField<String> PARTNER = new EquipmentPartnerField<String>("Partner");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static EquipmentPartnerField<String> CREATED_BY_USER =
        new EquipmentPartnerField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static EquipmentPartnerField<LocalDateTime> CREATION_DATE =
        new EquipmentPartnerField<LocalDateTime>("CreationDate");
    /**
     * Navigation property <b>to_Equipment</b> for <b>EquipmentPartner</b> to single <b>Equipment</b>.
     *
     */
    @SerializedName( "to_Equipment" )
    @JsonProperty( "to_Equipment" )
    @ODataField( odataName = "to_Equipment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Equipment toEquipment;
    /**
     * Use with available fluent helpers to apply the <b>to_Equipment</b> navigation property to query operations.
     *
     */
    public final static EquipmentPartnerOneToOneLink<Equipment> TO_EQUIPMENT =
        new EquipmentPartnerOneToOneLink<Equipment>("to_Equipment");

    @Nonnull
    @Override
    public Class<EquipmentPartner> getType()
    {
        return EquipmentPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>EquipmentPartnerObjectNmbr</b>
     * </p>
     *
     * @param equipmentPartnerObjectNmbr
     *            Counter for differentiation 6-digit
     */
    public void setEquipmentPartnerObjectNmbr( @Nullable final String equipmentPartnerObjectNmbr )
    {
        rememberChangedField("EquipmentPartnerObjectNmbr", this.equipmentPartnerObjectNmbr);
        this.equipmentPartnerObjectNmbr = equipmentPartnerObjectNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Partner</b>
     * </p>
     *
     * @param partner
     *            Partner
     */
    public void setPartner( @Nullable final String partner )
    {
        rememberChangedField("Partner", this.partner);
        this.partner = partner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "EquipmentPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Equipment", getEquipment());
        result.put("PartnerFunction", getPartnerFunction());
        result.put("EquipmentPartnerObjectNmbr", getEquipmentPartnerObjectNmbr());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Equipment", getEquipment());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("EquipmentPartnerObjectNmbr", getEquipmentPartnerObjectNmbr());
        values.put("Partner", getPartner());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("EquipmentPartnerObjectNmbr") ) {
                final Object value = values.remove("EquipmentPartnerObjectNmbr");
                if( (value == null) || (!value.equals(getEquipmentPartnerObjectNmbr())) ) {
                    setEquipmentPartnerObjectNmbr(((String) value));
                }
            }
            if( values.containsKey("Partner") ) {
                final Object value = values.remove("Partner");
                if( (value == null) || (!value.equals(getPartner())) ) {
                    setPartner(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Equipment") ) {
                final Object value = (values).remove("to_Equipment");
                if( value instanceof Map ) {
                    if( toEquipment == null ) {
                        toEquipment = new Equipment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEquipment.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EquipmentPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EquipmentPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EquipmentPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EquipmentPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EquipmentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEquipment != null ) {
            (values).put("to_Equipment", toEquipment);
        }
        return values;
    }

    /**
     * Fetches the <b>Equipment</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Equipment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Equipment</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Equipment fetchEquipment()
    {
        return fetchFieldAsSingle("to_Equipment", Equipment.class);
    }

    /**
     * Retrieval of associated <b>Equipment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Equipment</b>.
     * <p>
     * If the navigation property <b>to_Equipment</b> of a queried <b>EquipmentPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Equipment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Equipment getEquipmentOrFetch()
    {
        if( toEquipment == null ) {
            toEquipment = fetchEquipment();
        }
        return toEquipment;
    }

    /**
     * Retrieval of associated <b>Equipment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Equipment</b>.
     * <p>
     * If the navigation property for an entity <b>EquipmentPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Equipment</b> is already loaded, the result will contain
     *         the <b>Equipment</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Equipment> getEquipmentIfPresent()
    {
        return Option.of(toEquipment);
    }

    /**
     * Overwrites the associated <b>Equipment</b> entity for the loaded navigation property <b>to_Equipment</b>.
     *
     * @param value
     *            New <b>Equipment</b> entity.
     */
    public void setEquipment( final Equipment value )
    {
        toEquipment = value;
    }

    /**
     * Helper class to allow for fluent creation of EquipmentPartner instances.
     *
     */
    public final static class EquipmentPartnerBuilder
    {

        private Equipment toEquipment;
        private String equipment = null;

        private EquipmentPartner.EquipmentPartnerBuilder toEquipment( final Equipment value )
        {
            toEquipment = value;
            return this;
        }

        /**
         * Navigation property <b>to_Equipment</b> for <b>EquipmentPartner</b> to single <b>Equipment</b>.
         *
         * @param value
         *            The Equipment to build this EquipmentPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipmentPartner.EquipmentPartnerBuilder equipment( final Equipment value )
        {
            return toEquipment(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 18
         * <p>
         * Original property name from the Odata EDM: <b>Equipment</b>
         * </p>
         *
         * @param value
         *            The equipment to build this EquipmentPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EquipmentPartner.EquipmentPartnerBuilder equipment( final String value )
        {
            equipment = value;
            return this;
        }

    }

}
