/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment;

import java.net.URI;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.SingleValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>InstallEquipWithDataTransfer</b> OData function import.
 *
 */
public class InstallEquipWithDataTransferFluentHelper
    extends
    SingleValuedFluentHelperFunction<InstallEquipWithDataTransferFluentHelper, Equipment, Equipment>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>InstallEquipWithDataTransfer</b> OData function import
     * with the provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param maintPlanningPlantCopyIsReqd
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintPlanningPlantCopyIsReqd</b>
     *            </p>
     * @param workCenterCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WorkCenterCopyIsRequested</b>
     *            </p>
     * @param costCenterCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CostCenterCopyIsRequested</b>
     *            </p>
     * @param equipment
     *            Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>Equipment</b>
     *            </p>
     * @param catalogProfileCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CatalogProfileCopyIsRequested</b>
     *            </p>
     * @param wBSElementCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>WBSElementCopyIsRequested</b>
     *            </p>
     * @param validityEndDate
     *            Valid To
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ValidityEndDate</b>
     *            </p>
     * @param equipmentInstallationDate
     *            Changed On
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipmentInstallationDate</b>
     *            </p>
     * @param salesOrganizationCopyIsReqd
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SalesOrganizationCopyIsReqd</b>
     *            </p>
     * @param plantSectionCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PlantSectionCopyIsRequested</b>
     *            </p>
     * @param superordinateEquipment
     *            Superord. Equipment
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 18
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SuperordinateEquipment</b>
     *            </p>
     * @param standingOrderCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>StandingOrderCopyIsRequested</b>
     *            </p>
     * @param maintWorkCenterCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>MaintWorkCenterCopyIsRequested</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param functionalLocation
     *            Functional Location
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 40
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>FunctionalLocation</b>
     *            </p>
     * @param equipmentInstallationTime
     *            Time
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 0
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipmentInstallationTime</b>
     *            </p>
     * @param businessAreaCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>BusinessAreaCopyIsRequested</b>
     *            </p>
     * @param settlementOrderCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SettlementOrderCopyIsRequested</b>
     *            </p>
     * @param sortFieldCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>SortFieldCopyIsRequested</b>
     *            </p>
     * @param equipInstallationPositionNmbr
     *            Position
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>EquipInstallationPositionNmbr</b>
     *            </p>
     * @param roomCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>RoomCopyIsRequested</b>
     *            </p>
     * @param aBCIndicatorCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ABCIndicatorCopyIsRequested</b>
     *            </p>
     * @param locationCopyIsRequested
     *            Indicator
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>LocationCopyIsRequested</b>
     *            </p>
     */
    public InstallEquipWithDataTransferFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String equipment,
        @Nonnull final LocalDateTime validityEndDate,
        @Nullable final String superordinateEquipment,
        @Nullable final String functionalLocation,
        @Nullable final String equipInstallationPositionNmbr,
        @Nullable final LocalDateTime equipmentInstallationDate,
        @Nullable final LocalTime equipmentInstallationTime,
        @Nullable final Boolean locationCopyIsRequested,
        @Nullable final Boolean roomCopyIsRequested,
        @Nullable final Boolean plantSectionCopyIsRequested,
        @Nullable final Boolean workCenterCopyIsRequested,
        @Nullable final Boolean aBCIndicatorCopyIsRequested,
        @Nullable final Boolean sortFieldCopyIsRequested,
        @Nullable final Boolean businessAreaCopyIsRequested,
        @Nullable final Boolean costCenterCopyIsRequested,
        @Nullable final Boolean wBSElementCopyIsRequested,
        @Nullable final Boolean standingOrderCopyIsRequested,
        @Nullable final Boolean settlementOrderCopyIsRequested,
        @Nullable final Boolean maintPlanningPlantCopyIsReqd,
        @Nullable final Boolean maintWorkCenterCopyIsRequested,
        @Nullable final Boolean catalogProfileCopyIsRequested,
        @Nullable final Boolean salesOrganizationCopyIsReqd )
    {
        super(servicePath);
        values.put("Equipment", equipment);
        values.put("ValidityEndDate", validityEndDate);
        if( superordinateEquipment != null ) {
            values.put("SuperordinateEquipment", superordinateEquipment);
        }
        if( functionalLocation != null ) {
            values.put("FunctionalLocation", functionalLocation);
        }
        if( equipInstallationPositionNmbr != null ) {
            values.put("EquipInstallationPositionNmbr", equipInstallationPositionNmbr);
        }
        if( equipmentInstallationDate != null ) {
            values.put("EquipmentInstallationDate", equipmentInstallationDate);
        }
        if( equipmentInstallationTime != null ) {
            values.put("EquipmentInstallationTime", equipmentInstallationTime);
        }
        if( locationCopyIsRequested != null ) {
            values.put("LocationCopyIsRequested", locationCopyIsRequested);
        }
        if( roomCopyIsRequested != null ) {
            values.put("RoomCopyIsRequested", roomCopyIsRequested);
        }
        if( plantSectionCopyIsRequested != null ) {
            values.put("PlantSectionCopyIsRequested", plantSectionCopyIsRequested);
        }
        if( workCenterCopyIsRequested != null ) {
            values.put("WorkCenterCopyIsRequested", workCenterCopyIsRequested);
        }
        if( aBCIndicatorCopyIsRequested != null ) {
            values.put("ABCIndicatorCopyIsRequested", aBCIndicatorCopyIsRequested);
        }
        if( sortFieldCopyIsRequested != null ) {
            values.put("SortFieldCopyIsRequested", sortFieldCopyIsRequested);
        }
        if( businessAreaCopyIsRequested != null ) {
            values.put("BusinessAreaCopyIsRequested", businessAreaCopyIsRequested);
        }
        if( costCenterCopyIsRequested != null ) {
            values.put("CostCenterCopyIsRequested", costCenterCopyIsRequested);
        }
        if( wBSElementCopyIsRequested != null ) {
            values.put("WBSElementCopyIsRequested", wBSElementCopyIsRequested);
        }
        if( standingOrderCopyIsRequested != null ) {
            values.put("StandingOrderCopyIsRequested", standingOrderCopyIsRequested);
        }
        if( settlementOrderCopyIsRequested != null ) {
            values.put("SettlementOrderCopyIsRequested", settlementOrderCopyIsRequested);
        }
        if( maintPlanningPlantCopyIsReqd != null ) {
            values.put("MaintPlanningPlantCopyIsReqd", maintPlanningPlantCopyIsReqd);
        }
        if( maintWorkCenterCopyIsRequested != null ) {
            values.put("MaintWorkCenterCopyIsRequested", maintWorkCenterCopyIsRequested);
        }
        if( catalogProfileCopyIsRequested != null ) {
            values.put("CatalogProfileCopyIsRequested", catalogProfileCopyIsRequested);
        }
        if( salesOrganizationCopyIsReqd != null ) {
            values.put("SalesOrganizationCopyIsReqd", salesOrganizationCopyIsReqd);
        }
    }

    @Override
    @Nonnull
    protected Class<Equipment> getEntityClass()
    {
        return Equipment.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "InstallEquipWithDataTransfer";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nullable
    public Equipment executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeSingle(destination);
    }

}
