/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty;

/**
 * Implementation of the {@link EquipmentServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EquipmentService EquipmentService}.
 *
 */
public class DefaultEquipmentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<EquipmentServiceBatch, EquipmentServiceBatchChangeSet>
    implements
    EquipmentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EquipmentService service;

    @SuppressWarnings( "deprecation" )
    DefaultEquipmentServiceBatchChangeSet(
        @Nonnull final DefaultEquipmentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EquipmentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultEquipmentServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet createEquipment( @Nonnull final Equipment equipment )
    {
        return addRequestCreate(service::createEquipment, equipment);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet updateEquipment( @Nonnull final Equipment equipment )
    {
        return addRequestUpdate(service::updateEquipment, equipment);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet createEquipClassCharacteristicValue(
        @Nonnull final EquipClassCharacteristicValue equipClassCharacteristicValue )
    {
        return addRequestCreate(service::createEquipClassCharacteristicValue, equipClassCharacteristicValue);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet updateEquipClassCharacteristicValue(
        @Nonnull final EquipClassCharacteristicValue equipClassCharacteristicValue )
    {
        return addRequestUpdate(service::updateEquipClassCharacteristicValue, equipClassCharacteristicValue);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet createEquipmentClass( @Nonnull final EquipmentClass equipmentClass )
    {
        return addRequestCreate(service::createEquipmentClass, equipmentClass);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet updateEquipmentClass( @Nonnull final EquipmentClass equipmentClass )
    {
        return addRequestUpdate(service::updateEquipmentClass, equipmentClass);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet deleteEquipmentClass( @Nonnull final EquipmentClass equipmentClass )
    {
        return addRequestDelete(service::deleteEquipmentClass, equipmentClass);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet createEquipmentClassCharacteristic(
        @Nonnull final EquipmentClassCharacteristic equipmentClassCharacteristic )
    {
        return addRequestCreate(service::createEquipmentClassCharacteristic, equipmentClassCharacteristic);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet createEquipmentLongText( @Nonnull final EquipmentLongText equipmentLongText )
    {
        return addRequestCreate(service::createEquipmentLongText, equipmentLongText);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet updateEquipmentLongText( @Nonnull final EquipmentLongText equipmentLongText )
    {
        return addRequestUpdate(service::updateEquipmentLongText, equipmentLongText);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet createEquipmentPartner( @Nonnull final EquipmentPartner equipmentPartner )
    {
        return addRequestCreate(service::createEquipmentPartner, equipmentPartner);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet updateEquipmentPartner( @Nonnull final EquipmentPartner equipmentPartner )
    {
        return addRequestUpdate(service::updateEquipmentPartner, equipmentPartner);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet createEquipmentWarranty( @Nonnull final EquipmentWarranty equipmentWarranty )
    {
        return addRequestCreate(service::createEquipmentWarranty, equipmentWarranty);
    }

    @Nonnull
    @Override
    public EquipmentServiceBatchChangeSet updateEquipmentWarranty( @Nonnull final EquipmentWarranty equipmentWarranty )
    {
        return addRequestUpdate(service::updateEquipmentWarranty, equipmentWarranty);
    }

}
