/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EquipmentService EquipmentService}.
 *
 */
public interface EquipmentServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<EquipmentServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<EquipmentServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entity and
     * save it to the S/4HANA system.
     *
     * @param equipment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet createEquipment( @Nonnull final Equipment equipment );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment}
     * entity and save it to the S/4HANA system.
     *
     * @param equipment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet updateEquipment( @Nonnull final Equipment equipment );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     * EquipClassCharacteristicValue} entity and save it to the S/4HANA system.
     *
     * @param equipClassCharacteristicValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     *            EquipClassCharacteristicValue} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet createEquipClassCharacteristicValue(
        @Nonnull final EquipClassCharacteristicValue equipClassCharacteristicValue );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     * EquipClassCharacteristicValue} entity and save it to the S/4HANA system.
     *
     * @param equipClassCharacteristicValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
     *            EquipClassCharacteristicValue} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet updateEquipClassCharacteristicValue(
        @Nonnull final EquipClassCharacteristicValue equipClassCharacteristicValue );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     * entity and save it to the S/4HANA system.
     *
     * @param equipmentClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet createEquipmentClass( @Nonnull final EquipmentClass equipmentClass );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass
     * EquipmentClass} entity and save it to the S/4HANA system.
     *
     * @param equipmentClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet updateEquipmentClass( @Nonnull final EquipmentClass equipmentClass );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass
     * EquipmentClass} entity in the S/4HANA system.
     *
     * @param equipmentClass
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet deleteEquipmentClass( @Nonnull final EquipmentClass equipmentClass );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic
     * EquipmentClassCharacteristic} entity and save it to the S/4HANA system.
     *
     * @param equipmentClassCharacteristic
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClassCharacteristic
     *            EquipmentClassCharacteristic} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet
        createEquipmentClassCharacteristic( @Nonnull final EquipmentClassCharacteristic equipmentClassCharacteristic );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText
     * EquipmentLongText} entity and save it to the S/4HANA system.
     *
     * @param equipmentLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText
     *            EquipmentLongText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet createEquipmentLongText( @Nonnull final EquipmentLongText equipmentLongText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText
     * EquipmentLongText} entity and save it to the S/4HANA system.
     *
     * @param equipmentLongText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText
     *            EquipmentLongText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet updateEquipmentLongText( @Nonnull final EquipmentLongText equipmentLongText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner
     * EquipmentPartner} entity and save it to the S/4HANA system.
     *
     * @param equipmentPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner
     *            EquipmentPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet createEquipmentPartner( @Nonnull final EquipmentPartner equipmentPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner
     * EquipmentPartner} entity and save it to the S/4HANA system.
     *
     * @param equipmentPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner
     *            EquipmentPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet updateEquipmentPartner( @Nonnull final EquipmentPartner equipmentPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty
     * EquipmentWarranty} entity and save it to the S/4HANA system.
     *
     * @param equipmentWarranty
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty
     *            EquipmentWarranty} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet createEquipmentWarranty( @Nonnull final EquipmentWarranty equipmentWarranty );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty
     * EquipmentWarranty} entity and save it to the S/4HANA system.
     *
     * @param equipmentWarranty
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty
     *            EquipmentWarranty} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EquipmentServiceBatchChangeSet updateEquipmentWarranty( @Nonnull final EquipmentWarranty equipmentWarranty );

}
