/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue
 * EquipClassCharacteristicValue}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipClassCharacteristicValueField
 * EquipClassCharacteristicValueField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipClassCharacteristicValueLink
 * EquipClassCharacteristicValueLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#EQUIPMENT
 * EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CLASS_TYPE
 * CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_VALUE_POSITION_NUMBER
 * CHARC_VALUE_POSITION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARACTERISTIC_INTERNAL_ID
 * CHARACTERISTIC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARACTERISTIC
 * CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_DATA_TYPE
 * CHARC_DATA_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CLASS_INTERNAL_ID
 * CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_VALUE_DEPENDENCY
 * CHARC_VALUE_DEPENDENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_VALUE
 * CHARC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_FROM_NUMERIC_VALUE
 * CHARC_FROM_NUMERIC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_FROM_NUMERIC_VALUE_UNIT
 * CHARC_FROM_NUMERIC_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_TO_NUMERIC_VALUE
 * CHARC_TO_NUMERIC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_TO_NUMERIC_VALUE_UNIT
 * CHARC_TO_NUMERIC_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_FROM_DECIMAL_VALUE
 * CHARC_FROM_DECIMAL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_TO_DECIMAL_VALUE
 * CHARC_TO_DECIMAL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_FROM_AMOUNT
 * CHARC_FROM_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_TO_AMOUNT
 * CHARC_TO_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_FROM_DATE
 * CHARC_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_TO_DATE
 * CHARC_TO_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_FROM_TIME
 * CHARC_FROM_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#CHARC_TO_TIME
 * CHARC_TO_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#TO_EQUIPMENT
 * TO_EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipClassCharacteristicValue#TO_CHARACTERISTIC
 * TO_CHARACTERISTIC}</li>
 * </ul>
 *
 */
public interface EquipClassCharacteristicValueSelectable extends EntitySelectable<EquipClassCharacteristicValue>
{

}
