/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass EquipmentClass}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentClassField
 * EquipmentClassField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentClassLink
 * EquipmentClassLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#EQUIPMENT EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#CLASS_INTERNAL_ID
 * CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#CLASS_TYPE CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#KEY_DATE KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#CLFN_STATUS CLFN_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#CLASS_POSITION_NUMBER
 * CLASS_POSITION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#CLASS_IS_STANDARD_CLASS
 * CLASS_IS_STANDARD_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#CLFN_OBJECT_INTERNAL_ID
 * CLFN_OBJECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#CLASS_PROPERTY
 * CLASS_PROPERTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#TO_EQUIPMENT
 * TO_EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentClass#TO_CHARACTERISTIC
 * TO_CHARACTERISTIC}</li>
 * </ul>
 *
 */
public interface EquipmentClassSelectable extends EntitySelectable<EquipmentClass>
{

}
