/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText EquipmentLongText}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentLongTextField
 * EquipmentLongTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentLongTextLink
 * EquipmentLongTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText#EQUIPMENT EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText#TEXT_OBJECT_KEY
 * TEXT_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText#EQUIPMENT_LONG_TEXT
 * EQUIPMENT_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentLongText#TO_EQUIPMENT
 * TO_EQUIPMENT}</li>
 * </ul>
 *
 */
public interface EquipmentLongTextSelectable extends EntitySelectable<EquipmentLongText>
{

}
