/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner EquipmentPartner}. This
 * interface is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentPartnerField
 * EquipmentPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentPartnerLink EquipmentPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner#EQUIPMENT EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner#EQUIPMENT_PARTNER_OBJECT_NMBR
 * EQUIPMENT_PARTNER_OBJECT_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner#PARTNER PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentPartner#TO_EQUIPMENT
 * TO_EQUIPMENT}</li>
 * </ul>
 *
 */
public interface EquipmentPartnerSelectable extends EntitySelectable<EquipmentPartner>
{

}
