/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment Equipment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentField EquipmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentLink EquipmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#VALIDITY_END_TIME
 * VALIDITY_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_VALIDITY_END_DATE_TIME
 * EQUIPMENT_VALIDITY_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_OID EQUIPMENT_OID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_NAME
 * EQUIPMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_CATEGORY
 * EQUIPMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#TECHNICAL_OBJECT_TYPE
 * TECHNICAL_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#GROSS_WEIGHT GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#GROSS_WEIGHT_UNIT
 * GROSS_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#SIZE_OR_DIMENSION_TEXT
 * SIZE_OR_DIMENSION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#INVENTORY_NUMBER
 * INVENTORY_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#OPERATION_START_DATE
 * OPERATION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#ACQUISITION_VALUE
 * ACQUISITION_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#CURRENCY CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#ACQUISITION_DATE
 * ACQUISITION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#ASSET_MANUFACTURER_NAME
 * ASSET_MANUFACTURER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MANUFACTURER_PART_TYPE_NAME
 * MANUFACTURER_PART_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MANUFACTURER_COUNTRY
 * MANUFACTURER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#CONSTRUCTION_YEAR
 * CONSTRUCTION_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#CONSTRUCTION_MONTH
 * CONSTRUCTION_MONTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MANUFACTURER_PART_NMBR
 * MANUFACTURER_PART_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MANUFACTURER_SERIAL_NUMBER
 * MANUFACTURER_SERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MAINTENANCE_PLANT
 * MAINTENANCE_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#ASSET_LOCATION
 * ASSET_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#ASSET_ROOM ASSET_ROOM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#PLANT_SECTION PLANT_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#WORK_CENTER WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#WORK_CENTER_PLANT
 * WORK_CENTER_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#ABC_INDICATOR ABC_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MAINT_OBJECT_FREE_DEFINED_ATTRIB
 * MAINT_OBJECT_FREE_DEFINED_ATTRIB}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#BUSINESS_PARTNER_NAME1
 * BUSINESS_PARTNER_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#BUSINESS_PARTNER_NAME2
 * BUSINESS_PARTNER_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#CITY_NAME CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#HOUSE_NUMBER HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#HOUSE_NUMBER_SUPPLEMENT_TEXT
 * HOUSE_NUMBER_SUPPLEMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#BUILDING BUILDING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#FLOOR FLOOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#ROOM_NUMBER ROOM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#POSTAL_CODE POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#STREET_NAME STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#REGION REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#COUNTRY COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#PHONE_NUMBER PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#FAX_NUMBER FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#COMPANY_CODE COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#BUSINESS_AREA BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#FIXED_ASSET FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#COST_CENTER COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#SETTLEMENT_ORDER
 * SETTLEMENT_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MAINTENANCE_PLANNING_PLANT
 * MAINTENANCE_PLANNING_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MAINTENANCE_PLANNER_GROUP
 * MAINTENANCE_PLANNER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MAIN_WORK_CENTER
 * MAIN_WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MAIN_WORK_CENTER_INTERNAL_ID
 * MAIN_WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MAIN_WORK_CENTER_PLANT
 * MAIN_WORK_CENTER_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#CATALOG_PROFILE
 * CATALOG_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#FUNCTIONAL_LOCATION
 * FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#FUNCTIONAL_LOCATION_LABEL_NAME
 * FUNCTIONAL_LOCATION_LABEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#FUNCTIONAL_LOCATION_NAME
 * FUNCTIONAL_LOCATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIP_INSTALLATION_POSITION_NMBR
 * EQUIP_INSTALLATION_POSITION_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#SUPERORDINATE_EQUIPMENT
 * SUPERORDINATE_EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#TECHNICAL_OBJECT_SORT_CODE
 * TECHNICAL_OBJECT_SORT_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#CONSTRUCTION_MATERIAL
 * CONSTRUCTION_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#SERIAL_NUMBER SERIAL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#UNIQUE_ITEM_IDENTIFIER
 * UNIQUE_ITEM_IDENTIFIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#UNIQUE_ITEM_IDENTIFIER_STRUC_TYPE
 * UNIQUE_ITEM_IDENTIFIER_STRUC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#UNIQUE_ITEM_IDENTIFIER_RESP_PLANT
 * UNIQUE_ITEM_IDENTIFIER_RESP_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#SALES_GROUP SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#SALES_OFFICE SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#CREATION_DATE CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#NEXT_EQUIP_USAGE_PERIOD_SQNC_NMBR
 * NEXT_EQUIP_USAGE_PERIOD_SQNC_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR
 * MAINT_OBJECT_LOC_ACCT_ASSGMT_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#MAINT_OBJECT_INTERNAL_ID
 * MAINT_OBJECT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIP_USAGE_PERIOD_SEQUENCE_NUMBER
 * EQUIP_USAGE_PERIOD_SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_IS_AT_CUSTOMER
 * EQUIPMENT_IS_AT_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_IS_AVAILABLE
 * EQUIPMENT_IS_AVAILABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_IS_IN_WAREHOUSE
 * EQUIPMENT_IS_IN_WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_IS_ASSIGNED_TO_DELIVERY
 * EQUIPMENT_IS_ASSIGNED_TO_DELIVERY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_IS_MARKED_FOR_DELETION
 * EQUIPMENT_IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_IS_INSTALLED
 * EQUIPMENT_IS_INSTALLED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIP_IS_ALLOC_TO_SUPERIOR_EQUIP
 * EQUIP_IS_ALLOC_TO_SUPERIOR_EQUIP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIPMENT_IS_INACTIVE
 * EQUIPMENT_IS_INACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#EQUIP_HAS_SUB_ORDINATE_EQUIPMENT
 * EQUIP_HAS_SUB_ORDINATE_EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#TO_CLASSIFICATION
 * TO_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#TO_LONG_TEXT TO_LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#TO_PARTNER TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.Equipment#TO_WARRANTY TO_WARRANTY}</li>
 * </ul>
 *
 */
public interface EquipmentSelectable extends EntitySelectable<Equipment>
{

}
