/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty EquipmentWarranty}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.field.EquipmentWarrantyField
 * EquipmentWarrantyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.link.EquipmentWarrantyLink
 * EquipmentWarrantyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty#EQUIPMENT EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty#WARRANTY_TYPE
 * WARRANTY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty#MASTER_WARRANTY
 * MASTER_WARRANTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty#WARRANTY_START_DATE
 * WARRANTY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty#WARRANTY_END_DATE
 * WARRANTY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty#WRNTY_IS_INHTD_FROM_SUPERIOR_OBJECT
 * WRNTY_IS_INHTD_FROM_SUPERIOR_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty#WRNTY_IS_PASSED_ON_TO_CHILD_OBJECT
 * WRNTY_IS_PASSED_ON_TO_CHILD_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.equipment.EquipmentWarranty#TO_EQUIPMENT
 * TO_EQUIPMENT}</li>
 * </ul>
 *
 */
public interface EquipmentWarrantySelectable extends EntitySelectable<EquipmentWarranty>
{

}
