/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.field.Et_ActionResultField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.selectable.Et_ActionResultSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Action Result
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>et_ActionResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Et_ActionResult extends VdmEntity<Et_ActionResult>
{

    /**
     * Selector for all available fields of Et_ActionResult.
     *
     */
    public final static Et_ActionResultSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocumentRef</b>
     * </p>
     *
     * @return Ref. Document
     */
    @Key
    @SerializedName( "DocumentRef" )
    @JsonProperty( "DocumentRef" )
    @Nullable
    @ODataField( odataName = "DocumentRef" )
    private String documentRef;
    /**
     * Use with available fluent helpers to apply the <b>DocumentRef</b> field to query operations.
     *
     */
    public final static Et_ActionResultField<String> DOCUMENT_REF = new Et_ActionResultField<String>("DocumentRef");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ErrorMsg</b>
     * </p>
     *
     * @return String
     */
    @Key
    @SerializedName( "ErrorMsg" )
    @JsonProperty( "ErrorMsg" )
    @Nullable
    @ODataField( odataName = "ErrorMsg" )
    private String errorMsg;
    /**
     * Use with available fluent helpers to apply the <b>ErrorMsg</b> field to query operations.
     *
     */
    public final static Et_ActionResultField<String> ERROR_MSG = new Et_ActionResultField<String>("ErrorMsg");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Successstatus</b>
     * </p>
     *
     * @return Success status
     */
    @Key
    @SerializedName( "Successstatus" )
    @JsonProperty( "Successstatus" )
    @Nullable
    @ODataField( odataName = "Successstatus" )
    private String successstatus;
    /**
     * Use with available fluent helpers to apply the <b>Successstatus</b> field to query operations.
     *
     */
    public final static Et_ActionResultField<String> SUCCESSSTATUS = new Et_ActionResultField<String>("Successstatus");

    @Nonnull
    @Override
    public Class<Et_ActionResult> getType()
    {
        return Et_ActionResult.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocumentRef</b>
     * </p>
     *
     * @param documentRef
     *            Ref. Document
     */
    public void setDocumentRef( @Nullable final String documentRef )
    {
        rememberChangedField("DocumentRef", this.documentRef);
        this.documentRef = documentRef;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ErrorMsg</b>
     * </p>
     *
     * @param errorMsg
     *            String
     */
    public void setErrorMsg( @Nullable final String errorMsg )
    {
        rememberChangedField("ErrorMsg", this.errorMsg);
        this.errorMsg = errorMsg;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Successstatus</b>
     * </p>
     *
     * @param successstatus
     *            Success status
     */
    public void setSuccessstatus( @Nullable final String successstatus )
    {
        rememberChangedField("Successstatus", this.successstatus);
        this.successstatus = successstatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "es_ActionResult";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DocumentRef", getDocumentRef());
        result.put("ErrorMsg", getErrorMsg());
        result.put("Successstatus", getSuccessstatus());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DocumentRef", getDocumentRef());
        values.put("ErrorMsg", getErrorMsg());
        values.put("Successstatus", getSuccessstatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DocumentRef") ) {
                final Object value = values.remove("DocumentRef");
                if( (value == null) || (!value.equals(getDocumentRef())) ) {
                    setDocumentRef(((String) value));
                }
            }
            if( values.containsKey("ErrorMsg") ) {
                final Object value = values.remove("ErrorMsg");
                if( (value == null) || (!value.equals(getErrorMsg())) ) {
                    setErrorMsg(((String) value));
                }
            }
            if( values.containsKey("Successstatus") ) {
                final Object value = values.remove("Successstatus");
                if( (value == null) || (!value.equals(getSuccessstatus())) ) {
                    setSuccessstatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> Et_ActionResultField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new Et_ActionResultField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> Et_ActionResultField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new Et_ActionResultField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EventBasedRevenueRecognitionIntegrationService.DEFAULT_SERVICE_PATH);
    }

}
