/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>RAKeyChangeResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RAKeyChangeResult extends VdmComplex<RAKeyChangeResult>
{

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>SuccessStatus</b>
     * </p>
     *
     * @param successStatus
     *
     */
    @SerializedName( "SuccessStatus" )
    @JsonProperty( "SuccessStatus" )
    @Nullable
    @ODataField( odataName = "SuccessStatus" )
    private BigDecimal successStatus;

    @Nonnull
    @Override
    public Class<RAKeyChangeResult> getType()
    {
        return RAKeyChangeResult.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SuccessStatus", getSuccessStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SuccessStatus") ) {
                final Object value = values.remove("SuccessStatus");
                if( (value == null) || (!value.equals(getSuccessStatus())) ) {
                    setSuccessStatus(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 0
     * <p>
     * Original property from the Odata EDM: <b>SuccessStatus</b>
     * </p>
     *
     * @param successStatus
     *            The successStatus to set.
     */
    public void setSuccessStatus( @Nullable final BigDecimal successStatus )
    {
        rememberChangedField("SuccessStatus", this.successStatus);
        this.successStatus = successStatus;
    }

}
