/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.eventbasedrevenuerecognitionintegration.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link EventBasedRevenueRecognitionIntegrationServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EventBasedRevenueRecognitionIntegrationService
 * EventBasedRevenueRecognitionIntegrationService}, allowing you to create multiple changesets and finally execute the
 * batch request.
 *
 */
public class DefaultEventBasedRevenueRecognitionIntegrationServiceBatch
    extends
    BatchFluentHelperBasic<EventBasedRevenueRecognitionIntegrationServiceBatch, EventBasedRevenueRecognitionIntegrationServiceBatchChangeSet>
    implements
    EventBasedRevenueRecognitionIntegrationServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EventBasedRevenueRecognitionIntegrationService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultEventBasedRevenueRecognitionIntegrationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultEventBasedRevenueRecognitionIntegrationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EventBasedRevenueRecognitionIntegrationService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.EventBasedRevenueRecognitionIntegrationService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultEventBasedRevenueRecognitionIntegrationServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultEventBasedRevenueRecognitionIntegrationServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EventBasedRevenueRecognitionIntegrationService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultEventBasedRevenueRecognitionIntegrationServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public EventBasedRevenueRecognitionIntegrationServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultEventBasedRevenueRecognitionIntegrationServiceBatchChangeSet(this, service);
    }

}
